<?php 
  /*
@File a_la_carte_price.php(Controller)
ADMIN A La Carte list PAGE
    This class show all a la carte list with price to it.

@Author Ravi Ranjan
@date 9th Aug. 2016
*/
class ControllerBulkAlacarteprice extends Controller {

public function index() {

		$this->language->load('bulk/a_la_carte_price');
		 
		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('bulk/a_la_carte_price');
		
    	$this->getList();
  	}
 	
/*
FUNCTION NAME 		-	printPdf
DESCRIPTION 		-	Loads the selected data for generating 
						a pdf.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Generates a pdf with the details given.
*/  	
	public function printPdf(){
		
		if(isset($this->request->post['selected']))
		{
			$this->load->model('bulk/a_la_carte_price');
			$this->pdf->AddPage();
		    $this->pdf->SetFillColor(232,232,232);
		    $this->pdf->SetFont('times','B',10);
			$this->pdf->SetY(32);
			$this->pdf->SetX(15);

			$this->pdf->Cell(180,6,'-:A-la-carte details:-',1,0,'C',1);
			$this->pdf->SetFont('times','B',8);
		    
			$w = array(15,25,40,55,100,145,160,180);
		    $c = array(10,15,15,45,45,15,20,15);
		    $this->pdf->SetY(40);
		    $header =  array('Sr.No','Prod.Id','Ch.No','Channel Name','Broadcaster','Service Id','Access Criteria','LCN');
			for( $i = 0; $i < count($header) ; $i++){
			  	if($i==0)
		    		$this->pdf->SetX($w[0]);
		      	else
			   		$this->pdf->SetX($w[$i-1]+$c[$i-1]);
			   	$this->pdf->Cell($c[$i],6,$header[$i],1,0,'L',1);
		    }	
		    $this->pdf->Ln();
		    $this->pdf->SetFont('times','',8);
	        $count=1;
		      	foreach ($this->request->post['selected'] as $results){
		      		$SelectedProduct = explode("~", $results);
	        		$resultArr=$this->model_bulk_a_la_carte_price->getChannelListDetailsPDF($SelectedProduct[0]);
	        		foreach ($resultArr as $result) {
	        			$c_height=6;
				    	$this->pdf->SetX(15);
				    	$this->pdf->Cell($c[0],6,$count,1,0,'L',0);
				    	$this->pdf->Cell($c[1],6,$result["product_id"],1,0,'L',0);
				    	$this->pdf->Cell($c[2],6,$result["model"],1,0,'L',0);
				    	$x_axis=$this->pdf->getx();
			    		$this->pdf->vcell($c[3],$c_height,$x_axis,$result["name"],22);
				    	$x_axis=$this->pdf->getx();
			    		$this->pdf->vcell($c[4],$c_height,$x_axis,$result['broadcasterName']?$result['broadcasterName']:"N/A",22);
				    	$this->pdf->Cell($c[5],6,$result['service_id'],1,0,'L',0);
				    	$this->pdf->Cell($c[6],6,$result['access_criteria'],1,0,'L',0);
				    	$this->pdf->Cell($c[7],6,$result['lcn'],1,0,'L',0);
				    	$this->pdf->Ln();
				 		$count++;
		        	}
		        }
	                         
		    /*$this->pdf->Ln(8);   
		    $this->pdf->Cell(70,6,'Date',0,0,'C',0);
		    $this->pdf->Cell(70,6,'Signature',0,0,'C',0);
		    $this->pdf->Ln(8);
		    $this->pdf->Cell(70,6,Date("d-m-Y"),0,0,'C',0);
		    $this->pdf->Cell(70,6,'--------------------',0,0,'C',0);*/
		    ob_clean();
		    $this->pdf->Output();
		}else{
			$this->language->load('bulk/a_la_carte_price');
			$this->document->setTitle($this->language->get('heading_title'));
			$this->load->model('bulk/a_la_carte_price');
	       	$this->data['error_warning'] = $this->language->get('select_waning');
	       	$this->getList();
		}
    }

   
/*
FUNCTION NAME 		-	getList
DESCRIPTION 		-	Gets all the Ala carte along with their channels.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Displays the details as a list.
*/
public function getList() {	

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
		if (isset($this->request->get['filter_value'])) {
			$this->data['filter_value'] = $this->request->get['filter_value'];
		} else {
			$this->data['filter_value'] ='';
		}

		$url = '';
		if (isset($this->request->get['filter_value'])) {
			$url .= '&filter_value=' . urlencode(html_entity_decode($this->request->get['filter_value'], ENT_QUOTES, 'UTF-8'));
		}

  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   // 		$this->data['breadcrumbs'][] = array(
   //     		'text'      => $this->language->get('heading_title'),
			// 'href'      => $this->url->link('bulk/a_la_carte_price', 'token=' . $this->session->data['token'] . $url, 'SSL'),
   //    		'separator' => ' :: '
   // 		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('bulk/a_la_carte_price', 'token=' . $this->session->data['token'] , 'SSL'),
      		'separator' => ' :: '
   		);

		$data = array(
			'start'           => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'           => $this->config->get('config_admin_limit')
		);

		if (isset($this->request->get['filter_value'])) {
			$this->data['filter_value'] = $this->request->get['filter_value'];
			$data['filter_value']=$this->request->get['filter_value'];
		} else {
			$this->data['filter_value'] ='';
		}
		if (isset($this->request->get['filter_value'])) {
			$url .= '&filter_value=' . $this->request->get['filter_value'];
		}

		$total = $this->model_bulk_a_la_carte_price->getTotalChannels($data);
		$this->data['channels'] = array();
		$results = $this->model_bulk_a_la_carte_price->getChannelListDetails($data);

		foreach ($results as $result) {	
			$this->data['channels'][] = array(
				'product_id'  	=> $result['product_id'],
				'model' 	 	=> $result['model'],
				'name' 			=> $result['name'],
				'service_id'  	=> $result['service_id'],
				'access_criteria'=> $result['access_criteria'],
				'lcn' 			=> $result['lcn'],
				'broadcast' 	=> $result['broadcasterName']?$result['broadcasterName']:"N/A",
				'selected'      => isset($this->request->post['selected']) && in_array($result['product_id'], $this->request->post['selected']),
				);						
		}

		$this->data['heading_title'] = $this->language->get('heading_title');
		$this->data['column_channel_no'] = $this->language->get('column_channel_no');
		$this->data['column_channel_name'] = $this->language->get('column_channel_name');
		$this->data['column_category'] = $this->language->get('column_category');
		$this->data['column_free'] = $this->language->get('column_free');
		$this->data['column_digital'] = $this->language->get('column_digital');
		$this->data['column_broadcaster'] = $this->language->get('column_broadcaster');
		$this->data['column_m1price'] = $this->language->get('column_m1price');
		$this->data['column_m3price'] = $this->language->get('column_m3price');
		$this->data['column_m6price'] = $this->language->get('column_m6price');
		$this->data['column_m9price'] = $this->language->get('column_m9price');
		$this->data['column_m12price'] = $this->language->get('column_m12price');
		$this->data['entry_product_no'] = $this->language->get('entry_product_no');
		$this->data['button_filter'] = $this->language->get('button_filter');

		$this->data['text_paid'] = $this->language->get('text_paid');
		$this->data['text_fd'] = $this->language->get('text_fd');
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['button_invoice'] = $this->language->get('button_invoice');;
		$this->data['printPdf'] = $this->url->link('bulk/a_la_carte_price/printPdf', 'token=' . $this->session->data['token'], 'SSL');
		$this->data['token'] = $this->session->data['token'];
		
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		if(!isset($this->data['error_warning'])){
			$this->data['error_warning']='';
		}
		
		$url = '';
		$pagination = new Pagination();
		$pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('bulk/a_la_carte_price', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
			
		$this->data['pagination'] = $pagination->render();
	
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		$this->template = 'bulk/a_la_carte_price.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
		$this->response->setOutput($this->render());
  	}
 }
?> 
