<?php 
	/*
	@File transaction.php(Controller)
	ADMIN History of Transaction list PAGE
	This class show Transaction list with price to it.

	@Author Ravi Ranjan
	@date 17th March. 2018
	*/
 class ControllerBillTransaction extends Controller {
	private $error = array();
	
	public function index() {
			$this->language->load('bill/transaction');
			$this->document->setTitle($this->language->get('heading_title'));
			$this->load->model('bill/transaction');
	    	$this->getList();
	  	}	
	public function printPdf(){
	    if(isset($this->request->post['selected']))
		 { 
			$this->load->model('bill/transaction');
			$this->pdf->AddPage();
		    $this->pdf->SetFillColor(232,232,232);
		    $this->pdf->SetFont('times','B',10);
			$this->pdf->SetY(32);
			$this->pdf->SetX(15);

			$this->pdf->Cell(186,6,'-:Transaction History Of LCO :-',1,0,'C',1);
			$this->pdf->SetFont('times','B',8);
		    
			$w = array(15,25,43,73,103,120,137,156,173);
		    $c = array(10,18,30,30,17,17,19,17,26);

		    $this->pdf->SetY(40);
		    $header =  array('Tx. Id','User Name','Name','Email','Mobile No','Initiated by','Payment Type','Amount(Rs)','Tx. Date');

			for( $i = 0; $i < count($header) ; $i++){
			  	if($i==0)
		    		$this->pdf->SetX($w[0]);
		      	else
			   		$this->pdf->SetX($w[$i-1]+$c[$i-1]);
			   	 $this->pdf->Cell($c[$i],6,$header[$i],1,0,'L',1);
		    }	
		    $this->pdf->Ln();
		    $this->pdf->SetFont('times','',8);
		    foreach ($this->request->post['selected'] as $selected) {
	        $result = $this->model_bill_transaction->getTransactionListPDF($selected);
	        		$c_height=6;
			    	$this->pdf->SetX(15);
			    	$this->pdf->Cell($c[0],6,$result["mso_lco_tx_id"],1,0,'L',0);
			    	$x_axis=$this->pdf->getx();
			    	$this->pdf->vcell($c[1],$c_height,$x_axis,$result["username"],12);
			    	$x_axis=$this->pdf->getx();
			    	$this->pdf->vcell($c[2],$c_height,$x_axis,$result["name"],20);
			    	$x_axis=$this->pdf->getx();
			    	$this->pdf->vcell($c[2],$c_height,$x_axis,$result['email'],20);
			    	$this->pdf->Cell($c[4],6,$result['mobile_no'],1,0,'L',0);
			    	$this->pdf->Cell($c[5],6,$result['initiated_by'],1,0,'L',0);
			    	$this->pdf->Cell($c[6],6,$result['payment_type'],1,0,'L',0);
			    	$this->pdf->Cell($c[7],6,$result['amount'],1,0,'L',0);
			    	$this->pdf->Cell($c[8],6,$result['date_added'],1,0,'L',0);
			    	$this->pdf->Ln();
		    }
		    $this->pdf->Output();
			}else{
				$this->language->load('bill/transaction');
				$this->document->setTitle($this->language->get('heading_title'));
				$this->load->model('bill/transaction');
		       	$this->data['error_warning'] = $this->language->get('select_waning');
		       	$this->getList();
			}    
    	}

	public function getList(){

		$this->language->load('bill/transaction');
		$this->load->model('bill/transaction');
		$url='';

		if (isset($this->request->get['filter_trans_id'])) {
			$filter_trans_id = $this->request->get['filter_trans_id'];
		} else {
			$filter_trans_id = null;
		}

		if (isset($this->request->get['filter_username'])) {
			$filter_username = $this->request->get['filter_username'];
		} else {
			$filter_username = null;
		}

		if (isset($this->request->get['filter_name'])) {
			$filter_name = $this->request->get['filter_name'];
		} else {
			$filter_name = null;
		}

		if (isset($this->request->get['filter_email'])) {
			$filter_email = $this->request->get['filter_email'];
		} else {
			$filter_email = null;
		}

		if (isset($this->request->get['filter_mobile_no']) && is_numeric($this->request->get['filter_mobile_no'])) {
			$filter_mobile_no = $this->request->get['filter_mobile_no'];
		} else {
			$filter_mobile_no = null;
		}

		if (isset($this->request->get['filter_amount'])) {
			$filter_amount = $this->request->get['filter_amount'];
		} else {
			$filter_amount = null;
		}

		if (isset($this->request->get['filter_transaction_date'])) {
			$filter_transaction_date = $this->request->get['filter_transaction_date'];
		} else {
			$filter_transaction_date = null;
		}

		if (isset($this->request->get['filter_initiated_by'])) {
			// var_dump($this->request->get['filter_initiated_by']);exit();
			$filter_initiated_by = $this->request->get['filter_initiated_by'];
		} else {
			$filter_initiated_by = null;
		}

		if (isset($this->request->get['filter_payment_type'])) {
			$filter_payment_type = $this->request->get['filter_payment_type'];
		} else {
			$filter_payment_type = null;
		}

		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'invoice_id';
		}

		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'DESC';
		}

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		$this->data['breadcrumbs'] = array();

		$this->data['breadcrumbs'][] = array(
			'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
			'separator' => false
		);

		$this->data['breadcrumbs'][] = array(
			'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('bill/transaction', 'token=' . $this->session->data['token'] . $url, 'SSL'),
			'separator' => ' :: '
		);


		$this->data['generate'] = $this->url->link('bill/transaction/postPay', 'token=' . $this->session->data['token'], 'SSL');

		$this->data['printPdf'] = $this->url->link('bill/transaction/printPdf', 'token=' . $this->session->data['token'], 'SSL');

		$data=array();
		$billed_list_total = 0;

		$data = array(
			'filter_trans_id'     	 => $filter_trans_id,
			'filter_username'	   	 => $filter_username,
			'filter_name' 			 => $filter_name,
			'filter_email' 	 		 => $filter_email,
			'filter_mobile_no'  	 => $filter_mobile_no,
			'filter_amount'  		 => $filter_amount,
			'filter_payment_type'    => $filter_payment_type,
			'filter_transaction_date'=> $filter_transaction_date,
			'filter_initiated_by'    => $filter_initiated_by,
			'sort'                   => $sort,
			'order'                  => $order,
			'start'                  => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'                  => $this->config->get('config_admin_limit')
		);

		$trans_history = $this->model_bill_transaction->getTransactionList($data);

		$this->data['trans_details']=[];
		
		if(!empty($trans_history)){

			$billed_list_total =$this->model_bill_transaction->getTotalTransaction($data);

			foreach($trans_history as $trans){
				$this->data['trans_details'][] = array(
					'trans_id'	 	 => $trans['mso_lco_tx_id'],
					'username' 		 => $trans['username'],
					'name'  		 => $trans['name'],
					'email'			 => $trans['email'],
					'mobile_no'		 => $trans['mobile_no'],
					'initiated_by'   => $trans['initiated_by'],
					'payment_type'	 => $trans['payment_type'],
					'amount'	 	 => "₹ ".$trans['amount'],
					'date_added'   	 => $trans['date_added'],
					'selected'       => isset($this->request->post['selected']) && in_array($trans['mso_lco_tx_id'], $this->request->post['selected']));
			}
		}
		$this->data['heading_title'] = $this->language->get('heading_title');
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['text_missing'] = $this->language->get('text_missing');

		$this->data['column_txid']		= $this->language->get('column_txid');
		$this->data['column_username']	= $this->language->get('column_username');
		$this->data['column_name']		= $this->language->get('column_name');
		$this->data['column_email']		= $this->language->get('column_email');
		$this->data['column_mobile']	= $this->language->get('column_mobile');
		$this->data['column_amount']	= $this->language->get('column_amount');
		$this->data['column_pay_type']	= $this->language->get('column_pay_type');
		$this->data['column_tx_date']	= $this->language->get('column_tx_date');
		$this->data['column_initiated_by']	= $this->language->get('column_initiated_by');

		$this->data['button_filter'] = $this->language->get('button_filter');
		$this->data['token'] = $this->session->data['token'];

		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		}else if (isset($this->session->data['warning'])) {
			$this->data['error_warning'] = $this->session->data['warning'];
		} else {
			if(isset($this->request->get['error'])){
				$this->data['error_warning'] = "Warning: !";
			}else{
				$this->data['error_warning'] = '';
			}
		}
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		$pagination = new Pagination();
		$pagination->total = $billed_list_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('bill/transaction', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
		$this->data['pagination'] = $pagination->render();
		$this->data['filter_trans_id']    	 	 = $filter_trans_id;
		$this->data['filter_username']	     	 = $filter_username;
		$this->data['filter_name'] 	      	 	 = $filter_name;
		$this->data['filter_email'] 		 	 = $filter_email;
		$this->data['filter_mobile_no']     	 = $filter_mobile_no;
		$this->data['filter_amount']     		 = $filter_amount;
		$this->data['filter_transaction_date']   = $filter_transaction_date;
		
		$this->data['filter_initiated_by']       = $filter_initiated_by;
		$this->data['filter_payment_type']       = $filter_payment_type;
		$this->data['sort'] = $sort;
		$this->data['order'] = $order;
		$this->template = 'bill/transaction_list.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
		$this->response->setOutput($this->render());
	}
}