<?php 
	/*
	@File payment.php(Controller)
	ADMIN Payment list PAGE
	This class show payment list with price to it.

	@Author Ravi Ranjan
	@date 21st March. 2018
	*/
 class ControllerBillOperatorPayment extends Controller {
	
	private $error = array();
	
	public function index() {
			$this->language->load('bill/operator_payment');
			$this->document->setTitle($this->language->get('heading_title'));
			$this->load->model('bill/operator_payment');
	    	$this->getList();
	  	}	

	public function printPdf(){
	    if(isset($this->request->post['selected']))
		  {
			$this->load->model('bill/operator_payment');
			$this->pdf->AddPage();
		    $this->pdf->SetFillColor(232,232,232);
		    $this->pdf->SetFont('times','B',10);
			$this->pdf->SetY(32);
			$this->pdf->SetX(15);
			$this->pdf->Cell(180,6,'-: LCO To MSO Payment :-',1,0,'C',1);
			$this->pdf->SetFont('times','B',8);
			$w = array(15,47,87,137,167);
		    $c = array(32,40,50,30,28);
		    $this->pdf->SetY(40);
		    $header =  array('User Name','Name','Email','Mobile No','Balance'."(Rs)");
			for( $i = 0; $i < count($header) ; $i++){
			  	if($i==0)
		    		$this->pdf->SetX($w[0]);
		      	else
			   		$this->pdf->SetX($w[$i-1]+$c[$i-1]);
			   	$this->pdf->Cell($c[$i],6,$header[$i],1,0,'L',1);
		    }	
		    $this->pdf->Ln();
		    $this->pdf->SetFont('times','',8);
	        foreach ($this->request->post['selected'] as $selected) {
		     $result = $this->model_bill_operator_payment->getLCOPaymentPDFdata($selected);
			    $this->pdf->SetX(15);
			    $this->pdf->Cell($c[0],6,$result["username"],1,0,'L',0);
			    $this->pdf->Cell($c[1],6,$result["name"],1,0,'L',0);
			    $this->pdf->Cell($c[2],6,$result["email"],1,0,'L',0);
			    $this->pdf->Cell($c[3],6,$result['mobile_no'],1,0,'L',0);
			    $this->pdf->Cell($c[4],6,$result['credit'],1,0,'L',0);
			    $this->pdf->Ln();	
			}
		 	$this->pdf->Output();	   
			}else{
				$this->language->load('bill/transaction');
				$this->document->setTitle($this->language->get('heading_title'));
				$this->load->model('bill/transaction');
		       	$this->data['error_warning'] = $this->language->get('select_waning');
		       	$this->getList();
			}    
    	}

	public function getList(){
		
		//==========Paypal Data ==============
		$flag = 1;
		if(!empty($_REQUEST['st']) && $flag == 1){
			$this->load->model('bill/operator_payment');
			$this->language->load('bill/operator_payment');
			$itemNo            = $_REQUEST['item_number'];
			$itemTransaction   = $_REQUEST['tx'];  // Paypal transaction ID
			$itemPrice         = $_REQUEST['amt']; // Paypal received amount 
			$itemCurrency      = $_REQUEST['cc'];  // Paypal received currency type
			
			$item_name         = $_REQUEST['item_name'];
			$pay_status        = $_REQUEST['st'];

			$post_values['operator_id']   = $itemNo;
			$post_values['paypal_amount']  = $itemPrice;
			$post_values['payment_method'] = "paypal";

			$post_values['transaction_id'] = $itemTransaction;
			$post_values['status'] 		   = $pay_status;

 			$this->model_bill_operator_payment->addlcoCredite($post_values);

			$url='';
			$this->session->data['success'] = $this->language->get('text_success');
			$this->redirect($this->url->link('bill/operator_payment', 'token=' . $this->session->data['token'] . $url, 'SSL'));
			
		}	
		//====================================
		$this->language->load('bill/operator_payment');
		$this->load->model('bill/operator_payment');

		$url='';

		if (isset($this->request->get['filter_username'])) {
			$filter_username = $this->request->get['filter_username'];
		} else {
			$filter_username = null;
		}

		if (isset($this->request->get['filter_name'])) {
			$filter_name = $this->request->get['filter_name'];
		} else {
			$filter_name = null;
		}

		if (isset($this->request->get['filter_email'])) {
			$filter_email = $this->request->get['filter_email'];
		} else {
			$filter_email = null;
		}

		if (isset($this->request->get['filter_mobile_no'])) {
			$filter_mobile_no = $this->request->get['filter_mobile_no'];
		} else {
			$filter_mobile_no = null;
		}

		if (isset($this->request->get['filter_credit']) && preg_match("#^[a-zA-Z0-9 ]+$#", $this->request->get['filter_credit'])) {
			$filter_credit = $this->request->get['filter_credit'];
		} else {
			$filter_credit = null;
		}

		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'user_id';
		}

		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'DESC';
		}

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		$this->data['breadcrumbs'] = array();

		$this->data['breadcrumbs'][] = array(
			'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
			'separator' => false
		);

		$this->data['breadcrumbs'][] = array(
			'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('bill/operator_payment', 'token=' . $this->session->data['token'] . $url, 'SSL'),
			'separator' => ' :: '
		);
		$this->data['lco_paybutton_disable'] = $this->session->data['user_group_id'];
		$this->data['generate'] = $this->url->link('bill/operator_payment/postPay', 'token=' . $this->session->data['token'], 'SSL');

		$this->data['printPdf'] = $this->url->link('bill/operator_payment/printPdf', 'token=' . $this->session->data['token'], 'SSL');

		$data=array();
		$billed_list_total = 0;

		$data = array(
			'filter_username'     	 => $filter_username,
			'filter_name'	     	 => $filter_name,
			'filter_email' 			 => $filter_email,
			'filter_mobile_no' 	 	 => $filter_mobile_no,
			'filter_credit' 		 => $filter_credit,
			'sort'                   => $sort,
			'order'                  => $order,
			'start'                  => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'                  => $this->config->get('config_admin_limit')
		);
		$paid_details = $this->model_bill_operator_payment->getUserPaymentList($data);

		$total = $this->model_bill_operator_payment->getTotalpaid($data);

		$this->data['payment_details']=[];
		if(!empty($paid_details)){
			
			foreach($paid_details as $result){
				$this->data['payment_details'][] = array(
					'user_id'    => $result['user_id'],
					'usename'    => $result['username'],
					'name' 	     => $result['name'],
					'email'  	 => $result['email'],
					'mobile_no'	 => $result['mobile_no'],
					'credit'	 => "₹"." ".$result['credit'],
					'selected'       => isset($this->request->post['selected']) && in_array($result['user_id'], $this->request->post['selected'])
				);
			}
		}
		$this->data['heading_title'] = $this->language->get('heading_title');
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['text_missing'] = $this->language->get('text_missing');

		$this->data['column_lco_username'] = $this->language->get('column_lco_username');
		$this->data['column_lco_name']	   = $this->language->get('column_lco_name');

		$this->data['column_lco_email']	   = $this->language->get('column_lco_email');
		$this->data['column_lco_mobile']   = $this->language->get('column_lco_mobile');
		$this->data['column_lco_balance']  = $this->language->get('column_lco_balance');

		$this->data['column_stb']	=	$this->language->get('column_stb');
		$this->data['column_paid']	=   $this->language->get('column_paid');

		$this->data['column_advance']	= $this->language->get('column_advance');
		$this->data['column_balance']	= $this->language->get('column_balance');

		$this->data['column_created_date']	 = $this->language->get('column_created_date');
		$this->data['column_payment_option'] =	$this->language->get('column_payment_option');

		$this->data['column_action']	=  $this->language->get('column_action');
		$this->data['button_invoice']   =  $this->language->get('button_invoice');

		$this->data['button_generate'] = $this->language->get('button_generate');
		$this->data['button_delete']   = $this->language->get('button_delete');
		$this->data['button_filter']   = $this->language->get('button_filter');
		
		$this->data['token'] = $this->session->data['token'];
		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		}else if (isset($this->session->data['warning'])) {
			$this->data['error_warning'] = $this->session->data['warning'];
		} else {
			if(isset($this->request->get['error'])){
				$this->data['error_warning'] = "Warning: !";
			}else{
				$this->data['error_warning'] = '';
			}
		}
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		$pagination = new Pagination();
		$pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('bill/operator_payment', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');

		$this->data['pagination'] = $pagination->render();
		$this->data['filter_username']    	 = $filter_username;
		$this->data['filter_name']	     	 = $filter_name;
		$this->data['filter_email'] 	     = $filter_email;
		$this->data['filter_mobile_no'] 	 = $filter_mobile_no;
		$this->data['filter_credit']     	 = $filter_credit;
		$this->data['sort'] = $sort;
		$this->data['order'] = $order;
		
		$this->template = 'bill/operator_payment_list.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
		$this->response->setOutput($this->render());
	}

	public function postPay(){
		
		$total=0;
		$this->language->load('bill/operator_payment');
		$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('bill/operator_payment');

		$this->data['heading_title'] 	= $this->language->get('heading_title');
		$this->data['button_save']		= $this->language->get('button_save');
		$this->data['button_cancel'] 	= $this->language->get('button_cancel');
		$this->data['button_invoice'] 	= $this->language->get('button_invoice');

		$this->data['entry_lco_name'] 	= $this->language->get('entry_lco_name');
		$this->data['entry_billing_month'] 	= $this->language->get('entry_billing_month');
		$this->data['entry_bill_amount'] 	= $this->language->get('entry_bill_amount');
		$this->data['entry_advance_amount'] = $this->language->get('entry_advance_amount');
		$this->data['entry_less_amount'] 	= $this->language->get('entry_less_amount');

		if (isset($this->request->get['filter_operator_id'])) {
			$filter_operator_id = $this->request->get['filter_operator_id'];
		} else {
			$filter_operator_id = null;
		}
 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}

		
		if (isset($this->error['filter_operator_id'])) {
			$this->data['error_operator_id'] = $this->error['filter_operator_id'];
		} else {
			$this->data['error_operator_id'] = '';
		}

		if (isset($this->error['payable_amount'])) {
			$this->data['error_payable'] = $this->error['payable_amount'];
		} else {
			$this->data['error_payable'] = '';
		}

		$url = '';

		if (isset($this->request->get['filter_operator_id'])) {
			$url .= '&filter_operator_id=' . $this->request->get['filter_operator_id'];
		}
		$this->data['breadcrumbs'] = array();
		$this->data['breadcrumbs'][] = array(
			'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
			'separator' => false
		);

		$this->data['breadcrumbs'][] = array(
			'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('bill/operator_payment', 'token=' . $this->session->data['token'] . $url, 'SSL'),
			'separator' => ' :: '
		);
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
		$data = array(
			'start'           => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'           => $this->config->get('config_admin_limit')
		);
		$data = array('filter_operator_id'=> $filter_operator_id);
		$this->load->model('bill/operator_payment');
		$resultOperators = $this->model_bill_operator_payment->getOperators();
		if($this->session->data["user_id"] == 1){
		foreach ($resultOperators as $operator) {
			$this->data['operators'][] = array(
				'name' =>$operator['username'],
				'operator_id' =>$operator['user_id'],
				);
		}
		}else{
			$operator = $this->model_bill_operator_payment->getOperator($this->session->data["user_id"]);		
			$this->data['operators'][] = array(
				'name' =>$operator['username'],
				'operator_id' =>$operator['user_id'],
				);
		}
		$this->data['subscribed_details']=array();
		if(isset($this->request->get['filter_operator_id']) && $this->request->get['filter_operator_id']!=''){
			
			$key_id 	= $this->model_bill_operator_payment->getKeyId();
			$result_val = $this->model_bill_operator_payment->getLCODetails($data);
				$total_price=0;
					$this->data['subscribed_details'][]=[
						'key_id'				=> $key_id,
						'operator_name' 		=> $result_val['user_name'],
						'operator_id' 			=> $result_val['user_id'],
						'telephone' 			=> $result_val['mobile_no'],
						'email'					=> $result_val['email'],
						'balance'			    => $result_val['credit'],
						];
				}

			$this->data['filter_operator_id'] = $filter_operator_id;		
		//==========================
			// Payment Methods
			$method_data = array();
			$payment_address = array();
			$payment_address['country_id'] = 99;
			$payment_address['zone_id'] = 1479;

			$results = $this->model_bill_operator_payment->getExtensions('payment');

			foreach ($results as $result) {
				if ($this->config->get($result['code'] . '_status')) {
					
					$this->load->model('bill/' . $result['code']);
									
					$method = $this->{'model_bill_' . $result['code']}->getMethod($payment_address, 10); 
					if ($method) {
						$method_data[$result['code']] = $method;
					}
				}
			}
			$sort_order = array(); 
			foreach ($method_data as $key => $value) {
				$sort_order[$key] = $value['sort_order'];
			}
			array_multisort($sort_order, SORT_ASC, $method_data);			
			
			$this->session->data['payment_methods'] = $method_data;	
		// }			
		//Assigning page variables.		
		
		$this->data['text_payment_method'] = "Payment Method :"; //$this->language->

		$this->data['text_comments'] = $this->language->get('text_comments');

		$this->data['button_continue'] = $this->language->get('button_continue');
		//validating payment methods 
		if (empty($this->session->data['payment_methods'])) {
			$this->data['error_warning'] = sprintf($this->language->get('error_no_payment'), $this->url->link('information/contact'));
		
		} else {
			$this->data['error_warning'] = '';
		}	
		
		if (isset($this->session->data['payment_methods'])) {

			$this->data['payment_methods'] = $this->session->data['payment_methods']; 
		} else {
			$this->data['payment_methods'] = array();
		}
	  
		if (isset($this->session->data['payment_method']['code'])) {
			$this->data['code'] = $this->session->data['payment_method']['code'];
		} else {
			$this->data['code'] = '';
		}
		//==========================
		if (isset($this->request->post['payable_amount'])) {
      		$this->data['payable_amount'] = $this->request->post['payable_amount'];
		}else {
      		$this->data['payable_amount'] = '';
    	}
		
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		if(!isset($this->data['error_warning'])){
			$this->data['error_warning']='';
		}

		$this->language->load('bill/operator_payment');
		$this->data['token'] = $this->session->data['token'] ; 

		$this->data['action'] = $this->url->link('bill/operator_payment/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');

		$this->data['cancel'] = $this->url->link('bill/operator_payment', 'token=' . $this->session->data['token'] . $url, 'SSL');

		$this->data['return_url_paypal'] = $this->url->link('bill/operator_payment/', 'token=' . $this->session->data['token'] . $url, 'SSL'); 

		$this->data['return_url'] = $this->url->link('bill/operator_payment/insert', 'token=' . $this->session->data['token'] . $url, 'SSL'); 

		$this->template = 'bill/operator_payment.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
		$this->response->setOutput($this->render());
	}

	public function insert(){
				
		$this->load->model('bill/operator_payment');
		$this->language->load('bill/operator_payment');
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && ($this->request->post['payment_method'] == 'razorpay')) { 
			
			$razorpay_payment_id    = $this->request->post['razorpay_payment_id'];
            $merchant_order_id      = $this->request->post['merchant_order_id'];
            
            $key_id 	= $this->config->get('razorpay_key_id');
            $key_secret = $this->config->get('razorpay_key_secret');
            $success 	= false;
            $error 		= "";
            $amount 	= $this->request->post['payable_amount_online'];
            
            try {
                   $url = 'https://api.razorpay.com/v1/payments/'.$razorpay_payment_id.'/capture';
                   $fields_string="amount=$amount";
                    //cURL Request
                    $ch = curl_init();
                    //set the url, number of POST vars, POST data
                    curl_setopt($ch,CURLOPT_URL, $url);
                    curl_setopt($ch,CURLOPT_USERPWD, $key_id . ":" . $key_secret);
                    curl_setopt($ch,CURLOPT_TIMEOUT, 60);
                    curl_setopt($ch,CURLOPT_POST, 1);
                    curl_setopt($ch,CURLOPT_POSTFIELDS, $fields_string);
                    curl_setopt($ch,CURLOPT_RETURNTRANSFER, TRUE);
                    //execute post
                    $result = curl_exec($ch);
                    $http_status = curl_getinfo($ch, CURLINFO_HTTP_CODE);
                    if($result === false) {
                        $success = false;
                        $error = 'Curl error: ' . curl_error($ch);
                    }
                    else {
                        $response_array = json_decode($result, true);
                        //Check success response
                        if($http_status === 200 and isset($response_array['error']) === false){
                            $success = true;    
                        	
                        }
                        else {
                            $success = false;
                            if(!empty($response_array['error']['code'])) {
                                $error = $response_array['error']['code'].":".$response_array['error']['description'];
                            }
                            else {
                                $error = "RAZORPAY_ERROR:Invalid Response <br/>".$result;
                            }
                        }
                    }
                    curl_close($ch);
                }
                catch (Exception $e) {
                    $success = false;
                    $error ="OPENCART_ERROR:Request to Razorpay Failed";
                }

                if ($success === true) {

 			    $post_values = $this->request->post;
 			    
 			    $post_values["payable_amount_online"] = ($post_values["payable_amount_online"]/100);
 			    
 			    $this->model_bill_operator_payment->addlcoCredite($post_values);
				                
                echo '<html>' . "\n";
                echo '<head>' . "\n";
                echo '  <meta http-equiv="Refresh" content="0; url=' . $this->url->link('bill/operator_payment', 'token=' . $this->session->data['token'] ) . '">' . "\n";
                echo '</head>'. "\n";
                echo '<body>' . "\n";
                echo 'Payment12324 Successful. <p>Please <a href="' . $this->url->link('bill/operator_payment', 'token=' . $this->session->data['token']) . '">click here to continue</a>!</p>' . "\n";
                echo '</body>' . "\n";
                echo '</html>' . "\n";

                $this->session->data['success'] = $this->language->get('text_success');
                exit();
            } 
		}

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && ($this->request->post['payment_method'] == "cod") && $this->validate()) { 
				
				$post_values = $this->request->post;
				$this->model_bill_operator_payment->addlcoCredite($post_values);
				$url='';
				$this->session->data['success'] = $this->language->get('text_success');
				$this->redirect($this->url->link('bill/operator_payment', 'token=' . $this->session->data['token'] . $url, 'SSL'));
		}
		$this->postPay();
	}

	public function validate(){
			$this->language->load('bill/operator_payment');
	    	if (!$this->user->hasPermission('modify', 'bill/operator_payment')) {
	      		$this->error['warning'] = $this->language->get('error_permission');
	    	}
	    	if (empty($this->request->post['filter_operator_id']) || ($this->request->post['filter_operator_id']) == NULL) {
      			$this->error['filter_operator_id'] = $this->language->get('error_operator');
    		}
    		if (empty($this->request->post['payable_amount'])) {
      			$this->error['payable_amount'] = $this->language->get('error_payable_amount');
    		}
    		
	
		    if (!$this->error) {
				return true;
	    	} else {
	      		return false;
	    	}	
	}

}