<?php 
	/*
	@File transaction.php(Controller)
	ADMIN History of Transaction list PAGE
	This class show Transaction list with price to it.

	@Author Ravi Ranjan
	@date 17th March. 2018
	*/
 class ControllerBillBylcosubstrans extends Controller {
	private $error = array();
	
	public function index() {
			$this->language->load('bill/bylcosubstrans');
			$this->document->setTitle($this->language->get('heading_title'));
			$this->load->model('bill/bylcosubstrans');
	    	$this->getList();
	  	}	
	public function printPdf(){
	    if(isset($this->request->post['selected']))
		 { 
			
		 	// var_dump($this->request->post['selected']);exit();
			$this->load->model('bill/bylcosubstrans');
			$this->pdf->AddPage();
		    $this->pdf->SetFillColor(232,232,232);
		    $this->pdf->SetFont('times','B',10);
			$this->pdf->SetY(32);
			$this->pdf->SetX(15);

			$this->pdf->Cell(186,6,'-:By LCO/MSO Subscription :-',1,0,'C',1);
			$this->pdf->SetFont('times','B',8);
		    
			$w = array(15,30,55,90,120,150,170);
		    $c = array(15,25,35,30,30,20,30);

		    $this->pdf->SetY(40);
		    $header =  array('Order Id','STBNO','Customer','Operator','Initiator','Amount(Rs.)','Tx. Date');

			for( $i = 0; $i < count($header) ; $i++){
			  	if($i==0)
		    		$this->pdf->SetX($w[0]);
		      	else
			   		$this->pdf->SetX($w[$i-1]+$c[$i-1]);
			   	 $this->pdf->Cell($c[$i],6,$header[$i],1,0,'L',1);
		    }	
		    $this->pdf->Ln();
		    $this->pdf->SetFont('times','',8);
		    foreach ($this->request->post['selected'] as $selected) {
	        $result = $this->model_bill_bylcosubstrans->getTransactionListPDF($selected);
			    	$this->pdf->SetX(15);
			    	$this->pdf->Cell($c[0],6,$result["order_id"],1,0,'L',0);
			    	$this->pdf->Cell($c[1],6,$result["stbno"],1,0,'L',0);
			    	$this->pdf->Cell($c[2],6,$result["cname"],1,0,'L',0);
			    	$this->pdf->Cell($c[3],6,$result['lco'],1,0,'L',0);
			    	$this->pdf->Cell($c[4],6,$result['initiator'],1,0,'L',0);
			    	$this->pdf->Cell($c[5],6,$result['amount'],1,0,'L',0);
			    	$this->pdf->Cell($c[6],6,$result['date_triggered'],1,0,'L',0);

			    	$this->pdf->Ln();
		    }
		    $this->pdf->Output();
			}else{
				$this->language->load('bill/bylcosubstrans');
				$this->document->setTitle($this->language->get('heading_title'));
				$this->load->model('bill/bylcosubstrans');
		       	$this->data['error_warning'] = $this->language->get('select_waning');
		       	$this->getList();
			}    
    	}

	public function getList(){

		$this->language->load('bill/bylcosubstrans');
		$this->load->model('bill/bylcosubstrans');
		$url='';

		if (isset($this->request->get['filter_order_id'])) {
			$filter_order_id = $this->request->get['filter_order_id'];
		} else {
			$filter_order_id = null;
		}

		if (isset($this->request->get['filter_stbno'])) {
			$filter_stbno = $this->request->get['filter_stbno'];
		} else {
			$filter_stbno = null;
		}

		if (isset($this->request->get['filter_name'])) {
			$filter_name = $this->request->get['filter_name'];
		} else {
			$filter_name = null;
		}
		if (isset($this->request->get['filter_lco_id'])) {
			$filter_lco_id = $this->request->get['filter_lco_id'];
		} else {
			$filter_lco_id = null;
		}
		if (isset($this->request->get['filter_initiator_id'])) {
			$filter_initiator_id = $this->request->get['filter_initiator_id'];
		} else {
			$filter_initiator_id = null;
		}
/*		if (isset($this->request->get['filter_lco']) && preg_match("#^[a-zA-Z0-9 ]+$#", $this->request->get['filter_lco'])) {
			
			$result = $this->model_bill_bylcosubstrans->getLCOUserid($this->request->get['filter_lco']);
			$filter_lco = $this->request->get['filter_lco'];
		} else {
			$filter_lco = null;
		}

		if (isset($this->request->get['filter_initiator']) && preg_match("#^[a-zA-Z0-9 ]+$#", $this->request->get['filter_initiator'])) {

			$result = $this->model_bill_bylcosubstrans->getLCOUserid($this->request->get['filter_initiator']);
			
			$filter_initiator = $this->request->get['filter_initiator'];
		} else {
			$filter_initiator = null;
		}*/

		if (isset($this->request->get['filter_amount'])) {
			$filter_amount = $this->request->get['filter_amount'];
		} else {
			$filter_amount = null;
		}

		if (isset($this->request->get['filter_transaction_date'])) {
			$filter_transaction_date = $this->request->get['filter_transaction_date'];
		} else {
			$filter_transaction_date = null;
		}

		if (isset($this->request->get['filter_initiated_by'])) {
			$filter_initiated_by = $this->request->get['filter_initiated_by'];
		} else {
			$filter_initiated_by = null;
		}

		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'invoice_id';
		}

		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'DESC';
		}

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		$this->data['breadcrumbs'] = array();

		$this->data['breadcrumbs'][] = array(
			'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
			'separator' => false
		);

		$this->data['breadcrumbs'][] = array(
			'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('bill/bylcosubstrans', 'token=' . $this->session->data['token'] . $url, 'SSL'),
			'separator' => ' :: '
		);


		$this->data['generate'] = $this->url->link('bill/bylcosubstrans/postPay', 'token=' . $this->session->data['token'], 'SSL');

		$this->data['printPdf'] = $this->url->link('bill/bylcosubstrans/printPdf', 'token=' . $this->session->data['token'], 'SSL');

		$resultOperators = $this->model_bill_bylcosubstrans->getOperators();
		foreach ($resultOperators as $operator) {
			$this->data['operators'][] = array(
				'name' =>$operator['username'],
				'operator_id' =>$operator['user_id'],
				);
		}

		$resultOperators = $this->model_bill_bylcosubstrans->getInitiators();
		foreach ($resultOperators as $operator) {
			$this->data['initiator'][] = array(
				'name' =>$operator['username'],
				'operator_id' =>$operator['user_id'],
				);
		}

		$data=array();
		$billed_list_total = 0;

		$data = array(
			'filter_order_id'     	 => $filter_order_id,
			'filter_stbno'	   	 	 => $filter_stbno,
			'filter_name' 			 => $filter_name,
			'filter_lco_id' 	 		 => $filter_lco_id,
			'filter_initiator_id'  	 => $filter_initiator_id,
			'filter_amount'  		 => $filter_amount,
			'filter_transaction_date'=> $filter_transaction_date,
			
			'sort'                   => $sort,
			'order'                  => $order,
			'start'                  => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'                  => $this->config->get('config_admin_limit')
		);

		$trans_history = $this->model_bill_bylcosubstrans->getTransactionList($data);
		
		$this->data['trans_details']=[];
		
		if(!empty($trans_history)){

			$billed_list_total =$this->model_bill_bylcosubstrans->getTotalTransaction($data);

			foreach($trans_history as $trans){
				$this->data['trans_details'][] = array(
					'order_id'	 	 => $trans['order_id'],
					'stbno' 		 => $trans['stbno'],
					'cname'  		 => $trans['cname'],
					'lco'			 => $trans['lco'],
					'initiator'		 => $trans['initiator'],
					'amount'         => "₹ ".$trans['amount'],
					'date_triggered' => $trans['date_triggered'],

					'selected'       => isset($this->request->post['selected']) && in_array($trans['order_id'], $this->request->post['selected']));
			}
		}
		$this->data['heading_title'] = $this->language->get('heading_title');
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['text_missing'] = $this->language->get('text_missing');

		$this->data['column_txid']		= $this->language->get('column_txid');
		$this->data['column_stb']		= $this->language->get('column_stb');
		$this->data['column_name']		= $this->language->get('column_name');
		$this->data['column_lco']		= $this->language->get('column_lco');
		$this->data['column_initiate']	= $this->language->get('column_initiate');
		$this->data['column_amount']	= $this->language->get('column_amount');
		
		$this->data['column_tx_date']	= $this->language->get('column_tx_date');
		$this->data['column_initiated_by']	= $this->language->get('column_initiated_by');

		$this->data['button_filter'] = $this->language->get('button_filter');
		$this->data['token'] = $this->session->data['token'];

		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		}else if (isset($this->session->data['warning'])) {
			$this->data['error_warning'] = $this->session->data['warning'];
		} else {
			if(isset($this->request->get['error'])){
				$this->data['error_warning'] = "Warning: !";
			}else{
				$this->data['error_warning'] = '';
			}
		}
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		$pagination = new Pagination();
		$pagination->total = $billed_list_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('bill/bylcosubstrans', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
		$this->data['pagination'] = $pagination->render();
		$this->data['filter_order_id']    	 	 = $filter_order_id;
		$this->data['filter_stbno']	     	 	 = $filter_stbno;
		$this->data['filter_name'] 	      	 	 = $filter_name;
		$this->data['filter_lco_id'] 		 	 = $filter_lco_id;
		$this->data['filter_initiator_id']     	 = $filter_initiator_id;
		$this->data['filter_amount']     		 = $filter_amount;
		$this->data['filter_transaction_date']   = $filter_transaction_date;
		$this->data['sort'] = $sort;
		$this->data['order'] = $order;
		$this->template = 'bill/bylcosubstrans.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
		$this->response->setOutput($this->render());
	}
}