<?php
/*
@File user_group.php(MODEL)
USER:	 USER_GROUP PAGE
    This class queries,adds and updates the user_group details to the database for the backend page.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ModelUserUserGroup extends Model {
/*
FUNCTION NAME 		-	validateUserGroup
DESCRIPTION 		-	Queries to get the total number of user_group_name in the database.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	returns a row with column total containing count retrieved.

*/	
	public function validateUserGroup($user_group_name){
		// $query = $this->db->query("SELECT * FROM ".DB_PREFIX."user_group WHERE name='".$user_group_name."'");
		// return (mysql_num_rows($query->rows));
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "user_group WHERE name LIKE '%".$user_group_name."%'");
		
		return $query->row['total'];
	}
/*
FUNCTION NAME 		-	addUserGroup
DESCRIPTION 		-	Adds new user_group detail to the database.
INPUT PARAMETER 	-	data array containing the user_group description.
OUTPUT PARAMETER 	- 	Adds to the database and returns to 
						the user_list list page with a success notification
*/	
	public function addUserGroup($data) {
		$this->db->query("INSERT INTO " . DB_PREFIX . "user_group SET name = '" . $this->db->escape($data['name']) . "', permission = '" . (isset($data['permission']) ? serialize($data['permission']) : '') . "'");
	}
/*
FUNCTION NAME 		-	editUserGroup
DESCRIPTION 		-	Updates the given user_group detail to the database.
INPUT PARAMETER 	-	data array containing the user_group details, user_group_id
OUTPUT PARAMETER 	- 	Updates the database and returns to the user_group list page.
*/		
	public function editUserGroup($user_group_id, $data) {
		$this->db->query("UPDATE " . DB_PREFIX . "user_group SET name = '" . $this->db->escape($data['name']) . "', permission = '" . (isset($data['permission']) ? serialize($data['permission']) : '') . "' WHERE user_group_id = '" . (int)$user_group_id . "'");
	}
/*
FUNCTION NAME 		-	deleteUserGroup
DESCRIPTION 		-	Deletes the user_group for the given user_group_id
INPUT PARAMETER 	-	user_group_id
OUTPUT PARAMETER 	- 	Deletes the user_group and returns to the list page.
*/	
	public function deleteUserGroup($user_group_id) {
		$this->db->query("DELETE FROM " . DB_PREFIX . "user_group WHERE user_group_id = '" . (int)$user_group_id . "'");
	}
/*
FUNCTION NAME 		-	addPermission
DESCRIPTION 		-	Adds user page access permission for the given user
INPUT PARAMETER 	-	user_id, type variable, page
OUTPUT PARAMETER 	- 	Adds permission and returns
*/
	public function addPermission($user_id, $type, $page) {
		$user_query = $this->db->query("SELECT DISTINCT user_group_id FROM " . DB_PREFIX . "user WHERE user_id = '" . (int)$user_id . "'");
		
		if ($user_query->num_rows) {
			$user_group_query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "user_group WHERE user_group_id = '" . (int)$user_query->row['user_group_id'] . "'");
		
			if ($user_group_query->num_rows) {
				$data = unserialize($user_group_query->row['permission']);
		
				$data[$type][] = $page;
		
				$this->db->query("UPDATE " . DB_PREFIX . "user_group SET permission = '" . serialize($data) . "' WHERE user_group_id = '" . (int)$user_query->row['user_group_id'] . "'");
			}
		}
	}
/*
FUNCTION NAME 		-	getUserGroup
DESCRIPTION 		-	Retrieves the user_group details for the given user_group_id
INPUT PARAMETER 	-	user_group_id
OUTPUT PARAMETER 	- 	Returns the row retrieved containing the user_group detials.
*/	
	public function getUserGroup($user_group_id) {
		$query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "user_group WHERE user_group_id = '" . (int)$user_group_id . "'");
		
		$user_group = array(
			'name'       => $query->row['name'],
			'permission' => unserialize($query->row['permission'])
		);
		
		return $user_group;
	}
/*
FUNCTION NAME 		-	getUserGroups
DESCRIPTION 		-	Retrieves all the user_group details
INPUT PARAMETER 	-	data array containing the filter options if any
OUTPUT PARAMETER 	- 	Returns all the rows retrieved containing the user_group detials.
*/	
	public function getUserGroups($data = array()) {
		$sql = "SELECT * FROM " . DB_PREFIX . "user_group";
		
		$sql .= " ORDER BY name";	
			
		if (isset($data['order']) && ($data['order'] == 'DESC')) {
			$sql .= " DESC";
		} else {
			$sql .= " ASC";
		}
		
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}			

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
			
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}
			
		$query = $this->db->query($sql);
		
		return $query->rows;
	}
/*
FUNCTION NAME 		-	getTotalUserGroups
DESCRIPTION 		-	Queries to get the total number of user_goups in the database.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	returns a row with column total containing count for the user_group table.
*/		
	public function getTotalUserGroups() {
      	$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "user_group");
		
		return $query->row['total'];
	}
/*
FUNCTION NAME 		-	isUserTopadmin
DESCRIPTION 		-	Queries to get the user_group_id from the database.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	returns a user_group_id from the user_group table.
*/
	public function isUserTopadmin($user_id)
	{
		$query = $this->db->query("SELECT user_group_id FROM " . DB_PREFIX . "user WHERE user_id like '" . $user_id . "'");	
		return ($query->row['user_group_id']==1)?true:false;
	}

	public function validateUserGroupUpdate($user_group_name,$user_group_id) {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "user_group WHERE name='".$user_group_name."' and user_group_id !=".$user_group_id);
		return $query->row['total'];
	}		

}
?>