<?php 
/*
@File setting.php(MODEL)
SETTING:	 SETTING PAGE
    This class queries,deletes and updates store setting.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ModelSettingSetting extends Model {
/*
FUNCTION NAME 		-	getSetting
DESCRIPTION 		-	Queries all the setting for the selected store.
INPUT PARAMETER 	-	group variable, store_id
OUTPUT PARAMETER 	- 	Returns the data array containing all the setting details.
*/	
	public function getSetting($group, $store_id = 0) {
		$data = array(); 
		
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "setting WHERE store_id = '" . (int)$store_id . "' AND `group` = '" . $this->db->escape($group) . "'");
		
		foreach ($query->rows as $result) {
			if (!$result['serialized']) {
				$data[$result['key']] = $result['value'];
			} else {
				$data[$result['key']] = unserialize($result['value']);
			}
		}

		return $data;
	}
/*
FUNCTION NAME 		-	editSetting
DESCRIPTION 		-	Updates the new setting for the store.
INPUT PARAMETER 	-	group variable, data array containing setting details for the store, store_id
OUTPUT PARAMETER 	- 	updates the settings and returns to the list page.
*/	
	public function editSetting($group, $data, $store_id = 0) {
		$this->db->query("DELETE FROM " . DB_PREFIX . "setting WHERE store_id = '" . (int)$store_id . "' AND `group` = '" . $this->db->escape($group) . "'");

		foreach ($data as $key => $value) {
			if (!is_array($value)) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "setting SET store_id = '" . (int)$store_id . "', `group` = '" . $this->db->escape($group) . "', `key` = '" . $this->db->escape($key) . "', `value` = '" . $this->db->escape($value) . "'");
			} else {
				$this->db->query("INSERT INTO " . DB_PREFIX . "setting SET store_id = '" . (int)$store_id . "', `group` = '" . $this->db->escape($group) . "', `key` = '" . $this->db->escape($key) . "', `value` = '" . $this->db->escape(serialize($value)) . "', serialized = '1'");
			}
		}
	}
/*
FUNCTION NAME 		-	deleteSetting
DESCRIPTION 		-	Deletes all the setting details for the selected store.
INPUT PARAMETER 	-	group variable, store_id
OUTPUT PARAMETER 	- 	Deletes the selected store setting and returns to the list page.
*/	
	public function deleteSetting($group, $store_id = 0) {
		$this->db->query("DELETE FROM " . DB_PREFIX . "setting WHERE store_id = '" . (int)$store_id . "' AND `group` = '" . $this->db->escape($group) . "'");
	}
/*
FUNCTION NAME 		-	editSettingValue
DESCRIPTION 		-	Updates the specific setting values for the given store_id
INPUT PARAMETER 	-	group variable, key containing the column name, value containing the data, store_id
OUTPUT PARAMETER 	- 	Updates the setting and returns to the list page.
*/	
	public function editSettingValue($group = '', $key = '', $value = '', $store_id = 0) {
		if (!is_array($value)) {
			$this->db->query("UDPATE " . DB_PREFIX . "setting SET `value` = '" . $this->db->escape($value) . " WHERE `group` = '" . $this->db->escape($group) . "' AND `key` = '" . $this->db->escape($key) . "' AND store_id = '" . (int)$store_id . "'");
		} else {
			$this->db->query("UDPATE " . DB_PREFIX . "setting SET `value` = '" . $this->db->escape(serialize($value)) . "' WHERE `group` = '" . $this->db->escape($group) . "' AND `key` = '" . $this->db->escape($key) . "' AND store_id = '" . (int)$store_id . "', serialized = '1'");
		}
	}	
}
?>