<?php
/*
@File coupon.php(MODEL)
SALE:	 COUPON PAGE
    Manages the coupon by inserting, deleting and updating the coupon informations. 
    It also retrieves the coupon details if requiered.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ModelSaleCoupon extends Model {
/*
FUNCTION NAME 		-	addCoupon
DESCRIPTION 		-	Adds new coupon option to the database.
INPUT PARAMETER 	-	data array containing the details of the coupon.
OUTPUT PARAMETER 	- 	Inserts the coupon details to the database and returns.
*/	
	public function addCoupon($data) {
      	$this->db->query("INSERT INTO " . DB_PREFIX . "coupon SET name = '" . $this->db->escape($data['name']) . "', code = '" . $this->db->escape($data['code']) . "', discount = '" . (float)$data['discount'] . "', type = '" . $this->db->escape($data['type']) . "', total = '" . (float)$data['total'] . "', logged = '" . (int)$data['logged'] . "', shipping = '" . (int)$data['shipping'] . "', date_start = '" . $this->db->escape($data['date_start']) . "', date_end = '" . $this->db->escape($data['date_end']) . "', uses_total = '" . (int)$data['uses_total'] . "', uses_customer = '" . (int)$data['uses_customer'] . "', status = '" . (int)$data['status'] . "', date_added = NOW()");

      	$coupon_id = $this->db->getLastId();
		
		if (isset($data['coupon_product'])) {
      		foreach ($data['coupon_product'] as $product_id) {
        		$this->db->query("INSERT INTO " . DB_PREFIX . "coupon_product SET coupon_id = '" . (int)$coupon_id . "', product_id = '" . (int)$product_id . "'");
      		}			
		}
		
		if (isset($data['coupon_category'])) {
      		foreach ($data['coupon_category'] as $category_id) {
        		$this->db->query("INSERT INTO " . DB_PREFIX . "coupon_category SET coupon_id = '" . (int)$coupon_id . "', category_id = '" . (int)$category_id . "'");
      		}			
		}		
	}
/*
FUNCTION NAME 		-	editCoupon
DESCRIPTION 		-	Updates the coupon information based on the new values given in the array.
INPUT PARAMETER 	-	data array containing the information of the coupon
OUTPUT PARAMETER 	- 	Returns after updating
*/	
	public function editCoupon($coupon_id, $data) {
		$this->db->query("UPDATE " . DB_PREFIX . "coupon SET name = '" . $this->db->escape($data['name']) . "', code = '" . $this->db->escape($data['code']) . "', discount = '" . (float)$data['discount'] . "', type = '" . $this->db->escape($data['type']) . "', total = '" . (float)$data['total'] . "', logged = '" . (int)$data['logged'] . "', shipping = '" . (int)$data['shipping'] . "', date_start = '" . $this->db->escape($data['date_start']) . "', date_end = '" . $this->db->escape($data['date_end']) . "', uses_total = '" . (int)$data['uses_total'] . "', uses_customer = '" . (int)$data['uses_customer'] . "', status = '" . (int)$data['status'] . "' WHERE coupon_id = '" . (int)$coupon_id . "'");
		
		$this->db->query("DELETE FROM " . DB_PREFIX . "coupon_product WHERE coupon_id = '" . (int)$coupon_id . "'");
		
		if (isset($data['coupon_product'])) {
      		foreach ($data['coupon_product'] as $product_id) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "coupon_product SET coupon_id = '" . (int)$coupon_id . "', product_id = '" . (int)$product_id . "'");
      		}
		}	
		
		$this->db->query("DELETE FROM " . DB_PREFIX . "coupon_category WHERE coupon_id = '" . (int)$coupon_id . "'");
		
		if (isset($data['coupon_category'])) {
      		foreach ($data['coupon_category'] as $category_id) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "coupon_category SET coupon_id = '" . (int)$coupon_id . "', category_id = '" . (int)$category_id . "'");
      		}
		}				
	}
/*
FUNCTION NAME 		-	deleteCoupon
DESCRIPTION 		-	Deletes the coupon for the given coupon_id
INPUT PARAMETER 	-	Coupon_id for the coupon to be deleted
OUTPUT PARAMETER 	- 	Retruns after deleting the given coupon_id
*/		
	public function deleteCoupon($coupon_id) {
      	$this->db->query("DELETE FROM " . DB_PREFIX . "coupon WHERE coupon_id = '" . (int)$coupon_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "coupon_product WHERE coupon_id = '" . (int)$coupon_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "coupon_category WHERE coupon_id = '" . (int)$coupon_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "coupon_history WHERE coupon_id = '" . (int)$coupon_id . "'");		
	}
/*
FUNCTION NAME 		-	getCoupon
DESCRIPTION 		-	Retrieves a particular coupon for the given coupon_id from the database.
INPUT PARAMETER 	-	coupon_id
OUTPUT PARAMETER 	- 	Returns the row retrieved.
*/	
	public function getCoupon($coupon_id) {
      	$query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "coupon WHERE coupon_id = '" . (int)$coupon_id . "'");
		
		return $query->row;
	}
/*
FUNCTION NAME 		-	getCouponBycode
DESCRIPTION 		-	Retrieves all the coupon for the given zone_code from the database.
INPUT PARAMETER 	-	zone code
OUTPUT PARAMETER 	- 	Returns the row retrieved.
*/	
	public function getCouponByCode($code) {
      	$query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "coupon WHERE code = '" . $this->db->escape($code) . "'");
		
		return $query->row;
	}
/*
FUNCTION NAME 		-	getCoupons
DESCRIPTION 		-	Retrieves all the coupons form the database
INPUT PARAMETER 	-	data array containing filter options if any
OUTPUT PARAMETER 	- 	Returns all the rows retrieved
*/			
	public function getCoupons($data = array()) {
		$sql = "SELECT coupon_id, name, code, discount, date_start, date_end, status FROM " . DB_PREFIX . "coupon";
		
		$sort_data = array(
			'name',
			'code',
			'discount',
			'date_start',
			'date_end',
			'status'
		);	
			
		if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
			$sql .= " ORDER BY " . $data['sort'];	
		} else {
			$sql .= " ORDER BY name";	
		}
			
		if (isset($data['order']) && ($data['order'] == 'DESC')) {
			$sql .= " DESC";
		} else {
			$sql .= " ASC";
		}
		
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}			

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
			
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}		
		
		$query = $this->db->query($sql);
		
		return $query->rows;
	}
/*
FUNCTION NAME 		-	getCouponProducts
DESCRIPTION 		-	Retrieves all the products for which the given coupon can be used.
INPUT PARAMETER 	-	coupon_id
OUTPUT PARAMETER 	- 	Returns an array containing the product_id
*/	
	public function getCouponProducts($coupon_id) {
		$coupon_product_data = array();
		
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "coupon_product WHERE coupon_id = '" . (int)$coupon_id . "'");
		
		foreach ($query->rows as $result) {
			$coupon_product_data[] = $result['product_id'];
		}
		
		return $coupon_product_data;
	}
/*
FUNCTION NAME 		-	getCouponsCategories
DESCRIPTION 		-	Retrieves the categories for the given coupon_id
INPUT PARAMETER 	-	coupon_id
OUTPUT PARAMETER 	- 	Returns an array conatining the category_id
*/		
	public function getCouponCategories($coupon_id) {
		$coupon_category_data = array();
		
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "coupon_category WHERE coupon_id = '" . (int)$coupon_id . "'");
		
		foreach ($query->rows as $result) {
			$coupon_category_data[] = $result['category_id'];
		}

		return $coupon_category_data;
	}
/*
FUNCTION NAME 		-	getTotalCoupons
DESCRIPTION 		-	Retrieves the total count of all the coupons from the database.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns the total count.
*/			
	public function getTotalCoupons() {
      	$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "coupon");
		
		return $query->row['total'];
	}	
/*
FUNCTION NAME 		-	getCouponHistories
DESCRIPTION 		-	Retrieves the coupon history for the given coupon_id
INPUT PARAMETER 	-	coupon_id, start, limit for retrieving in blocs
OUTPUT PARAMETER 	- 	Returns all the rows retrieved
*/		
	public function getCouponHistories($coupon_id, $start = 0, $limit = 10) {
		if ($start < 0) {
			$start = 0;
		}
		
		if ($limit < 1) {
			$limit = 10;
		}	
				
		$query = $this->db->query("SELECT ch.order_id, CONCAT(c.firstname, ' ', c.lastname) AS customer, ch.amount, ch.date_added FROM " . DB_PREFIX . "coupon_history ch LEFT JOIN " . DB_PREFIX . "customer c ON (ch.customer_id = c.customer_id) WHERE ch.coupon_id = '" . (int)$coupon_id . "' ORDER BY ch.date_added ASC LIMIT " . (int)$start . "," . (int)$limit);

		return $query->rows;
	}
/*
FUNCTION NAME 		-	getTotalCouponHistories
DESCRIPTION 		-	Retrieves the total count for all the coupon history for the given 
						coupon_id from the database.
INPUT PARAMETER 	-	coupon_id
OUTPUT PARAMETER 	- 	Returns the total count.
*/
	public function getTotalCouponHistories($coupon_id) {
	  	$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "coupon_history WHERE coupon_id = '" . (int)$coupon_id . "'");

		return $query->row['total'];
	}			
}
?>