<?php
/*
@File transaction_status.php(MODEL)
REPORT:	TRANSACTION  PAGE
    This class queries the transaction list from the database.

@Author Mahesh 
@date 7th Oct. 2015
*/
class ModelReportTransactionStatus extends Model {

/*
FUNCTION NAME 		-	getTransactions
DESCRIPTION 		-	Retrieves all the transactions list
INPUT PARAMETER 	-	data array containing filter options if any
OUTPUT PARAMETER 	- 	Returns all the rows.
*/			
	public function getTransactions($data = array(),$user_id) { 
		$qry = $this->db->query("SELECT user_group_id FROM " . DB_PREFIX . "user WHERE user_id like '" . $user_id . "'");
		$sql = "SELECT * FROM `" . DB_PREFIX . "cas_op_transactions` c,`" . DB_PREFIX . "customer` cust ";
		
		$implode = array();
		if($qry->row['user_group_id']!=1){ 
			$implode[] = "c.user_id =cust.customer_id AND cust.operator_id = '" . $user_id . "' ";
		}	

		if (!empty($data['filter_tx_id'])) {
			$implode[] = "c.tx_id = '" . $this->db->escape($data['filter_tx_id']) . "'";
		}
		if (!empty($data['filter_order_id'])) {
			$implode[] = "c.order_id = '" . $this->db->escape($data['filter_order_id']) . "'";
		}
		
		
		if ($implode) {
			$sql .= " WHERE " . implode(" AND ", $implode);
		}		
		$sql .= "GROUP BY c.id ORDER BY c.id DESC";
		
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}			

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
			
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}
		$query = $this->db->query($sql);
		return $query->rows;
	}

/*
FUNCTION NAME 		-	getTotalTransactions
DESCRIPTION 		-	Queries to get the total number of transactions in the database.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	returns a row with column total containing count.
*/	
	public function getTotalTransactions($data=array(),$user_id) {
		$qry = $this->db->query("SELECT user_group_id FROM " . DB_PREFIX . "user WHERE user_id like '" . $user_id . "'");
		$sql = "SELECT COUNT(DISTINCT tx_id) AS total FROM `" . DB_PREFIX . "cas_op_transactions` c,`" . DB_PREFIX . "customer` cust";
		$implode = array();
		if($qry->row['user_group_id']!=1){ 
			$implode[] = "c.user_id =cust.customer_id AND cust.operator_id = '" . $user_id . "' ";
		}		
		if (!empty($data['filter_tx_id'])) {
			$implode[] = "c.tx_id = '" . $this->db->escape($data['filter_tx_id']) . "'";
		}
		if (!empty($data['filter_order_id'])) {
			$implode[] = "c.order_id = '" . $this->db->escape($data['filter_order_id']) . "'";
		}
		
		if ($implode) {
			$sql .= " WHERE " . implode(" AND ", $implode);
		}
				
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}			
			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}
		
		$query = $this->db->query($sql);
		return $query->row['total'];
	}

/*
FUNCTION NAME 		-	addToCasOpTransanction
DESCRIPTION 		-	Queries to add the response data of api in the database.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	void.
*/
	public function addToCasOpTransanction($user_id,$cmd_id,$end_time,$product_subscription_id,$ack_is='-1',$nack_is='-1',$order_id,$product_id,$start_date)
	{
		$this->db->query("INSERT INTO " . DB_PREFIX . "cas_op_transactions SET tx_id='".$product_subscription_id."',cmd_id='".$cmd_id."',order_id='".$order_id."',product_id='".$product_id."',user_id='".$user_id."',ack_ctr='".$ack_is."',nack_ctr='".$nack_is."',nack_type=-1,exp_date='".$end_time."',initiated_by='Customer',modify_date='".$start_date."'");
	}

/*
FUNCTION NAME 		-	getUserGroupBelongs
DESCRIPTION 		-	Queries to get the group id user belongs.
INPUT PARAMETER 	-	user id
OUTPUT PARAMETER 	- 	user group id.
*/
	public function getUserGroupBelongs($user_id)
	{
		$sql = "SELECT user_group_id FROM `" . DB_PREFIX . "user` WHERE user_id = '" . $user_id ."'";
		$query = $this->db->query($sql);
		return $query->row;
	}	

/*
FUNCTION NAME 		-	getUserName
DESCRIPTION 		-	Queries to get User name.
INPUT PARAMETER 	-	user id
OUTPUT PARAMETER 	- 	user name.
*/
	public function getUserName($user_id)
	{
		$sql = "SELECT  CONCAT(firstname, ' ', lastname) AS name FROM ".DB_PREFIX."customer WHERE customer_id='".$user_id."'";
		$query = $this->db->query($sql);
		return $query->row;
	}	

	/*
FUNCTION NAME 		-	getProductName
DESCRIPTION 		-	Queries to get Product name.
INPUT PARAMETER 	-	Product id
OUTPUT PARAMETER 	- 	Product name.
*/
	public function getProductName($product_id)
	{
		$sql = "SELECT  name FROM `" . DB_PREFIX . "product_description` WHERE product_id='".$product_id."'";
		$query = $this->db->query($sql);
		return $query->row;
	}


	/*
FUNCTION NAME 		-	getTransactionOrderProductIds
DESCRIPTION 		-	Queries to get Product and order id.
INPUT PARAMETER 	-	user id, cmd id, tx id
OUTPUT PARAMETER 	- 	order id,product id.
*/
	public function getTransactionOrderProductIds($user_id,$cmd_id,$trans_id)	
	{
		$sql = "SELECT  * FROM `" . DB_PREFIX . "cas_op_transactions` WHERE user_id='".$user_id."' 
		and cmd_id='".$cmd_id."' and tx_id='".$trans_id."'";
		$query = $this->db->query($sql);
		return $query->row;
	}

		/*
FUNCTION NAME 		-	getTransactionOrderProductIds
DESCRIPTION 		-	Queries to get Product and order id.
INPUT PARAMETER 	-	user id, cmd id, tx id
OUTPUT PARAMETER 	- 	order id,product id.
*/
	public function deleteTransaction($cmd_id,$trans_id)	
	{
		$this->db->query("DELETE FROM `" . DB_PREFIX . "cas_op_transactions` WHERE tx_id = '" . (int)$trans_id . "' AND cmd_id = '" . (int)$cmd_id . "'");
		return $query->affected_rows;
	}
		/*
FUNCTION NAME 		-	getCustomerKmsId
DESCRIPTION 		-	Queries to get Customer KMS Id.
INPUT PARAMETER 	-	user id
OUTPUT PARAMETER 	- 	Customer KMS Id.
*/
	public function getCustomerKmsId($cust_id)
	{
		$query = $this->db->query("SELECT api_user_id FROM `" . DB_PREFIX . "sms_kms_map` WHERE user_id = '" . (int)$cust_id . "'");

		return $query->row;
	}
	
}
?>