<?php
/*
@File pckwisechannels.php(MODEL)
LOCALISATION:	 PCKWISECHANNELS PAGE
    This class queries all the packages with the channels added to each of them.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ModelReportPckgWiseChannels extends Model {
/*
FUNCTION NAME 		-	getPackages
DESCRIPTION 		-	Queries all the package details with their descriptions.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved.
*/	
	public function getPackages($data) {
	$sql = "SELECT DISTINCT(p.product_id),p.price,p.status,pd.name,p.channel_list FROM " . DB_PREFIX . "product p LEFT JOIN " . DB_PREFIX . "product_description pd ON (p.product_id = pd.product_id) where p.is_package is true";
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}				

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
		
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}	
		$query = $this->db->query($sql);
		return $query->rows;	
	}
	
	/*
FUNCTION NAME 		-	getTotalPkgWiseChannel
DESCRIPTION 		-	Queries all the package details with their descriptions.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved.
*/	
	public function getTotalPkgWiseChannel() {
		$query = $this->db->query("SELECT count(DISTINCT(p.product_id)) AS total FROM " . DB_PREFIX . "product p LEFT JOIN " . DB_PREFIX . "product_description pd ON (p.product_id = pd.product_id) where p.is_package is true");
		return $query->row['total'];
	}
	
/*
FUNCTION NAME 		-	getPackage
DESCRIPTION 		-	Queries the selected package details with its description.
INPUT PARAMETER 	-	package_id
OUTPUT PARAMETER 	- 	Returns the row retrieved.
*/
	public function getPackage($package_id) {
		$query = $this->db->query("SELECT DISTINCT(name),p.product_id,price,status,channel_list FROM " . DB_PREFIX . "product p LEFT JOIN " . DB_PREFIX . "product_description pd ON (p.product_id = pd.product_id) where (p.is_package is true and p.product_id=".$package_id.")");
		return $query->rows;
	}

}
?>
