<?php
/*
@File particulardate.php(MODEL)
LOCALISATION:	 PARTICULARDATE PAGE
    This class queries the package-wise subscribers at particular dates as a list.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ModelReportParticularDate extends Model {
/*
FUNCTION NAME 		-	getStatus
DESCRIPTION 		-	Queries the detail with the count for each of the packages been subscribed by the 
						customers.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns the asked currency details.
*/	
	public function getStatus($data = array()) {	
		$sql="SELECT DISTINCT s.product_id as product_id, COUNT( DISTINCT(s.customer_id) ) as count , d.name as name FROM  `".DB_PREFIX."subscription` s LEFT JOIN  `".DB_PREFIX."product_description` d ON ( s.product_id = d.product_id ) LEFT JOIN  `".DB_PREFIX."product` pd ON d.product_id = pd.product_id WHERE pd.is_package =1 GROUP BY s.product_id";
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}				

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
		
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}	
		$query = $this->db->query($sql);
		return $query->rows;
	}

/*
FUNCTION NAME 		-	getFilter
DESCRIPTION 		-	Queries the detail with the count for each of the packages been subscribed by the 
						customers for the given dates.
INPUT PARAMETER 	-	data array containing filter options if any
OUTPUT PARAMETER 	- 	Returns all the rows queried.
*/		
	public function getFilter($data = array()){
		$sql="SELECT DISTINCT s.product_id as product_id, COUNT(DISTINCT(s.customer_id)) as count , d.name as name FROM  `".DB_PREFIX."subscription` s LEFT JOIN  `".DB_PREFIX."product_description` d ON ( s.product_id = d.product_id ) LEFT JOIN  `".DB_PREFIX."product` pd ON d.product_id = pd.product_id WHERE pd.is_package =1 && s.start_date >='".$data['filter_date_start']."' AND s.start_date <='".$data['filter_date_end']."' GROUP BY s.product_id";
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}				

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
		
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}	
		$query = $this->db->query($sql);

		return $query->rows;
	}
/*
FUNCTION NAME 		-	getEachStatus
DESCRIPTION 		-	Queries the detail with the count for the given package been subscribed by the 
						customers within the start and end dates given
INPUT PARAMETER 	-	filter_date_start,filter_date_end,product_id
OUTPUT PARAMETER 	- 	Returns all the rows retrieved.
*/
	public function getEachStatus($filter_date_start,$filter_date_end,$product_id) {		   
		$query = $this->db->query("SELECT  COUNT(c.customer_id) as count,(d.name) FROM  ".DB_PREFIX."subscription  c LEFT JOIN ". DB_PREFIX . "product_description d ON (c.product_id = d.product_id) LEFT JOIN ". DB_PREFIX ."product pd ON (d.product_id = pd.product_id) where ((pd.is_package=1 and '". $filter_date_start . "'>= c.start_date and '".$filter_date_end."'<=c.expire_date) and c.product_id = ".$product_id." ) group by c.product_id");
		return $query->rows;

	}
/*
FUNCTION NAME 		-	getTotalpkgSubs
DESCRIPTION 		-	Queries the subscribers count for each of the package.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved.
*/	
	public function getTotalpkgSubs()
	{
		$query = $this->db->query("SELECT  COUNT(*) as total ,(d.product_id), (d.name) FROM " . DB_PREFIX . "subscription c LEFT JOIN " . DB_PREFIX . "product_description d ON (c.product_id = d.product_id) LEFT JOIN ". DB_PREFIX ."product pd ON (d.product_id = pd.product_id) where pd.is_package=1 GROUP BY c.product_id");
		return $query->num_rows;
	}

/*
FUNCTION NAME 		-	getPackage
DESCRIPTION 		-	Queries the subscribers count for the given package_id
INPUT PARAMETER 	-	package_id
OUTPUT PARAMETER 	- 	Returns the row retrieved.
*/
	public function getPackage($package_id) {
		$query = $this->db->query("SELECT COUNT(*) as count,(d.name),d.product_id FROM " . DB_PREFIX . "subscription c LEFT JOIN " . DB_PREFIX . "product_description d ON (c.product_id = d.product_id) LEFT JOIN ". DB_PREFIX ."product pd ON (d.product_id = pd.product_id) where (pd.is_package=1 and d.product_id =".$package_id.") GROUP BY c.product_id");
		return $query->rows;
	}
}
?>
