<?php
/*
@File pckwisesubscribers.php(MODEL)
LOCALISATION:	 PCKWISESUBSCRIBERS PAGE
    This class queries the total number of subscribers for each of the packages as a list
    to generate report.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ModelReportPackageList extends Model {
/*
FUNCTION NAME 		-	getPackages
DESCRIPTION 		-	Queries the subscribers count for each of the package.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved.
*/	
	public function getPackages($data) {
		$sql = "SELECT d.product_id, COUNT(DISTINCT(c.customer_id)) as count,(d.name) FROM " . DB_PREFIX . "subscription c LEFT JOIN " . DB_PREFIX . "product_description d ON (c.product_id = d.product_id) LEFT JOIN ". DB_PREFIX ."product pd ON (d.product_id = pd.product_id)  where pd.is_package=1 AND pd.is_ppv=0  GROUP BY c.product_id";
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}				

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
		
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}	
		$query = $this->db->query($sql);
		return $query->rows;
	}

/*
FUNCTION NAME 		-	getTotalpkgSubs
DESCRIPTION 		-	Queries the subscribers count for each of the package.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved.
*/	
	public function getTotalpkgSubs()
	{
		$query = $this->db->query("SELECT  COUNT(*) as total ,(d.product_id), (d.name) FROM " . DB_PREFIX . "subscription c LEFT JOIN " . DB_PREFIX . "product_description d ON (c.product_id = d.product_id) LEFT JOIN ". DB_PREFIX ."product pd ON (d.product_id = pd.product_id) where pd.is_package=1 AND is_ppv=0 GROUP BY c.product_id");
		return $query->num_rows;
	}

/*
FUNCTION NAME 		-	getOptions
DESCRIPTION 		-	
INPUT PARAMETER 	-	
OUTPUT PARAMETER 	- 	Returns the row retrieved.
*/
	public function getOptions($product_id) {
		$query = $this->db->query("SELECT vd.name,vd.option_value_id,p.price,p.product_id FROM ".DB_PREFIX."product_option_value p, ".DB_PREFIX."option_value_description vd
			WHERE p.product_id='".$product_id."' and p.option_value_id=vd.option_value_id");
			return $query->rows;
	}

/*
FUNCTION NAME 		-	getUserDetails
DESCRIPTION 		-	
INPUT PARAMETER 	-	
OUTPUT PARAMETER 	- 	Returns the row retrieved.
*/
	public function getUserDetails($user_id) {
	$query = $this->db->query("SELECT `firstname`,`lastname`,`email` FROM ".DB_PREFIX."user WHERE `user_id`='".$user_id."'");
		return $query->row;
	}

/*
FUNCTION NAME 		-	getPackage
DESCRIPTION 		-	Queries the subscribers count for the given package_id
INPUT PARAMETER 	-	package_id
OUTPUT PARAMETER 	- 	Returns the row retrieved.
*/
	public function getPackage($package_id) {
		$sql = "SELECT d.product_id, COUNT(DISTINCT(c.customer_id)) as count,(d.name) FROM " . DB_PREFIX . "subscription c LEFT JOIN " . DB_PREFIX . "product_description d ON (c.product_id = d.product_id) LEFT JOIN ". DB_PREFIX ."product pd ON (d.product_id = pd.product_id)  where pd.is_package=1 AND pd.is_ppv=0 and d.product_id =".(int)$package_id."  GROUP BY c.product_id";
		$query = $this->db->query($sql);
		return $query->rows;
	}

}
?>
