<?php
/*
@File sale.php(MODEL)
LOCALISATION:	 SALE PAGE
    This class queries orders, shipping and tax list from the database for the store
    to generate a report.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ModelReportHistoricalSubscriptionSummary extends Model {

	
/*
FUNCTION NAME 		-	getChannelListDetails
DESCRIPTION 		-	Queries all the channel list details with their descriptions.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved.
*/
	public function getSubscribedCustomers() {	
		$sql = "SELECT DISTINCT(s.customer_id),c.firstname,c.lastname FROM oc_subscription s,oc_customer c WHERE s.customer_id=c.customer_id";
		$query = $this->db->query($sql);
		return $query->rows;	
	}
/*
FUNCTION NAME 		-	getChannelListDetails
DESCRIPTION 		-	Queries all the channel list details with their descriptions.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved.
*/	
	public function getOrderDetails($customer_id,$order='ASC') {
		$sql = "SELECT o.order_id, o.customer_id, op.product_id, op.name
				FROM oc_order o, oc_order_product op
				WHERE o.order_id = op.order_id and o.customer_id='".$customer_id."' ORDER BY  o.order_id ".$order." LIMIT 1";
		$query = $this->db->query($sql);
		return $query->row;	
	 }

/*
FUNCTION NAME 		-	getChannelListDetails
DESCRIPTION 		-	Queries all the channel list details with their descriptions.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved.
*/	
	public function getDeActiveSub($customer_id) {
		$active='';
		$sql = "SELECT product_id FROM  `oc_subscription` WHERE  `customer_id` ='".$customer_id."' AND  `expire_date` < NOW( ) ";
		$query = $this->db->query($sql);
		if($query->rows)
		{
			foreach ($query->rows as $row) {
			$sql = "SELECT name FROM `oc_product_description` WHERE `product_id`='".$row['product_id']."'";
			$qry = $this->db->query($sql);
			$active=$active.','.$qry->row['name'];
			}
		}
		return $active;
	 }
/*
FUNCTION NAME 		-	getChannelListDetails
DESCRIPTION 		-	Queries all the channel list details with their descriptions.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved.
*/	
	public function getActiveSub($customer_id) {
		$active='';
		$sql = "SELECT product_id FROM  `oc_subscription` WHERE  `customer_id` ='".$customer_id."' AND  `expire_date` >= NOW( ) ";
		$query = $this->db->query($sql);
		if($query->rows)
		{
			foreach ($query->rows as $row) {
			$sql = "SELECT name FROM `oc_product_description` WHERE `product_id`='".$row['product_id']."'";
			$qry = $this->db->query($sql);
			$active=$active.','.$qry->row['name'];
			}
		}
		return $active;
	 }
/*
FUNCTION NAME 		-	getChannelListDetails
DESCRIPTION 		-	Queries all the channel list details with their descriptions.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved.
*/	
	public function getChannelListDetails($data=array()) {
		$sql = "SELECT p.product_id, p.service_id, pd.name, p.price FROM oc_product p, oc_product_description pd
				WHERE p.product_id = pd.product_id AND p.is_package =0 AND p.is_ppv =0 
				GROUP BY p.product_id ORDER BY pd.name";
				if (isset($data['start']) || isset($data['limit'])) {
					if ($data['start'] < 0) {
						$data['start'] = 0;
					}				

					if ($data['limit'] < 1) {
						$data['limit'] = 20;
					}	
				
					$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
				}	
		$query = $this->db->query($sql);
		return $query->rows;	
	 }

	 	/*
FUNCTION NAME 		-	getOptions
DESCRIPTION 		-	Queries all the options with their descriptions.
INPUT PARAMETER 	-	product_id
OUTPUT PARAMETER 	- 	Returns all the rows retrieved.
*/	
	public function getOptions($product_id) {
		$query = $this->db->query("SELECT vd.name,vd.option_value_id,p.price FROM ".DB_PREFIX."product_option_value p, ".DB_PREFIX."option_value_description vd
			WHERE p.product_id='".$product_id."' and p.option_value_id=vd.option_value_id");
			return $query->rows;
	}

/*
FUNCTION NAME 		-	getChannelListDetails
DESCRIPTION 		-	Queries all the channel list details with their descriptions.
INPUT PARAMETER 	-	product_id
OUTPUT PARAMETER 	- 	Returns the detail row.
*/	
	public function getChannelDetail($product_id) {
		$sql = "SELECT p.product_id, p.service_id, pd.name, p.price FROM oc_product p, oc_product_description pd
				WHERE p.product_id = pd.product_id AND p.is_package =0 AND p.is_ppv =0 AND p.product_id = ".$product_id." 
				GROUP BY p.product_id ORDER BY pd.name";
		$query = $this->db->query($sql);
		return $query->rows;	
	}
/*
FUNCTION NAME 		-	getOptions
DESCRIPTION 		-	Queries all the options with their descriptions.
INPUT PARAMETER 	-	product_id
OUTPUT PARAMETER 	- 	Returns all the rows retrieved.
*/	
	public function getCategories($product_id) {
		$query = $this->db->query("SELECT cd.name as category
			FROM oc_product p, oc_product_description pd, oc_product_to_category cat, oc_category_description cd
			WHERE  p.product_id ='".$product_id."' AND p.product_id = pd.product_id AND p.product_id = cat.product_id AND cat.category_id = cd.category_id AND p.is_package=0 AND p.is_ppv=0");
			return $query->rows;
	}


		/*
FUNCTION NAME 		-	getUserDetails
DESCRIPTION 		-	Queries the selected User details with its description.
INPUT PARAMETER 	-	package_id
OUTPUT PARAMETER 	- 	Returns the row retrieved.
*/
	public function getUserDetails($user_id) {
		$query = $this->db->query("SELECT `firstname`,`lastname`,`email` FROM ".DB_PREFIX."user WHERE `user_id`='".$user_id."'");
		return $query->row;
	}

	/*
FUNCTION NAME 		-	getTotalOrders
DESCRIPTION 		-	Queries to get the total number of orders raised in the database.
INPUT PARAMETER 	-	data array containing filter options if any
OUTPUT PARAMETER 	- 	returns a row with column total containing count for the order table.
*/	
	public function getTotalChannels($data = array()) {
		
		$sql="SELECT count(DISTINCT(product_id)) as total FROM ".DB_PREFIX."product";
		$query = $this->db->query($sql);

		return $query->row['total'];	
	}

}
?>