<?php
/*
@File ageing.php(MODEL)
REPORT:	 AGING PAGE
    This class queries the ageing list for the subscribers from the database for the store
    to generate the report.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ModelReportAgeing extends Model {
/*
FUNCTION NAME 		-	getAgeing
DESCRIPTION 		-	Queries the ageing of the subscriber on particular channels/packages
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns the asked queried rows
*/	
	public function getAgeing($data) {
		$sql ="SELECT DISTINCT(p.product_id),c.customer_id,s.product_id,CONCAT(c.firstname,' ',c.lastname) as name, datediff(s.expire_date,now()) as time,p.name as 'product_name'  FROM " . DB_PREFIX . "customer c INNER JOIN ".DB_PREFIX."subscription s ON (c.customer_id=s.customer_id) INNER JOIN ". DB_PREFIX ."product_description p ON (s.product_id=p.product_id)";
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}				

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
		
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}	
		$query = $this->db->query($sql);
		return $query->rows;
	}
/*
FUNCTION NAME 		-	getAgeing
DESCRIPTION 		-	Queries the ageing of the subscriber on particular channels/packages
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns the asked queried rows
*/	
	public function getTotalageing() {
		$query = $this->db->query("SELECT DISTINCT(p.product_id), c.customer_id,s.product_id,CONCAT(c.firstname,' ',c.lastname) as name, datediff(s.expire_date,now()) as time,(p.name) as 'product_name'  FROM " . DB_PREFIX . "customer c INNER JOIN ".DB_PREFIX."subscription s ON (c.customer_id=s.customer_id) INNER JOIN ". DB_PREFIX ."product_description p ON (s.product_id=p.product_id)");
		
		return $query->num_rows;	
	}
	
/*
FUNCTION NAME 		-	getAgeingCustomer
DESCRIPTION 		-	Queries the ageing of the given product for the given customer_id
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns the queried rows
*/	

	public function getAgeingCustomer($customer_id,$product_id) {
		$query = $this->db->query("SELECT DISTINCT(CONCAT(c.firstname,' ',c.lastname)) as name,c.customer_id,datediff(s.expire_date,now()) as time,(p.name) as 'product_name'  FROM " . DB_PREFIX . "customer c LEFT JOIN ".DB_PREFIX."subscription s ON (c.customer_id=s.customer_id) LEFT JOIN ". DB_PREFIX ."product_description p ON (s.product_id=p.product_id) where (c.customer_id=".$customer_id." and s.product_id=".$product_id.")");
		
		return $query->rows;	
	}
}
?>
