<?php
/*
@File active_deactive.php(MODEL)
REPORT:	 ACTIVE_DEACTIVE PAGE
    This class queries the active_deactive list from the database for the store
    to generate the report.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ModelReportActiveDeactive extends Model {
/*
FUNCTION NAME 		-	getCustomerStatus
DESCRIPTION 		-	Retrieves the historial data in terms of activations and deactivations
						for channels/packages for the customer.
INPUT PARAMETER 	-	customer_id, product_id
OUTPUT PARAMETER 	- 	Returns all the rows queried
*/
public function getCustomerStatus($customer_id,$product_id) {
		$var ="";
		if($product_id=="")
		 	$var = "(c.customer_id= ".$customer_id.")";
		else
			$var = "(c.customer_id= ".$customer_id." and s.product_id =".$product_id.")";
		$query = $this->db->query("SELECT DISTINCT(CONCAT(c.firstname, ' ', c.lastname)) AS name, datediff(s.expire_date,s.start_date) as status , datediff(s.expire_date,s.start_date) as due , (pd.name) as product_name ,(c.customer_id) as customer_id FROM " . DB_PREFIX . "customer c LEFT JOIN " . DB_PREFIX . "subscription s ON (c.customer_id=s.customer_id) LEFT JOIN ". DB_PREFIX ."product_description pd ON (s.product_id=pd.product_id) where $var ORDER BY CONCAT(c.firstname, ' ', c.lastname) ASC");
		return $query->rows;
	}

/*
FUNCTION NAME 		-	getStatus
DESCRIPTION 		-	Retrieves all the subscription status for all the orders.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows queried, containing subscription staus,customer_id and other details.
*/
	public function getStatus($data = array()) {
		$sql = "SELECT DISTINCT(pd.product_id),c.customer_id,s.product_id,CONCAT(c.firstname, ' ', c.lastname) AS name, datediff(s.expire_date,s.start_date) as status , datediff(s.expire_date,s.start_date) as due , (pd.name) as product_name FROM " . DB_PREFIX . "customer c LEFT JOIN " . DB_PREFIX . "subscription s ON (c.customer_id=s.customer_id) LEFT JOIN ". DB_PREFIX ."product_description pd ON (s.product_id=pd.product_id) ORDER BY CONCAT(c.firstname, ' ', c.lastname) ASC";
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}
			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}
		$query = $this->db->query($sql);
		return $query->rows;
	}

/*
FUNCTION NAME 		-	getStatusTotal
DESCRIPTION 		-	
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	
*/
	public function getStatusTotal() {
			$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "customer c LEFT JOIN " . DB_PREFIX . "subscription s ON (c.customer_id=s.customer_id) LEFT JOIN ". DB_PREFIX ."product_description pd ON (s.product_id=pd.product_id) ORDER BY CONCAT(c.firstname, ' ', c.lastname) ASC");
			return $query->row['total'];
			
	}
}
?>
