<?php
/*
@File home.php(MODEL)
PAIRNING:	 HOME PAGE
    This class queries and updates the database regarding the pairing between stb number,
    cas number and customer id.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ModelPairingHome extends Model {
/*
FUNCTION NAME 		-	getCustomerPair
DESCRIPTION 		-	Queries the pairing details for the given customer id.
INPUT PARAMETER 	-	customer_id
OUTPUT PARAMETER 	- 	Returns the row retrieved by the query.
*/		
	public function getCustomerPair($customer_id){
		$query = $this->db->query("SELECT * FROM `" . DB_PREFIX. "customer_stb_cas` WHERE `customer_id`=".$customer_id);
		
		return $query->row;
	}
/*
FUNCTION NAME 		-	removeBond
DESCRIPTION 		-	Queries and updates the table to remove the pairing details for the given customer id.
INPUT PARAMETER 	-	customer_id
OUTPUT PARAMETER 	- 	Updates the tables in the database.
*/	
	public function removeBond($customer_id){
		$query = $this->db->query("SELECT * FROM `" . DB_PREFIX. "customer_stb_cas` WHERE `customer_id`=".$customer_id);
		$this->db->query("UPDATE " . DB_PREFIX . "customer_stb_cas SET current_stbno = '0', current_casno = '0', prev_stbno ='".$query->row['current_stbno']."', prev_casno ='".$query->row['current_casno']."' WHERE customer_id = '" . (int)$customer_id . "'");
		$this->db->query("UPDATE " . DB_PREFIX . "stb SET customer_id = '0', is_avail = '1' WHERE stb_id = '" . $query->row['current_stbno']. "'");
		$this->db->query("UPDATE " . DB_PREFIX . "cas SET customer_id = '0', is_avail = '1' WHERE cas_id = '" . $query->row['current_casno'] . "'");
		$this->db->query("UPDATE " . DB_PREFIX . "customer SET STBNO = '0', CASNO = '0' WHERE customer_id = '" . (int)$customer_id . "'");
	}
/*
FUNCTION NAME 		-	createBond
DESCRIPTION 		-	Queries and updates the table to add the pairing details for the given customer id.
INPUT PARAMETER 	-	customer_id
OUTPUT PARAMETER 	- 	Updates the tables in the database.
*/	
	public function createBond($customer_id,$stb_no,$cas_no){
		$query = $this->db->query("SELECT * FROM `" . DB_PREFIX. "customer_stb_cas` WHERE `customer_id`=".$customer_id);
		$this->db->query("UPDATE " . DB_PREFIX . "stb SET customer_id = '".$customer_id."', is_avail = '0' WHERE stb_id = '" . $stb_no. "'");
		$this->db->query("UPDATE " . DB_PREFIX . "cas SET customer_id = '".$customer_id."', is_avail = '0' WHERE cas_id = '" . $cas_no . "'");	
		$this->db->query("UPDATE " . DB_PREFIX . "customer_stb_cas SET current_stbno = '".$stb_no."', current_casno = '".$cas_no."' WHERE customer_id = '" . (int)$customer_id . "'");
		$this->db->query("UPDATE " . DB_PREFIX . "customer SET STBNO = '".$stb_no."', CASNO = '".$cas_no."' WHERE customer_id = '" . (int)$customer_id . "'");
	}
/*
FUNCTION NAME 		-	getCustomerIdHavingBond
DESCRIPTION 		-	Queries all the customers who have been assigned the cas number and stb number.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns the row retrieved by the query.
*/		
	public function getCustomerIdHavingBond(){
		// $query = $this->db->query("SELECT * FROM `" . DB_PREFIX. "customer_stb_cas` where current_stbno!='0' and current_casno!='0'");
		$query = $this->db->query("SELECT b.customer_id as customer_id, b.firstname as fname, b.lastname as lname FROM `".DB_PREFIX."customer_stb_cas` as a LEFT JOIN `".DB_PREFIX."customer` as b ON a.customer_id=b.customer_id where a.current_stbno!='0' and a.current_casno!='0'");
		return $query;
	}	
/*
FUNCTION NAME 		-	getCustomerIdHavingNoBond
DESCRIPTION 		-	Queries all the customers who have not been assigned the cas number and stb number.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns the row retrieved by the query.
*/		
	public function getCustomerIdHavingNoBond(){
		//$query = $this->db->query("SELECT * FROM `" . DB_PREFIX. "customer_stb_cas` where current_stbno='0' and current_casno='0'");
		$query = $this->db->query("SELECT b.customer_id as customer_id, b.firstname as fname, b.lastname as lname FROM `".DB_PREFIX."customer_stb_cas` as a LEFT JOIN `".DB_PREFIX."customer` as b ON a.customer_id=b.customer_id where a.current_stbno='0' and a.current_casno='0'");
		return $query;
	}
/*
FUNCTION NAME 		-	getAvailableSTB
DESCRIPTION 		-	Queries all the stb numbers that have not been assigned to any customers.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns the row retrieved by the query.
*/		
	public function getAvailableSTB(){
		$query = $this->db->query("SELECT * FROM `" . DB_PREFIX. "stb` where is_avail='1'");
		return $query;
	}
/*
FUNCTION NAME 		-	getAvailableCAS
DESCRIPTION 		-	Queries all the cas numbers that have not been assigned to any customers.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns the row retrieved by the query.
*/	
	public function getAvailableCAS(){
		$query = $this->db->query("SELECT * FROM `" . DB_PREFIX. "cas` where is_avail='1'");
		return $query;
	}
}
?>