<?php
/*
@File zone.php(MODEL)
LOCALISATION:	 ZONE PAGE
    This class queries,adds and updates the zone details to the database for the store.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ModelLocalisationZone extends Model {
/*
FUNCTION NAME 		-	addZone
DESCRIPTION 		-	Adds new zone detail to the database.
INPUT PARAMETER 	-	data array containing the zone description.
OUTPUT PARAMETER 	- 	Adds to the database, deletes the cache for zone and returns to 
						the zone list page with a success notification
*/	
	public function addZone($data) {
		$this->db->query("INSERT INTO " . DB_PREFIX . "zone SET status = '" . (int)$data['status'] . "', name = '" . $this->db->escape($data['name']) . "', code = '" . $this->db->escape($data['code']) . "', country_id = '" . (int)$data['country_id'] . "'");
			
		$this->cache->delete('zone');
	}
/*
FUNCTION NAME 		-	editZone
DESCRIPTION 		-	Updates the zone detail given for the given zone_id.
INPUT PARAMETER 	-	zone_id, data array containing the zone description.
OUTPUT PARAMETER 	- 	Updates the database, deletes the cache for zone and returns to 
						the zone list page with a success notification
*/	
	public function editZone($zone_id, $data) {
		$this->db->query("UPDATE " . DB_PREFIX . "zone SET status = '" . (int)$data['status'] . "', name = '" . $this->db->escape($data['name']) . "', code = '" . $this->db->escape($data['code']) . "', country_id = '" . (int)$data['country_id'] . "' WHERE zone_id = '" . (int)$zone_id . "'");

		$this->cache->delete('zone');
	}
/*
FUNCTION NAME 		-	deleteZone
DESCRIPTION 		-	Deletes the zone detail for the given zone_id.
INPUT PARAMETER 	-	zone_id
OUTPUT PARAMETER 	- 	Deletes the given zone details and the cache for zone and returns to 
						the zone list page with a success notification
*/	
	public function deleteZone($zone_id) {
		$this->db->query("DELETE FROM " . DB_PREFIX . "zone WHERE zone_id = '" . (int)$zone_id . "'");

		$this->cache->delete('zone');	
	}
/*
FUNCTION NAME 		-	getZone
DESCRIPTION 		-	Queries the zone details for the given zone_id from the database.
INPUT PARAMETER 	-	zone_id
OUTPUT PARAMETER 	- 	Returns the asked zone details.
*/	
	public function getZone($zone_id) {
		$query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "zone WHERE zone_id = '" . (int)$zone_id . "'");
		
		return $query->row;
	}
/*
FUNCTION NAME 		-	getZones
DESCRIPTION 		-	Queries all the zone details from the database.
INPUT PARAMETER 	-	data array containing the filter options if any 
OUTPUT PARAMETER 	- 	Returns all the rows retrieved.
*/	
	public function getZones($data = array()) {
		$sql = "SELECT *, z.name, c.name AS country FROM " . DB_PREFIX . "zone z LEFT JOIN " . DB_PREFIX . "country c ON (z.country_id = c.country_id)";
			
		$sort_data = array(
			'c.name',
			'z.name',
			'z.code'
		);	
			
		if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
			$sql .= " ORDER BY " . $data['sort'];	
		} else {
			$sql .= " ORDER BY c.name";	
		}
			
		if (isset($data['order']) && ($data['order'] == 'DESC')) {
			$sql .= " DESC";
		} else {
			$sql .= " ASC";
		}
		
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}		
			
			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
			
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}
		
		$query = $this->db->query($sql);
		
		return $query->rows;
	}
/*
FUNCTION NAME 		-	getZonesByCountryId
DESCRIPTION 		-	Queries to get the zones for the given country_id and status is acive.
INPUT PARAMETER 	-	country_id
OUTPUT PARAMETER 	- 	returns all the zones matching the country_id
*/	
	public function getZonesByCountryId($country_id) {
		$zone_data = $this->cache->get('zone.' . (int)$country_id);
	
		if (!$zone_data) {
			$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "zone WHERE country_id = '" . (int)$country_id . "' AND status = '1' ORDER BY name");
			$zone_data = $query->rows;
			
			$this->cache->set('zone.' . (int)$country_id, $zone_data);
		}

		return $zone_data;
	}

/*
FUNCTION NAME 		-	getRegionsByZoneId
DESCRIPTION 		-	Queries to get the Regions for the given zone_id and status is acive.
INPUT PARAMETER 	-	country_id
OUTPUT PARAMETER 	- 	returns all the regions matching the zone_id
*/	
	public function getRegionsByZoneId($zone_id) {
		$region_data = $this->cache->get('zone.' . (int)$zone_id);
	
		if (!$region_data) {
			$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "region  WHERE zone_id = '" . (int)$zone_id . "' ORDER BY region_name");
	
			$region_data = $query->rows;
			$this->cache->set('region.' . (int)$zone_id, $region_data);
		}
	
		return $region_data;
	}

/*
FUNCTION NAME 		-	getPostcodeByRegionId
DESCRIPTION 		-	Queries to get the Regions for the given zone_id and status is acive.
INPUT PARAMETER 	-	country_id
OUTPUT PARAMETER 	- 	returns all the regions matching the zone_id
*/	
	public function getPostcodeByRegionId($region_id) {
		$postcode_data = $this->cache->get('postcode.' . (int)$region_id);
	
		if (!$postcode_data) {
			$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "region  WHERE region_id = '" . (int)$region_id . "' ORDER BY region_name");
	
			$postcode_data = $query->rows;
			$this->cache->set('postcode.' . (int)$region_id, $postcode_data);
		}
	
		return $postcode_data;
	}	
/*
FUNCTION NAME 		-	getTotalCurrencies
DESCRIPTION 		-	Queries to get the total number of zone in the database.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	returns a row with column total containing count for the zone table.
*/	
	public function getTotalZones() {
      	$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "zone");
		
		return $query->row['total'];
	}
/*
FUNCTION NAME 		-	getTotalZonesByCountryId
DESCRIPTION 		-	Queries to get the total number of zone matching the given country_id
INPUT PARAMETER 	-	country_id
OUTPUT PARAMETER 	- 	returns a row with column total containing count for the retrieved zones
*/				
	public function getTotalZonesByCountryId($country_id) {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "zone WHERE country_id = '" . (int)$country_id . "'");
	
		return $query->row['total'];
	}
}
?>