<?php 
/*
@File stock_status.php(MODEL)
LOCALISATION:	 STOCK_STATUS PAGE
    This class queries,adds and updates the stock_status details to the database for the store.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ModelLocalisationStockStatus extends Model {
/*
FUNCTION NAME 		-	addStockStatus
DESCRIPTION 		-	Adds new stock_status detail to the database.
INPUT PARAMETER 	-	data array containing the stock_status description.
OUTPUT PARAMETER 	- 	Adds to the database, deletes the cache for stock_status and returns to 
						the stock_status list page with a success notification
*/	
	public function addStockStatus($data) {
		foreach ($data['stock_status'] as $language_id => $value) {
			if (isset($stock_status_id)) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "stock_status SET stock_status_id = '" . (int)$stock_status_id . "', language_id = '" . (int)$language_id . "', name = '" . $this->db->escape($value['name']) . "'");
			} else {
				$this->db->query("INSERT INTO " . DB_PREFIX . "stock_status SET language_id = '" . (int)$language_id . "', name = '" . $this->db->escape($value['name']) . "'");
				
				$stock_status_id = $this->db->getLastId();
			}
		}
		
		$this->cache->delete('stock_status');
	}
/*
FUNCTION NAME 		-	editStockStatus
DESCRIPTION 		-	Updates the stock_status detail given for the given stock_status_id.
INPUT PARAMETER 	-	stock_status_id, data array containing the stock_status description.
OUTPUT PARAMETER 	- 	Updates the database, deletes the cache for stock_status and returns to 
						the stock_status list page with a success notification
*/
	public function editStockStatus($stock_status_id, $data) {
		$this->db->query("DELETE FROM " . DB_PREFIX . "stock_status WHERE stock_status_id = '" . (int)$stock_status_id . "'");

		foreach ($data['stock_status'] as $language_id => $value) {
			$this->db->query("INSERT INTO " . DB_PREFIX . "stock_status SET stock_status_id = '" . (int)$stock_status_id . "', language_id = '" . (int)$language_id . "', name = '" . $this->db->escape($value['name']) . "'");
		}
				
		$this->cache->delete('stock_status');
	}
/*
FUNCTION NAME 		-	deleteStockStatus
DESCRIPTION 		-	Deletes the stock_status detail for the given stock_status_id.
INPUT PARAMETER 	-	stock_status_id
OUTPUT PARAMETER 	- 	Deletes the given stock_status details and the cache for stock_status and returns to 
						the stock_status list page with a success notification
*/	
	public function deleteStockStatus($stock_status_id) {
		$this->db->query("DELETE FROM " . DB_PREFIX . "stock_status WHERE stock_status_id = '" . (int)$stock_status_id . "'");
	
		$this->cache->delete('stock_status');
	}
/*
FUNCTION NAME 		-	getStockStatus
DESCRIPTION 		-	Queries the stock_status details for the given stock_status_id from the database.
INPUT PARAMETER 	-	stock_status_id
OUTPUT PARAMETER 	- 	Returns the asked stock_status details.
*/		
	public function getStockStatus($stock_status_id) {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "stock_status WHERE stock_status_id = '" . (int)$stock_status_id . "' AND language_id = '" . (int)$this->config->get('config_language_id') . "'");
		
		return $query->row;
	}
/*
FUNCTION NAME 		-	getStockStatuses
DESCRIPTION 		-	Queries all the stock_status details from the database.
INPUT PARAMETER 	-	data array containing the filter options if any 
OUTPUT PARAMETER 	- 	Returns all the rows retrieved.
*/
	public function getStockStatuses($data = array()) {
		if ($data) {
			$sql = "SELECT * FROM " . DB_PREFIX . "stock_status WHERE language_id = '" . (int)$this->config->get('config_language_id') . "'";
      		
			$sql .= " ORDER BY name";	
			
			if (isset($data['order']) && ($data['order'] == 'DESC')) {
				$sql .= " DESC";
			} else {
				$sql .= " ASC";
			}
			
			if (isset($data['start']) || isset($data['limit'])) {
				if ($data['start'] < 0) {
					$data['start'] = 0;
				}					
	
				if ($data['limit'] < 1) {
					$data['limit'] = 20;
				}	
			
				$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
			}			
			
			$query = $this->db->query($sql);
		
			return $query->rows;
		} else {
			$stock_status_data = $this->cache->get('stock_status.' . (int)$this->config->get('config_language_id'));
		
			if (!$stock_status_data) {
				$query = $this->db->query("SELECT stock_status_id, name FROM " . DB_PREFIX . "stock_status WHERE language_id = '" . (int)$this->config->get('config_language_id') . "' ORDER BY name");
	
				$stock_status_data = $query->rows;
			
				$this->cache->set('stock_status.' . (int)$this->config->get('config_language_id'), $stock_status_data);
			}	
	
			return $stock_status_data;			
		}
	}
/*
FUNCTION NAME 		-	getStockStatusDescriptions
DESCRIPTION 		-	Queries to get the description for the given stock status id.
INPUT PARAMETER 	-	stock_status_id
OUTPUT PARAMETER 	- 	returns a row with the stock_status description
*/	
	public function getStockStatusDescriptions($stock_status_id) {
		$stock_status_data = array();
		
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "stock_status WHERE stock_status_id = '" . (int)$stock_status_id . "'");
		
		foreach ($query->rows as $result) {
			$stock_status_data[$result['language_id']] = array('name' => $result['name']);
		}
		
		return $stock_status_data;
	}
/*
FUNCTION NAME 		-	getTotalStockStatuses
DESCRIPTION 		-	Queries to get the total number of stock_status in the database.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	returns a row with column total containing count for the stock_status table.
*/	
	public function getTotalStockStatuses() {
      	$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "stock_status WHERE language_id = '" . (int)$this->config->get('config_language_id') . "'");
		
		return $query->row['total'];
	}	
}
?>