<?php
/*
@File geo_zone.php(MODEL)
LOCALISATION:	 GEO_ZONE PAGE
    This class queries,adds and updates the geographical zone details to the database for the store.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ModelLocalisationGeoZone extends Model {
/*
FUNCTION NAME 		-	addGeoZone
DESCRIPTION 		-	Adds new geo_zone detail to the database.
INPUT PARAMETER 	-	data array containing the geo_zone description.
OUTPUT PARAMETER 	- 	Adds to the database, deletes the cache for geo_zone and returns to 
						the geo_zone list page with a success notification
*/	
	public function addGeoZone($data) {
		$this->db->query("INSERT INTO " . DB_PREFIX . "geo_zone SET name = '" . $this->db->escape($data['name']) . "', description = '" . $this->db->escape($data['description']) . "', date_added = NOW()");

		$geo_zone_id = $this->db->getLastId();
		
		if (isset($data['zone_to_geo_zone'])) {
			foreach ($data['zone_to_geo_zone'] as $value) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "zone_to_geo_zone SET country_id = '"  . (int)$value['country_id'] . "', zone_id = '"  . (int)$value['zone_id'] . "', geo_zone_id = '"  .(int)$geo_zone_id . "', date_added = NOW()");
			}
		}
		
		$this->cache->delete('geo_zone');
	}
/*
FUNCTION NAME 		-	editGeoZone
DESCRIPTION 		-	Updates the geo_zone detail given for the given geo_zone_id.
INPUT PARAMETER 	-	geo_zone_id, data array containing the geo_zone description.
OUTPUT PARAMETER 	- 	Updates the database, deletes the cache for geo_zone and returns to 
						the geo_zone list page with a success notification
*/	
	public function editGeoZone($geo_zone_id, $data) {
		$this->db->query("UPDATE " . DB_PREFIX . "geo_zone SET name = '" . $this->db->escape($data['name']) . "', description = '" . $this->db->escape($data['description']) . "', date_modified = NOW() WHERE geo_zone_id = '" . (int)$geo_zone_id . "'");

		$this->db->query("DELETE FROM " . DB_PREFIX . "zone_to_geo_zone WHERE geo_zone_id = '" . (int)$geo_zone_id . "'");
		
		if (isset($data['zone_to_geo_zone'])) {
			foreach ($data['zone_to_geo_zone'] as $value) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "zone_to_geo_zone SET country_id = '"  . (int)$value['country_id'] . "', zone_id = '"  . (int)$value['zone_id'] . "', geo_zone_id = '"  .(int)$geo_zone_id . "', date_added = NOW()");
			}
		}
		
		$this->cache->delete('geo_zone');
	}
/*
FUNCTION NAME 		-	deleteGeoZone
DESCRIPTION 		-	Deletes the geo_zone detail for the given geo_zone_id.
INPUT PARAMETER 	-	geo_zone_id
OUTPUT PARAMETER 	- 	Deletes the given geo_zone details and the cache for geo_zone and returns to 
						the geo_zone list page with a success notification
*/	
	public function deleteGeoZone($geo_zone_id) {
		$this->db->query("DELETE FROM " . DB_PREFIX . "geo_zone WHERE geo_zone_id = '" . (int)$geo_zone_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "zone_to_geo_zone WHERE geo_zone_id = '" . (int)$geo_zone_id . "'");

		$this->cache->delete('geo_zone');
	}
/*
FUNCTION NAME 		-	getGeoZone
DESCRIPTION 		-	Queries the geo_zone details for the given geo_zone_id from the database.
INPUT PARAMETER 	-	geo_zone_id
OUTPUT PARAMETER 	- 	Returns the asked geo_zone details.
*/	
	public function getGeoZone($geo_zone_id) {
		$query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "geo_zone WHERE geo_zone_id = '" . (int)$geo_zone_id . "'");
		
		return $query->row;
	}
/*
FUNCTION NAME 		-	getGeoZones
DESCRIPTION 		-	Queries all the geo_zone details from the database.
INPUT PARAMETER 	-	data array containing filter values if any.
OUTPUT PARAMETER 	- 	Returns all the geo_zone details queried.
*/	
	public function getGeoZones($data = array()) {
		if ($data) {
			$sql = "SELECT * FROM " . DB_PREFIX . "geo_zone";
	
			$sort_data = array(
				'name',
				'description'
			);	
			
			if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
				$sql .= " ORDER BY " . $data['sort'];	
			} else {
				$sql .= " ORDER BY name";	
			}
			
			if (isset($data['order']) && ($data['order'] == 'DESC')) {
				$sql .= " DESC";
			} else {
				$sql .= " ASC";
			}
			
			if (isset($data['start']) || isset($data['limit'])) {
				if ($data['start'] < 0) {
					$data['start'] = 0;
				}					

				if ($data['limit'] < 1) {
					$data['limit'] = 20;
				}	
			
				$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
			}
			
			$query = $this->db->query($sql);
	
			return $query->rows;
		} else {
			$geo_zone_data = $this->cache->get('geo_zone');

			if (!$geo_zone_data) {
				$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "geo_zone ORDER BY name ASC");
	
				$geo_zone_data = $query->rows;
			
				$this->cache->set('geo_zone', $geo_zone_data);
			}
			
			return $geo_zone_data;				
		}
	}
/*
FUNCTION NAME 		-	getTotalGeoZones
DESCRIPTION 		-	Queries to get the total number of geo_zone in the database.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	returns a row with column total containing count for the geo_zone table.
*/	
	public function getTotalGeoZones() {
      	$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "geo_zone");
		
		return $query->row['total'];
	}	
/*
FUNCTION NAME 		-	getZoneToGeoZones
DESCRIPTION 		-	Queries to get the zone details for the given geo_zone_id
INPUT PARAMETER 	-	geo_zone_id
OUTPUT PARAMETER 	- 	returns all the rows retrieved.
*/	
	public function getZoneToGeoZones($geo_zone_id) {	
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "zone_to_geo_zone WHERE geo_zone_id = '" . (int)$geo_zone_id . "'");
		
		return $query->rows;	
	}		
/*
FUNCTION NAME 		-	getTotalZoneToGeoZoneByGeoZoneId
DESCRIPTION 		-	Queries to get the total number of zone to geo_zone mapped enries for the 
						given geo_zone_id
INPUT PARAMETER 	-	geo_zone_id
OUTPUT PARAMETER 	- 	returns a row with column total containing count retrieved.
*/
	public function getTotalZoneToGeoZoneByGeoZoneId($geo_zone_id) {
      	$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "zone_to_geo_zone WHERE geo_zone_id = '" . (int)$geo_zone_id . "'");
		
		return $query->row['total'];
	}
/*
FUNCTION NAME 		-	getTotalZoneToGeoZoneByCountryId
DESCRIPTION 		-	Queries to get the total number of zone to geo_zone mapped enries for the 
						given country_id
INPUT PARAMETER 	-	country_id
OUTPUT PARAMETER 	- 	returns a row with column total containing count retrieved
*/	
	public function getTotalZoneToGeoZoneByCountryId($country_id) {
      	$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "zone_to_geo_zone WHERE country_id = '" . (int)$country_id . "'");
		
		return $query->row['total'];
	}	
/*
FUNCTION NAME 		-	getTotalZoneToGeoZoneByZoneId
DESCRIPTION 		-	Queries to get the total number of zone to geo_zone mapped enries for the
						given zone_id 
INPUT PARAMETER 	-	zone_id
OUTPUT PARAMETER 	- 	returns a row with column total containing count retrieved
*/	
	public function getTotalZoneToGeoZoneByZoneId($zone_id) {
      	$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "zone_to_geo_zone WHERE zone_id = '" . (int)$zone_id . "'");
		
		return $query->row['total'];
	}		
}
?>