<?php
/*
@File feed.php(MODEL)
DESIGN:	 FEED PAGE
    This class creates and updates the json feed for channels, packages and packageChannels.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/

class ModelJsonFeed extends Model {
/*
FUNCTION NAME 		-	CreateChannelFeed
DESCRIPTION 		-	Creates the channel feed for the first time if this feed in not available, 
						if available - it loads the channels from this feed without interacting with 
						the database.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Creates channel feed and save it in a json file.
*/		
	public function CreateChannelFeed() {
		$json = array();
		$row_array=array();
		$query_1=$this->db->query("SELECT * FROM `" . DB_PREFIX . "product` where is_package='0' and is_ppv='0'and status='1'");
		foreach($query_1->rows as $r_1)
		{
			$query_2 = $this->db->query("SELECT * FROM `" . DB_PREFIX . "product_description` where product_id=".$r_1['product_id']);
			foreach($query_2->rows as $r_2)
			{
				$row_array['name'] = $r_2['name'];
			}
				$row_array['pid'] = $r_1['product_id'];
				$row_array['image'] = $r_1['image'];
			    $row_array['price'] = $r_1['price'];
				$query_3=$this->db->query("SELECT * FROM `" . DB_PREFIX . "product_option_value` where product_id=".$r_1['product_id']);
				$c=0;
				$k=0;
				foreach($query_3->rows as $r_3)
				{
					if($c==0)
					{ 
						$row_array['p_o_id'] = $r_3['product_option_id'];
						$c=1;
					}
					$query_4 = $this->db->query("SELECT * FROM `" . DB_PREFIX . "option_value_description` where option_value_id=".$r_3['option_value_id']);
					foreach($query_4->rows as $r_4)
					{
						$row_array['subscription'][$r_3['product_option_value_id']] = $r_4['name']."+".$r_3['price'];
					}
					$k++;	
				}
				$row_array['count']= (string)$k;
				$row_mod[$r_1['product_id']]=$row_array;
				array_push($json, $row_mod);
				unset($row_mod);
				unset($row_array);
		}
		$json_data=json_encode($json);
		$File = DIR_JSON."c.json"; 
		$Handle = fopen($File,"w");
		fwrite($Handle, $json_data);
		fclose($Handle);
		chmod($File, 0777);
		unset($json);

		//$name="channel";
		//return $name;
	}

/*
FUNCTION NAME 		-	CreatePackageFeed
DESCRIPTION 		-	Creates the package feed for the first time if this feed in not available, 
						if available - it loads the packages from this feed without interacting with 
						the database.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Creates package feed and save it in a json file.
*/	
	public function CreatePackageFeed() {
		$json = array();
		$row_array=array();
		$query_1=$this->db->query("SELECT * FROM `" . DB_PREFIX . "product` where is_package='1' and status='1'");
		foreach($query_1->rows as $r_1)
		{
			$query_2 = $this->db->query("SELECT * FROM `" . DB_PREFIX . "product_description` where product_id=".$r_1['product_id']);
			foreach($query_2->rows as $r_2)
			{
				$row_array['name'] = $r_2['name'];
			}
				$row_array['pid'] = $r_1['product_id'];
				$row_array['image'] = $r_1['image'];
			    $row_array['price'] = $r_1['price'];
				$query_3=$this->db->query("SELECT * FROM `" . DB_PREFIX . "product_option_value` where product_id=".$r_1['product_id']);
				$c=0;
				$k=0;
				foreach($query_3->rows as $r_3)
				{
					if($c==0)
					{ 
						$row_array['p_o_id'] = $r_3['product_option_id'];
						$c=1;
					}
					$query_4 = $this->db->query("SELECT * FROM `" . DB_PREFIX . "option_value_description` where option_value_id=".$r_3['option_value_id']);
					foreach($query_4->rows as $r_4)
					{
						$row_array['subscription'][$r_3['product_option_value_id']] = $r_4['name']."+".$r_3['price'];
					}
					$k++;	
				}
				$row_array['count']= (string)$k;
				$row_mod[$r_1['product_id']]=$row_array;
				array_push($json, $row_mod);
				unset($row_mod);
				unset($row_array);
		}
		$json_data=json_encode($json);
		$File = DIR_JSON."p.json"; 
		$Handle = fopen($File,"w");
		fwrite($Handle, $json_data);
		fclose($Handle);
		chmod($File, 0777);
		unset($json);


		//$name = "Package";
		//return $name;
	}

/*
FUNCTION NAME 		-	CreatePackChannelFeed
DESCRIPTION 		-	Creates the package-channel feed for the first time if this feed in not available, 
						if available - it loads the channels for each package from this feed without interacting with 
						the database.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Creates package-channel feed and save it in a json file.
*/	
	public function CreatePackChannelFeed() {
		$json = array();
		$row_array=array();
		$query_1=$this->db->query("SELECT * FROM `" . DB_PREFIX . "product` where is_package='1' and status='1'");
		foreach($query_1->rows as $child)
		{
			$arr = explode(',',$child['channel_list']);
			foreach($arr as $t)
			{
				if($fet=$this->db->query("SELECT a.product_id ,a.image, b.name FROM `" . DB_PREFIX ."product_image` a left join `".DB_PREFIX."product_description` b on a.product_id = b.product_id where b.name in ('".trim($t)."')"))
				{
				foreach($fet->rows as $r)
				{	
					$row_array[$r['name']] = $r['image']."+".$r['product_id'];
				}
				}
			}
			$row_mod[$child['product_id']]=$row_array;
			array_push($json, $row_mod);
			unset($row_mod);
			unset($row_array);
		}
		$json_data=json_encode($json);
		$File = DIR_JSON."pc.json"; 
		$Handle = fopen($File,"w");
		fwrite($Handle, $json_data);
		fclose($Handle);
		chmod($File, 0777);
		unset($json);


		//$name = "PackChannel";
		//return $name;
	}
/*
FUNCTION NAME 		-	CreateSTBFeed
DESCRIPTION 		-	Creates the stb number feed for the first time if this feed in not available, 
						if available - it loads the stb numbers from this feed without interacting with 
						the database.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Creates stb number feed and save it in a json file.
*/
	public function CreateSTBFeed(){
		$json = array();
		$row_array=array();
		$query_1=$this->db->query("SELECT * FROM `" . DB_PREFIX . "stb`");
		foreach($query_1->rows as $r_1)
		{
			$row_array['cust_id']=$r_1['customer_id'];
			$row_array['is_avail']=$r_1['is_avail'];
			$row_array['is_smart_card']=$r_1['is_smart_card'];
			
			$row_mod[$r_1['stb_id']]=$row_array;
			array_push($json, $row_mod);
			unset($row_mod);
			unset($row_array);
		}
		//JSOn data to Json file
		$json_data=json_encode($json);
		//echo $json_data;
		$File = DIR_JSON."/STBCAS/stb.json"; 
		$Handle = fopen($File,"w");
		fwrite($Handle, $json_data);
		fclose($Handle);
		chmod($File, 0777);
		unset($json);

	}
/*
FUNCTION NAME 		-	CreateCASFeed
DESCRIPTION 		-	Creates the cas number feed for the first time if this feed in not available, 
						if available - it loads the cas numbers from this feed without interacting with 
						the database.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Creates cas number feed and save it in a json file.
*/
	public function CreateCASFeed(){
		$json = array();
		$row_array=array();
		$query_1=$this->db->query("SELECT * FROM `" . DB_PREFIX . "cas`");
		foreach($query_1->rows as $r_1)
		{
			$row_array['cust_id']=$r_1['customer_id'];
			$row_array['is_avail']=$r_1['is_avail'];
			$row_array['is_smart_card']=$r_1['is_smart_card'];
			
			$row_mod[$r_1['cas_id']]=$row_array;
			array_push($json, $row_mod);
			unset($row_mod);
			unset($row_array);
		}
		//JSOn data to Json file
		$json_data=json_encode($json);
		//echo $json_data;
		$File = DIR_JSON."STBCAS/cas.json"; 
		$Handle = fopen($File,"w");
		fwrite($Handle, $json_data);
		fclose($Handle);
		chmod($File, 0777);
		unset($json);
	}
/*
FUNCTION NAME 		-	CreateBondFeed
DESCRIPTION 		-	Creates the stb-cas-customer_id bond feed for the first time if this feed in not available, 
						if available - it loads the bond details from this feed without interacting with 
						the database.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Creates stb-cas-customer_id bond feed and saves it in a json file.
*/
	public function CreateBondFeed(){
		$json = array();
		$row_array=array();
		$query_1=$this->db->query("SELECT * FROM `" . DB_PREFIX . "customer_stb_cas`");
		foreach($query_1->rows as $r_1)
		{
			$row_array['current_stbno']=$r_1['current_stbno'];
			$row_array['current_casno']=$r_1['current_casno'];
			$row_array['prev_stbno']=$r_1['prev_stbno'];
			$row_array['prev_casno']=$r_1['prev_casno'];

			$row_mod[$r_1['customer_id']]=$row_array;
			array_push($json, $row_mod);
			unset($row_mod);
			unset($row_array);
		}
		//JSOn data to Json file
		$json_data=json_encode($json);
		//echo $json_data;
		$File = DIR_JSON."STBCAS/cust_stb_cas.json"; 
		$Handle = fopen($File,"w");
		fwrite($Handle, $json_data);
		fclose($Handle);
		chmod($File, 0777);
		unset($json);
	}


}