<?php
/*
@File stb.php(MODEL)
DESIGN:	 STB PAGE
    This class retrieves the stb number detials along with their activation.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ModelInventrySTB extends Model {
/*
FUNCTION NAME 		-	getDetail
DESCRIPTION 		-	Retrieves all the mapping between cas number, stb number and customer id.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved by the query.
*/		
	


	public function getDetail($data) {
		$flag=true;
		if($this->session->data['user_group_id']==1){
			// $sql="SELECT  (c.customer_id),CONCAT(c.firstname, ' ', c.lastname) AS name,(s.stb_no),(s.is_avail),(s.is_smart_card),(s.is_black_list),(s.hw_version_no),(s.sw_version_no),(s.pass_code),(s.sc_no)  FROM " . DB_PREFIX . "customer c Right JOIN " . DB_PREFIX . "stb s ON (c.customer_id = s.customer_id)  "; //WHERE s.operator_id ='" . $this->session->data['user_group_id'] . "'

			$sql="SELECT username AS name,(s.stb_no),(s.is_avail),(s.is_smart_card),(s.is_black_list),(s.hw_version_no),(s.sw_version_no),(s.pass_code),(s.sc_no), (s.is_active) FROM oc_user u Right JOIN oc_stb s ON (u.user_id = s.operator_id)";
		}else{
			$flag=false;
			// $sql="SELECT  (c.customer_id),CONCAT(c.firstname, ' ', c.lastname) AS name,(s.stb_no),(s.is_avail),(s.is_smart_card),(s.is_black_list),(s.hw_version_no),(s.sw_version_no),(s.pass_code),(s.sc_no)  FROM " . DB_PREFIX . "customer c Right JOIN " . DB_PREFIX . "stb s ON (c.customer_id = s.customer_id) WHERE s.operator_id ='" . $this->session->data['user_id'] . "'";

			$sql="SELECT u.username AS name,(s.stb_no),(s.is_avail),(s.is_smart_card),(s.is_black_list),(s.hw_version_no),(s.sw_version_no),(s.pass_code),(s.sc_no), (s.is_active) FROM oc_user u Right JOIN oc_stb s ON (u.user_id = s.operator_id) WHERE s.operator_id ='" . $this->session->data['user_id'] . "'";
		}

		$implode=array();
		if (isset($this->request->get['filter_operator']) && $this->session->data['user_group_id']==1) { 
			if($flag==true)
				$implode[] = "s.operator_id='" .(int)$this->request->get['filter_operator'] . "'";
		}

		if (isset($this->request->get['filter_status'])) {
			$implode[]= " s.is_active = '" . (int)$this->request->get['filter_status'] . "'";
		}

		if (isset($this->request->get['filter_paired_status'])) {
			if($this->request->get['filter_paired_status']==1){
				$implode[]= " s.customer_id != 0";	
			}else{
				$implode[]= " s.customer_id = 0";
			}
		}
		if (isset($this->request->get['filter_blacklist_status'])) {
			$implode[] = " s.is_black_list = " . (int)$this->request->get['filter_blacklist_status'] ;
		}

		if(isset($data['filter_value']) && $this->session->data['user_group_id']==1)
		{
			$implode[] = "s.stb_no like '%".$data['filter_value']."%'";
		}else if(isset($data['filter_value']) && $this->session->data['user_group_id']!=1){
			$implode[] = " s.stb_no like '%".$data['filter_value']."%'";
		}
		if(isset($data['filter_passcode']) && $this->session->data['user_group_id']==1)
		{
			$implode[]= " s.pass_code like '%".$data['filter_passcode']."%'";
		}else if(isset($data['filter_passcode']) && $this->session->data['user_group_id']!=1){
			$implode[] = " s.pass_code like '%".$data['filter_passcode']."%'";
		}

		if($implode){
				$sql.=" WHERE ".implode( ' AND ', $implode);
			}

		//$sql="SELECT  (c.customer_id),CONCAT(c.firstname, ' ', c.lastname) AS name,(s.stb_no),(s.is_avail),(s.is_smart_card),(s.is_black_list),(s.hw_version_no),(s.sw_version_no)  FROM " . DB_PREFIX . "customer c Right JOIN " . DB_PREFIX . "stb s ON (c.customer_id = s.customer_id)";
		
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}				

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
		
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}	
		$query = $this->db->query($sql);
		return $query->rows;
		}
//---------------------------
/*
FUNCTION NAME 		-	getTotalStb
DESCRIPTION 		-	Retrieves number of  stb number assign to customer and balance.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved by the query.
*/		
		public function getTotalStb($data) {
			
			$sql="SELECT count(*) AS total FROM " . DB_PREFIX . "stb s LEFT JOIN " . DB_PREFIX . "user u ON (u.user_id = s.operator_id)";
			$implode=array();
			if($this->session->data['user_group_id']!=1){
				$implode[] ="s.operator_id ='" . $this->session->data['user_id'] . "'";
			}

			if (isset($this->request->get['filter_operator']) && $this->session->data['user_group_id']==1) { 
				$implode[] = " s.operator_id='" .(int)$this->request->get['filter_operator'] . "'";
			}

			if (isset($this->request->get['filter_status'])) {
				$implode[] = " s.is_active = '" . (int)$this->request->get['filter_status'] . "'";
			}

			if (isset($this->request->get['filter_paired_status'])) {
				if($this->request->get['filter_paired_status']==1){
					$implode[]= " s.customer_id != 0";	
				}else{
					$implode[]= " s.customer_id = 0";
				}
			}
			if (isset($this->request->get['filter_blacklist_status'])) {
				$implode[] = " s.is_black_list = " . (int)$this->request->get['filter_blacklist_status'] ;
			}

			if(isset($data['filter_value']))
			{
				$implode[] = " s.stb_no like '%".$data['filter_value']."%'";
			}
			if(isset($data['filter_passcode']))
			{
				$implode[] = " s.pass_code like '%".$data['filter_passcode']."%'";
			}
			
			if($implode){
				$sql.=" WHERE ".implode( ' AND ', $implode);
			}
			// var_dump($sql);die;
			$query = $this->db->query($sql);
				return $query->row['total'];
		}



//---------------------------
/*
FUNCTION NAME 		-	getActiveSTB
DESCRIPTION 		-	Retrieves all the stb numbers details which are active on the store.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved by the query.
*/	
		public function getActiveSTB()
		{
		//$this->db->query("select c.name c.stbno c.casno a.city from customer c  ");
		$query = $this->db->query("SELECT  (c.customer_id),CONCAT(c.firstname, ' ', c.lastname) AS name,(s.stb_no),(s.is_avail),(s.is_smart_card) FROM " . DB_PREFIX . "customer c Right JOIN " . DB_PREFIX . "stb s ON (c.customer_id = s.customer_id) WHERE s.is_avail=1");
		return $query->rows;
		}

		// ============================================

/*
FUNCTION NAME 		-	addCustomerBanIp
DESCRIPTION 		-	Adds new customer_ban_ip to the database.
INPUT PARAMETER 	-	data array containing the details of the customer_ban_ip.
OUTPUT PARAMETER 	- 	Inserts the customer_ban_ip details to the database and returns.
*/	
	public function addSTB($data,$stb_sw_hw,$sc_no) {
		if($sc_no!=-1)
			$this->db->query("INSERT INTO `" . DB_PREFIX . "stb` SET `customer_id` = '0', `stb_no` = '" . $data['stb_no'] . "',`sw_version_no` = '" . (float)$stb_sw_hw[0] . "',`hw_version_no` = '" .(float)$stb_sw_hw[1] . "', `is_avail`='1',`is_black_list`='0',`is_smart_card`=1, `sc_no` = '" .$sc_no. "',operator_id='".$this->session->data['user_id']."' ON DUPLICATE KEY UPDATE `is_smart_card`=0");
		else
			$this->db->query("INSERT INTO `" . DB_PREFIX . "stb` SET `customer_id` = '0', `stb_no` = '" . $data['stb_no'] . "',`sw_version_no` = '" . (float)$stb_sw_hw[0] . "',`hw_version_no` = '" .(float)$stb_sw_hw[1] . "', `is_avail`='1',`is_black_list`='0',`is_smart_card`=0, `sc_no` = '" .$sc_no. "',operator_id='".$this->session->data['user_id']."' ON DUPLICATE KEY UPDATE `is_smart_card`=0");

		return $this->db->getLastId();;
	}		

/*
FUNCTION NAME 		-	editCustomerBanIp
DESCRIPTION 		-	Updates the customer ban ip for the given customer ban ip id
INPUT PARAMETER 	-	customer_ban_ip_id
OUTPUT PARAMETER 	- 	Retuns after updaing the ban ip
*/	
	public function editSTB($stb_no, $data) {
		$this->db->query("UPDATE `" . DB_PREFIX . "stb` SET `is_smart_card` = '" . $this->db->escape($data['sc']) . "' WHERE stb_no = '" . (int)$stb_no . "'");
	}
/*
FUNCTION NAME 		-	deleteCustomerBanIp
DESCRIPTION 		-	Deletes the customer ban ip for the given customer ban ip id
INPUT PARAMETER 	-	customer_ban_ip_id
OUTPUT PARAMETER 	- 	Returns after deleting the ban ip
*/		
	public function deleteSTB($stb_no) {
		$id = $this->getSTB($stb_no);
		$this->db->query("DELETE FROM `" . DB_PREFIX . "stb` WHERE stb_no = '" .$stb_no . "'");
		$this->db->query("DELETE FROM `" . DB_PREFIX . "sms_kms_stb` WHERE sms_stb_id = '" . (int)$id['id'] . "'");
	}
/*
FUNCTION NAME 		-	blacklistSTB
DESCRIPTION 		-	Updates the customer ban ip for the given customer ban ip id
INPUT PARAMETER 	-	customer_ban_ip_id
OUTPUT PARAMETER 	- 	Retuns after updaing the ban ip
*/	
	public function blacklistSTB($stb_no) {
		$this->db->query("UPDATE `" . DB_PREFIX . "stb` SET `is_black_list` = '1',`black_list_date`=now() WHERE stb_no = '" .$stb_no. "'");
		$query = $this->db->query("SELECT  is_black_list FROM " . DB_PREFIX . "stb WHERE stb_no = '" . $stb_no . "'");
		if($query->num_rows)
			return 1;
		else
			return 0;
	}

	public function CheckBlackList($stb_no)	{
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "stb WHERE stb_no = '" . $stb_no . "' AND is_black_list=1");
		if($query->num_rows)
			return 1;
		else
			return 0;
	}
/*
FUNCTION NAME 		-	getDetail
DESCRIPTION 		-	Retrieves all the mapping between cas number, stb number and customer id.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved by the query.
*/		
		public function getSTB($stb_no) {
		$query = $this->db->query("SELECT  * FROM " . DB_PREFIX . "stb where stb_no='".$stb_no."'");
		return $query->row;
		}

		public function isSTBExist($stb_no) {
		$query = $this->db->query("SELECT *  FROM " . DB_PREFIX . "stb where stb_no='".$stb_no."'");
		return $query->num_rows;
		}

		public function isSCNoExist($smart_card) {
		$query = $this->db->query("SELECT *  FROM " . DB_PREFIX . "stb where sc_no='".$smart_card."'");
		return $query->num_rows;
		}

	public function getStbidByStbno($STBNO) {
		$query = $this->db->query("SELECT id,customer_id FROM `" . DB_PREFIX . "stb` WHERE stb_no = '" .$STBNO . "'");
	
		return $query->row;
		}
	public function addApiResponceId($kms_stb_no,$sms_stb_no)
	{
	 	$this->db->query("INSERT INTO " . DB_PREFIX . "sms_kms_stb SET sms_stb_id = '" . (int)$sms_stb_no . "', kms_stb_id = '" . (int)$kms_stb_no . "'");

	}
	 
	 public function getSTBNOById($stb_id){
	 	$query = $this->db->query("SELECT stb_no FROM `" . DB_PREFIX . "stb` WHERE id = '" . (int)$stb_id. "'");
	
	 	return $query->row;

	 }

	public function getApiResponceId($sms_stb_no)
	{
	 	// $this->db->query("INSERT INTO " . DB_PREFIX . "user_api_response SET user_id = '" . (int)$user_id . "', api_user_id = '" . (int)$apiuser_id . "'");
	 	$query = $this->db->query("SELECT kms_stb_id FROM `" . DB_PREFIX . "sms_kms_stb` WHERE sms_stb_id = '" . (int)$sms_stb_no . "'");
	
		return $query->row;
	}
	public function getApiCustomerId($customer_id)
	{
	 	$query = $this->db->query("SELECT api_user_id FROM `" . DB_PREFIX . "sms_kms_map` WHERE user_id = '" . (int)$customer_id . "'");
	
		return $query->row;
	}

	public function checkSTBPairedBySTBNO($stb_no)
	{
	 	$query = $this->db->query("SELECT customer_id FROM `" . DB_PREFIX . "customer` WHERE STBNO = '" .$stb_no. "'");
		if($query->row!=NULL)
		return $query->row['customer_id'];
	}

	public function getSTBWithoutPasscode() {
		$query = $this->db->query("SELECT stb_no FROM " . DB_PREFIX . "stb where pass_code=''");
		return $query->rows;
	}

	public function addPasscode($result) {		
		foreach ($result as $key => $value) {
			$this->db->query("UPDATE " . DB_PREFIX . "stb SET pass_code = '" . $value . "' WHERE stb_no='" .$key. "'");	
		}			
	}

	public function getOperators() {
		$query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "user");
		return $query->rows;
	}

}
?>