<?php
/*
@File stb_cas.php(MODEL)
DESIGN:	 STB_CAS PAGE
    This class retrieves the stb and cas pairing details along with the customer assigned.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ModelInventrySTBCAS extends Model {
/*
FUNCTION NAME 		-	getDetail
DESCRIPTION 		-	Retrieves all the mapping between cas number, stb number and customer id.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved by the query.
*/		
	public function getDetail($data) {
		if($this->session->data['user_group_id']==1){
			$sql ="SELECT  c.customer_unique_id as customer_no, (c.customer_id),CONCAT(c.firstname, ' ', c.lastname) AS name,(sc.current_stbno) AS stb_id,(sc.prev_stbno) AS prev_stb_id FROM " . DB_PREFIX . "customer c," . DB_PREFIX . "customer_stb_cas sc WHERE c.customer_id = sc.customer_id ";
		}else{
			$sql ="SELECT c.customer_unique_id as customer_no, (c.customer_id),CONCAT(c.firstname, ' ', c.lastname) AS name,(sc.current_stbno) AS stb_id,(sc.prev_stbno) AS prev_stb_id FROM " . DB_PREFIX . "customer c," . DB_PREFIX . "customer_stb_cas sc WHERE c.customer_id = sc.customer_id AND c.operator_id='".$this->session->data['user_id']."'";
			//$sql = "SELECT *, CONCAT(c.firstname, ' ', c.lastname) AS name, cgd.name AS customer_group FROM " . DB_PREFIX . "customer c LEFT JOIN " . DB_PREFIX . "customer_group_description cgd ON (c.customer_group_id = cgd.customer_group_id) WHERE cgd.language_id = '" . (int)$this->config->get('config_language_id') . "' AND  c.operator_id='".$user_id."'";
		}
		if(isset($data['filter_value']))
		{
			$sql .= "AND c.STBNO like '%".$this->db->escape($data['filter_value'])."%'";
		}
	
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}				

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
		
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}	
		// var_dump($sql);exit();
		$query = $this->db->query($sql);
		return $query->rows;
		}

/*
FUNCTION NAME 		-	getTotalDetails
DESCRIPTION 		-	Retrieves number of  the mapping between cas number, stb number and customer id.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved by the query.
*/		
		public function getTotalDetails($data) {
		if($this->session->data['user_group_id']==1){
			$sql ="SELECT count(*) AS total  FROM " . DB_PREFIX . "customer c," . DB_PREFIX . "customer_stb_cas sc WHERE c.customer_id = sc.customer_id ";
		}else{
			$sql ="SELECT count(*) AS total  FROM " . DB_PREFIX . "customer c," . DB_PREFIX . "customer_stb_cas sc WHERE c.customer_id = sc.customer_id AND c.operator_id='".$this->session->data['user_id']."'";
			//$sql = "SELECT *, CONCAT(c.firstname, ' ', c.lastname) AS name, cgd.name AS customer_group FROM " . DB_PREFIX . "customer c LEFT JOIN " . DB_PREFIX . "customer_group_description cgd ON (c.customer_group_id = cgd.customer_group_id) WHERE cgd.language_id = '" . (int)$this->config->get('config_language_id') . "' AND  c.operator_id='".$user_id."'";
		}
	   		if(isset($data['filter_value']))
			{
				$sql .= "AND c.STBNO like '%".$this->db->escape($data['filter_value'])."%'";
			}
		  $query = $this->db->query($sql);
		  return $query->row['total'];
		}
		
/*
FUNCTION NAME 		-	getData
DESCRIPTION 		-	Retrieves cas and stb number for the given customer_id
INPUT PARAMETER 	-	customer_id
OUTPUT PARAMETER 	- 	Returns a row conatining the customer stb and cas details.
*/	
		public function getData($customer_id) {

		$query = $this->db->query("SELECT customer_id,stbno FROM " . DB_PREFIX . "customer  WHERE customer_id = ".$customer_id."");
		return $query->rows;
		}

/*
FUNCTION NAME 		-	unbound
DESCRIPTION 		-	Updateds the customer stb and cas details by releasing the numbers and making 
						them available.
INPUT PARAMETER 	-	customer_id
OUTPUT PARAMETER 	- 	Returns to the release pair page with the success notification
*/
		public function approve($customer_id)
		{
		    // $this->db->query("UPDATE " . DB_PREFIX . "stb SET is_avail= 1,customer_id=0 WHERE customer_id = '" . (int)$customer_id . "'");
		    // $this->db->query("UPDATE " . DB_PREFIX . "cas SET is_avail= 1,customer_id=0 WHERE customer_id = '" . (int)$customer_id . "'");
		    $this->db->query("UPDATE " . DB_PREFIX . "customer_stb_cas SET `status`='Activated' WHERE customer_id = '" . (int)$customer_id . "'");
		}

/*
FUNCTION NAME 		-	unbound
DESCRIPTION 		-	Updateds the customer stb and cas details by releasing the numbers and making 
						them available.
INPUT PARAMETER 	-	customer_id
OUTPUT PARAMETER 	- 	Returns to the release pair page with the success notification
*/
		public function unpair($customer_id)
		{
			$q = $this->db->query("SELECT customer_unique_id,STBNO,a.region_id,c.customer_group_id,c.operator_id FROM " . DB_PREFIX . "customer c INNER JOIN oc_address a ON (c.address_id=a.address_id) WHERE c.customer_id = '" . (int)$customer_id . "'");		
			$stb = $q->row['STBNO'];
			$customer_no = $q->row['customer_unique_id'];
			$c_grp_id = $q->row['customer_group_id'];
			$c_region_id = $q->row['region_id'];
			$c_operator_id = $q->row['operator_id'];


			$this->db->query("UPDATE " . DB_PREFIX . "stb SET active_date = null WHERE customer_id = '" . (int)$customer_id . "'");
			$query = $this->db->query("SELECT  current_stbno FROM " . DB_PREFIX . "customer_stb_cas WHERE customer_id = '" . (int)$customer_id . "'")  ;
			$this->db->query("UPDATE " . DB_PREFIX . "customer_stb_cas SET `status`='Unpaired', current_stbno='',prev_stbno='".$query->row['current_stbno']."' WHERE customer_id = '" . (int)$customer_id . "'");
		    $this->db->query("UPDATE " . DB_PREFIX . "stb SET is_avail= 1,customer_id=0 WHERE customer_id = '" . (int)$customer_id . "'");
		    
   		    $this->db->query("UPDATE " . DB_PREFIX . "customer SET STBNO='0' WHERE customer_id = '" . (int)$customer_id . "'");
   		    
   		    $this->db->query("INSERT INTO " . DB_PREFIX . "customer_stb_pair_unpair SET customer_unique_id = '" . (int)$customer_no . "', stb_no = '" . $stb."', pairing_status = 0 , operator_id = '" . $c_operator_id."',group_id = '" . $c_grp_id."',region_id = '" . $c_region_id."'");
		}		


	public function CheckUnpair($customer_id)		{
		$query = $this->db->query("SELECT  current_stbno FROM " . DB_PREFIX . "customer_stb_cas WHERE customer_id = '" . (int)$customer_id . "'")  ;
		if(isset($query->row['current_stbno'])){
			if(strlen($query->row['current_stbno'])==0)
				return 1;
			else
				return 0;
		}else{
			return 0; 
		}
	}

	public function isSTBActive($customer_id) {
		$query = $this->db->query("SELECT  is_active FROM " . DB_PREFIX . "stb WHERE customer_id = '" . (int)$customer_id . "'")  ;
		return $query->row['is_active'];
	}

	public function CheckApprove($customer_id)		{
		$query = $this->db->query("SELECT  current_stbno,status FROM " . DB_PREFIX . "customer_stb_cas WHERE customer_id = '" . (int)$customer_id . "'")  ;
		if($query->row['current_stbno']!=0 && $query->row['status']=='Activated')
			return 1;
		else
			return 0;

	}
		/*
FUNCTION NAME 		-	getCasFronCustomerId
DESCRIPTION 		-	Retrieves all the mapping between cas number, stb number and customer id.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved by the query.
*/		
		public function getCasFronCustomerId($customer_id) {
			$query = $this->db->query("SELECT  id FROM " . DB_PREFIX . "customer c ," . DB_PREFIX . "cas cs where c.customer_id='".$customer_id."' AND c.customer_id=cs.customer_id");
			$cas_id=$query->row['id'];
			$qry = $this->db->query("SELECT kms_cas_id FROM " . DB_PREFIX . "sms_kms_cas where sms_cas_id='".$cas_id."'");
			return $qry->row;
		}

		public function getSmartCard($cas_id) {
			$query = $this->db->query("SELECT smart_card_no FROM " . DB_PREFIX . "cas where cas_id='".$cas_id."'");
			return $query->row;
		}
		
		public function checkSmartCardExists($customer_id) {
			$query = $this->db->query("SELECT is_smart_card FROM " . DB_PREFIX . "stb  where customer_id ='".$customer_id."'");
			return $query->row['is_smart_card'];
		}

		public function checkStbCasPairing($customer_id) {
			$query = $this->db->query("SELECT STBNO FROM " . DB_PREFIX . "customer  where customer_id ='".$customer_id."'");
			return $query->row['STBNO']!=0;
		}
	
       public function updateCasStatus($customer_id,$status)
       {
       		$this->db->query("UPDATE " . DB_PREFIX . "customer_stb_cas SET `status`='".$status."' WHERE customer_id = '" . (int)$customer_id . "'");
       		
       }

       public function addToTransanction($customer_id,$cmd_id,$id,$ack_is='-1',$nack_is='-1')
		{
			$this->db->query("INSERT INTO " . DB_PREFIX . "cas_op_transactions SET tx_id='".$id."',cmd_id='".$cmd_id."',user_id='".$customer_id."',ack_ctr='".$ack_is."',nack_ctr='".$nack_is."',nack_type=-1,initiated_by='Customer'");
		}
	/*
FUNCTION NAME 		-	getDetail
DESCRIPTION 		-	Retrieves all the mapping between cas number, stb number and customer id.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved by the query.
*/		
		public function getCustomerInfo($customer_id) {
		$query = $this->db->query("SELECT  * FROM " . DB_PREFIX . "customer where customer_id='".$customer_id."'");
		return $query->row;
		}

		public function editCustomerInfo($customer_id, $data){
			
			$this->db->query("UPDATE " . DB_PREFIX . "customer_stb_cas SET `status`='Pending', current_stbno='".$data['stb']."' WHERE customer_id = '" . (int)$customer_id . "'");
		    $this->db->query("UPDATE " . DB_PREFIX . "stb SET is_avail= 0,customer_id='".$customer_id."' WHERE stb_no = '" . $data['stb'] . "'");
		    $this->db->query("UPDATE " . DB_PREFIX . "cas SET is_avail= 0,customer_id='".$customer_id."' WHERE cas_id = '" . $data['cas'] . "'");
		    //$this->db->query("UPDATE " . DB_PREFIX . "customer_stb_cas SET `status`='Unpaired' WHERE customer_id = '" . (int)$customer_id . "'");
		    $this->db->query("UPDATE " . DB_PREFIX . "customer SET STBNO='".$data['stb']."' WHERE customer_id = '" . (int)$customer_id . "'");	
		}

		public function CheckSTB($stb_id){
			$query = $this->db->query("SELECT  * FROM " . DB_PREFIX . "stb where stb_no='".$stb_id."'");
			return $query->row;
		}

		public function CheckCAS($cas_id){
			$query = $this->db->query("SELECT  * FROM " . DB_PREFIX . "cas where cas_id='".$cas_id."'");
			return $query->row;
		}
		public function getApiResponceId($customer_id)
	{
	 	// $this->db->query("INSERT INTO " . DB_PREFIX . "user_api_response SET user_id = '" . (int)$user_id . "', api_user_id = '" . (int)$apiuser_id . "'");
	 	$query = $this->db->query("SELECT api_user_id FROM `" . DB_PREFIX . "sms_kms_map` WHERE user_id = '" . (int)$customer_id . "'");
	
		return $query->row;
	}


	/*
FUNCTION NAME 		-	getCasID
DESCRIPTION 		-	Retrieves cas and stb number for the given customer_id
INPUT PARAMETER 	-	cas_no
OUTPUT PARAMETER 	- 	Returns a row conatining the customer stb and cas details.
*/	
		public function getCasID($cas_no) {

		$query = $this->db->query("SELECT id FROM ".DB_PREFIX."cas WHERE `cas_id`='".$cas_no."'");
		return $query->row['id'];
		}

		public function getSTB($customer_id) {
			$query = $this->db->query("SELECT  STBNO,customer_unique_id FROM " . DB_PREFIX . "customer where customer_id='".$customer_id."'");
			// var_dump($query->row['STBNO']);exit();
			return $query->row;
		}
}
?>