<?php
/*
@File cas.php(MODEL)
DESIGN:	 CAS PAGE
    This class retrieves the cas number detials along with their activation.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ModelInventryCAS extends Model {
/*
FUNCTION NAME 		-	getDetail
DESCRIPTION 		-	Retrieves all the mapping between cas number, stb number and customer id.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved by the query.
*/	
		public function getDetail($data) {
		//$this->db->query("select c.name c.stbno c.casno a.city from customer c  ");
		$sql ="SELECT  (c.customer_id),CONCAT(c.firstname, ' ', c.lastname) AS name,(s.cas_id),s.id,(s.is_avail),(s.smart_card_no) FROM " . DB_PREFIX . "customer c RIGHT JOIN " . DB_PREFIX . "cas s ON (c.customer_id = s.customer_id)";
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}				

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
		
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}	
		$query = $this->db->query($sql);
		return $query->rows;
		}
//-----------------------
/*
FUNCTION NAME 		-	getTotalCas
DESCRIPTION 		-	Retrieves number of  cas number.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved by the query.
*/	
		public function getTotalCas() {
		//$this->db->query("select c.name c.stbno c.casno a.city from customer c  ");
		$query = $this->db->query("SELECT  COUNT(*) AS total FROM " . DB_PREFIX . "cas ");
		return $query->row['total'];
		}

//-------------------------
/*
FUNCTION NAME 		-	getActiveCAS
DESCRIPTION 		-	Retrieves all the cas numbers details which are active on the store.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved by the query.
*/			
		public function getActiveCAS()
		{
		//$this->db->query("select c.name c.stbno c.casno a.city from customer c  ");
		$query = $this->db->query("SELECT  (c.customer_id),CONCAT(c.firstname, ' ', c.lastname) AS name,(s.cas_id),(s.is_avail),(s.is_smart_card) FROM " . DB_PREFIX . "customer c Right JOIN " . DB_PREFIX . "cas s ON (c.customer_id = s.customer_id) WHERE s.is_avail=1");
		return $query->rows;
		}

// ============================================

/*
FUNCTION NAME 		-	addCustomerBanIp
DESCRIPTION 		-	Adds new customer_ban_ip to the database.
INPUT PARAMETER 	-	data array containing the details of the customer_ban_ip.
OUTPUT PARAMETER 	- 	Inserts the customer_ban_ip details to the database and returns.
*/	
	public function addCAS($data) {
		if($this->db->escape($data['sc'])==1)
			$this->db->query("INSERT INTO `" . DB_PREFIX . "cas` SET `customer_id` = '0', `cas_id` = '" . $this->db->escape($data['cas']) . "', `is_avail`='1',`is_smart_card`='" . $this->db->escape($data['sc']) . "',`smart_card_no`='" . $this->db->escape($data['smart_card']) . "'");
		else
			$this->db->query("INSERT INTO `" . DB_PREFIX . "cas` SET `customer_id` = '0', `cas_id` = '" . $this->db->escape($data['cas']) . "', `is_avail`='1',`is_smart_card`='" . $this->db->escape($data['sc']) . "',`smart_card_no`=-1");	
	}		

/*
FUNCTION NAME 		-	editCustomerBanIp
DESCRIPTION 		-	Updates the customer ban ip for the given customer ban ip id
INPUT PARAMETER 	-	customer_ban_ip_id
OUTPUT PARAMETER 	- 	Retuns after updaing the ban ip
*/	
	public function editCAS($cas_id, $data) {
		$this->db->query("UPDATE `" . DB_PREFIX . "cas` SET `is_smart_card` = '" . $this->db->escape($data['sc']) . "' WHERE cas_id = '" . (int)$cas_id . "'");
	}
/*
FUNCTION NAME 		-	deleteCustomerBanIp
DESCRIPTION 		-	Deletes the customer ban ip for the given customer ban ip id
INPUT PARAMETER 	-	customer_ban_ip_id
OUTPUT PARAMETER 	- 	Returns after deleting the ban ip
*/		
	public function deleteCAS($cas_id) {
		$id= $this->getCAS($cas_id);
		$this->db->query("DELETE FROM `" . DB_PREFIX . "cas` WHERE cas_id like '" . $cas_id . "'");
		$this->db->query("DELETE FROM `" . DB_PREFIX . "sms_kms_cas` WHERE sms_cas_id = '" . (int)$id['id'] . "'");
	}

/*
FUNCTION NAME 		-	getDetail
DESCRIPTION 		-	Retrieves all the mapping between cas number, stb number and customer id.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved by the query.
*/		
		public function getCAS($cas_id) {
		$query = $this->db->query("SELECT  * FROM " . DB_PREFIX . "cas where cas_id like '".$cas_id."'");
		return $query->row;
		}

	public function getStbidByStbno($CASNO) {
		$query = $this->db->query("SELECT id FROM `" . DB_PREFIX . "cas` WHERE cas_no = '" .$CASNO . "'");
	
		return $query->row;
		}
	public function addApiResponceId($kms_stb_no,$sms_stb_no)
	{
	 	$this->db->query("INSERT INTO " . DB_PREFIX . "sms_kms_cas SET sms_cas_id = '" . (int)$sms_stb_no . "', kms_cas_id = '" . (int)$kms_stb_no . "'");

	}
	 
	 public function getCASNOById($cas_id){
	 	$query = $this->db->query("SELECT cas_id FROM `" . DB_PREFIX . "cas` WHERE id = '" . (int)$cas_id. "'");
	
	 	return $query->row;

	 }

	public function getApiResponceId($sms_cas_no)
	{
	 	// $this->db->query("INSERT INTO " . DB_PREFIX . "user_api_response SET user_id = '" . (int)$user_id . "', api_user_id = '" . (int)$apiuser_id . "'");
	 	$query = $this->db->query("SELECT kms_cas_id FROM `" . DB_PREFIX . "sms_kms_cas` WHERE sms_cas_id = '" . (int)$sms_cas_no . "'");
	
		return $query->row;
	}




}
?>