<?php
/*
@File banner.php(MODEL)
DESIGN:	 BANNER PAGE
    This class retrieves the banner detials based on the given banner id. 

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ModelDesignBanner extends Model {
/*
FUNCTION NAME 		-	addBanner
DESCRIPTION 		-	Adds new banner detail to the database.
INPUT PARAMETER 	-	new banner details as an array 
OUTPUT PARAMETER 	- 	Adds to the database and returns to the banner list page with a success notification
*/	
	public function addBanner($data) {
		$this->db->query("INSERT INTO " . DB_PREFIX . "banner SET name = '" . $this->db->escape($data['name']) . "', status = '" . (int)$data['status'] . "'");
	
		$banner_id = $this->db->getLastId();
	
		if (isset($data['banner_image'])) {
			foreach ($data['banner_image'] as $banner_image) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "banner_image SET banner_id = '" . (int)$banner_id . "', link = '" .  $this->db->escape($banner_image['link']) . "', image = '" .  $this->db->escape($banner_image['image']) . "'");
				
				$banner_image_id = $this->db->getLastId();
				
				foreach ($banner_image['banner_image_description'] as $language_id => $banner_image_description) {				
					$this->db->query("INSERT INTO " . DB_PREFIX . "banner_image_description SET banner_image_id = '" . (int)$banner_image_id . "', language_id = '" . (int)$language_id . "', banner_id = '" . (int)$banner_id . "', title = '" .  $this->db->escape($banner_image_description['title']) . "'");
				}
			}
		}		
	}
/*
FUNCTION NAME 		-	editBanner
DESCRIPTION 		-	Updates banner details for the selected banner_id.
INPUT PARAMETER 	-	banner_id, new banner details as an array
OUTPUT PARAMETER 	- 	Adds detail to the database and returns to the banner list page with a success notification
*/	
	public function editBanner($banner_id, $data) {
		$this->db->query("UPDATE " . DB_PREFIX . "banner SET name = '" . $this->db->escape($data['name']) . "', status = '" . (int)$data['status'] . "' WHERE banner_id = '" . (int)$banner_id . "'");

		$this->db->query("DELETE FROM " . DB_PREFIX . "banner_image WHERE banner_id = '" . (int)$banner_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "banner_image_description WHERE banner_id = '" . (int)$banner_id . "'");
			
		if (isset($data['banner_image'])) {
			foreach ($data['banner_image'] as $banner_image) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "banner_image SET banner_id = '" . (int)$banner_id . "', link = '" .  $this->db->escape($banner_image['link']) . "', image = '" .  $this->db->escape($banner_image['image']) . "'");
				
				$banner_image_id = $this->db->getLastId();
				
				foreach ($banner_image['banner_image_description'] as $language_id => $banner_image_description) {				
					$this->db->query("INSERT INTO " . DB_PREFIX . "banner_image_description SET banner_image_id = '" . (int)$banner_image_id . "', language_id = '" . (int)$language_id . "', banner_id = '" . (int)$banner_id . "', title = '" .  $this->db->escape($banner_image_description['title']) . "'");
				}
			}
		}			
	}
/*
FUNCTION NAME 		-	deleteBanner
DESCRIPTION 		-	Deletes banner detail from the database for the selected banner_id.
INPUT PARAMETER 	-	banner_id
OUTPUT PARAMETER 	- 	Deletes detail from the database and returns to the banner list page with a success notification
*/		
	public function deleteBanner($banner_id) {
		$this->db->query("DELETE FROM " . DB_PREFIX . "banner WHERE banner_id = '" . (int)$banner_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "banner_image WHERE banner_id = '" . (int)$banner_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "banner_image_description WHERE banner_id = '" . (int)$banner_id . "'");
	}
/*
FUNCTION NAME 		-	getBanner
DESCRIPTION 		-	Retrieves banner details from the database based on the given banner_id.
INPUT PARAMETER 	-	banner_id
OUTPUT PARAMETER 	- 	Retruns a row queried containing details of the banner.
*/		
	public function getBanner($banner_id) {
		$query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "banner WHERE banner_id = '" . (int)$banner_id . "'");
		
		return $query->row;
	}
/*
FUNCTION NAME 		-	getBanners
DESCRIPTION 		-	Retrieves all the banners from the database. 
INPUT PARAMETER 	-	data array for filter options if any.
OUTPUT PARAMETER 	- 	Returns all the rows queried, containing banner details.
*/	
	public function getBanners($data = array()) {
		$sql = "SELECT * FROM " . DB_PREFIX . "banner";
		
		$sort_data = array(
			'name',
			'status'
		);	
		
		if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
			$sql .= " ORDER BY " . $data['sort'];	
		} else {
			$sql .= " ORDER BY name";	
		}
		
		if (isset($data['order']) && ($data['order'] == 'DESC')) {
			$sql .= " DESC";
		} else {
			$sql .= " ASC";
		}
		
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}					

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
		
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}		
		
		$query = $this->db->query($sql);

		return $query->rows;
	}
/*
FUNCTION NAME 		-	getBannerImages
DESCRIPTION 		-	Retrieves the image added for the given banner_id
INPUT PARAMETER 	-	banner_id
OUTPUT PARAMETER 	- 	Retruns all the rows matched with the banner_id with image description
*/		
	public function getBannerImages($banner_id) {
		$banner_image_data = array();
		
		$banner_image_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "banner_image WHERE banner_id = '" . (int)$banner_id . "'");
		
		foreach ($banner_image_query->rows as $banner_image) {
			$banner_image_description_data = array();
			 
			$banner_image_description_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "banner_image_description WHERE banner_image_id = '" . (int)$banner_image['banner_image_id'] . "' AND banner_id = '" . (int)$banner_id . "'");
			
			foreach ($banner_image_description_query->rows as $banner_image_description) {			
				$banner_image_description_data[$banner_image_description['language_id']] = array('title' => $banner_image_description['title']);
			}
		
			$banner_image_data[] = array(
				'banner_image_description' => $banner_image_description_data,
				'link'                     => $banner_image['link'],
				'image'                    => $banner_image['image']	
			);
		}
		
		return $banner_image_data;
	}
/*
FUNCTION NAME 		-	getTotalBanners
DESCRIPTION 		-	Retrieves the count for the total number of banners.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns a column "total" containing the count for banners.
*/			
	public function getTotalBanners() {
      	$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "banner");
		
		return $query->row['total'];
	}
/*
FUNCTION NAME 		-	getTotalBanners
DESCRIPTION 		-	Retrieves the count for the total number of banners.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns a column "total" containing the count for banners.
*/			
	public function checkDuplicateBanner($name,$banner_id) {
      	$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "banner WHERE name = '".$name."' AND banner_id <> '".$banner_id."'");
		
		return $query->row['total'];
	}
		
}
?>