<?php
/*
@File box_reset.php(MODEL)
DESIGN:	 BoxReset PAGE
    This class retrieves the BoxReset status detials.

@Author Ravi Ranjan 
@date 19 Jan. 2016
*/
class ModelCommandsSpecialCommands extends Model {

/*
FUNCTION NAME 		-	getBoxReset
DESCRIPTION 		-	Retrieves all transation details.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved by the query.
*/		
		public function getBoxReset($data) {
		switch ($data['target_level']) {
				case 1:
					$sql="SELECT id,tx_id,cmd_id,user_id,ack_ctr,nack_ctr,payload,product_id,modify_date,exp_date,c.STBNO,cmd_type FROM ".DB_PREFIX."cas_op_transactions cas left join ".DB_PREFIX."customer c ON(cas.user_id=c.customer_id) WHERE cmd_id=16";
					if(isset($data['filter_value']))
					{
						$sql .=" AND c.STBNO = '".$this->db->escape($data['filter_value'])."'";			
					}
					if($this->session->data['user_group_id']!=1)
			      	{
			      		$sql.=" AND c.operator_id ='" . $this->session->data['user_id'] . "'";
			      	}
				break;
				case 2:
					$sql="SELECT id,tx_id,cmd_id,user_id,ack_ctr,nack_ctr,payload,product_id,modify_date,exp_date,cmd_type FROM ".DB_PREFIX."cas_op_transactions WHERE cmd_id=16 AND target_level=2";
					if($this->session->data['user_group_id']!=1)
			      	{
			      		$sql.=" AND operator_id ='" . $this->session->data['user_id'] . "'";
			      	}
				break;
				case 3:
					$sql="SELECT * FROM ".DB_PREFIX."cas_op_transactions left join ".DB_PREFIX."region on (user_id=pin) WHERE target_level=3 AND cmd_id=16 AND pin ='".$this->db->escape($data["filter_value"])."'";								
					if($this->session->data['user_group_id']!=1)
			      	{
			      		$sql.=" AND operator_id ='" . $this->session->data['user_id'] . "'";
			      	}
				break;
				case 4:
					
					$sql="SELECT * FROM ".DB_PREFIX."customer_group_description left join ".DB_PREFIX."cas_op_transactions on (user_id=customer_group_id) WHERE target_level=4 AND cmd_id=16 AND name='".$this->db->escape($data["filter_value"])."'";				
					if($this->session->data['user_group_id']!=1)
			      	{
			      		$sql.=" AND operator_id ='" . $this->session->data['user_id'] . "'";
			      	}
				break;
				default:
					$sql="SELECT id,tx_id,cmd_id,user_id,ack_ctr,nack_ctr,payload,product_id,modify_date,exp_date,c.STBNO,cmd_type FROM ".DB_PREFIX."cas_op_transactions cas left join ".DB_PREFIX."customer c ON(cas.user_id=c.customer_id) WHERE cmd_id=16 AND c.customer_id=1";
					if($this->session->data['user_group_id']!=1)
			      	{
			      		$sql.=" AND c.operator_id ='" . $this->session->data['user_id'] . "'";
			      	}
				break;
			}
			
			if (isset($data['start']) || isset($data['limit'])) {
				if ($data['start'] < 0) {
					$data['start'] = 0;
				}				
				if ($data['limit'] < 1) {
					$data['limit'] = 20;
				}	
				$sql .= " ORDER BY id DESC LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
			}	
			$query = $this->db->query($sql);

			return $query->rows;	
		}
		/*
		FUNCTION NAME 		-	getTotalStbActivations
		DESCRIPTION 		-	Retrieves number of  stb number assign to customer and balance.
		INPUT PARAMETER 	-	void
		OUTPUT PARAMETER 	- 	Returns all the rows retrieved by the query.
		*/		
		public function getTotalboxReset($data) {
			$sql="SELECT count(*) as total FROM ".DB_PREFIX."cas_op_transactions cas,".DB_PREFIX."customer c WHERE user_id=customer_id AND cmd_id=16";
			if(isset($data['filter_value']))
			{
				$sql .= " AND c.STBNO = '".$this->db->escape($data['filter_value'])."'";
			}
			if($this->session->data['user_group_id']!=1)
	      	{
	      		$sql.=" AND c.operator_id ='" . $this->session->data['user_id'] . "'";
	      	}
		   	$query = $this->db->query($sql);
			return $query->row['total'];
		}

/*
FUNCTION NAME 		-	getSTBs
DESCRIPTION 		-	Retrieves all the mapping between cas number, stb number and customer id.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved by the query.
*/		
	public function getSTBs($data=array()) {
		$sql="SELECT id,stb_no FROM " . DB_PREFIX . "stb WHERE customer_id!=0";
		if(!empty($data['filter_no'])){
			$sql.=" AND stb_no LIKE '" . $this->db->escape($data['filter_no']) . "%'";
		}
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}			

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
			
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}	
		$query = $this->db->query($sql);
		return $query->rows;
	}
/*
FUNCTION NAME 		-	addToCasOpTransanction
DESCRIPTION 		-	Queries to add the response data of api in the database.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	void.
*/
	public function addToCasOpTransanction($target_level,$target1,$id,$payload,$ack_is,$nack_is,$operator_id,$cmd_type)
	{
		$this->db->query("INSERT INTO " . DB_PREFIX . "cas_op_transactions SET tx_id='".$id."',cmd_id=16,order_id=0,product_id=0,user_id='".$target1."',ack_ctr='".$ack_is."',nack_ctr='".$nack_is."',nack_type=-1,exp_date=now(),initiated_by='Admin',payload='".$payload."',target_level='".$target_level."' ,cmd_type='".$cmd_type."', operator_id='".$operator_id."'");
	}


/*
FUNCTION NAME 		-	getTransactionDetails
DESCRIPTION 		-	Retrieves transaction details.
INPUT PARAMETER 	-	$id
OUTPUT PARAMETER 	- 	Returns transaction id,cmd id,user id of transaction query.
*/	
	public function getTransactionDetails($id)	{
		$query = $this->db->query("SELECT * FROM ".DB_PREFIX."cas_op_transactions c left join ".DB_PREFIX."sms_kms_map k on  c.user_id=k.user_id WHERE c.id='".$id."'");
		return $query->row;
	}

	public function getTransactionDetailsGroup($id)	{
		$query = $this->db->query("SELECT * FROM ".DB_PREFIX."cas_op_transactions c left join ".DB_PREFIX."sms_kms_group k on c.user_id=k.sms_group_id WHERE c.id='".$id."'");
		return $query->row;
	}

	public function getTransactionDetailsRegion($id)	{
		$query = $this->db->query("SELECT * FROM ".DB_PREFIX."cas_op_transactions c WHERE c.id='".$id."' AND cmd_id=16");
		return $query->row;
	}

/*
FUNCTION NAME 		-	getApiResponceId
DESCRIPTION 		-	Retrieves Kms id.
INPUT PARAMETER 	-	$id
OUTPUT PARAMETER 	- 	Returns kms_stb_id.
*/

	public function getApiResponceId($sms_stb_no)
	{
	 	$query = $this->db->query("SELECT kms_stb_id FROM `" . DB_PREFIX . "sms_kms_stb` WHERE sms_stb_id = '" . (int)$sms_stb_no . "'");
		return $query->row;
	}	

/*
FUNCTION NAME 		-	isSTBPaired
DESCRIPTION 		-	.
INPUT PARAMETER 	-	stb_no
OUTPUT PARAMETER 	- 	Returns rows.
*/

	public function isSTBPaired($stb_no)
	{
	 	
	 	$query = $this->db->query("SELECT `customer_id` FROM ".DB_PREFIX."stb WHERE `stb_no`='".$stb_no."'");
		return $query->row;
	}	

/*
FUNCTION NAME 		-	getCustomerId
DESCRIPTION 		-	.
INPUT PARAMETER 	-	stb_no
OUTPUT PARAMETER 	- 	Returns Customer Id.
*/

	public function getCustomerId($stb_no)
	{	
	 	$query = $this->db->query("SELECT c.customer_id,sk.api_user_id,c.operator_id FROM ".DB_PREFIX."customer c left join ".DB_PREFIX."sms_kms_map sk ON(c.customer_id=sk.user_id)  WHERE c.STBNO='".$stb_no."'");
		return $query->row;
		
	}

	public function getSTBno($customer_id){
	 	$query = $this->db->query("SELECT STBNO FROM ".DB_PREFIX."customer WHERE customer_id='".$customer_id."'");
		return $query->row;
	}


	public function isStbExistedAndPaired($stb_no){
		$query= $this->db->query("SELECT `customer_id` FROM `".DB_PREFIX."stb` WHERE `stb_no`='".$stb_no."'");
		return $query->row;
	}
	public function checkPinExist($pin){
		$query= $this->db->query("SELECT count(*) as total FROM `".DB_PREFIX."region` WHERE `pin`='".$pin."'");
		return $query->row['total']>0;
	}

	public function checkGroupExists($gname){
		$query= $this->db->query("SELECT count(*) as total FROM `".DB_PREFIX."customer_group_description` WHERE `name`='".$gname."'");
		return $query->row['total']>0;
	}

	public function getKMSUserId($customer_id){
		 	$query = $this->db->query("SELECT api_user_id FROM ".DB_PREFIX."sms_kms_map WHERE user_id='".$customer_id."'");
			return $query->row['api_user_id'];
		}
	
	public function getKMSGroupId($group_id){
		 	$query = $this->db->query("SELECT kms_group_id FROM ".DB_PREFIX."sms_kms_group WHERE sms_group_id='".$group_id."'");
			return $query->row['kms_group_id'];
		}		

	public function getGroupNameById($group_id){
		 	$query = $this->db->query("SELECT name FROM ".DB_PREFIX."customer_group_description WHERE customer_group_id='".$group_id."'");
			return $query->row['name'];
		}
	public function isSTBBlackListed($stbno){
		$query = $this->db->query("SELECT * FROM ".DB_PREFIX."stb WHERE is_black_list=1 AND stb_no='".$stbno."'");
		return $query->num_rows;
	}
	public function isSTBActivated($stb_no)
	{
	 	$query = $this->db->query("SELECT is_active FROM ".DB_PREFIX."stb WHERE `stb_no`='".$stb_no."'");
		return $query->row['is_active'];
	}
	
	public function getStbNoFromId($id){
	 	$query = $this->db->query("SELECT `user_id` FROM ".DB_PREFIX."cas_op_transactions WHERE `id`='".$id."'");
	 	$query1 = $this->db->query("SELECT `stb_no` FROM ".DB_PREFIX."stb WHERE `customer_id`='".$query->row['user_id']."'");
	 	if($query1->num_rows==1){
			return $query1->row['stb_no'];
	 	} else {
			return '0';
		}
	}
	
	public function isBlacklist($stb_no){	 	
	 	$query = $this->db->query("SELECT `is_black_list` FROM ".DB_PREFIX."stb WHERE `stb_no`='".$stb_no."'");
	 	if($query->row!=NULL){
			return $query->row['is_black_list'];
	 	}else{
	 		return 0;
		}		
	}
	
}
?>
