<?php
/*
@File emm_fingerprint.php(MODEL)
DESIGN:	 EmmFingerprint PAGE
    This class retrieves the EmmFingerprint status detials.

@Author Ravi Ranjan 
@date 19 Jan. 2016
*/
class ModelCommandsServiceTunning extends Model {

		/*
		FUNCTION NAME 		-	getActivationTransactions
		DESCRIPTION 		-	Retrieves all transation details.
		INPUT PARAMETER 	-	void
		OUTPUT PARAMETER 	- 	Returns all the rows retrieved by the query.
		*/		
		public function getServiceTunning($data) {
					//---
			switch ($data['target_level']) {
				case 1:
					$sql="SELECT id,tx_id,cmd_id,user_id,ack_ctr,nack_ctr,payload,pd.name,modify_date,exp_date,c.STBNO ,target_level FROM ".DB_PREFIX."cas_op_transactions cas left join ".DB_PREFIX."customer c ON(cas.user_id=c.customer_id)  left join ".DB_PREFIX."product_description pd ON(pd.product_id=cas.product_id) WHERE cmd_id=15";
					if(isset($data['filter_value']))
					{
						$sql .=" AND c.STBNO = '".$this->db->escape($data['filter_value'])."'";			
					}
					if($this->session->data['user_group_id']!=1)
			      	{
			      		$sql.=" AND c.operator_id ='" . $this->session->data['user_id'] . "'";
			      	}
				break;
				case 2:
					$sql="SELECT id,tx_id,cmd_id,user_id,ack_ctr,nack_ctr,payload,modify_date,exp_date,target_level,pd.name FROM ".DB_PREFIX."cas_op_transactions cas left join ".DB_PREFIX."product_description pd ON(pd.product_id=cas.product_id) WHERE cmd_id=15 AND target_level=2";
					if($this->session->data['user_group_id']!=1)
			      	{
			      		$sql.=" AND operator_id ='" . $this->session->data['user_id'] . "'";
			      	}
				break;
				case 3:
					$sql="SELECT * FROM ".DB_PREFIX."cas_op_transactions cas left join ".DB_PREFIX."region on (user_id=pin) left join ".DB_PREFIX."product_description pd ON(pd.product_id=cas.product_id) WHERE target_level=3 AND cmd_id=15 AND pin ='".$this->db->escape($data["filter_value"])."'";								
					if($this->session->data['user_group_id']!=1)
			      	{
			      		$sql.=" AND operator_id ='" . $this->session->data['user_id'] . "'";
			      	}
				break;
				case 4:
					$sql="SELECT *,cd.name AS gname FROM ".DB_PREFIX."cas_op_transactions cas left join ".DB_PREFIX."customer_group_description cd on (user_id=customer_group_id) left join ".DB_PREFIX."product_description pd ON(pd.product_id=cas.product_id) WHERE target_level=4 AND cmd_id=15 AND cd.name='".$this->db->escape($data["filter_value"])."'";				
					if($this->session->data['user_group_id']!=1)
			      	{
			      		$sql.=" AND operator_id ='" . $this->session->data['user_id'] . "'";
			      	}
				break;
				default:
					$sql="SELECT id,tx_id,cmd_id,pd.name,user_id,ack_ctr,nack_ctr,payload,modify_date,exp_date,c.STBNO FROM ".DB_PREFIX."cas_op_transactions cas left join ".DB_PREFIX."customer c ON(cas.user_id=c.customer_id) left join ".DB_PREFIX."product_description pd ON(pd.product_id=cas.product_id) WHERE cmd_id=15 AND c.customer_id=1";
					if($this->session->data['user_group_id']!=1)
			      	{
			      		$sql.=" AND c.operator_id ='" . $this->session->data['user_id'] . "'";
			      	}
				break;
			}
			
			if (isset($data['start']) || isset($data['limit'])) {
				if ($data['start'] < 0) {
					$data['start'] = 0;
				}				
				if ($data['limit'] < 1) {
					$data['limit'] = 20;
				}	
				$sql .= " ORDER BY id DESC LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
			}	
			$query = $this->db->query($sql);
			//var_dump($query);exit();
			return $query->rows;
			}
				/*
				FUNCTION NAME 		-	getTotalStbActivations
				DESCRIPTION 		-	Retrieves number of  stb number assign to customer and balance.
				INPUT PARAMETER 	-	void
				OUTPUT PARAMETER 	- 	Returns all the rows retrieved by the query.
				*/		
				public function getTotalServiceTunning($data) {
					switch ($data['target_level']) {
				case 1:
					$sql="SELECT count(*) AS 'total' FROM ".DB_PREFIX."cas_op_transactions cas left join ".DB_PREFIX."customer c ON(cas.user_id=c.customer_id)  left join ".DB_PREFIX."product_description pd ON(pd.product_id=cas.product_id) WHERE cmd_id=15";
					if(isset($data['filter_value']))
					{
						$sql .=" AND c.STBNO = '".$this->db->escape($data['filter_value'])."'";			
					}
					if($this->session->data['user_group_id']!=1)
			      	{
			      		$sql.=" AND c.operator_id ='" . $this->session->data['user_id'] . "'";
			      	}
				break;
				case 2:
					$sql="SELECT count(*) AS 'total' FROM ".DB_PREFIX."cas_op_transactions cas left join ".DB_PREFIX."product_description pd ON(pd.product_id=cas.product_id) WHERE cmd_id=15 AND target_level=2";
					if($this->session->data['user_group_id']!=1)
			      	{
			      		$sql.=" AND operator_id ='" . $this->session->data['user_id'] . "'";
			      	}
				break;
				case 3:
					$sql="SELECT count(*) AS 'total' FROM ".DB_PREFIX."cas_op_transactions cas left join ".DB_PREFIX."region on (user_id=pin) left join ".DB_PREFIX."product_description pd ON(pd.product_id=cas.product_id) WHERE target_level=3 AND cmd_id=15 AND pin ='".$this->db->escape($data["filter_value"])."'";								
					if($this->session->data['user_group_id']!=1)
			      	{
			      		$sql.=" AND operator_id ='" . $this->session->data['user_id'] . "'";
			      	}
				break;
				case 4:
					$sql="SELECT count(*) AS 'total' FROM ".DB_PREFIX."cas_op_transactions cas left join ".DB_PREFIX."customer_group_description cd on (user_id=customer_group_id) left join ".DB_PREFIX."product_description pd ON(pd.product_id=cas.product_id) WHERE target_level=4 AND cmd_id=15 AND cd.name='".$this->db->escape($data["filter_value"])."'";				
					if($this->session->data['user_group_id']!=1)
			      	{
			      		$sql.=" AND operator_id ='" . $this->session->data['user_id'] . "'";
			      	}
				break;
				default:
					$sql="SELECT count(*) AS 'total' FROM ".DB_PREFIX."cas_op_transactions cas left join ".DB_PREFIX."customer c ON(cas.user_id=c.customer_id) left join ".DB_PREFIX."product_description pd ON(pd.product_id=cas.product_id) WHERE cmd_id=15 AND c.customer_id=1";
					if($this->session->data['user_group_id']!=1)
			      	{
			      		$sql.=" AND c.operator_id ='" . $this->session->data['user_id'] . "'";
			      	}
				break;
			}
			
			if (isset($data['start']) || isset($data['limit'])) {
				if ($data['start'] < 0) {
					$data['start'] = 0;
				}				
				if ($data['limit'] < 1) {
					$data['limit'] = 20;
				}	
				$sql .= " ORDER BY id DESC LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
			}	
					$query = $this->db->query($sql);
					return $query->row['total'];
			
			}

			/*
			FUNCTION NAME 		-	getSTBs
			DESCRIPTION 		-	Retrieves all the mapping between cas number, stb number and customer id.
			INPUT PARAMETER 	-	void
			OUTPUT PARAMETER 	- 	Returns all the rows retrieved by the query.
			*/		
			public function getSTBs($data=array()) {
				$sql="SELECT id,stb_no FROM " . DB_PREFIX . "stb WHERE customer_id!=0";
				if(!empty($data['filter_no'])){
					$sql.=" AND stb_no LIKE '" . $this->db->escape($data['filter_no']) . "%'";
				}
				if (isset($data['start']) || isset($data['limit'])) {
					if ($data['start'] < 0) {
						$data['start'] = 0;
					}			

					if ($data['limit'] < 1) {
						$data['limit'] = 20;
					}	
					
					$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
				}	
				$query = $this->db->query($sql);
				return $query->rows;
			}
		/*
		FUNCTION NAME 		-	addToCasOpTransanction
		DESCRIPTION 		-	Queries to add the response data of api in the database.
		INPUT PARAMETER 	-	void
		OUTPUT PARAMETER 	- 	void.
		*/
		public function addToCasOpTransanction($target_level,$target1,$id,$product_id,$payload,$ack_is,$nack_is,$operator_id,$lcn)
		{
			
				$sql="SELECT * FROM `oc_cas_op_transactions` WHERE `payload` ='".$lcn."' AND cmd_id=15 AND target_level='".$target_level."'";
				$query = $this->db->query($sql);
				if (!empty($query->rows)) {
					$this->db->query("UPDATE " . DB_PREFIX . "cas_op_transactions SET tx_id='".$id."',cmd_id=15,target_level='".$target_level."',user_id='".$target1."',product_id='".$product_id."',ack_ctr='".$ack_is."',nack_ctr='".$nack_is."',nack_type=-1,initiated_by='Admin',payload='".$payload."',operator_id='".$operator_id."' WHERE payload='".$lcn."' AND cmd_id=15 AND target_level='".$query->rows['target_level']."'");
				}
				else {
		
					$this->db->query("INSERT INTO " . DB_PREFIX . "cas_op_transactions SET tx_id='".$id."',cmd_id=15,order_id=0,product_id='".$product_id."',user_id='".$target1."',ack_ctr='".$ack_is."',nack_ctr='".$nack_is."',nack_type=-1,exp_date=now(),initiated_by='Admin',payload='".$lcn."',target_level='".$target_level."',operator_id='".$operator_id."'");

				}
		}



		/*
		FUNCTION NAME 		-	getApiResponceId
		DESCRIPTION 		-	Retrieves Kms id.
		INPUT PARAMETER 	-	$id
		OUTPUT PARAMETER 	- 	Returns kms_stb_id.
		*/

			public function getApiResponceId($sms_stb_no)
			{
			 	$query = $this->db->query("SELECT kms_stb_id FROM `" . DB_PREFIX . "sms_kms_stb` WHERE sms_stb_id = '" . (int)$sms_stb_no . "'");
				return $query->row;
			}	

	

		/*
		FUNCTION NAME 		-	getCustomerId
		DESCRIPTION 		-	.
		INPUT PARAMETER 	-	stb_no
		OUTPUT PARAMETER 	- 	Returns Customer Id.
		*/

		public function getCustomerId($stb_no)
		{
		 	$query = $this->db->query("SELECT customer_id,api_user_id,c.operator_id FROM ".DB_PREFIX."customer c left join ".DB_PREFIX."sms_kms_map sk ON(c.customer_id=sk.user_id)  WHERE `STBNO`='".$stb_no."'");
			return $query->row;
		}



		/*
		FUNCTION NAME 		-	getApiResponceId
		DESCRIPTION 		-	Retrieves Kms id.
		INPUT PARAMETER 	-	$id
		OUTPUT PARAMETER 	- 	Returns kms_stb_id.
		*/

	public function getProductid($lcn)
	{
	 	$query = $this->db->query("SELECT product_id FROM `" . DB_PREFIX . "product` WHERE lcn = '" . (int)$lcn . "'");
		return $query->row;
	}

	public function getChanelList(){
	 	$query = $this->db->query("SELECT `lcn`,`name` FROM ".DB_PREFIX."product p left join ".DB_PREFIX."product_description pd on(p.product_id=pd.product_id) WHERE `is_package`!=1 AND `is_ppv`!=1");
		return $query->rows;
	}	
	public function getGroupIdByname($groupName){
		$query= $this->db->query("SELECT k.kms_group_id, k.sms_group_id FROM ".DB_PREFIX."customer_group_description g,".DB_PREFIX."sms_kms_group k WHERE g.name='".$groupName."' AND g.customer_group_id=k.sms_group_id");
		return $query->row;
	}

	public function isSTBBlackListed($stbno){
		$query = $this->db->query("SELECT * FROM ".DB_PREFIX."stb WHERE is_black_list=1 AND stb_no='".$stbno."'");
		return $query->num_rows;
	}
		
}
?>
