<?php
	/*
	@File ppv_subscription.php(MODEL)
	DESIGN:	 PpvSubscription PAGE
	    This class retrieves the PpvSubscription staus detials.

	@Author Ravi Ranjan 
	@date 19 Jan. 2016
	*/
class ModelCommandsPpvSubscription extends Model {

		/*
		FUNCTION NAME 		-	getSubscribePPV
		DESCRIPTION 		-	Retrieves all ppv subscription  details.
		INPUT PARAMETER 	-	void
		OUTPUT PARAMETER 	- 	Returns all the rows retrieved by the query.
		*/		
		public function getSubscribePPV($data) {
			$sql="SELECT id,tx_id,cmd_id,user_id,ack_ctr,nack_ctr,payload,product_id,modify_date,exp_date,cas.STBNO FROM ".DB_PREFIX."cas_op_transactions cas left join ".DB_PREFIX."customer c ON(cas.user_id=c.customer_id) where ";
			if($this->session->data['user_group_id']!=1)
	      	{
	      		$sql.=" c.operator_id ='" . $this->session->data['user_id'] . "' AND";
	      	}
			if(!empty($data['filter_value']))
			{
			$sql .= "  cas.STBNO LIKE '%".$this->db->escape($data['filter_value'])."%' AND";
			}

			if (isset($data['start']) || isset($data['limit'])) {
				if ($data['start'] < 0) {
					$data['start'] = 0;
				}				
				if ($data['limit'] < 1) {
					$data['limit'] = 20;
				}	
				$sql .= " (cmd_id=18 or cmd_id=19) ORDER BY id DESC LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
			}	
			$query = $this->db->query($sql);
			return $query->rows;
		}
		/*
		FUNCTION NAME 		-	getTotalppvSubscription
		DESCRIPTION 		-	Retrieves total number of ppv subscription.
		INPUT PARAMETER 	-	void
		OUTPUT PARAMETER 	- 	Returns all the rows retrieved by the query.
		*/		
		public function getTotalppvSubscription($data) {
			$sql="SELECT  count(*) AS total FROM " . DB_PREFIX . "cas_op_transactions cas left join ".DB_PREFIX."customer c ON(cas.user_id=c.customer_id) WHERE (cmd_id=18 or cmd_id=19)";
			if($this->session->data['user_group_id']!=1)
	      	{
	      		$sql.=" AND c.operator_id ='" . $this->session->data['user_id'] . "'";
	      	}
			if(!empty($data['filter_value']))
			{
				$sql .= " AND cas.STBNO like '%".$this->db->escape($data['filter_value'])."%'";
			}
		   	$query = $this->db->query($sql);
			return $query->row['total'];
		}

		/*
		FUNCTION NAME 		-	getProductsName
		DESCRIPTION 		-	Retrieves number of  stb number assign to customer and balance.
		INPUT PARAMETER 	-	void
		OUTPUT PARAMETER 	- 	Returns all the rows retrieved by the query.
		*/		
		public function getPpvName($id) {
			$query = $this->db->query("SELECT name FROM " . DB_PREFIX . "product_description WHERE product_id='".$id."'");
			return $query->row;
		}

		/*
		FUNCTION NAME 		-	getSTBs
		DESCRIPTION 		-	Retrieves all the mapping between cas number, stb number and customer id.
		INPUT PARAMETER 	-	void
		OUTPUT PARAMETER 	- 	Returns all the rows retrieved by the query.
		*/		
		public function getSTBs($data=array()) {
			$sql="SELECT id,stb_no FROM " . DB_PREFIX . "stb WHERE customer_id!=0";
			if(!empty($data['filter_no'])){
				$sql.=" AND stb_no LIKE '" . $this->db->escape($data['filter_no']) . "%'";
				}
			if (isset($data['start']) || isset($data['limit'])) {
				if ($data['start'] < 0) {
					$data['start'] = 0;
				}			

				if ($data['limit'] < 1) {
					$data['limit'] = 20;
				}	
				
				$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
			}	
			$query = $this->db->query($sql);
			return $query->rows;
		}
		/*
		FUNCTION NAME 		-	addToCasOpTransanction
		DESCRIPTION 		-	Queries to add the response data of api in the database.
		INPUT PARAMETER 	-	void
		OUTPUT PARAMETER 	- 	void.
		*/										//$customer_id,$cmd_id,$id,$ack_is,$nack_is,$payload,$product_id
		public function addToCasOpTransanction($target,$user_id,$cmd_id,$tx_id,$ack_is='-1',$nack_is='-1',$payload,$product_id,$end_time,$oredr_id=0,$operator_id,$stbno)
		{
			$this->db->query("INSERT INTO " . DB_PREFIX . "cas_op_transactions SET tx_id='".$tx_id."',cmd_id='".$cmd_id."',user_id='".$user_id."', stbno ='".$stbno."',ack_ctr='".$ack_is."',nack_ctr='".$nack_is."',nack_type=-1,initiated_by='Admin',payload='".$payload."',product_id='".$product_id."',exp_date='".$end_time."',target_level='".$target."',order_id='".$oredr_id."',operator_id='".$operator_id."'");
		}

		/*
		FUNCTION NAME 		-	getTransactionDetails
		DESCRIPTION 		-	Retrieves transaction details.
		INPUT PARAMETER 	-	$id
		OUTPUT PARAMETER 	- 	Returns transaction id,cmd id,user id of transaction query.
		*/	
		public function getTransactionDetails($id){
			$query = $this->db->query("SELECT * FROM ".DB_PREFIX."cas_op_transactions c left join ".DB_PREFIX."sms_kms_map k on c.user_id=k.user_id WHERE c.id='".$id."'");
			return $query->row;
		}
		public function getKmsPpvId($sms_product_id)
		{
		 	$query = $this->db->query("SELECT api_product_id FROM `" . DB_PREFIX . "sms_kms_product` WHERE product_id = '" . (int)$sms_product_id . " AND is_ppv=1'");
			return $query->row['api_product_id'];
		}

		/*
		FUNCTION NAME 		-	getApiResponceId
		DESCRIPTION 		-	Retrieves Kms id.
		INPUT PARAMETER 	-	$id
		OUTPUT PARAMETER 	- 	Returns kms_stb_id.
		*/

		public function getApiResponceId($sms_stb_no)
		{
		 	$query = $this->db->query("SELECT kms_stb_id FROM `" . DB_PREFIX . "sms_kms_stb` WHERE sms_stb_id = '" . (int)$sms_stb_no . "'");
			return $query->row;
		}	

		/*
		FUNCTION NAME 		-	isSTBPaired
		DESCRIPTION 		-	.
		INPUT PARAMETER 	-	stb_no
		OUTPUT PARAMETER 	- 	Returns rows.
		*/

			public function isSTBPaired($stb_no)
			{
			 	$query = $this->db->query("SELECT `customer_id` FROM ".DB_PREFIX."stb WHERE `stb_no`='".$stb_no."'");
				return ($query->row['customer_id'] > 0);
			}	

		/*
		FUNCTION NAME 		-	getCustomerId
		DESCRIPTION 		-	.
		INPUT PARAMETER 	-	stb_no
		OUTPUT PARAMETER 	- 	Returns Customer Id.
		*/

		public function getCustomerId($stb_no)
			{
			 	$query = $this->db->query("SELECT `customer_id` FROM ".DB_PREFIX."stb WHERE `stb_no`='".$stb_no."'");
				return $query->row['customer_id'];
			}

		
		public function getStbno($customer_id){
	 		$query = $this->db->query("SELECT `STBNO` FROM ".DB_PREFIX."customer WHERE `customer_id`='".$customer_id."'");
			return $query->row['STBNO'];
		}
		
		public function updateExpiryFlag($product_id,$customer_id){
			$query = $this->db->query("UPDATE " . DB_PREFIX . "subscription SET  is_cancel=1 WHERE product_id = '" . (int)$product_id. "' AND customer_id = '" . (int)$customer_id. "'");
		}

		/*
		FUNCTION NAME 		-	getEventDetails
		DESCRIPTION 		-	.
		INPUT PARAMETER 	-	event_id
		OUTPUT PARAMETER 	- 	Returns Number of column.
		*/
		public function getPPVExist($channel_id){
			 	$query = $this->db->query("SELECT * FROM ".DB_PREFIX."product WHERE `product_id`='".$channel_id."'");
				return $query->num_rows;
			}

		public function getMaxExpiry($user_id,$product_id)	{
			$query = $this->db->query("SELECT id,exp_date FROM ".DB_PREFIX."cas_op_transactions c WHERE c.product_id='".$product_id."' AND c.user_id='".$user_id."' ORDER BY ID DESC LIMIT 1");
			return $query->row;
		}

		public function updateExpiry($user_id,$product_id)	{
			$this->db->query("UPDATE " . DB_PREFIX . "cas_op_transactions SET  exp_date = NOW() WHERE user_id = '" .$user_id. "' AND product_id = '" .$product_id. "' AND cmd_id=18");
		}

		public function getStbNoFromId($id){
		 	$query = $this->db->query("SELECT `user_id` FROM ".DB_PREFIX."cas_op_transactions WHERE `id`='".$id."'");
		 	$query1 = $this->db->query("SELECT `stb_no` FROM ".DB_PREFIX."stb WHERE `customer_id`='".$query->row['user_id']."'");
		 	if($query1->num_rows==1){
				return $query1->row['stb_no'];
		 	} else {
				return '0';
			}
		}

		public function isBlacklist($stb_no){	 	
		 	$query = $this->db->query("SELECT `is_black_list` FROM ".DB_PREFIX."stb WHERE `stb_no`='".$stb_no."'");
		 	if($query->row!=NULL){
				return $query->row['is_black_list'];
		 	}else{
		 		return 0;
			}		
		}

}
?>