<?php
/*
@File force_nit_tunning.php(MODEL)
DESIGN:	 Force Nit Tunning PAGE
    This class retrieves the OtaDownload staus detials.

@Author Ravi Ranjan 
@date 13 Dec. 2016
*/
class ModelCommandsForceNitTunning extends Model {

	/*
	FUNCTION NAME 		-	getOtadownload
	DESCRIPTION 		-	Retrieves all transation details.
	INPUT PARAMETER 	-	void
	OUTPUT PARAMETER 	- 	Returns all the rows retrieved by the query.
	*/		
	public function getOtadownload($data) {
		switch ($data['target_level'])
		{
			case 1:
				$sql="SELECT id,tx_id,cmd_id,user_id,ack_ctr,nack_ctr,payload,product_id,modify_date,exp_date,c.STBNO FROM ".DB_PREFIX."cas_op_transactions cas left join ".DB_PREFIX."customer c ON(cas.user_id=c.customer_id) WHERE cmd_id=17 ";
				if(isset($data['filter_value']))
				{
					$sql .=" AND c.STBNO = '".$this->db->escape($data['filter_value'])."'";			
				}
				if($this->session->data['user_group_id']!=1)
		      	{
		      		$sql.=" AND c.operator_id ='" . $this->session->data['user_id'] . "'";
		      	}
			break;
			case 2:
				$sql="SELECT id,tx_id,cmd_id,ack_ctr,nack_ctr,payload,modify_date,exp_date FROM ".DB_PREFIX."cas_op_transactions WHERE target_level=2 AND cmd_id=17";		
				if($this->session->data['user_group_id']!=1)
		      	{
		      		$sql.=" AND operator_id ='" . $this->session->data['user_id'] . "'";
		      	}					
			break;
			case 3:
				$sql="SELECT * FROM ".DB_PREFIX."cas_op_transactions left join ".DB_PREFIX."region on (user_id=pin) WHERE target_level=3 AND cmd_id=17 AND pin ='".$this->db->escape($data["filter_value"])."'";				
				if($this->session->data['user_group_id']!=1)
		      	{
		      		$sql.=" AND operator_id ='" . $this->session->data['user_id'] . "'";
		      	}
			break;
			case 4:
				$sql="SELECT * FROM ".DB_PREFIX."cas_op_transactions left join ".DB_PREFIX."customer_group_description on (user_id=customer_group_id) WHERE target_level=4 AND cmd_id=17 AND name='".$this->db->escape($data["filter_value"])."'";
				if($this->session->data['user_group_id']!=1)
		      	{
		      		$sql.=" AND operator_id ='" . $this->session->data['user_id'] . "'";
		      	}				
			break;
			default:
				$sql="SELECT id,tx_id,cmd_id,user_id,ack_ctr,nack_ctr,payload,product_id,modify_date,exp_date,c.STBNO FROM ".DB_PREFIX."cas_op_transactions cas left join ".DB_PREFIX."customer c ON(cas.user_id=c.customer_id) WHERE c.customer_id=-1";
				if($this->session->data['user_group_id']!=1)
		      	{
		      		$sql.=" AND c.operator_id ='" . $this->session->data['user_id'] . "'";
		      	}
			break;
		}
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}				
			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
			$sql .= " ORDER BY id DESC LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}	
		$query = $this->db->query($sql);
		return $query->rows;
	}
/*
FUNCTION NAME 		-	getTotalStbActivations
DESCRIPTION 		-	Retrieves number of  stb number assign to customer and balance.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved by the query.
*/		
	public function getTotalotaUpdate($data) {
		switch ($data['target_level']) {
			case 1:
				$sql="SELECT  count(*) AS total FROM " . DB_PREFIX . "cas_op_transactions cas left join ".DB_PREFIX."customer c ON(cas.user_id=c.customer_id) WHERE cmd_id=17";
				if(isset($data['filter_value']))
				{
					$sql .= " AND c.STBNO = '".$this->db->escape($data['filter_value'])."'";
				}
				if($this->session->data['user_group_id']!=1)
		      	{
		      		$sql.=" AND c.operator_id ='" . $this->session->data['user_id'] . "'";
		      	}	
			break;
			case 2:
				$sql="SELECT  count(*) AS total FROM " . DB_PREFIX . "cas_op_transactions WHERE cmd_id=17 AND target_level=2";	
				if($this->session->data['user_group_id']!=1)
		      	{
		      		$sql.=" AND operator_id ='" . $this->session->data['user_id'] . "'";
		      	}	
				break;
			case 3:
				$sql="SELECT  count(*) AS total FROM " . DB_PREFIX . "cas_op_transactions WHERE cmd_id=17 AND target_level=3";		
				if($this->session->data['user_group_id']!=1)
		      	{
		      		$sql.=" AND operator_id ='" . $this->session->data['user_id'] . "'";
		      	}			

			break;
			case 4:
				$sql="SELECT  count(*) AS total FROM " . DB_PREFIX . "cas_op_transactions WHERE cmd_id=17 AND target_level=4";	
				if($this->session->data['user_group_id']!=1)
		      	{
		      		$sql.=" AND operator_id ='" . $this->session->data['user_id'] . "'";
		      	}				
			break;
			default:
				return 0;
			break;
		}
	    $query = $this->db->query($sql);
		return $query->row['total'];
	}

	/*
	FUNCTION NAME 		-	getSTBs
	DESCRIPTION 		-	Retrieves all the mapping between cas number, stb number and customer id.
	INPUT PARAMETER 	-	void
	OUTPUT PARAMETER 	- 	Returns all the rows retrieved by the query.
	*/		
	public function getSTBs($data=array()) {
		$sql="SELECT id,stb_no FROM " . DB_PREFIX . "stb WHERE customer_id!=0";
		if(!empty($data['filter_no'])){
			$sql.=" AND stb_no LIKE '" . $this->db->escape($data['filter_no']) . "%'";
		}
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}			

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
			
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}	
		$query = $this->db->query($sql);
		return $query->rows;
	}
	/*
	FUNCTION NAME 		-	addToCasOpTransanction
	DESCRIPTION 		-	Queries to add the response data of api in the database.
	INPUT PARAMETER 	-	void
	OUTPUT PARAMETER 	- 	void.
	*/
	public function addToCasOpTransanction($target_level,$target1,$id,$payload,$ack_is,$nack_is,$operator_id){
		
		$this->db->query("INSERT INTO " . DB_PREFIX . "cas_op_transactions SET tx_id='".$id."',cmd_id=17,target_level='".$target_level."',order_id=0,product_id=0,user_id='".$target1."',ack_ctr='".$ack_is."',nack_ctr='".$nack_is."',nack_type=-1,exp_date=now(),initiated_by='Admin',payload='".$payload."',operator_id='".$operator_id."'");
	}
	
	public function getTransactionDetails($id){
		$query = $this->db->query("SELECT * FROM ".DB_PREFIX."cas_op_transactions WHERE id='".$id."'");
		return $query->row;
	}

	public function isSTBPaired($stb_no){
	 	$query = $this->db->query("SELECT `customer_id` FROM ".DB_PREFIX."stb WHERE `stb_no`='".$stb_no."'");
		return $query->row;
	}	

	public function getCustomerId($stb_no){
	 	$query = $this->db->query("SELECT customer_id,api_user_id,operator_id FROM ".DB_PREFIX."customer c left join ".DB_PREFIX."sms_kms_map sk ON(c.customer_id=sk.user_id)  WHERE `STBNO`='".$stb_no."'");
		return $query->row;
	}


	public function getGroupIdByname($groupName){
		$query= $this->db->query("SELECT k.kms_group_id, k.sms_group_id FROM ".DB_PREFIX."customer_group_description g,".DB_PREFIX."sms_kms_group k WHERE g.name='".$groupName."' AND g.customer_group_id=k.sms_group_id");
		return $query->row;
	}
	
	public function isStbExistedAndPaired($stb_no){
		$query= $this->db->query("SELECT `customer_id` FROM `".DB_PREFIX."stb` WHERE `stb_no`='".$stb_no."'");
		return $query->row;
	}
	public function checkPinExist($pin){
		$query= $this->db->query("SELECT count(*) as total FROM `".DB_PREFIX."region` WHERE `pin`='".$this->db->escape($pin)."'");
		return $query->row['total']>0;
	}

	public function checkGroupExists($gname){
		$query= $this->db->query("SELECT count(*) as total FROM `".DB_PREFIX."customer_group_description` WHERE `name`='".$this->db->escape($gname)."'");
		return $query->row['total']>0;
	}
	
	public function getStbNo($customer_id){
	 	$query = $this->db->query("SELECT STBNO FROM ".DB_PREFIX."customer WHERE `customer_id`='".$customer_id."'");
		return $query->row['STBNO'];
	}

	public function getGroupNameById($group_id){
	 	$query = $this->db->query("SELECT name FROM ".DB_PREFIX."customer_group_description WHERE customer_group_id='".$group_id."'");
		return $query->row['name'];
	}

	public function getKMSGroupId($group_id){
	 	$query = $this->db->query("SELECT kms_group_id FROM ".DB_PREFIX."sms_kms_group WHERE sms_group_id='".$group_id."'");
		return $query->row['kms_group_id'];
	}
	public function getKMSUserId($customer_id){
	 	$query = $this->db->query("SELECT api_user_id FROM ".DB_PREFIX."sms_kms_map WHERE user_id='".$customer_id."'");
		return $query->row['api_user_id'];
	}
	public function isSTBBlackListed($stbno){
		$query = $this->db->query("SELECT * FROM ".DB_PREFIX."stb WHERE is_black_list=1 AND stb_no='".$stbno."'");
		return $query->num_rows;
	}
	
}
?>
