<?php
/*
@File emm_fingerprint.php(MODEL)
DESIGN:	 EmmFingerprint PAGE
    This class retrieves the EmmFingerprint status detials.

@Author Ravi Ranjan 
@date 19 Jan. 2016
*/
class ModelCommandsEcmFingerprint extends Model {

/*
FUNCTION NAME 		-	getActivationTransactions
DESCRIPTION 		-	Retrieves all transation details.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved by the query.
*/		
		public function getEcmFingerprint($data) {
					$sql="SELECT id,tx_id,cmd_id,user_id,ack_ctr,nack_ctr,payload,product_id,modify_date,exp_date FROM ".DB_PREFIX."cas_op_transactions cas where cmd_id=255";
					if($this->session->data['user_group_id']!=1)
			      	{
			      		$sql.=" AND cas.operator_id ='" . $this->session->data['user_id'] . "'";
			      	}
			
					if (isset($data['start']) || isset($data['limit'])) {
					
					if ($data['start'] < 0) {
						$data['start'] = 0;
					}				
					if ($data['limit'] < 1) {
						$data['limit'] = 20;
					}	
					$sql .= " ORDER BY id DESC LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
				}	
					$query = $this->db->query($sql);
					return $query->rows;
			}
/*
FUNCTION NAME 		-	getTotalStbActivations
DESCRIPTION 		-	Retrieves number of  stb number assign to customer and balance.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved by the query.
*/		
		public function getTotalEcmFingeprint($data) {
					$sql="SELECT  count(*) AS total FROM " . DB_PREFIX . "cas_op_transactions cas left join ".DB_PREFIX."customer c ON(cas.user_id=c.customer_id) where cmd_id=255";
					if($this->session->data['user_group_id']!=1)
			      	{
			      		$sql.=" AND c.operator_id ='" . $this->session->data['user_id'] . "'";
			      	}
		   			 $query = $this->db->query($sql);
					return $query->row['total'];
					}

/*
FUNCTION NAME 		-	getSTBs
DESCRIPTION 		-	Retrieves all the mapping between cas number, stb number and customer id.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved by the query.
*/		
	public function getSTBs($data=array()) {
		$sql="SELECT id,stb_no FROM " . DB_PREFIX . "stb WHERE customer_id!=0";
		if(!empty($data['filter_no'])){
			$sql.=" AND stb_no LIKE '" . $this->db->escape($data['filter_no']) . "%'";
		}
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}			

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
			
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}	
		$query = $this->db->query($sql);
		return $query->rows;
	}
/*
FUNCTION NAME 		-	addToCasOpTransanction
DESCRIPTION 		-	Queries to add the response data of api in the database.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	void.
*/
	public function addToCasOpTransanction($id,$payload,$ack_is,$nack_is,$operator_id)
	{
		$this->db->query("INSERT INTO " . DB_PREFIX . "cas_op_transactions SET tx_id='".$id."',cmd_id=255,order_id=0,product_id=0,ack_ctr='".$ack_is."',nack_ctr='".$nack_is."',nack_type=-1,initiated_by='Admin',payload='".$payload."',target_level=2,operator_id='".$operator_id."'");
	}


/*
FUNCTION NAME 		-	getTransactionDetails
DESCRIPTION 		-	Retrieves transaction details.
INPUT PARAMETER 	-	$id
OUTPUT PARAMETER 	- 	Returns transaction id,cmd id,user id of transaction query.
*/	
	public function getTransactionDetails($id)
	{
		$query = $this->db->query("SELECT tx_id,cmd_id,c.user_id,payload,k.api_user_id,c.operator_id FROM ".DB_PREFIX."cas_op_transactions c,".DB_PREFIX."sms_kms_map k WHERE c.id='".$id."' AND c.user_id=k.user_id");
		return $query->row;
	}

/*
FUNCTION NAME 		-	getApiResponceId
DESCRIPTION 		-	Retrieves Kms id.
INPUT PARAMETER 	-	$id
OUTPUT PARAMETER 	- 	Returns kms_stb_id.
*/

	public function getApiResponceId($sms_stb_no)
	{
	 	$query = $this->db->query("SELECT kms_stb_id FROM `" . DB_PREFIX . "sms_kms_stb` WHERE sms_stb_id = '" . (int)$sms_stb_no . "'");
		return $query->row;
	}	

/*
FUNCTION NAME 		-	isSTBPaired
DESCRIPTION 		-	.
INPUT PARAMETER 	-	stb_no
OUTPUT PARAMETER 	- 	Returns rows.
*/

	public function isSTBPaired($stb_no)
	{
	 	
		// var_dump($stb_no);
	 	$query = $this->db->query("SELECT `customer_id` FROM ".DB_PREFIX."stb WHERE `stb_no`='".$stb_no."'");
		return $query->row;
	}	

/*
FUNCTION NAME 		-	getCustomerId
DESCRIPTION 		-	.
INPUT PARAMETER 	-	stb_no
OUTPUT PARAMETER 	- 	Returns Customer Id.
*/

	public function getCustomerId($stb_no)
	{
	 	$query = $this->db->query("SELECT customer_id,api_user_id,c.operator_id FROM ".DB_PREFIX."customer c left join ".DB_PREFIX."sms_kms_map sk ON(c.customer_id=sk.user_id)  WHERE `STBNO`='".$stb_no."'");
		return $query->row;
	}


	// public function addToTransanction($target_level,$target,$id,2,"admin",$payload,$ack_is,$nack_is)
	// {
		
	
	// 		// $newDate=date('Y-m-d H:i:s', $end_time+19800);
	// 		// $this->db->query("INSERT INTO " . DB_PREFIX . "cas_op_transactions SET tx_id='".$id."',cmd_id=2,order_id=0,product_id=0,user_id='".$target."',ack_ctr='".$ack_is."',nack_ctr='".$nack_is."',nack_type=-1,modify_date=now(),initiated_by='Admin'");
	
	// }

	public function getChanelList()
		{
	 	$query = $this->db->query("SELECT `service_id`,`name` FROM ".DB_PREFIX."product p left join ".DB_PREFIX."product_description pd on(p.product_id=pd.product_id) WHERE `is_package`!=1 AND `is_ppv`!=1");
		return $query->rows;
		}	

	
}
?>