<?php
/*
@File box_pairing.php(MODEL)
DESIGN:	 BoxPairing PAGE
    This class retrieves the BoxPairing status detials.

@Author Ravi Ranjan 
@date 19 Jan. 2016
*/
class ModelCommandsBoxPairing extends Model {

/*
FUNCTION NAME 		-	getActivationTransactions
DESCRIPTION 		-	Retrieves all transation details.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved by the query.
*/		
		public function getSubscribeProducts($data) {
			//$sql="SELECT id,cas.tx_id,cas.cmd_id,cas.user_id,cas.ack_ctr,cas.nack_ctr,payload FROM ".DB_PREFIX."cas_op_transactions cas left join ".DB_PREFIX."customer c ON(cas.user_id=c.customer_id) left join ".DB_PREFIX."product p ON(cas.product_id=p.product_id) where p.is_ppv=0 AND p.is_package=0 AND cmd_id=23";
			$sql="SELECT id,tx_id,cmd_id,user_id,ack_ctr,nack_ctr,payload,modify_date FROM ".DB_PREFIX."cas_op_transactions WHERE cmd_id=23";
			if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}				
			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
			$sql .= " ORDER BY id DESC LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}	
		$query = $this->db->query($sql);
		return $query->rows;
		}
/*
FUNCTION NAME 		-	getTotalStbActivations
DESCRIPTION 		-	Retrieves number of  stb number assign to customer and balance.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved by the query.
*/		
		public function getTotalStbActivations() {
			$query = $this->db->query("SELECT  count(*) AS total FROM " . DB_PREFIX . "cas_op_transactions WHERE cmd_id=0");
			return $query->row['total'];
		}

/*
FUNCTION NAME 		-	getSTBs
DESCRIPTION 		-	Retrieves all the mapping between cas number, stb number and customer id.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved by the query.
*/		
	public function getSTBs($data=array()) {
		$sql="SELECT id,stb_no FROM " . DB_PREFIX . "stb WHERE customer_id!=0";
		if(!empty($data['filter_no'])){
			$sql.=" AND stb_no LIKE '" . $this->db->escape($data['filter_no']) . "%'";
		}
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}			

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
			
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}	
		$query = $this->db->query($sql);
		return $query->rows;
	}
/*
FUNCTION NAME 		-	addToCasOpTransanction
DESCRIPTION 		-	Queries to add the response data of api in the database.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	void.
*/
	public function addToCasOpTransanction($user_id,$cmd_id,$tx_id,$ack_is='-1',$nack_is='-1',$payload)
	{
		$this->db->query("INSERT INTO " . DB_PREFIX . "cas_op_transactions SET tx_id='".$tx_id."',cmd_id='".$cmd_id."',user_id='".$user_id."',ack_ctr='".$ack_is."',nack_ctr='".$nack_is."',nack_type=-1,initiated_by='Admin',payload='".$payload."'");
	}


/*
FUNCTION NAME 		-	getTransactionDetails
DESCRIPTION 		-	Retrieves transaction details.
INPUT PARAMETER 	-	$id
OUTPUT PARAMETER 	- 	Returns transaction id,cmd id,user id of transaction query.
*/	
	public function getTransactionDetails($id)
	{
		$query = $this->db->query("SELECT tx_id,cmd_id,c.user_id,payload,k.api_user_id FROM ".DB_PREFIX."cas_op_transactions c,".DB_PREFIX."sms_kms_map k WHERE c.id='".$id."' AND c.user_id=k.user_id");
		return $query->row;
	}

/*
FUNCTION NAME 		-	getApiResponceId
DESCRIPTION 		-	Retrieves Kms id.
INPUT PARAMETER 	-	$id
OUTPUT PARAMETER 	- 	Returns kms_stb_id.
*/

	public function getApiResponceId($sms_stb_no)
	{
	 	$query = $this->db->query("SELECT kms_stb_id FROM `" . DB_PREFIX . "sms_kms_stb` WHERE sms_stb_id = '" . (int)$sms_stb_no . "'");
		return $query->row;
	}	

/*
FUNCTION NAME 		-	isSTBPaired
DESCRIPTION 		-	.
INPUT PARAMETER 	-	stb_no
OUTPUT PARAMETER 	- 	Returns rows.
*/

	public function isSTBPaired($stb_no)
	{
	 	$query = $this->db->query("SELECT `customer_id` FROM ".DB_PREFIX."stb WHERE `stb_no`='".$stb_no."'");
		return ($query->row['customer_id'] > 0);
	}	

/*
FUNCTION NAME 		-	getCustomerId
DESCRIPTION 		-	.
INPUT PARAMETER 	-	stb_no
OUTPUT PARAMETER 	- 	Returns Customer Id.
*/

	public function getCustomerId($stb_no)
	{
	 	$query = $this->db->query("SELECT `customer_id` FROM ".DB_PREFIX."stb WHERE `stb_no`='".$stb_no."'");
		return $query->row['customer_id'];
	}
	
}
?>