<?php
/*
@File account_info.php(MODEL)
DESIGN:	 Account Information  PAGE
    This class retrieves the stb number detials along with their activation.

@Author Ravi Ranjan 
@date 25 Nov. 2016
*/
class ModelCommandsAccountInfo extends Model {

			/*
			FUNCTION NAME 		-	getActivationTransactions
			DESCRIPTION 		-	Retrieves all transation details.
			INPUT PARAMETER 	-	void
			OUTPUT PARAMETER 	- 	Returns all the rows retrieved by the query.
			*/		
			public function getActivationTransactions($data) {
				$sql="SELECT c.firstname,c.lastname,a.postcode,cgd.name,cas.modify_date,cas.ack_ctr,c.STBNO,c.telephone,a.postcode FROM ".DB_PREFIX."cas_op_transactions cas left join ".DB_PREFIX."customer c ON(cas.user_id=c.customer_id) LEFT JOIN ".DB_PREFIX."address a ON(c.address_id=a.address_id) LEFT join ".DB_PREFIX."customer_group_description cgd ON(c.customer_group_id=cgd.customer_group_id) where cmd_id=25";
				if($this->session->data['user_group_id']!=1)
		      	{
		      		$sql.=" AND c.operator_id ='" . $this->session->data['user_id'] . "'";
		      	}
				if(isset($data['filter_value'])){
					$sql .=" AND c.STBNO like '%".$data['filter_value']."%'";			
				}
				if (isset($data['start']) || isset($data['limit'])) {
					if ($data['start'] < 0) {
						$data['start'] = 0;
					}				

					if ($data['limit'] < 1) {
						$data['limit'] = 20;
					}	
				
					$sql .= " ORDER BY c.customer_id DESC LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
				}	
				$query = $this->db->query($sql);
				return $query->rows;
			}
			/*
			FUNCTION NAME 		-	getTotalStbActivations
			DESCRIPTION 		-	Retrieves number of  stb number assign to customer and balance.
			INPUT PARAMETER 	-	void
			OUTPUT PARAMETER 	- 	Returns all the rows retrieved by the query.
			*/		
			public function getTotalStbActivations($data) {
				$sql = "SELECT count(*) AS total FROM ".DB_PREFIX."cas_op_transactions cas left join ".DB_PREFIX."customer c ON(cas.user_id=c.customer_id) LEFT JOIN ".DB_PREFIX."region r ON(c.customer_region_id=r.region_id) LEFT join ".DB_PREFIX."customer_group_description cgd ON(c.customer_group_id=cgd.customer_group_id) where cmd_id=25";
				if($this->session->data['user_group_id']!=1)
		      	{
		      		$sql.=" AND c.operator_id ='" . $this->session->data['user_id'] . "'";
		      	}
				if(isset($data['filter_value'])){
					$sql .=" AND c.STBNO like '%".$data['filter_value']."%'";			
				}
				$query = $this->db->query($sql);
				return $query->row['total'];
			}

			/*
			FUNCTION NAME 		-	getSTBs
			DESCRIPTION 		-	Retrieves all the mapping between cas number, stb number and customer id.
			INPUT PARAMETER 	-	void
			OUTPUT PARAMETER 	- 	Returns all the rows retrieved by the query.
			*/		
			public function getSTBdetails($data=array()) {

				$sql="SELECT CONCAT(c.firstname, ' ', c.lastname) AS name,c.STBNO,c.telephone,c.customer_group_id,c.address_id,ad.postcode,(cg.name) AS group_name FROM " . DB_PREFIX . "customer c left JOIN " . DB_PREFIX . "address ad ON(c.address_id=ad.address_id) LEFT join " . DB_PREFIX . "customer_group_description cg ON(c.customer_group_id=cg.customer_group_id)  WHERE c.customer_id!=0";
				if(!empty($data['filter_no'])){
					$sql.=" AND STBNO LIKE '" . $this->db->escape($data['filter_no']) . "%'";
				}
				if (isset($data['start']) || isset($data['limit'])) { 
					if ($data['start'] < 0) {
						$data['start'] = 0;
					}			

					if ($data['limit'] < 1) {
						$data['limit'] = 20;
					}	
					
					$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
				}	
				$query = $this->db->query($sql);
				return $query->rows;
			}
			/*
			FUNCTION NAME 		-	addToCasOpTransanction
			DESCRIPTION 		-	Queries to add the response data of api in the database.
			INPUT PARAMETER 	-	void
			OUTPUT PARAMETER 	- 	void.
			*/
			public function addToCasOpTransanction($user_id,$id,$payload,$ack_is,$nack_is,$operator_id)
			 {	
				$sql="SELECT * FROM `oc_cas_op_transactions` WHERE `user_id` ='".$user_id."' AND `cmd_id`=25";
				$query = $this->db->query($sql);
				// var_dump($query);
				// var_dump(empty($query->row));
				if (!empty($query->row)) {
					$this->db->query("UPDATE " . DB_PREFIX . "cas_op_transactions SET tx_id='".$id."',cmd_id=25,user_id='".$user_id."',ack_ctr='".$ack_is."',nack_ctr='".$nack_is."',nack_type=-1,initiated_by='Admin',payload='".$payload."',operator_id='".$operator_id."' WHERE user_id='".$user_id."' AND cmd_id=25");
				}else {
					// var_dump("expression");
					// var_dump($id);
					$this->db->query("INSERT INTO " . DB_PREFIX . "cas_op_transactions SET tx_id='".$id."',cmd_id=25,user_id='".$user_id."',ack_ctr='".$ack_is."',nack_ctr='".$nack_is."',nack_type=-1,initiated_by='Admin',payload='".$payload."',operator_id='".$operator_id."'");
				}
				// exit();
			}


			/*
			FUNCTION NAME 		-	getTransactionDetails
			DESCRIPTION 		-	Retrieves transaction details.
			INPUT PARAMETER 	-	$id
			OUTPUT PARAMETER 	- 	Returns transaction id,cmd id,user id of transaction query.
			*/	
			public function getTransactionDetails($id)
			{
				$query = $this->db->query("SELECT tx_id,cmd_id,c.user_id,payload,k.api_user_id,c.exp_date,c.operator_id FROM ".DB_PREFIX."cas_op_transactions c,".DB_PREFIX."sms_kms_map k WHERE c.id='".$id."' AND c.user_id=k.user_id");
				return $query->row;
			}

			/*
			FUNCTION NAME 		-	getApiResponceId
			DESCRIPTION 		-	Retrieves Kms id.
			INPUT PARAMETER 	-	$id
			OUTPUT PARAMETER 	- 	Returns kms_stb_id.
			*/

			public function getApiResponceId($sms_stb_no)
			{
			 	$query = $this->db->query("SELECT kms_stb_id FROM `" . DB_PREFIX . "sms_kms_stb` WHERE sms_stb_id = '" . (int)$sms_stb_no . "'");
				return $query->row;
			}	

			/*
			FUNCTION NAME 		-	isSTBPaired
			DESCRIPTION 		-	.
			INPUT PARAMETER 	-	stb_no
			OUTPUT PARAMETER 	- 	Returns rows.
			*/

			public function isSTBPaired($stb_no)
			{
			 	$query = $this->db->query("SELECT `customer_id` FROM ".DB_PREFIX."stb WHERE `stb_no`='".$stb_no."'");

				return $query->num_rows;
			}	

			/*
			FUNCTION NAME 		-	getCustomerId
			DESCRIPTION 		-	.
			INPUT PARAMETER 	-	stb_no
			OUTPUT PARAMETER 	- 	Returns Customer Id.
			*/

			public function getCustomerId($stb_no)
			{
			 	$query = $this->db->query("SELECT `customer_id`,`operator_id` FROM ".DB_PREFIX."stb WHERE `stb_no`='".$stb_no."'");
				return $query->row;
			}
			/*
			FUNCTION NAME 		-	getCustomerId
			DESCRIPTION 		-	.
			INPUT PARAMETER 	-	stb_no
			OUTPUT PARAMETER 	- 	Returns Customer Id.
			*/
			public function setSTBActiveDeactive($is_active,$cust_id)	
			{
				$query = $this->db->query("UPDATE  ".DB_PREFIX."stb SET is_active='".$is_active."' WHERE `customer_id`='".$cust_id."'");	
			}

				/*
			FUNCTION NAME 		-	getCasID
			DESCRIPTION 		-	Retrieves cas and stb number for the given customer_id
			INPUT PARAMETER 	-	cas_no
			OUTPUT PARAMETER 	- 	Returns a row conatining the customer stb and cas details.
			*/	
			public function addPasscode($stb_no,$pass_code){
				$query = $this->db->query("UPDATE  ".DB_PREFIX."stb SET `pass_code`='".$pass_code."' WHERE `stb_no`='".$stb_no."'");	
			}

					/*
			FUNCTION NAME 		-	getCustomerId
			DESCRIPTION 		-	.
			INPUT PARAMETER 	-	stb_no
			OUTPUT PARAMETER 	- 	Returns Customer Id.
			*/

			public function getStbNo($customer_id){
			 	$query = $this->db->query("SELECT `STBNO` FROM ".DB_PREFIX."customer WHERE `customer_id`='".$customer_id."'");
				return $query->row['STBNO'];
			}

				/*
			FUNCTION NAME 		-	getCustomers
			DESCRIPTION 		-	Retrieves all the customer details from the database
			INPUT PARAMETER 	-	data array conatining filter options if any.
			OUTPUT PARAMETER 	- 	Returns all th rows retrieved.
			*/				
			public function getAccountInfo($data = array(),$user_id) {
					$sql = "SELECT CONCAT(c.firstname, ' ', c.lastname) AS name,c.customer_id,cgd.name AS customer_group,c.customer_group_id AS group_id,c.customer_region_id As region_id,c.telephone FROM ".DB_PREFIX."customer c LEFT JOIN ".DB_PREFIX."customer_group_description cgd ON (c.customer_group_id = cgd.customer_group_id) LEFT JOIN ".DB_PREFIX."region r ON(c.customer_region_id=r.region_id) WHERE cgd.language_id = '" . (int)$this->config->get('config_language_id') . "' AND  c.operator_id='".$user_id."'";
					if (!empty($data['filter_no'])) {
						$sql .=" AND c.STBNO LIKE '" .($_GET['name_startsWith']). "%'";
					}
					$query = $this->db->query($sql);
					return $query->rows;	
			}
			
			public function	updateCustomer($customer_name,$telephone,$postcode,$customer_group,$operator_id,$terget,$region_id,$customer_id)
			{	
				// var_dump($customer_group);exit();
				$name=explode(" ", $customer_name);
				$query = $this->db->query("UPDATE  ".DB_PREFIX."customer SET `firstname`='".$name[0]."',`lastname`='".$name[1]."',`telephone`='".$telephone."',`customer_group_id`='".$customer_group."',`operator_id`='".$operator_id."' WHERE `STBNO`='".$terget."'");

				$query = $this->db->query("UPDATE  ".DB_PREFIX."address SET `firstname`='".$name[0]."',`lastname`='".$name[1]."',`postcode`='".$postcode."',`region_id`='".$region_id["region_id"]."' WHERE `customer_id`='".$customer_id."'");

			}

					/*
			FUNCTION NAME 		-	getCustomerId
			DESCRIPTION 		-	.
			INPUT PARAMETER 	-	stb_no
			OUTPUT PARAMETER 	- 	Returns Customer Id.
			*/

			public function getRegion($postcode){
			 	$query = $this->db->query("SELECT `region_id` FROM ".DB_PREFIX."region WHERE `pin`='".$postcode."'");
				return $query->row;
			}

						/*
			FUNCTION NAME 		-	getCustomerId
			DESCRIPTION 		-	.
			INPUT PARAMETER 	-	stb_no
			OUTPUT PARAMETER 	- 	Returns Customer Id.
			*/

			public function getCustomergroup($customer_group){
				$query = $this->db->query("SELECT customer_group_id FROM ".DB_PREFIX."customer_group_description WHERE `name`='".$customer_group."'");
					return $query->row;
			}
	
			public function isValidGroup($customer_group){
				$query = $this->db->query("SELECT customer_group_id FROM ".DB_PREFIX."customer_group_description WHERE `name`='".$customer_group."'");
					return $query->num_rows;
			}

			public function isValidRegion($postcode){
				 	$query = $this->db->query("SELECT `region_id` FROM ".DB_PREFIX."region WHERE `pin`='".$postcode."'");
					return $query->num_rows;
				}


			/*
			FUNCTION NAME 		-	getCustomerId
			DESCRIPTION 		-	.
			INPUT PARAMETER 	-	stb_no
			OUTPUT PARAMETER 	- 	Returns Customer Id.
			*/

			public function getKmsGroupid($sms_group_id){
		 		$query = $this->db->query("SELECT `kms_group_id` FROM ".DB_PREFIX."sms_kms_group WHERE `sms_group_id`='".$sms_group_id."'");
				return $query->row;
			}
				/*
			FUNCTION NAME 		-	getSTBExist
			DESCRIPTION 		-	Retrieve the row if STBNO already exists
			INPUT PARAMETER 	-	STBNO
			OUTPUT PARAMETER 	- 	Returns the row retrieved.
			*/
			public function getSTBExist($STBNO){
				$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "stb WHERE stb_no = '" . $STBNO . "'");
				if($query->num_rows){
					return 1;
				}else{
					return 0;
				}
			}
	
			/*
			FUNCTION NAME 		-	getCutomerBySTBNO
			DESCRIPTION 		-	Retrieves the customer details for the given STBNO
			INPUT PARAMETER 	-	STBNO
			OUTPUT PARAMETER 	- 	Returns the row retrieved.
			*/	
		    public function getCustomerBySTBNO($STBNO) {
				$query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "customer WHERE STBNO = '" . $STBNO . "'");
			
				return $query->row;
			}

			/*
			FUNCTION NAME 		-	getSTBblackList
			DESCRIPTION 		-	
			INPUT PARAMETER 	-	STBNO
			OUTPUT PARAMETER 	- 	Returns the row retrieved.
			*/
			public function getSTBblackList($STBNO){
				$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "stb WHERE stb_no = '" . $STBNO . "'");
				return $query->row;
			}

			/*
			FUNCTION NAME 		-	getCutomerByMobile
			DESCRIPTION 		-	Retrieves the customer details for the given mobile number
			INPUT PARAMETER 	-	mobile number
			OUTPUT PARAMETER 	- 	Returns the row retrieved.
			*/	
			public function getCustomerByMobile($mobile) {
				$query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "customer WHERE telephone = '" . $this->db->escape($mobile) . "'");
			
				return $query->row;
			}

			/*
			FUNCTION NAME 		-	getGroupIdByName
			DESCRIPTION 		-	Retrieves the group id from name
			INPUT PARAMETER 	-	group name
			OUTPUT PARAMETER 	- 	Returns the row with group id retrieved.
			*/
			public function getGroupIdByName($group_name)
			{
				$query = $this->db->query("SELECT customer_group_id FROM " . DB_PREFIX . "customer_group_description WHERE name='".$group_name."'" );
				return $query->row;	
			}


			/*
			FUNCTION NAME 		-	getRegionIdByName
			DESCRIPTION 		-	Retrieves the region id from name
			INPUT PARAMETER 	-	region name
			OUTPUT PARAMETER 	- 	Returns the row with region id retrieved.
			*/
			public function isRegionpinExist($region_pin)
			{
				$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "region WHERE pin='".$region_pin."'" );
				return $query->num_rows;	
			}

				/*
			FUNCTION NAME 		-	getApigroupid
			DESCRIPTION 		-	retrives the associated kms group id of group 
			INPUT PARAMETER 	-	sms group id
			OUTPUT PARAMETER 	- 	Returns the row with kms group id.
			*/
			public function getApigroupid($sms_group_id) {
				$query = $this->db->query("SELECT kms_group_id FROM `" . DB_PREFIX . "sms_kms_group` where sms_group_id = ".$sms_group_id);
			
				return $query->row;
			}

			/*
			FUNCTION NAME 		-	getZoneIdByName
			DESCRIPTION 		-	Retrieves the zone id from name, country id
			INPUT PARAMETER 	-	name, country id
			OUTPUT PARAMETER 	- 	Returns the row with zone id retrieved.
			*/
			public function getCustomerGroups()
			{
				$query = $this->db->query("SELECT name FROM " . DB_PREFIX . "customer_group_description" );
				return $query->rows;	
			}	

}
?>