<?php
/*
@File product.php(MODEL)
CATALOG:	 CHANNEL PAGE
    Manages the channel list by retrieving/adding/editing it from database.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ModelCatalogPpv extends Model {
/*
FUNCTION NAME 		-	addProduct
DESCRIPTION 		-	Adds new channel detail to the database.
INPUT PARAMETER 	-	channel details as an array 
OUTPUT PARAMETER 	- 	Adds to the database and returns to the channel list page with a success notification
*/	
	public function addProduct($data) {
		 
		 $query = $this->db->query("SELECT * FROM oc_product WHERE product_id='".(int)$data['product_id']."'");
		 $query1 = $this->db->query("SELECT * FROM oc_product_description WHERE product_id='".(int)$data['product_id']."'");
	
		//-----------
		 	// $this->db->query("INSERT INTO " . DB_PREFIX . "product SET service_id= '" . $query->rows[0]['service_id'] . "', model = '" . $this->db->escape($data['model']) . "', sku = '" . $this->db->escape($data['sku']) . "', upc = '" . $this->db->escape($data['upc']) . "', ean = '" . $this->db->escape($data['ean']) . "', jan = '" . $this->db->escape($data['jan']) . "', isbn = '" . $this->db->escape($data['isbn']) . "', mpn = '" . $this->db->escape($data['mpn']) . "', location = '" . $this->db->escape($data['location']) . "', quantity = '1', minimum = '1', subtract = '0', stock_status_id = '" . (int)$data['stock_status_id'] . "', date_available = '" . $this->db->escape($data['date_available']) . "', manufacturer_id = '" . (int)$data['manufacturer_id'] . "', shipping = '" . (int)$data['shipping'] . "', price = '" . (float)$data['price'] . "', points = '" . (int)$data['points'] . "', status = '" . (int)$data['status'] . "', tax_class_id = '" . $this->db->escape($data['tax_class_id']) . "', sort_order = '" . (int)$data['sort_order'] . "', date_added = NOW()");
		$this->db->query("INSERT INTO " . DB_PREFIX . "product SET service_id = '" . $query->rows[0]['service_id'] . "', model = '" . $this->db->escape($data['model']) . "', sku = '" . $this->db->escape($data['sku']) . "', upc = '" . $this->db->escape($data['upc']) . "', ean = '" . $this->db->escape($data['ean']) . "', jan = '" . $this->db->escape($data['jan']) . "', isbn = '" . $this->db->escape($data['isbn']) . "', mpn = '" . $this->db->escape($data['mpn']) . "', location = '" . $this->db->escape($data['location']) . "', quantity = '1', minimum = '1', subtract = '0', stock_status_id = '" . (int)$data['stock_status_id'] . "', date_available = '" . $this->db->escape($data['date_available']) . "', broadcaster_id = '" . (int)$data['manufacturer_id'] . "', shipping = '1', price = '" . (float)$data['price'] . "', points = '" . (int)$data['points'] . "', tax_class_id = '" . $this->db->escape($data['tax_class_id']) . "', sort_order = '" . (int)$data['sort_order'] . "' , date_added = '".$data['ppv_duration'][0]["date_start"]."',date_modified='".$data['ppv_duration'][0]["date_end"]."', is_ppv =1, channel_list ='".$query1->rows[0]['name']."'");
			$product_id = $this->db->getLastId();
	foreach ($data['product_description'] as $language_id => $value) {
			$this->db->query("INSERT INTO " . DB_PREFIX . "product_description SET product_id = '" . (int)$product_id . "', language_id = '" . (int)$language_id . "', name = '" . $data['product_description'][1]['name'] . "', meta_keyword = '" . $this->db->escape($value['meta_keyword']) . "', meta_description = '" . $this->db->escape($value['meta_description']) . "', description = '" . $this->db->escape($value['description']) . "', tag = '" . $this->db->escape($value['tag']) . "'");
		}


		//-------------	
		// if (isset($data['product_store'])) {
		// 	foreach ($data['product_store'] as $store_id) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "product_to_store SET product_id = '" . (int)$product_id . "', store_id = 0");
		// 	}
		// }

		if (isset($data['product_attribute'])) {
			foreach ($data['product_attribute'] as $product_attribute) {
				if ($product_attribute['attribute_id']) {
					$this->db->query("DELETE FROM " . DB_PREFIX . "product_attribute WHERE product_id = '" . (int)$product_id . "' AND attribute_id = '" . (int)$product_attribute['attribute_id'] . "'");
					
					foreach ($product_attribute['product_attribute_description'] as $language_id => $product_attribute_description) {				
						$this->db->query("INSERT INTO " . DB_PREFIX . "product_attribute SET product_id = '" . (int)$product_id . "', attribute_id = '" . (int)$product_attribute['attribute_id'] . "', language_id = '" . (int)$language_id . "', text = '" .  $this->db->escape($product_attribute_description['text']) . "'");
					}
				}
			}
		}
	
		if (isset($data['product_option'])) {
			foreach ($data['product_option'] as $product_option) {
				if ($product_option['type'] == 'select' || $product_option['type'] == 'radio' || $product_option['type'] == 'checkbox' || $product_option['type'] == 'image') {
					$this->db->query("INSERT INTO " . DB_PREFIX . "product_option SET product_id = '" . (int)$product_id . "', option_id = '" . (int)$product_option['option_id'] . "', required = '" . (int)$product_option['required'] . "'");
				
					$product_option_id = $this->db->getLastId();
				
					if (isset($product_option['product_option_value']) && count($product_option['product_option_value']) > 0 ) {
						foreach ($product_option['product_option_value'] as $product_option_value) {
							$this->db->query("INSERT INTO " . DB_PREFIX . "product_option_value SET product_option_id = '" . (int)$product_option_id . "', product_id = '" . (int)$product_id . "', option_id = '" . (int)$product_option['option_id'] . "', option_value_id = '" . (int)$product_option_value['option_value_id'] . "', quantity = '1', subtract = '0', price = '" . (float)$product_option_value['price'] . "', price_prefix = '" . $this->db->escape($product_option_value['price_prefix']) . "', points = '" . (int)$product_option_value['points'] . "', points_prefix = '" . $this->db->escape($product_option_value['points_prefix']) . "'");
						} 
					}else{
						$this->db->query("DELETE FROM " . DB_PREFIX . "product_option WHERE product_option_id = '".$product_option_id."'");
					}
				} else { 
					$this->db->query("INSERT INTO " . DB_PREFIX . "product_option SET product_id = '" . (int)$product_id . "', option_id = '" . (int)$product_option['option_id'] . "', option_value = '" . $this->db->escape($product_option['option_value']) . "', required = '" . (int)$product_option['required'] . "'");
				}
			}
		}
		
		if (isset($data['product_discount'])) {
			foreach ($data['product_discount'] as $product_discount) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "product_discount SET product_id = '" . (int)$product_id . "', customer_group_id = '" . (int)$product_discount['customer_group_id'] . "', quantity = '1', priority = '" . (int)$product_discount['priority'] . "', price = '" . (float)$product_discount['price'] . "', date_start = '" . $this->db->escape($product_discount['date_start']) . "', date_end = '" . $this->db->escape($product_discount['date_end']) . "'");
			}
		}

		if (isset($data['product_special'])) {
			foreach ($data['product_special'] as $product_special) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "product_special SET product_id = '" . (int)$product_id . "', customer_group_id = '" . (int)$product_special['customer_group_id'] . "', priority = '" . (int)$product_special['priority'] . "', price = '" . (float)$product_special['price'] . "', date_start = '" . $this->db->escape($product_special['date_start']) . "', date_end = '" . $this->db->escape($product_special['date_end']) . "'");
			}
		}
		
		if (isset($data['product_image'])) {
			foreach ($data['product_image'] as $product_image) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "product_image SET product_id = '" . (int)$product_id . "', image = '" . $this->db->escape(html_entity_decode($product_image['image'], ENT_QUOTES, 'UTF-8')) . "', sort_order = '" . (int)$product_image['sort_order'] . "'");
			}
		}
		
		if (isset($data['product_download'])) {
			foreach ($data['product_download'] as $download_id) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "product_to_download SET product_id = '" . (int)$product_id . "', download_id = '" . (int)$download_id . "'");
			}
		}
		
		if (isset($data['product_category'])) {
			foreach ($data['product_category'] as $category_id) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "product_to_category SET product_id = '" . (int)$product_id . "', category_id = '" . (int)$category_id . "'");
			}
		}
		
		if (isset($data['product_filter'])) {
			foreach ($data['product_filter'] as $filter_id) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "product_filter SET product_id = '" . (int)$product_id . "', filter_id = '" . (int)$filter_id . "'");
			}
		}
		
		if (isset($data['product_related'])) {
			foreach ($data['product_related'] as $related_id) {
				$this->db->query("DELETE FROM " . DB_PREFIX . "product_related WHERE product_id = '" . (int)$product_id . "' AND related_id = '" . (int)$related_id . "'");
				$this->db->query("INSERT INTO " . DB_PREFIX . "product_related SET product_id = '" . (int)$product_id . "', related_id = '" . (int)$related_id . "'");
				$this->db->query("DELETE FROM " . DB_PREFIX . "product_related WHERE product_id = '" . (int)$related_id . "' AND related_id = '" . (int)$product_id . "'");
				$this->db->query("INSERT INTO " . DB_PREFIX . "product_related SET product_id = '" . (int)$related_id . "', related_id = '" . (int)$product_id . "'");
			}
		}

		if (isset($data['product_reward'])) {
			foreach ($data['product_reward'] as $customer_group_id => $product_reward) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "product_reward SET product_id = '" . (int)$product_id . "', customer_group_id = '" . (int)$customer_group_id . "', points = '" . (int)$product_reward['points'] . "'");
			}
		}

		if (isset($data['product_layout'])) {
			foreach ($data['product_layout'] as $store_id => $layout) {
				if ($layout['layout_id']) {
					$this->db->query("INSERT INTO " . DB_PREFIX . "product_to_layout SET product_id = '" . (int)$product_id . "', store_id = '" . (int)$store_id . "', layout_id = '" . (int)$layout['layout_id'] . "'");
				}
			}
		}
						
		if ($data['keyword']) {
			$this->db->query("INSERT INTO " . DB_PREFIX . "url_alias SET query = 'product_id=" . (int)$product_id . "', keyword = '" . $this->db->escape($data['keyword']) . "'");
		}
						
		$this->cache->delete('product');
	}
/*
FUNCTION NAME 		-	getProductName
DESCRIPTION 		-	Retrieves all the product related data for the given product_id
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Retruns an array with the related ids.
*/
	public function getProductName($data) {
		$query = $this->db->query("SELECT name FROM `oc_product_description` WHERE product_id = '".(int)$this->db->escape($data)."'");
		return $query->row;
	}
/*
FUNCTION NAME 		-	getProductName
DESCRIPTION 		-	Retrieves all the product related data for the given product_id
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Retruns an array with the related ids.
*/
	public function getProductDetails($data) {
		$query = $this->db->query("SELECT image,service_id,status FROM `oc_product` WHERE product_id = '".(int)$this->db->escape($data)."'");
		return $query->row;
	}
/*
FUNCTION NAME 		-	editProduct
DESCRIPTION 		-	Updates channel details for the selected product_id.
INPUT PARAMETER 	-	product_id, channel details as an array
OUTPUT PARAMETER 	- 	Adds detail to the database and returns to the channel list page with a success notification
*/	
	public function editProduct($product_id,$data) {
		$this->db->query("UPDATE " . DB_PREFIX . "product SET  price = '" . (float)$data['price'] . "',date_added='".$data["ppv_duration"][0]["date_start"]."',  date_modified = '".$data["ppv_duration"][0]["date_end"]."',is_ppv = 1 WHERE product_id = '" . (int)$product_id . "'");

		if (isset($data['image'])) {
			$this->db->query("UPDATE " . DB_PREFIX . "product SET image = '" . $this->db->escape(html_entity_decode($data['image'], ENT_QUOTES, 'UTF-8')) . "' WHERE product_id = '" . (int)$product_id . "'");
		}
		
		$this->db->query("DELETE FROM " . DB_PREFIX . "product_description WHERE product_id = '" . (int)$product_id . "'");
		
		foreach ($data['product_description'] as $language_id => $value) {
			$this->db->query("INSERT INTO " . DB_PREFIX . "product_description SET product_id = '" . (int)$product_id . "', language_id = '" . (int)$language_id . "', name = '" . $this->db->escape($value['name']) . "', meta_keyword = '" . $this->db->escape($value['meta_keyword']) . "', meta_description = '" . $this->db->escape($value['meta_description']) . "', description = '" . $this->db->escape($value['description']) . "', tag = '" . $this->db->escape($value['tag']) . "'");
		}

		$this->db->query("DELETE FROM " . DB_PREFIX . "product_to_store WHERE product_id = '" . (int)$product_id . "'");

		// if (isset($data['product_store'])) {
		// 	foreach ($data['product_store'] as $store_id) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "product_to_store SET product_id = '" . (int)$product_id . "', store_id =0");
		// 	}
		// }
	
		$this->db->query("DELETE FROM " . DB_PREFIX . "product_attribute WHERE product_id = '" . (int)$product_id . "'");

		if (!empty($data['product_attribute'])) {
			foreach ($data['product_attribute'] as $product_attribute) {
				if ($product_attribute['attribute_id']) {
					$this->db->query("DELETE FROM " . DB_PREFIX . "product_attribute WHERE product_id = '" . (int)$product_id . "' AND attribute_id = '" . (int)$product_attribute['attribute_id'] . "'");
					
					foreach ($product_attribute['product_attribute_description'] as $language_id => $product_attribute_description) {				
						$this->db->query("INSERT INTO " . DB_PREFIX . "product_attribute SET product_id = '" . (int)$product_id . "', attribute_id = '" . (int)$product_attribute['attribute_id'] . "', language_id = '" . (int)$language_id . "', text = '" .  $this->db->escape($product_attribute_description['text']) . "'");
					}
				}
			}
		}

	// 	$this->db->query("DELETE FROM " . DB_PREFIX . "product_option WHERE product_id = '" . (int)$product_id . "'");
	// 	$this->db->query("DELETE FROM " . DB_PREFIX . "product_option_value WHERE product_id = '" . (int)$product_id . "'");
		
	// 	if (isset($data['product_option'])) {
	// 		foreach ($data['product_option'] as $product_option) {
	// 			if ($product_option['type'] == 'select' || $product_option['type'] == 'radio' || $product_option['type'] == 'checkbox' || $product_option['type'] == 'image') {
	// 				$this->db->query("INSERT INTO " . DB_PREFIX . "product_option SET product_option_id = '" . (int)$product_option['product_option_id'] . "', product_id = '" . (int)$product_id . "', option_id = '" . (int)$product_option['option_id'] . "', required = '" . (int)$product_option['required'] . "'");
				
	// 				$product_option_id = $this->db->getLastId();
				
	// 				if (isset($product_option['product_option_value'])  && count($product_option['product_option_value']) > 0 ) {
	// 					foreach ($product_option['product_option_value'] as $product_option_value) {
	// 						$this->db->query("INSERT INTO " . DB_PREFIX . "product_option_value SET product_option_value_id = '" . (int)$product_option_value['product_option_value_id'] . "', product_option_id = '" . (int)$product_option_id . "', product_id = '" . (int)$product_id . "', option_id = '" . (int)$product_option['option_id'] . "', option_value_id = '" . (int)$product_option_value['option_value_id'] . "', quantity = '1', subtract = '0', price = '" . (float)$product_option_value['price'] . "', price_prefix = '" . $this->db->escape($product_option_value['price_prefix']) . "', points = '" . (int)$product_option_value['points'] . "', points_prefix = '" . $this->db->escape($product_option_value['points_prefix']) . "'");
	// 					}
	// 				}else{
	// 					$this->db->query("DELETE FROM " . DB_PREFIX . "product_option WHERE product_option_id = '".$product_option_id."'");
	// 				}
	// 			} else { 
	// 				$this->db->query("INSERT INTO " . DB_PREFIX . "product_option SET product_option_id = '" . (int)$product_option['product_option_id'] . "', product_id = '" . (int)$product_id . "', option_id = '" . (int)$product_option['option_id'] . "', option_value = '" . $this->db->escape($product_option['option_value']) . "', required = '" . (int)$product_option['required'] . "'");
	// 			}					
	// 		}
	// 	}
		
	 	$this->db->query("DELETE FROM " . DB_PREFIX . "product_discount WHERE product_id = '" . (int)$product_id . "'");
 
		if (isset($data['product_discount'])) {
			foreach ($data['product_discount'] as $product_discount) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "product_discount SET product_id = '" . (int)$product_id . "', customer_group_id = '" . (int)$product_discount['customer_group_id'] . "', quantity = '1', priority = '" . (int)$product_discount['priority'] . "', price = '" . (float)$product_discount['price'] . "', date_start = '" . $this->db->escape($product_discount['date_start']) . "', date_end = '" . $this->db->escape($product_discount['date_end']) . "'");
			}
		}
		
		$this->db->query("DELETE FROM " . DB_PREFIX . "product_special WHERE product_id = '" . (int)$product_id . "'");
		
		if (isset($data['product_special'])) {
			foreach ($data['product_special'] as $product_special) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "product_special SET product_id = '" . (int)$product_id . "', customer_group_id = '" . (int)$product_special['customer_group_id'] . "', priority = '" . (int)$product_special['priority'] . "', price = '" . (float)$product_special['price'] . "', date_start = '" . $this->db->escape($product_special['date_start']) . "', date_end = '" . $this->db->escape($product_special['date_end']) . "'");
			}
		}
		
		$this->db->query("DELETE FROM " . DB_PREFIX . "product_image WHERE product_id = '" . (int)$product_id . "'");
		
		if (isset($data['product_image'])) {
			foreach ($data['product_image'] as $product_image) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "product_image SET product_id = '" . (int)$product_id . "', image = '" . $this->db->escape(html_entity_decode($product_image['image'], ENT_QUOTES, 'UTF-8')) . "', sort_order = '" . (int)$product_image['sort_order'] . "'");
			}
		}
		
		$this->db->query("DELETE FROM " . DB_PREFIX . "product_to_download WHERE product_id = '" . (int)$product_id . "'");
		
		if (isset($data['product_download'])) {
			foreach ($data['product_download'] as $download_id) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "product_to_download SET product_id = '" . (int)$product_id . "', download_id = '" . (int)$download_id . "'");
			}
		}
		
		$this->db->query("DELETE FROM " . DB_PREFIX . "product_to_category WHERE product_id = '" . (int)$product_id . "'");
		
		if (isset($data['product_category'])) {
			foreach ($data['product_category'] as $category_id) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "product_to_category SET product_id = '" . (int)$product_id . "', category_id = '" . (int)$category_id . "'");
			}		
		}
		
		$this->db->query("DELETE FROM " . DB_PREFIX . "product_filter WHERE product_id = '" . (int)$product_id . "'");
		
		if (isset($data['product_filter'])) {
			foreach ($data['product_filter'] as $filter_id) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "product_filter SET product_id = '" . (int)$product_id . "', filter_id = '" . (int)$filter_id . "'");
			}		
		}
		
		$this->db->query("DELETE FROM " . DB_PREFIX . "product_related WHERE product_id = '" . (int)$product_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "product_related WHERE related_id = '" . (int)$product_id . "'");

		if (isset($data['product_related'])) {
			foreach ($data['product_related'] as $related_id) {
				$this->db->query("DELETE FROM " . DB_PREFIX . "product_related WHERE product_id = '" . (int)$product_id . "' AND related_id = '" . (int)$related_id . "'");
				$this->db->query("INSERT INTO " . DB_PREFIX . "product_related SET product_id = '" . (int)$product_id . "', related_id = '" . (int)$related_id . "'");
				$this->db->query("DELETE FROM " . DB_PREFIX . "product_related WHERE product_id = '" . (int)$related_id . "' AND related_id = '" . (int)$product_id . "'");
				$this->db->query("INSERT INTO " . DB_PREFIX . "product_related SET product_id = '" . (int)$related_id . "', related_id = '" . (int)$product_id . "'");
			}
		}
		
		$this->db->query("DELETE FROM " . DB_PREFIX . "product_reward WHERE product_id = '" . (int)$product_id . "'");

		if (isset($data['product_reward'])) {
			foreach ($data['product_reward'] as $customer_group_id => $value) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "product_reward SET product_id = '" . (int)$product_id . "', customer_group_id = '" . (int)$customer_group_id . "', points = '" . (int)$value['points'] . "'");
			}
		}

		$this->db->query("DELETE FROM " . DB_PREFIX . "product_to_layout WHERE product_id = '" . (int)$product_id . "'");

		if (isset($data['product_layout'])) {
			foreach ($data['product_layout'] as $store_id => $layout) {
				if ($layout['layout_id']) {
					$this->db->query("INSERT INTO " . DB_PREFIX . "product_to_layout SET product_id = '" . (int)$product_id . "', store_id = '" . (int)$store_id . "', layout_id = '" . (int)$layout['layout_id'] . "'");
				}
			}
		}
						
		$this->db->query("DELETE FROM " . DB_PREFIX . "url_alias WHERE query = 'product_id=" . (int)$product_id. "'");
		
		if ($data['keyword']) {
			$this->db->query("INSERT INTO " . DB_PREFIX . "url_alias SET query = 'product_id=" . (int)$product_id . "', keyword = '" . $this->db->escape($data['keyword']) . "'");
		}
						
		$this->cache->delete('product');
	}
/*
FUNCTION NAME 		-	copyProduct
DESCRIPTION 		-	Copies the given channel details to a new channel and open the addChannel form.
INPUT PARAMETER 	-	product_id
OUTPUT PARAMETER 	- 	Fill the addChannel form with the copied details
*/	
	public function copyProduct($product_id) {
		$query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "product p LEFT JOIN " . DB_PREFIX . "product_description pd ON (p.product_id = pd.product_id) WHERE p.product_id = '" . (int)$product_id . "' AND pd.language_id = '" . (int)$this->config->get('config_language_id') . "'");
		
		if ($query->num_rows) {
			$data = array();
			
			$data = $query->row;
			
			$data['sku'] = '';
			$data['upc'] = '';
			$data['viewed'] = '0';
			$data['keyword'] = '';
			$data['status'] = '0';
						
			$data = array_merge($data, array('product_attribute' => $this->getProductAttributes($product_id)));
			$data = array_merge($data, array('product_description' => $this->getProductDescriptions($product_id)));			
			$data = array_merge($data, array('product_discount' => $this->getProductDiscounts($product_id)));
			$data = array_merge($data, array('product_filter' => $this->getProductFilters($product_id)));
			$data = array_merge($data, array('product_image' => $this->getProductImages($product_id)));		
			$data = array_merge($data, array('product_option' => $this->getProductOptions($product_id)));
			$data = array_merge($data, array('product_related' => $this->getProductRelated($product_id)));
			$data = array_merge($data, array('product_reward' => $this->getProductRewards($product_id)));
			$data = array_merge($data, array('product_special' => $this->getProductSpecials($product_id)));
			$data = array_merge($data, array('product_category' => $this->getProductCategories($product_id)));
			$data = array_merge($data, array('product_download' => $this->getProductDownloads($product_id)));
			$data = array_merge($data, array('product_layout' => $this->getProductLayouts($product_id)));
			$data = array_merge($data, array('product_store' => $this->getProductStores($product_id)));
			
			$this->addProduct($data);
		}
	}
/*
FUNCTION NAME 		-	deleteProduct
DESCRIPTION 		-	Deletes channel detail form the database for the selected product_id.
INPUT PARAMETER 	-	product_id
OUTPUT PARAMETER 	- 	Deletes detail from the database and returns to the channel list page with a success notification
*/	
	public function deleteProduct($product_id) {
		//$list=explode("~",$event_deatails);
		$this->db->query("DELETE FROM " . DB_PREFIX . "sms_kms_product WHERE product_id = '" . (int)$product_id . "' AND is_ppv=1");
		$this->db->query("DELETE FROM " . DB_PREFIX . "product WHERE product_id = '" . (int)$product_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "product_attribute WHERE product_id = '" . (int)$product_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "product_description WHERE product_id = '" . (int)$product_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "product_discount WHERE product_id = '" . (int)$product_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "product_filter WHERE product_id = '" . (int)$product_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "product_image WHERE product_id = '" . (int)$product_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "product_option WHERE product_id = '" . (int)$product_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "product_option_value WHERE product_id = '" . (int)$product_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "product_related WHERE product_id = '" . (int)$product_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "product_related WHERE related_id = '" . (int)$product_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "product_reward WHERE product_id = '" . (int)$product_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "product_special WHERE product_id = '" . (int)$product_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "product_to_category WHERE product_id = '" . (int)$product_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "product_to_download WHERE product_id = '" . (int)$product_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "product_to_layout WHERE product_id = '" . (int)$product_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "product_to_store WHERE product_id = '" . (int)$product_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "review WHERE product_id = '" . (int)$product_id . "'");
		
		$this->db->query("DELETE FROM " . DB_PREFIX . "url_alias WHERE query = 'product_id=" . (int)$product_id. "'");
		
		$this->cache->delete('product');
	}
/*
FUNCTION NAME 		-	getProduct
DESCRIPTION 		-	Retrieves channel details from the database based on the given product_id.
INPUT PARAMETER 	-	product_id
OUTPUT PARAMETER 	- 	Retruns a row queried containing details of the channel.
*/	
	public function getProduct($product_id) {
		$query = $this->db->query("SELECT DISTINCT *, (SELECT keyword FROM " . DB_PREFIX . "url_alias WHERE query = 'product_id=" . (int)$product_id . "') AS keyword FROM " . DB_PREFIX . "product p LEFT JOIN " . DB_PREFIX . "product_description pd ON (p.product_id = pd.product_id) WHERE p.product_id = '" . (int)$product_id . "' AND pd.language_id = '" . (int)$this->config->get('config_language_id') . "'");
		// $query	= $this->db->query("SELECT * from oc_ppv");	
		return $query->row;
	}
	public function getPpvDuration($product_id) {
		$query = $this->db->query("SELECT * " . DB_PREFIX . "product WHERE product_id= '".$product_id."'");
		// $query	= $this->db->query("SELECT * from oc_ppv");	
		return $query->row;
	}
	//getPpvDuration
//------------
/*
FUNCTION NAME 		-	getProductOptionsExit
DESCRIPTION 		-	Retrieves option details from the database based on the given product_id.
INPUT PARAMETER 	-	product_id
OUTPUT PARAMETER 	- 	Retruns a row queried containing details of the subscription options.
*/	
	public function getProductOptionsExit($product_id) {
		$query = $this->db->query("SELECT  `option_value_id` 
									FROM  `oc_product_option_value` 
														WHERE  `product_id` ='".$product_id."' LIMIT 0,5 ");
				
		return $query->rows;
	}
//------------	
/*
FUNCTION NAME 		-	getCustomerGroups
DESCRIPTION 		-	Retrieves all the customer_groups
INPUT PARAMETER 	-	data array conatining filter options if any
OUTPUT PARAMETER 	- 	Returns all the rows retrieved.
*/			
	public function getPpvChannel($data = array()) {
	// 	// $sql = "SELECT * FROM " . DB_PREFIX . "customer_group cg LEFT JOIN " . DB_PREFIX . "customer_group_description cgd ON (cg.customer_group_id = cgd.customer_group_id) WHERE cgd.language_id = '" . (int)$this->config->get('config_language_id') . "'";
		$sql = "SELECT * FROM " . DB_PREFIX . "product p LEFT JOIN " . DB_PREFIX . "product_description pd ON (p.product_id = pd.product_id) WHERE p.is_package =0 AND p.is_nvod = 0";
		$sort_data = array(
			'pd.name',
			'p.sort_order'
		);	
		if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
			$sql .= " ORDER BY " . $data['sort'];	
		} else {
			$sql .= " ORDER BY p.product_id";	
		}
			
		if (isset($data['order']) && ($data['order'] == 'DESC')) {
			$sql .= " DESC";
		} else {
			$sql .= " ASC";
		}
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}			

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
			
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}
			
		$query = $this->db->query($sql);
		
		return $query->rows;
	}


/*
FUNCTION NAME 		-	getProducts
DESCRIPTION 		-	Retrieves all the channels from the database. 
INPUT PARAMETER 	-	data array for filter options if any.
OUTPUT PARAMETER 	- 	Returns all the rows queried, containing channel details.
*/		
	public function getProducts($data = array()) {
		$sql = "SELECT * FROM " . DB_PREFIX . "product p LEFT JOIN " . DB_PREFIX . "product_description pd ON (p.product_id = pd.product_id) where is_ppv=1";
			$sql .= " GROUP BY p.product_id";
		$sort_data = array(
			'pd.name',
			'p.model',
			'p.service_id',
			'p.price',
			'p.quantity',
			'p.status',
			'p.sort_order'
		);	
		
		if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
			$sql .= " ORDER BY " . $data['sort'];	
		} else {
			$sql .= " ORDER BY pd.name";	
		}
		
		if (isset($data['order']) && ($data['order'] == 'DESC')) {
			$sql .= " DESC";
		} else {
			$sql .= " ASC";
		}
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}				

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
		
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}
		// if(now()<date_added)
		$query = $this->db->query($sql);
		
		return $query->rows;
	}
//--------------------------------------------------
/*
FUNCTION NAME 		-	getProducts
DESCRIPTION 		-	Retrieves all the channels from the database. 
INPUT PARAMETER 	-	data array for filter options if any.
OUTPUT PARAMETER 	- 	Returns all the rows queried, containing channel details.
*/		
	public function getProductAndPackages($data = array()) {
		$sql = "SELECT * FROM " . DB_PREFIX . "product p LEFT JOIN " . DB_PREFIX . "product_description pd ON (p.product_id = pd.product_id)";
		
		if (!empty($data['filter_category_id'])) {
			$sql .= " LEFT JOIN " . DB_PREFIX . "product_to_category p2c ON (p.product_id = p2c.product_id)";			
		}
				
		$sql .= " WHERE pd.language_id = '" . (int)$this->config->get('config_language_id') . "'"; 
		
		if (!empty($data['filter_name'])) {
			$sql .= " AND pd.name LIKE '" . $this->db->escape($data['filter_name']) . "%'";
		}

		if (!empty($data['filter_model'])) {
			$sql .= " AND p.model LIKE '" . $this->db->escape($data['filter_model']) . "%'";
		}

		if (!empty($data['filter_service_id'])) {
			$sql .= " AND p.service_id LIKE '" . $this->db->escape($data['filter_service_id']) . "%'";
		}
		
		if (!empty($data['filter_price'])) {
			$sql .= " AND p.price LIKE '" . $this->db->escape($data['filter_price']) . "%'";
		}
		
		if (isset($data['filter_quantity']) && !is_null($data['filter_quantity'])) {
			$sql .= " AND p.quantity = '" . $this->db->escape($data['filter_quantity']) . "'";
		}
		
		if (isset($data['filter_status']) && !is_null($data['filter_status'])) {
			$sql .= " AND p.status = '" . (int)$data['filter_status'] . "'";
		}
		
		$sql .= " GROUP BY p.product_id";
					
		$sort_data = array(
			'pd.name',
			'p.model',
			'p.service_id',
			'p.price',
			'p.quantity',
			'p.status',
			'p.sort_order'
		);	
		
		if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
			$sql .= " ORDER BY " . $data['sort'];	
		} else {
			$sql .= " ORDER BY pd.name";	
		}
		
		if (isset($data['order']) && ($data['order'] == 'DESC')) {
			$sql .= " DESC";
		} else {
			$sql .= " ASC";
		}
	
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}				

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
		
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}	
		
		$query = $this->db->query($sql);
	
		return $query->rows;
	}
//--------------------------------------------------
/*
FUNCTION NAME 		-	getProductsByCategoryId
DESCRIPTION 		-	Retrieves number of channels in the given category_id
INPUT PARAMETER 	-	category_id
OUTPUT PARAMETER 	- 	Returns a column "total" containing the count of channels in the selected category id.
*/		
	public function getProductsByCategoryId($category_id) {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product p LEFT JOIN " . DB_PREFIX . "product_description pd ON (p.product_id = pd.product_id) LEFT JOIN " . DB_PREFIX . "product_to_category p2c ON (p.product_id = p2c.product_id) WHERE pd.language_id = '" . (int)$this->config->get('config_language_id') . "' AND p2c.category_id = '" . (int)$category_id . "' ORDER BY pd.name ASC");
								  
		return $query->rows;
	} 

//----
	/*
FUNCTION NAME 		-	getPpvByChannel
DESCRIPTION 		-	Retrieves number of channels in the given category_id
INPUT PARAMETER 	-	category_id
OUTPUT PARAMETER 	- 	Returns a column "total" containing the count of channels in the selected category id.
*/		
	public function getPpvByChannel($ppv_name) {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product p LEFT JOIN " . DB_PREFIX . "product_description pd ON (p.product_id = pd.product_id)  WHERE pd.name='".$ppv_name."' ");
		return $query->row;
	} 
		/*
FUNCTION NAME 		-	getProductApiId
DESCRIPTION 		-	Retrieves number of channels in the given category_id
INPUT PARAMETER 	-	category_id
OUTPUT PARAMETER 	- 	Returns a column "total" containing the count of channels in the selected category id.
*/		
	public function getProductApiId($product_name) {
		$query = $this->db->query("SELECT api_product_id FROM " . DB_PREFIX . "product_description pd LEFT JOIN " . DB_PREFIX . "sms_kms_product ps ON (pd.product_id = ps.product_id)  WHERE pd.name='".$product_name."'");
								  
		return $query->row;
	} 

//----
/*
FUNCTION NAME 		-	getProductDescriptions
DESCRIPTION 		-	Retrieves the description for the given product_id
INPUT PARAMETER 	-	product_id
OUTPUT PARAMETER 	- 	Retruns an array conatining the channel description
*/		
	public function getProductDescriptions($product_id) {
		$product_description_data = array();
		
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_description WHERE product_id = '" . (int)$product_id . "'");
		
		foreach ($query->rows as $result) {
			$product_description_data[$result['language_id']] = array(
				'name'             => $result['name'],
				'description'      => $result['description'],
				'meta_keyword'     => $result['meta_keyword'],
				'meta_description' => $result['meta_description'],
				'tag'              => $result['tag']
			);
		}
		
		return $product_description_data;
	}
/*
FUNCTION NAME 		-	getProductCategories
DESCRIPTION 		-	Retrieves the categories for the given product_id
INPUT PARAMETER 	-	product_id
OUTPUT PARAMETER 	- 	Retruns an array conatining the category id assigned
*/		
	public function getProductCategories($product_id) {
		$product_category_data = array();
		
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_to_category WHERE product_id = '" . (int)$product_id . "'");
		
		foreach ($query->rows as $result) {
			$product_category_data[] = $result['category_id'];
		}

		return $product_category_data;
	}
/*
FUNCTION NAME 		-	getProductFilters
DESCRIPTION 		-	Retrieves the filters that can be applied for the given product_id
INPUT PARAMETER 	-	product_id
OUTPUT PARAMETER 	- 	Retruns an array conatining the filter id assigned
*/	
	public function getProductFilters($product_id) {
		$product_filter_data = array();
		
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_filter WHERE product_id = '" . (int)$product_id . "'");
		
		foreach ($query->rows as $result) {
			$product_filter_data[] = $result['filter_id'];
		}
				
		return $product_filter_data;
	}
/*
FUNCTION NAME 		-	getProductAttributes
DESCRIPTION 		-	Retrieves the attributes that are added for the given product_id
INPUT PARAMETER 	-	product_id
OUTPUT PARAMETER 	- 	Retruns an array containing the attribute id and attribute description assigned
*/
	public function getProductAttributes($product_id) {
		$product_attribute_data = array();
		
		$product_attribute_query = $this->db->query("SELECT attribute_id FROM " . DB_PREFIX . "product_attribute WHERE product_id = '" . (int)$product_id . "' GROUP BY attribute_id");
		
		foreach ($product_attribute_query->rows as $product_attribute) {
			$product_attribute_description_data = array();
			
			$product_attribute_description_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_attribute WHERE product_id = '" . (int)$product_id . "' AND attribute_id = '" . (int)$product_attribute['attribute_id'] . "'");
			
			foreach ($product_attribute_description_query->rows as $product_attribute_description) {
				$product_attribute_description_data[$product_attribute_description['language_id']] = array('text' => $product_attribute_description['text']);
			}
			
			$product_attribute_data[] = array(
				'attribute_id'                  => $product_attribute['attribute_id'],
				'product_attribute_description' => $product_attribute_description_data
			);
		}
		
		return $product_attribute_data;
	}
/*
FUNCTION NAME 		-	getProductOptions
DESCRIPTION 		-	Retrieves the options applied for the given product_id
INPUT PARAMETER 	-	product_id
OUTPUT PARAMETER 	- 	Retruns an array containing channel option details.
*/	
	public function getProductOptions($product_id) {
		$product_option_data = array();
		
		$product_option_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_option WHERE product_id = '" . (int)$product_id . "'");
		
		foreach ($product_option_query->rows as $product_option) {
			$product_option_value_data = array();	
				
			$product_option_value_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_option_value WHERE product_option_id = '" . (int)$product_option['product_option_id'] . "'");
				
			foreach ($product_option_value_query->rows as $product_option_value) {
				$product_option_value_data[] = array(
					'product_option_value_id' => $product_option_value['product_option_value_id'],
					'option_value_id'         => $product_option_value['option_value_id'],
					'quantity'                => $product_option_value['quantity'],
					'subtract'                => $product_option_value['subtract'],
					'price'                   => $product_option_value['price'],
					'price_prefix'            => $product_option_value['price_prefix'],
					'points'                  => $product_option_value['points'],
					'points_prefix'           => $product_option_value['points_prefix'],						
					'weight'                  => $product_option_value['weight'],
					'weight_prefix'           => $product_option_value['weight_prefix']					
				);
			}
				
			$product_option_data[] = array(
				'product_option_id'    => $product_option['product_option_id'],
				'option_id'            => $product_option['option_id'],
				'product_option_value' => $product_option_value_data,
				'option_value'         => $product_option['option_value'],
				'required'             => $product_option['required']				
			);
		}
		
		return $product_option_data;
	}
/*
FUNCTION NAME 		-	getProductImages
DESCRIPTION 		-	Retrieves the image added for the given product_id
INPUT PARAMETER 	-	product_id
OUTPUT PARAMETER 	- 	Retruns all the rows matched with the product_id
*/				
	public function getProductImages($product_id) {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_image WHERE product_id = '" . (int)$product_id . "'");
		
		return $query->rows;
	}
/*
FUNCTION NAME 		-	getProductDiscounts
DESCRIPTION 		-	Retrieves all the discounts matching the given product_id
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Retruns all the rows retrieved.
*/	
	public function getProductDiscounts($product_id) {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_discount WHERE product_id = '" . (int)$product_id . "' ORDER BY quantity, priority, price");
		
		return $query->rows;
	}
/*
FUNCTION NAME 		-	getProductSpecials
DESCRIPTION 		-	Retrieves all the special offers matching the given product_id
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Retruns all the rows retrieved.
*/		
	public function getProductSpecials($product_id) {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_special WHERE product_id = '" . (int)$product_id . "' ORDER BY priority, price");
		
		return $query->rows;
	}
/*
FUNCTION NAME 		-	getProductRewards
DESCRIPTION 		-	Retrieves all the rewards points for the given product_id
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Retruns an array assigned with the reward points.
*/		
	public function getProductRewards($product_id) {
		$product_reward_data = array();
		
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_reward WHERE product_id = '" . (int)$product_id . "'");
		
		foreach ($query->rows as $result) {
			$product_reward_data[$result['customer_group_id']] = array('points' => $result['points']);
		}
		
		return $product_reward_data;
	}
/*
FUNCTION NAME 		-	getProductDownloads
DESCRIPTION 		-	Retrieves all the download available for the given product_id
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Retruns all the download ids matched.
*/			
	public function getProductDownloads($product_id) {
		$product_download_data = array();
		
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_to_download WHERE product_id = '" . (int)$product_id . "'");
		
		foreach ($query->rows as $result) {
			$product_download_data[] = $result['download_id'];
		}
		
		return $product_download_data;
	}
/*
FUNCTION NAME 		-	getProductStores
DESCRIPTION 		-	Retrieves all the stores in which the given product_id is added.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Retruns all the rows containing the store id.
*/
	public function getProductStores($product_id) {
		$product_store_data = array();
		
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_to_store WHERE product_id = '" . (int)$product_id . "'");

		foreach ($query->rows as $result) {
			$product_store_data[] = $result['store_id'];
		}
		
		return $product_store_data;
	}
/*
FUNCTION NAME 		-	getProductLayouts
DESCRIPTION 		-	Retrieves layout that is assigned to the given product_id
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Retruns an array with the layout ids.
*/
	public function getProductLayouts($product_id) {
		$product_layout_data = array();
		
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_to_layout WHERE product_id = '" . (int)$product_id . "'");
		
		foreach ($query->rows as $result) {
			$product_layout_data[$result['store_id']] = $result['layout_id'];
		}
		
		return $product_layout_data;
	}
	
/*
FUNCTION NAME 		-	getProductRelated
DESCRIPTION 		-	Retrieves all the product related data for the given product_id
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Retruns an array with the related ids.
*/
	public function getProductRelated($product_id) {
		$query = $this->db->query("SELECT pd.name,pd.product_id FROM " . DB_PREFIX . "product p LEFT JOIN " . DB_PREFIX . "product_description pd ON (p.product_id = pd.product_id) WHERE p.is_package =0 AND p.is_ppv =0 AND p.status=1 AND p.is_nvod = 0 GROUP BY pd.product_id");
		return $query->rows;
		// $product_related_data = array();
		
		// $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_related WHERE product_id = '" . (int)$product_id . "'");
		
		// foreach ($query->rows as $result) {
		// 	$product_related_data[] = $result['related_id'];
		// }
		
		// return $product_related_data;
	}
/*
FUNCTION NAME 		-	getTotalProducts
DESCRIPTION 		-	Retrieves the count for the total number of proudcts/packages.
INPUT PARAMETER 	-	data array for filter options if any.
OUTPUT PARAMETER 	- 	Returns a column "total" containing the count for packages.
*/	
	public function getTotalProducts($data = array()) {
		$sql = "SELECT COUNT(DISTINCT p.product_id) AS total FROM " . DB_PREFIX . "product p LEFT JOIN " . DB_PREFIX . "product_description pd ON (p.product_id = pd.product_id) WHERE is_ppv=1";
		$query = $this->db->query($sql);
		return $query->row['total'];
	}	
/*
FUNCTION NAME 		-	getTotalProductsByTaxClassId
DESCRIPTION 		-	Retrieves the the count for the number of rows matching tax_class_id
INPUT PARAMETER 	-	tax_class_id
OUTPUT PARAMETER 	- 	Returns a column "total" containing the count of rows matched
*/	
	public function getTotalProductsByTaxClassId($tax_class_id) {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "product WHERE tax_class_id = '" . (int)$tax_class_id . "'");
		return $query->row['total'];
	}
/*
FUNCTION NAME 		-	getTotalProductsByStockStatusId
DESCRIPTION 		-	Retrieves the the count for the number of rows matching stock_status_id
INPUT PARAMETER 	-	stock_status_id
OUTPUT PARAMETER 	- 	Returns a column "total" containing the count of rows matched.
*/		
	public function getTotalProductsByStockStatusId($stock_status_id) {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "product WHERE stock_status_id = '" . (int)$stock_status_id . "'");

		return $query->row['total'];
	}
/*
				NOT IN USE
*/	
	public function getTotalProductsByWeightClassId($weight_class_id) {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "product WHERE weight_class_id = '" . (int)$weight_class_id . "'");

		return $query->row['total'];
	}
/*
				NOT IN USE
*/	
	public function getTotalProductsByLengthClassId($length_class_id) {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "product WHERE length_class_id = '" . (int)$length_class_id . "'");

		return $query->row['total'];
	}
/*
FUNCTION NAME 		-	getTotalProductsByDownloadId
DESCRIPTION 		-	Retrieves the rows containing the count of rows matching download_id
INPUT PARAMETER 	-	download_id
OUTPUT PARAMETER 	- 	Returns a column "total" containing the count of rows matched
*/
	public function getTotalProductsByDownloadId($download_id) {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "product_to_download WHERE download_id = '" . (int)$download_id . "'");
		
		return $query->row['total'];
	}
/*
FUNCTION NAME 		-	getTotalProductsByManufacturerId
DESCRIPTION 		-	Retrieves the rows containing the count of rows matching manufacturer_id
INPUT PARAMETER 	-	manufacturer_id
OUTPUT PARAMETER 	- 	Returns a column "total" containing the count of rows matched
*/		
	public function getTotalProductsByManufacturerId($manufacturer_id) {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "product WHERE broadcaster_id = '" . (int)$manufacturer_id . "'");

		return $query->row['total'];
	}
/*
FUNCTION NAME 		-	getTotalProductsByAttributeId
DESCRIPTION 		-	Retrieves the rows containing the count of rows matching attribute_id
INPUT PARAMETER 	-	attribute_id
OUTPUT PARAMETER 	- 	Returns a column "total" containing the count of rows matched
*/	
	public function getTotalProductsByAttributeId($attribute_id) {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "product_attribute WHERE attribute_id = '" . (int)$attribute_id . "'");

		return $query->row['total'];
	}	
/*
FUNCTION NAME 		-	getTotalProductsByOptionId
DESCRIPTION 		-	Retrieves the rows containing the count of rows matching option_id
INPUT PARAMETER 	-	option_id
OUTPUT PARAMETER 	- 	Returns a column "total" containing the count of rows matched
*/	
	public function getTotalProductsByOptionId($option_id) {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "product_option WHERE option_id = '" . (int)$option_id . "'");

		return $query->row['total'];
	}	
/*
FUNCTION NAME 		-	getTotalProductsByLayoutId
DESCRIPTION 		-	Retrieves the rows containing the count of rows matching layout_id
INPUT PARAMETER 	-	layout_id
OUTPUT PARAMETER 	- 	Returns a column "total" containing the count of rows matched
*/	
	public function getTotalProductsByLayoutId($layout_id) {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "product_to_layout WHERE layout_id = '" . (int)$layout_id . "'");

		return $query->row['total'];
	}
/*
FUNCTION NAME 		-	getCategory
DESCRIPTION 		-	Retrieves the rows containing the count of rows matching product_id
						in product_to_category table.
INPUT PARAMETER 	-	product_id
OUTPUT PARAMETER 	- 	Returns a column "total" containing the count of rows matched
*/	
	public function getCategory($product_id){
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "product_to_category WHERE product_id = '" . (int)$product_id . "'");

		return $query->row['total'];

	}

	public function CheckChannelNo($channel_no){
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product WHERE model = '" . (int)$channel_no . "'");

		return $query->row;
	}

	public function CheckServiceId($service_id)
	{
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product WHERE service_id = '" . (int)$service_id . "'");
		return $query->row;
	}
	public function getProductStatus($product_id)
	{
		$res=$this->db->query("SELECT status FROM " . DB_PREFIX . "product WHERE product_id = '" . (int)$product_id . "'");
		$rowdata=$res->row;
		return $rowdata['status'];
	}
	/*public function getProductResponseId($product_id)
	{
		$resp=$this->db->query("SELECT api_product_id from " . DB_PREFIX . "product_apiresponce WHERE product_id='" .(int)$product_id."'");
		return $api_prod_id=$resp->row;
	}*/
	public function getPPVIdByName($name)
    {
        $query = $this->db->query("SELECT p.product_id, p.channel_list
                                   FROM oc_product_description p_desc, oc_product p
                                   WHERE p_desc.name = '".$name."'
                                   AND p_desc.product_id = p.product_id
                                   AND p.is_ppv =1");
	     return $query->rows;
    }
    public function addApiResponceId($p_id,$product_id)
    {
         $this->db->query("INSERT INTO " . DB_PREFIX . "sms_kms_product SET product_id = '" . (int)$product_id . "', api_product_id = '" . (int)$p_id . "', is_ppv = 1");
    }
    public function getApiResponceId($product_id)
    {       
         $query = $this->db->query("SELECT api_product_id FROM `" . DB_PREFIX . "sms_kms_product` WHERE product_id = '" . (int)$product_id . "'");    
         return $query->row;
    }

 public function getProdList($product_id)
    {       
         $query = $this->db->query("SELECT name FROM `" . DB_PREFIX . "product_description` WHERE product_id = '" . (int)$product_id . "'");    
         return $query->row;
    }
    public function getPPVList($channel)
    {       
         $query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "product` WHERE channel_list like '".$channel."' AND is_ppv=1");    
         return $query->rows;
    }
    public function getPPVListS($start_time,$channel)   {       
    	if(isset($this->request->get['product_id'])){
         	$query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "product` WHERE '".$start_time."' between 	date_added AND date_modified AND channel_list like '".$channel."' AND is_ppv=1 AND product_id != '".$this->request->get['product_id']."'"); 
         	// var_dump($query->num_rows)   ;
        }else{
        	$query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "product` WHERE '".$start_time."' between 	date_added AND date_modified AND channel_list like '".$channel."' AND is_ppv=1");    
        }
        return $query->num_rows;
    }
    
    public function getPPVListE($end_time,$channel)
    {       
    	if(isset($this->request->get['product_id'])){
         	$query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "product` WHERE '".$end_time."'  between date_added AND date_modified AND channel_list like '".$channel."' AND is_ppv=1 AND product_id != '".$this->request->get['product_id']."'");    
         // var_dump($query->num_rows)   ;exit();
     	}else{
     		$query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "product` WHERE '".$end_time."'  between date_added AND date_modified AND channel_list like '".$channel."' AND is_ppv=1");    
     	}
        return $query->num_rows;
     	
    }

    public function gettime($product_id) {
    	$now_datetime = new DateTime("now", new DateTimeZone('Asia/Kolkata'));
			// $currentDate =  $now_datetime->getTimestamp(); 	
    	$cur_date = (array)$now_datetime;
	// var_dump($cur_date['date']);exit();
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product p WHERE p.is_ppv=1 AND p.product_id=$product_id AND p.date_added>'".$cur_date['date']."'");
		return $query->num_rows;
	} 

	public function isProductNameExists($ppv_name) {
		$query = $this->db->query("SELECT `name` FROM  " . DB_PREFIX . "product_description WHERE  `name` ='".$this->db->escape($ppv_name)."' ");
				
		return $query->num_rows;
	}

	public function getPpvName($id) {
		$query = $this->db->query("SELECT `name` FROM  " . DB_PREFIX . "product_description WHERE  `product_id` ='".$id."' ");				
		return $query->row['name'];
	}
    

}
?>