<?php
/*
@File package.php(MODEL)
CATALOG:	 PACKAGE PAGE
    Manages the package list by retrieving/adding/editing it from database.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ModelCatalogPackage extends Model {
/*
FUNCTION NAME 		-	addProduct
DESCRIPTION 		-	Adds new package detail to the database.
INPUT PARAMETER 	-	package details as an array 
OUTPUT PARAMETER 	- 	Adds to the database and returns to the package list page with a success notification
*/		
	public function addProduct($data) {
		$values = implode(",",$data['destchannels']);
		//$this->db->query("INSERT INTO " . DB_PREFIX . "product SET  model = '" . $this->db->escape($data['model']) . "', sku = '" . $this->db->escape($data['sku']) . "', upc = '" . $this->db->escape($data['upc']) . "', ean = '" . $this->db->escape($data['ean']) . "', jan = '" . $this->db->escape($data['jan']) . "', isbn = '" . $this->db->escape($data['isbn']) . "', mpn = '" . $this->db->escape($data['mpn']) . "', location = '" . $this->db->escape($data['location']) . "', quantity = '1', minimum = '1', subtract = '0', stock_status_id = '" . (int)$data['stock_status_id'] . "', date_available = '" . $this->db->escape($data['date_available']) . "', manufacturer_id = '" . (int)$data['manufacturer_id'] . "', shipping = '" . (int)$data['shipping'] . "', price = '" . (float)$data['price'] . "', points = '" . (int)$data['points'] . "', status = '" . (int)$data['status'] . "', tax_class_id = '" . $this->db->escape($data['tax_class_id']) . "', sort_order = '" . (int)$data['sort_order'] . "' , date_added = NOW() ,". 'is_package = ' . $data['ispackage'] .",". ' channel_list = '. " \" ".$values. " \" "."");
		$this->db->query("INSERT INTO " . DB_PREFIX . "product SET  model = '" . $this->db->escape($data['model']) . "', sku = '" . $this->db->escape($data['sku']) . "', upc = '" . $this->db->escape($data['upc']) . "', ean = '" . $this->db->escape($data['ean']) . "', jan = '" . $this->db->escape($data['jan']) . "', isbn = '" . $this->db->escape($data['isbn']) . "', mpn = '" . $this->db->escape($data['mpn']) . "', location = '" . $this->db->escape($data['location']) . "', quantity = '1', minimum = '1', subtract = '0', stock_status_id = '" . (int)$data['stock_status_id'] . "', date_available = '" . $this->db->escape($data['date_available']) . "', broadcaster_id = '" . (int)$data['manufacturer_id'] . "', shipping = '1', price = '" . (float)$data['price'] . "', points = '" . (int)$data['points'] . "', status = '" . (int)$data['status'] . "', tax_class_id = '" . $this->db->escape($data['tax_class_id']) . "', sort_order = '" . (int)$data['sort_order'] . "' , date_added = NOW() ,". 'is_package = ' . $data['ispackage'] .", region_id = '".$this->db->escape($data['region'])."', package_type=".$data['package_type']." ");
		$product_id = $this->db->getLastId();
		
		if (isset($data['image'])) {
			$this->db->query("UPDATE " . DB_PREFIX . "product SET image = '" . $this->db->escape(html_entity_decode($data['image'], ENT_QUOTES, 'UTF-8')) . "' WHERE product_id = '" . (int)$product_id . "'");
		}
		
		foreach ($data['product_description'] as $language_id => $value) {
			$this->db->query("INSERT INTO " . DB_PREFIX . "product_description SET product_id = '" . (int)$product_id . "', language_id = '" . (int)$language_id . "', name = '" . $this->db->escape(trim($value['name'])) . "', meta_keyword = '" . $this->db->escape($value['meta_keyword']) . "', meta_description = '" . $this->db->escape($value['meta_description']) . "', description = '" . $this->db->escape($value['description']) . "', tag = '" . $this->db->escape($value['tag']) . "'");
		}
		
		if (isset($data['product_store'])) {
			foreach ($data['product_store'] as $store_id) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "product_to_store SET product_id = '" . (int)$product_id . "', store_id = '" . (int)$store_id . "'");
			}
		}

		if (isset($data['product_attribute'])) {
			foreach ($data['product_attribute'] as $product_attribute) {
				if ($product_attribute['attribute_id']) {
					$this->db->query("DELETE FROM " . DB_PREFIX . "product_attribute WHERE product_id = '" . (int)$product_id . "' AND attribute_id = '" . (int)$product_attribute['attribute_id'] . "'");
					
					foreach ($product_attribute['product_attribute_description'] as $language_id => $product_attribute_description) {				
						$this->db->query("INSERT INTO " . DB_PREFIX . "product_attribute SET product_id = '" . (int)$product_id . "', attribute_id = '" . (int)$product_attribute['attribute_id'] . "', language_id = '" . (int)$language_id . "', text = '" .  $this->db->escape($product_attribute_description['text']) . "'");
					}
				}
			}
		}
	
		if (isset($data['product_option'])) {
			foreach ($data['product_option'] as $product_option) {
				if ($product_option['type'] == 'select' || $product_option['type'] == 'radio' || $product_option['type'] == 'checkbox' || $product_option['type'] == 'image') {
					// $this->db->query("INSERT INTO " . DB_PREFIX . "product_option SET product_id = '" . (int)$product_id . "', option_id = '" . (int)$product_option['option_id'] . "', required = '" . (int)$product_option['required'] . "'");
					$this->db->query("INSERT INTO " . DB_PREFIX . "product_option SET product_id = '" . (int)$product_id . "', option_id = '" . (int)$product_option['option_id'] . "', required = 1");
				
					$product_option_id = $this->db->getLastId();
				
					if (isset($product_option['product_option_value']) && count($product_option['product_option_value']) > 0 ) {
						foreach ($product_option['product_option_value'] as $product_option_value) {
							$this->db->query("INSERT INTO " . DB_PREFIX . "product_option_value SET product_option_id = '" . (int)$product_option_id . "', product_id = '" . (int)$product_id . "', option_id = '" . (int)$product_option['option_id'] . "', option_value_id = '" . (int)$product_option_value['option_value_id'] . "', quantity = '1', subtract = '0', price = '" . (float)$product_option_value['price'] . "', price_prefix = '" . $this->db->escape($product_option_value['price_prefix']) . "', points = '" . (int)$product_option_value['points'] . "', points_prefix = '" . $this->db->escape($product_option_value['points_prefix']) . "'");
						} 
					}else{
						$this->db->query("DELETE FROM " . DB_PREFIX . "product_option WHERE product_option_id = '".$product_option_id."'");
					}
				} else { 
					// $this->db->query("INSERT INTO " . DB_PREFIX . "product_option SET product_id = '" . (int)$product_id . "', option_id = '" . (int)$product_option['option_id'] . "', option_value = '" . $this->db->escape($product_option['option_value']) . "', required = '" . (int)$product_option['required'] . "'");
					$this->db->query("INSERT INTO " . DB_PREFIX . "product_option SET product_id = '" . (int)$product_id . "', option_id = '" . (int)$product_option['option_id'] . "', option_value = '" . $this->db->escape($product_option['option_value']) . "', required = 1");
				}
			}
		}
		
		if (isset($data['product_discount'])) {
			foreach ($data['product_discount'] as $product_discount) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "product_discount SET product_id = '" . (int)$product_id . "', customer_group_id = '" . (int)$product_discount['customer_group_id'] . "', quantity = '1', priority = '" . (int)$product_discount['priority'] . "', price = '" . (float)$product_discount['price'] . "', date_start = '" . $this->db->escape($product_discount['date_start']) . "', date_end = '" . $this->db->escape($product_discount['date_end']) . "'");
			}
		}

		if (isset($data['product_special'])) {
			foreach ($data['product_special'] as $product_special) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "product_special SET product_id = '" . (int)$product_id . "', customer_group_id = '" . (int)$product_special['customer_group_id'] . "', priority = '" . (int)$product_special['priority'] . "', price = '" . (float)$product_special['price'] . "', date_start = '" . $this->db->escape($product_special['date_start']) . "', date_end = '" . $this->db->escape($product_special['date_end']) . "'");
			}
		}
		
		if (isset($data['product_image'])) {
			foreach ($data['product_image'] as $product_image) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "product_image SET product_id = '" . (int)$product_id . "', image = '" . $this->db->escape(html_entity_decode($product_image['image'], ENT_QUOTES, 'UTF-8')) . "', sort_order = '" . (int)$product_image['sort_order'] . "'");
			}
		}
		
		if (isset($data['product_download'])) {
			foreach ($data['product_download'] as $download_id) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "product_to_download SET product_id = '" . (int)$product_id . "', download_id = '" . (int)$download_id . "'");
			}
		}
		
		if (isset($data['product_category'])) {
			foreach ($data['product_category'] as $category_id) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "product_to_category SET product_id = '" . (int)$product_id . "', category_id = '" . (int)$category_id . "'");
			}
		}
		
		if (isset($data['product_filter'])) {
			foreach ($data['product_filter'] as $filter_id) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "product_filter SET product_id = '" . (int)$product_id . "', filter_id = '" . (int)$filter_id . "'");
			}
		}
		
		if (isset($data['product_related'])) {
			foreach ($data['product_related'] as $related_id) {
				$this->db->query("DELETE FROM " . DB_PREFIX . "product_related WHERE product_id = '" . (int)$product_id . "' AND related_id = '" . (int)$related_id . "'");
				$this->db->query("INSERT INTO " . DB_PREFIX . "product_related SET product_id = '" . (int)$product_id . "', related_id = '" . (int)$related_id . "'");
				$this->db->query("DELETE FROM " . DB_PREFIX . "product_related WHERE product_id = '" . (int)$related_id . "' AND related_id = '" . (int)$product_id . "'");
				$this->db->query("INSERT INTO " . DB_PREFIX . "product_related SET product_id = '" . (int)$related_id . "', related_id = '" . (int)$product_id . "'");
			}
		}

		if (isset($data['product_reward'])) {
			foreach ($data['product_reward'] as $customer_group_id => $product_reward) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "product_reward SET product_id = '" . (int)$product_id . "', customer_group_id = '" . (int)$customer_group_id . "', points = '" . (int)$product_reward['points'] . "'");
			}
		}

		if (isset($data['product_layout'])) {
			foreach ($data['product_layout'] as $store_id => $layout) {
				if ($layout['layout_id']) {
					$this->db->query("INSERT INTO " . DB_PREFIX . "product_to_layout SET product_id = '" . (int)$product_id . "', store_id = '" . (int)$store_id . "', layout_id = '" . (int)$layout['layout_id'] . "'");
				}
			}
		}
						
		if ($data['keyword']) {
			$this->db->query("INSERT INTO " . DB_PREFIX . "url_alias SET query = 'product_id=" . (int)$product_id . "', keyword = '" . $this->db->escape($data['keyword']) . "'");
		}
						
		$this->cache->delete('product');
	}
/*
FUNCTION NAME 		-	editProduct
DESCRIPTION 		-	Updates package details for the selected package_id.
INPUT PARAMETER 	-	package_id, package details as an array
OUTPUT PARAMETER 	- 	Adds detail to the database and returns to the package list page with a success notification
*/	
	public function editProduct($product_id, $data) {
		$obj = new restapi();
		// $values = implode(",",$data['destchannels']);
		$values = "";
		$this->db->query("UPDATE " . DB_PREFIX . "product SET  model = '" . $this->db->escape($data['model']) . "', sku = '" . $this->db->escape($data['sku']) . "', upc = '" . $this->db->escape($data['upc']) . "', ean = '" . $this->db->escape($data['ean']) . "', jan = '" . $this->db->escape($data['jan']) . "', isbn = '" . $this->db->escape($data['isbn']) . "', mpn = '" . $this->db->escape($data['mpn']) . "', location = '" . $this->db->escape($data['location']) . "', quantity = '1', minimum = '1', subtract = '0', stock_status_id = '" . (int)$data['stock_status_id'] . "', date_available = '" . $this->db->escape($data['date_available']) . "', broadcaster_id = '" . (int)$data['manufacturer_id'] . "', shipping = '1', price = '" . (float)$data['price'] . "', points = '" . (int)$data['points'] . "', tax_class_id = '" . $this->db->escape($data['tax_class_id']) . "', sort_order = '" . (int)$data['sort_order'] . "', date_modified = NOW() ,". 'is_package = ' . $data['ispackage'] .",". ' channel_list = '. " \" ".$values. " \" , region_id = '".$this->db->escape($data['region'])."', package_type=".$data['package_type']." WHERE product_id = '" . (int)$product_id . "'");

		if (isset($data['image'])) {
			$this->db->query("UPDATE " . DB_PREFIX . "product SET image = '" . $this->db->escape(html_entity_decode($data['image'], ENT_QUOTES, 'UTF-8')) . "' WHERE product_id = '" . (int)$product_id . "'");
		}
		
		$this->db->query("DELETE FROM " . DB_PREFIX . "product_description WHERE product_id = '" . (int)$product_id . "'");
		
		foreach ($data['product_description'] as $language_id => $value) {
			$this->db->query("INSERT INTO " . DB_PREFIX . "product_description SET product_id = '" . (int)$product_id . "', language_id = '" . (int)$language_id . "', name = '" . $this->db->escape(trim($value['name'])) . "', meta_keyword = '" . $this->db->escape($value['meta_keyword']) . "', meta_description = '" . $this->db->escape($value['meta_description']) . "', description = '" . $this->db->escape($value['description']) . "', tag = '" . $this->db->escape($value['tag']) . "'");
		}

		$this->db->query("DELETE FROM " . DB_PREFIX . "productToPackage WHERE package_id = '" . (int)$product_id . "'");

		foreach($data['destchannels'] as $value){
			$query = $this->db->query("INSERT INTO " . DB_PREFIX . "productToPackage (product_id, package_id) VALUES (".$value.",".(int)$product_id.")");
		}

		$this->db->query("DELETE FROM " . DB_PREFIX . "product_to_store WHERE product_id = '" . (int)$product_id . "'");

		if (isset($data['product_store'])) {
			foreach ($data['product_store'] as $store_id) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "product_to_store SET product_id = '" . (int)$product_id . "', store_id = '" . (int)$store_id . "'");
			}
		}
	
		$this->db->query("DELETE FROM " . DB_PREFIX . "product_attribute WHERE product_id = '" . (int)$product_id . "'");

		if (!empty($data['product_attribute'])) {
			foreach ($data['product_attribute'] as $product_attribute) {
				if ($product_attribute['attribute_id']) {
					$this->db->query("DELETE FROM " . DB_PREFIX . "product_attribute WHERE product_id = '" . (int)$product_id . "' AND attribute_id = '" . (int)$product_attribute['attribute_id'] . "'");
					
					foreach ($product_attribute['product_attribute_description'] as $language_id => $product_attribute_description) {				
						$this->db->query("INSERT INTO " . DB_PREFIX . "product_attribute SET product_id = '" . (int)$product_id . "', attribute_id = '" . (int)$product_attribute['attribute_id'] . "', language_id = '" . (int)$language_id . "', text = '" .  $this->db->escape($product_attribute_description['text']) . "'");
					}
				}
			}
		}

		$this->db->query("DELETE FROM " . DB_PREFIX . "product_option WHERE product_id = '" . (int)$product_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "product_option_value WHERE product_id = '" . (int)$product_id . "'");
		
		if (isset($data['product_option'])) {
			foreach ($data['product_option'] as $product_option) {
				if ($product_option['type'] == 'select' || $product_option['type'] == 'radio' || $product_option['type'] == 'checkbox' || $product_option['type'] == 'image') {
					// $this->db->query("INSERT INTO " . DB_PREFIX . "product_option SET product_option_id = '" . (int)$product_option['product_option_id'] . "', product_id = '" . (int)$product_id . "', option_id = '" . (int)$product_option['option_id'] . "', required = '" . (int)$product_option['required'] . "'");
					$this->db->query("INSERT INTO " . DB_PREFIX . "product_option SET product_option_id = '" . (int)$product_option['product_option_id'] . "', product_id = '" . (int)$product_id . "', option_id = '" . (int)$product_option['option_id'] . "', required = 1");
				
					$product_option_id = $this->db->getLastId();
				
					if (isset($product_option['product_option_value'])  && count($product_option['product_option_value']) > 0 ) {
						foreach ($product_option['product_option_value'] as $product_option_value) {
							$this->db->query("INSERT INTO " . DB_PREFIX . "product_option_value SET product_option_value_id = '" . (int)$product_option_value['product_option_value_id'] . "', product_option_id = '" . (int)$product_option_id . "', product_id = '" . (int)$product_id . "', option_id = '" . (int)$product_option['option_id'] . "', option_value_id = '" . (int)$product_option_value['option_value_id'] . "', quantity = '1', subtract = '0', price = '" . (float)$product_option_value['price'] . "', price_prefix = '" . $this->db->escape($product_option_value['price_prefix']) . "', points = '" . (int)$product_option_value['points'] . "', points_prefix = '" . $this->db->escape($product_option_value['points_prefix']) . "'");
						}
					}else{
						$this->db->query("DELETE FROM " . DB_PREFIX . "product_option WHERE product_option_id = '".$product_option_id."'");
					}
				} else { 
					// $this->db->query("INSERT INTO " . DB_PREFIX . "product_option SET product_option_id = '" . (int)$product_option['product_option_id'] . "', product_id = '" . (int)$product_id . "', option_id = '" . (int)$product_option['option_id'] . "', option_value = '" . $this->db->escape($product_option['option_value']) . "', required = '" . (int)$product_option['required'] . "'");
					$this->db->query("INSERT INTO " . DB_PREFIX . "product_option SET product_option_id = '" . (int)$product_option['product_option_id'] . "', product_id = '" . (int)$product_id . "', option_id = '" . (int)$product_option['option_id'] . "', option_value = '" . $this->db->escape($product_option['option_value']) . "', required = 1");
				}					
			}
		}
		
		$this->db->query("DELETE FROM " . DB_PREFIX . "product_discount WHERE product_id = '" . (int)$product_id . "'");
 
		if (isset($data['product_discount'])) {
			foreach ($data['product_discount'] as $product_discount) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "product_discount SET product_id = '" . (int)$product_id . "', customer_group_id = '" . (int)$product_discount['customer_group_id'] . "', quantity = '1', priority = '" . (int)$product_discount['priority'] . "', price = '" . (float)$product_discount['price'] . "', date_start = '" . $this->db->escape($product_discount['date_start']) . "', date_end = '" . $this->db->escape($product_discount['date_end']) . "'");
			}
		}
		
		$this->db->query("DELETE FROM " . DB_PREFIX . "product_special WHERE product_id = '" . (int)$product_id . "'");
		
		if (isset($data['product_special'])) {
			foreach ($data['product_special'] as $product_special) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "product_special SET product_id = '" . (int)$product_id . "', customer_group_id = '" . (int)$product_special['customer_group_id'] . "', priority = '" . (int)$product_special['priority'] . "', price = '" . (float)$product_special['price'] . "', date_start = '" . $this->db->escape($product_special['date_start']) . "', date_end = '" . $this->db->escape($product_special['date_end']) . "'");
			}
		}
		
		$this->db->query("DELETE FROM " . DB_PREFIX . "product_image WHERE product_id = '" . (int)$product_id . "'");
		
		if (isset($data['product_image'])) {
			foreach ($data['product_image'] as $product_image) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "product_image SET product_id = '" . (int)$product_id . "', image = '" . $this->db->escape(html_entity_decode($product_image['image'], ENT_QUOTES, 'UTF-8')) . "', sort_order = '" . (int)$product_image['sort_order'] . "'");
			}
		}
		
		$this->db->query("DELETE FROM " . DB_PREFIX . "product_to_download WHERE product_id = '" . (int)$product_id . "'");
		
		if (isset($data['product_download'])) {
			foreach ($data['product_download'] as $download_id) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "product_to_download SET product_id = '" . (int)$product_id . "', download_id = '" . (int)$download_id . "'");
			}
		}
		
		$this->db->query("DELETE FROM " . DB_PREFIX . "product_to_category WHERE product_id = '" . (int)$product_id . "'");
		
		if (isset($data['product_category'])) {
			foreach ($data['product_category'] as $category_id) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "product_to_category SET product_id = '" . (int)$product_id . "', category_id = '" . (int)$category_id . "'");
			}		
		}
		
		$this->db->query("DELETE FROM " . DB_PREFIX . "product_filter WHERE product_id = '" . (int)$product_id . "'");
		
		if (isset($data['product_filter'])) {
			foreach ($data['product_filter'] as $filter_id) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "product_filter SET product_id = '" . (int)$product_id . "', filter_id = '" . (int)$filter_id . "'");
			}		
		}
		
		$this->db->query("DELETE FROM " . DB_PREFIX . "product_related WHERE product_id = '" . (int)$product_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "product_related WHERE related_id = '" . (int)$product_id . "'");

		if (isset($data['product_related'])) {
			foreach ($data['product_related'] as $related_id) {
				$this->db->query("DELETE FROM " . DB_PREFIX . "product_related WHERE product_id = '" . (int)$product_id . "' AND related_id = '" . (int)$related_id . "'");
				$this->db->query("INSERT INTO " . DB_PREFIX . "product_related SET product_id = '" . (int)$product_id . "', related_id = '" . (int)$related_id . "'");
				$this->db->query("DELETE FROM " . DB_PREFIX . "product_related WHERE product_id = '" . (int)$related_id . "' AND related_id = '" . (int)$product_id . "'");
				$this->db->query("INSERT INTO " . DB_PREFIX . "product_related SET product_id = '" . (int)$related_id . "', related_id = '" . (int)$product_id . "'");
			}
		}
		
		$this->db->query("DELETE FROM " . DB_PREFIX . "product_reward WHERE product_id = '" . (int)$product_id . "'");

		if (isset($data['product_reward'])) {
			foreach ($data['product_reward'] as $customer_group_id => $value) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "product_reward SET product_id = '" . (int)$product_id . "', customer_group_id = '" . (int)$customer_group_id . "', points = '" . (int)$value['points'] . "'");
			}
		}

		$this->db->query("DELETE FROM " . DB_PREFIX . "product_to_layout WHERE product_id = '" . (int)$product_id . "'");

		if (isset($data['product_layout'])) {
			foreach ($data['product_layout'] as $store_id => $layout) {
				if ($layout['layout_id']) {
					$this->db->query("INSERT INTO " . DB_PREFIX . "product_to_layout SET product_id = '" . (int)$product_id . "', store_id = '" . (int)$store_id . "', layout_id = '" . (int)$layout['layout_id'] . "'");
				}
			}
		}
						
		$this->db->query("DELETE FROM " . DB_PREFIX . "url_alias WHERE query = 'product_id=" . (int)$product_id. "'");
		
		if ($data['keyword']) {
			$this->db->query("INSERT INTO " . DB_PREFIX . "url_alias SET query = 'product_id=" . (int)$product_id . "', keyword = '" . $this->db->escape($data['keyword']) . "'");
		}
						
		$this->cache->delete('product');
	}
	public function setPackageStatus($status,$package_id){
		//var_dump("UPDATE " . DB_PREFIX . "product SET status = '" .$status . "' WHERE product_id = '" . (int)$package_id . "'");
		$this->db->query("UPDATE " . DB_PREFIX . "product SET status = '" .$status . "' WHERE product_id = '" . (int)$package_id . "'"); 		
	
	}
/*
FUNCTION NAME 		-	copyProduct
DESCRIPTION 		-	Copies the given package details to a new package and open the addPackage form.
INPUT PARAMETER 	-	product_id
OUTPUT PARAMETER 	- 	Fill the addPackage form with the copied details
*/		
	public function copyProduct($product_id) {
		$query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "product p LEFT JOIN " . DB_PREFIX . "product_description pd ON (p.product_id = pd.product_id) WHERE p.product_id = '" . (int)$product_id . "' AND pd.language_id = '" . (int)$this->config->get('config_language_id') . "'");
		
		if ($query->num_rows) {
			$data = array();
			
			$data = $query->row;
			
			$data['sku'] = '';
			$data['upc'] = '';
			$data['viewed'] = '0';
			$data['keyword'] = '';
			$data['status'] = '0';
						
			$data = array_merge($data, array('product_attribute' => $this->getProductAttributes($product_id)));
			$data = array_merge($data, array('product_description' => $this->getProductDescriptions($product_id)));			
			$data = array_merge($data, array('product_discount' => $this->getProductDiscounts($product_id)));
			$data = array_merge($data, array('product_filter' => $this->getProductFilters($product_id)));
			$data = array_merge($data, array('product_image' => $this->getProductImages($product_id)));		
			$data = array_merge($data, array('product_option' => $this->getProductOptions($product_id)));
			$data = array_merge($data, array('product_related' => $this->getProductRelated($product_id)));
			$data = array_merge($data, array('product_reward' => $this->getProductRewards($product_id)));
			$data = array_merge($data, array('product_special' => $this->getProductSpecials($product_id)));
			$data = array_merge($data, array('product_category' => $this->getProductCategories($product_id)));
			$data = array_merge($data, array('product_download' => $this->getProductDownloads($product_id)));
			$data = array_merge($data, array('product_layout' => $this->getProductLayouts($product_id)));
			$data = array_merge($data, array('product_store' => $this->getProductStores($product_id)));
			
			$this->addProduct($data);
		}
	}
/*
FUNCTION NAME 		-	deleteProduct
DESCRIPTION 		-	Deletes package detail form the database for the selected product_id.
INPUT PARAMETER 	-	product_id
OUTPUT PARAMETER 	- 	Deletes detail from the database and returns to the package list page with a success notification
*/	
	public function deleteProduct($product_id) {
		$this->db->query("DELETE FROM " . DB_PREFIX . "sms_kms_product WHERE product_id = '" . (int)$product_id . "' AND is_package=1");
		$this->db->query("DELETE FROM " . DB_PREFIX . "product WHERE product_id = '" . (int)$product_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "product_attribute WHERE product_id = '" . (int)$product_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "product_description WHERE product_id = '" . (int)$product_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "product_discount WHERE product_id = '" . (int)$product_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "product_filter WHERE product_id = '" . (int)$product_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "product_image WHERE product_id = '" . (int)$product_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "product_option WHERE product_id = '" . (int)$product_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "product_option_value WHERE product_id = '" . (int)$product_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "product_related WHERE product_id = '" . (int)$product_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "product_related WHERE related_id = '" . (int)$product_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "product_reward WHERE product_id = '" . (int)$product_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "product_special WHERE product_id = '" . (int)$product_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "product_to_category WHERE product_id = '" . (int)$product_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "product_to_download WHERE product_id = '" . (int)$product_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "product_to_layout WHERE product_id = '" . (int)$product_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "product_to_store WHERE product_id = '" . (int)$product_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "review WHERE product_id = '" . (int)$product_id . "'");
		
		$this->db->query("DELETE FROM " . DB_PREFIX . "url_alias WHERE query = 'product_id=" . (int)$product_id. "'");
		
		$this->cache->delete('product');
	}
/*
FUNCTION NAME 		-	getProduct
DESCRIPTION 		-	Retrieves pacakge details from the database based on the given product_id.
INPUT PARAMETER 	-	product_id
OUTPUT PARAMETER 	- 	Retruns a row queried containing details of the package.
*/	
	public function getProduct($product_id) {
		$query = $this->db->query("SELECT DISTINCT *, (SELECT keyword FROM " . DB_PREFIX . "url_alias WHERE query = 'product_id=" . (int)$product_id . "') AS keyword FROM " . DB_PREFIX . "product p LEFT JOIN " . DB_PREFIX . "product_description pd ON (p.product_id = pd.product_id) WHERE p.product_id = '" . (int)$product_id . "' AND pd.language_id = '" . (int)$this->config->get('config_language_id') . "'");
				
		return $query->row;
	}
/*
FUNCTION NAME 		-	getProducts
DESCRIPTION 		-	Retrieves all the packages from the database. 
INPUT PARAMETER 	-	data array for filter options if any.
OUTPUT PARAMETER 	- 	Returns all the rows queried, containing package details.
*/		
	public function getProducts($data = array()) {
		$sql = "SELECT * FROM " . DB_PREFIX . "product p LEFT JOIN " . DB_PREFIX . "product_description pd ON (p.product_id = pd.product_id)";
		
		if (!empty($data['filter_category_id'])) {
			$sql .= " LEFT JOIN " . DB_PREFIX . "product_to_category p2c ON (p.product_id = p2c.product_id)";			
		}
				
		$sql .= " WHERE pd.language_id = '" . (int)$this->config->get('config_language_id') . "'"; 
		
		if (!empty($data['filter_name'])) {
			$sql .= " AND pd.name LIKE '%" . $this->db->escape($data['filter_name']) . "%'";
		}

		if (!empty($data['filter_model'])) {
			$sql .= " AND p.model LIKE '" . $this->db->escape($data['filter_model']) . "%'";
		}
		
		if (!empty($data['filter_price'])) {
			$sql .= " AND p.price LIKE '" . $this->db->escape($data['filter_price']) . "%'";
		}
		
		if (isset($data['filter_quantity']) && !is_null($data['filter_quantity'])) {
			$sql .= " AND p.quantity = '" . $this->db->escape($data['filter_quantity']) . "'";
		}
		
		if (isset($data['filter_status']) && !is_null($data['filter_status'])) {
			$sql .= " AND p.status = '" . (int)$data['filter_status'] . "'";
		}
		
		$sql .= " GROUP BY p.product_id";
					
		$sort_data = array(
			'pd.name',
			'p.model',
			'p.price',
			'p.quantity',
			'p.status',
			'p.sort_order'
		);	
		
		if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
			$sql .= " ORDER BY " . $data['sort'];	
		} else {
			$sql .= " ORDER BY pd.name";	
		}
		
		if (isset($data['order']) && ($data['order'] == 'DESC')) {
			$sql .= " DESC";
		} else {
			$sql .= " ASC";
		}
	
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}				

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
		
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}	
		
		$query = $this->db->query($sql);
	   var_dump($sql);exit();
		return $query->rows;
	}
/*
FUNCTION NAME 		-	getProductsByCategoryId
DESCRIPTION 		-	Retrieves number of packages in the given category_id
INPUT PARAMETER 	-	category_id
OUTPUT PARAMETER 	- 	Returns a column "total" containing the count of packages in the selected category id.
*/	
	public function getProductsByCategoryId($category_id) {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product p LEFT JOIN " . DB_PREFIX . "product_description pd ON (p.product_id = pd.product_id) LEFT JOIN " . DB_PREFIX . "product_to_category p2c ON (p.product_id = p2c.product_id) WHERE p.is_nvod=0 AND p.status = 1 AND pd.language_id = '" . (int)$this->config->get('config_language_id') . "' AND p2c.category_id = '" . (int)$category_id . "' AND p.is_package!=1 ORDER BY pd.name ASC");
								  
		return $query->rows;
	} 

/*
FUNCTION NAME 		-	getAllProducts
DESCRIPTION 		-	Retrieves number of packages in the gi
INPUT PARAMETER 	-	category_id
OUTPUT PARAMETER 	- 	Returns a column "total" containing the count of packages in the selected category id.
*/	
	public function getAllProducts() {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product p LEFT JOIN " . DB_PREFIX . "product_description pd ON (p.product_id = pd.product_id) LEFT JOIN " . DB_PREFIX . "product_to_category p2c ON (p.product_id = p2c.product_id) WHERE pd.language_id = '" . (int)$this->config->get('config_language_id') . "' ORDER BY pd.name ASC");
								  
		return $query->rows;
	} 
/*
FUNCTION NAME 		-	getPrevChannels
DESCRIPTION 		-	Retrieves number of packages in the gi
INPUT PARAMETER 	-	category_id
OUTPUT PARAMETER 	- 	Returns a column "total" containing the count of packages in the selected category id.
*/	
	public function getPrevChannels($product_id) {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product  WHERE product_id='".$product_id."'");
								  
		return $query->rows;
	} 	
/*
FUNCTION NAME 		-	getProductDescriptions
DESCRIPTION 		-	Retrieves the description for the given product_id
INPUT PARAMETER 	-	product_id
OUTPUT PARAMETER 	- 	Retruns an array conatining the package description
*/	
	public function getProductDescriptions($product_id) {
		$product_description_data = array();
		
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_description WHERE product_id = '" . (int)$product_id . "'");
		
		foreach ($query->rows as $result) {
			$product_description_data[$result['language_id']] = array(
				'name'             => $result['name'],
				'description'      => $result['description'],
				'meta_keyword'     => $result['meta_keyword'],
				'meta_description' => $result['meta_description'],
				'tag'              => $result['tag']
			);
		}
		
		return $product_description_data;
	}
/*
FUNCTION NAME 		-	getProductCategories
DESCRIPTION 		-	Retrieves the categories for the given product_id
INPUT PARAMETER 	-	product_id
OUTPUT PARAMETER 	- 	Retruns an array conatining the category id assigned
*/			
	public function getProductCategories($product_id) {
		$product_category_data = array();
		
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_to_category WHERE product_id = '" . (int)$product_id . "'");
		
		foreach ($query->rows as $result) {
			$product_category_data[] = $result['category_id'];
		}

		return $product_category_data;
	}
/*
FUNCTION NAME 		-	getProductFilters
DESCRIPTION 		-	Retrieves the filters that can be applied for the given product_id
INPUT PARAMETER 	-	product_id
OUTPUT PARAMETER 	- 	Retruns an array conatining the filter id assigned
*/	
	public function getProductFilters($product_id) {
		$product_filter_data = array();
		
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_filter WHERE product_id = '" . (int)$product_id . "'");
		
		foreach ($query->rows as $result) {
			$product_filter_data[] = $result['filter_id'];
		}
				
		return $product_filter_data;
	}
/*
FUNCTION NAME 		-	getProductAttributes
DESCRIPTION 		-	Retrieves the attributes that are added for the given product_id
INPUT PARAMETER 	-	product_id
OUTPUT PARAMETER 	- 	Retruns an array containing the attribute id and attribute description assigned
*/	
	public function getProductAttributes($product_id) {
		$product_attribute_data = array();
		
		$product_attribute_query = $this->db->query("SELECT attribute_id FROM " . DB_PREFIX . "product_attribute WHERE product_id = '" . (int)$product_id . "' GROUP BY attribute_id");
		
		foreach ($product_attribute_query->rows as $product_attribute) {
			$product_attribute_description_data = array();
			
			$product_attribute_description_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_attribute WHERE product_id = '" . (int)$product_id . "' AND attribute_id = '" . (int)$product_attribute['attribute_id'] . "'");
			
			foreach ($product_attribute_description_query->rows as $product_attribute_description) {
				$product_attribute_description_data[$product_attribute_description['language_id']] = array('text' => $product_attribute_description['text']);
			}
			
			$product_attribute_data[] = array(
				'attribute_id'                  => $product_attribute['attribute_id'],
				'product_attribute_description' => $product_attribute_description_data
			);
		}
		
		return $product_attribute_data;
	}
/*
FUNCTION NAME 		-	getProductOptions
DESCRIPTION 		-	Retrieves the options applied for the given product_id
INPUT PARAMETER 	-	product_id
OUTPUT PARAMETER 	- 	Retruns an array containing package option details.
*/		
	public function getProductOptions($product_id) {
		$product_option_data = array();
		
		$product_option_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_option WHERE product_id = '" . (int)$product_id . "'");
		
		foreach ($product_option_query->rows as $product_option) {
			$product_option_value_data = array();	
				
			$product_option_value_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_option_value WHERE product_option_id = '" . (int)$product_option['product_option_id'] . "'");
				
			foreach ($product_option_value_query->rows as $product_option_value) {
				$product_option_value_data[] = array(
					'product_option_value_id' => $product_option_value['product_option_value_id'],
					'option_value_id'         => $product_option_value['option_value_id'],
					'quantity'                => $product_option_value['quantity'],
					'subtract'                => $product_option_value['subtract'],
					'price'                   => $product_option_value['price'],
					'price_prefix'            => $product_option_value['price_prefix'],
					'points'                  => $product_option_value['points'],
					'points_prefix'           => $product_option_value['points_prefix'],						
					'weight'                  => $product_option_value['weight'],
					'weight_prefix'           => $product_option_value['weight_prefix']					
				);
			}
				
			$product_option_data[] = array(
				'product_option_id'    => $product_option['product_option_id'],
				'option_id'            => $product_option['option_id'],
				'product_option_value' => $product_option_value_data,
				'option_value'         => $product_option['option_value'],
				'required'             => $product_option['required']				
			);
		}
		
		return $product_option_data;
	}
/*
FUNCTION NAME 		-	getProductImages
DESCRIPTION 		-	Retrieves the image added for the given product_id
INPUT PARAMETER 	-	product_id
OUTPUT PARAMETER 	- 	Retruns all the rows matched with the product_id
*/			
	public function getProductImages($product_id) {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_image WHERE product_id = '" . (int)$product_id . "'");
		
		return $query->rows;
	}
/*
FUNCTION NAME 		-	getPackages
DESCRIPTION 		-	Retrieves all the packages added to the store
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Retruns all the rows retrieved.
*/	
     public function getPackages($data) {
     	$sql = "SELECT * FROM " . DB_PREFIX . "product p LEFT JOIN " . DB_PREFIX . "product_description pd ON (p.product_id = pd.product_id)";
		
		if (!empty($data['filter_category_id'])) {
			$sql .= " LEFT JOIN " . DB_PREFIX . "product_to_category p2c ON (p.product_id = p2c.product_id)";			
		}
				
		$sql .= " WHERE pd.language_id = '" . (int)$this->config->get('config_language_id') . "' && p.is_package='1'"; 
		
		if (!empty($data['filter_name'])) {
			$sql .= " AND pd.name LIKE '%" . $this->db->escape($data['filter_name']) . "%'";
		}

		if (!empty($data['filter_product_id'])) {
			$sql .= " AND pd.product_id LIKE '%" . $this->db->escape($data['filter_product_id']) . "%'";
		}

		if (!empty($data['filter_model'])) {
			$sql .= " AND p.model LIKE '" . $this->db->escape($data['filter_model']) . "%'";
		}

		if (!empty($data['filter_service_id'])) {
			$sql .= " AND p.service_id LIKE '" . $this->db->escape($data['filter_service_id']) . "%'";
		}
		
		if (!empty($data['filter_price'])) {
			$sql .= " AND p.price LIKE '" . $this->db->escape($data['filter_price']) . "%'";
		}
		
		if (isset($data['filter_quantity']) && !is_null($data['filter_quantity'])) {
			$sql .= " AND p.quantity = '" . $this->db->escape($data['filter_quantity']) . "'";
		}
		
		if (isset($data['filter_status']) && !is_null($data['filter_status'])) {
			$sql .= " AND p.status = '" . (int)$data['filter_status'] . "'";
		}
		if (isset($data['filter_packageType']) && !is_null($data['filter_packageType'])) {
			$sql .= " AND p.package_type = '" . (int)$data['filter_packageType'] . "'";
		}
		
		$sql .= " GROUP BY p.product_id";
					
		$sort_data = array(
			'pd.name',
			'p.model',
			'p.service_id',
			'p.price',
			'p.quantity',
			'p.status',
			'p.package_type',
			'p.sort_order'
		);	
		
		if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
			$sql .= " ORDER BY " . $data['sort'];	
		} else {
			$sql .= " ORDER BY pd.name";	
		}
		
		if (isset($data['order']) && ($data['order'] == 'DESC')) {
			$sql .= " DESC";
		} else {
			$sql .= " ASC";
		}
	
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}				

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
		
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}	
		
		$query = $this->db->query($sql);
	
		return $query->rows;

	}
/*
FUNCTION NAME 		-	getChannelList
DESCRIPTION 		-	Retrieves all the channels added to the packages with given product_id
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Retruns all the rows retrieved.
*/
	public function getChannelList($product_id)
	{
        // $query = $this->db->query("SELECT channel_list FROM " . DB_PREFIX . "product where product_id ='".(int)$product_id."'");
        // return $query->rows;
        $query = $this->db->query("SELECT pd.product_id,pd.name FROM " . DB_PREFIX . "product_description pd INNER JOIN ".DB_PREFIX."productToPackage p2p ON p2p.product_id = pd.product_id WHERE p2p.package_id ='".(int)$product_id."'");
        return $query->rows;
	}
/*
FUNCTION NAME 		-	getProductDiscounts
DESCRIPTION 		-	Retrieves all the discounts matching the given product_id
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Retruns all the rows retrieved.
*/
	public function getProductDiscounts($product_id) {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_discount WHERE product_id = '" . (int)$product_id . "' ORDER BY quantity, priority, price");
		
		return $query->rows;
	}
/*
FUNCTION NAME 		-	getProductSpecials
DESCRIPTION 		-	Retrieves all the special offers matching the given product_id
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Retruns all the rows retrieved.
*/	
	public function getProductSpecials($product_id) {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_special WHERE product_id = '" . (int)$product_id . "' ORDER BY priority, price");
		
		return $query->rows;
	}
/*
FUNCTION NAME 		-	getProductRewards
DESCRIPTION 		-	Retrieves all the rewards points for the given product_id
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Retruns an array assigned with the reward points.
*/	
	public function getProductRewards($product_id) {
		$product_reward_data = array();
		
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_reward WHERE product_id = '" . (int)$product_id . "'");
		
		foreach ($query->rows as $result) {
			$product_reward_data[$result['customer_group_id']] = array('points' => $result['points']);
		}
		
		return $product_reward_data;
	}
/*
FUNCTION NAME 		-	getProductDownloads
DESCRIPTION 		-	Retrieves all the download available for the given product_id
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Retruns all the download ids matched.
*/		
	public function getProductDownloads($product_id) {
		$product_download_data = array();
		
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_to_download WHERE product_id = '" . (int)$product_id . "'");
		
		foreach ($query->rows as $result) {
			$product_download_data[] = $result['download_id'];
		}
		
		return $product_download_data;
	}
/*
FUNCTION NAME 		-	getProductStores
DESCRIPTION 		-	Retrieves all the stores in which the given product_id is added.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Retruns all the rows containing the store id.
*/
	public function getProductStores($product_id) {
		$product_store_data = array();
		
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_to_store WHERE product_id = '" . (int)$product_id . "'");

		foreach ($query->rows as $result) {
			$product_store_data[] = $result['store_id'];
		}
		
		return $product_store_data;
	}
/*
FUNCTION NAME 		-	getProductLayouts
DESCRIPTION 		-	Retrieves layout that is assigned to the given product_id
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Retruns an array with the layout ids.
*/
	public function getProductLayouts($product_id) {
		$product_layout_data = array();
		
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_to_layout WHERE product_id = '" . (int)$product_id . "'");
		
		foreach ($query->rows as $result) {
			$product_layout_data[$result['store_id']] = $result['layout_id'];
		}
		
		return $product_layout_data;
	}
/*
FUNCTION NAME 		-	getProductRelated
DESCRIPTION 		-	Retrieves all the product related data for the given product_id
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Retruns an array with the related ids.
*/
	public function getProductRelated($product_id) {
		$product_related_data = array();
		
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_related WHERE product_id = '" . (int)$product_id . "'");
		
		foreach ($query->rows as $result) {
			$product_related_data[] = $result['related_id'];
		}
		
		return $product_related_data;
	}
/*
FUNCTION NAME 		-	getTotalProducts
DESCRIPTION 		-	Retrieves the count for the total number of proudcts/packages.
INPUT PARAMETER 	-	data array for filter options if any.
OUTPUT PARAMETER 	- 	Returns a column "total" containing the count for packages.
*/	
	public function getTotalProducts($data = array()) {
		$sql = "SELECT COUNT(DISTINCT p.product_id) AS total FROM " . DB_PREFIX . "product p LEFT JOIN " . DB_PREFIX . "product_description pd ON (p.product_id = pd.product_id)";

		if (!empty($data['filter_category_id'])) {
			$sql .= " LEFT JOIN " . DB_PREFIX . "product_to_category p2c ON (p.product_id = p2c.product_id)";			
		}
		 
		$sql .= " WHERE pd.language_id = '" . (int)$this->config->get('config_language_id') . "' && p.is_package='1'";
		 			
		if (!empty($data['filter_name'])) {
			$sql .= " AND pd.name LIKE '" . $this->db->escape($data['filter_name']) . "%'";
		}

		if (!empty($data['filter_product_id'])) {
			$sql .= " AND pd.product_id LIKE '" . $this->db->escape($data['filter_product_id']) . "%'";
		}

		if (!empty($data['filter_model'])) {
			$sql .= " AND p.model LIKE '" . $this->db->escape($data['filter_model']) . "%'";
		}
		
		if (!empty($data['filter_price'])) {
			$sql .= " AND p.price LIKE '" . $this->db->escape($data['filter_price']) . "%'";
		}
		
		if (isset($data['filter_quantity']) && !is_null($data['filter_quantity'])) {
			$sql .= " AND p.quantity = '" . $this->db->escape($data['filter_quantity']) . "'";
		}
		
		if (isset($data['filter_status']) && !is_null($data['filter_status'])) {
			$sql .= " AND p.status = '" . (int)$data['filter_status'] . "'";
		}
		if (isset($data['filter_packageType']) && !is_null($data['filter_packageType'])) {
			$sql .= " AND p.package_type = '" . (int)$data['filter_packageType'] . "'";
		}
		
		$query = $this->db->query($sql);
		
		return $query->row['total'];
	}	
/*
FUNCTION NAME 		-	getTotalProductsByTaxClassId
DESCRIPTION 		-	Retrieves the the count for the number of rows matching tax_class_id
INPUT PARAMETER 	-	tax_class_id
OUTPUT PARAMETER 	- 	Returns a column "total" containing the count of rows matched
*/	
	public function getTotalProductsByTaxClassId($tax_class_id) {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "product WHERE tax_class_id = '" . (int)$tax_class_id . "'");

		return $query->row['total'];
	}
/*
FUNCTION NAME 		-	getTotalProductsByStockStatusId
DESCRIPTION 		-	Retrieves the the count for the number of rows matching stock_status_id
INPUT PARAMETER 	-	stock_status_id
OUTPUT PARAMETER 	- 	Returns a column "total" containing the count of rows matched.
*/		
	public function getTotalProductsByStockStatusId($stock_status_id) {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "product WHERE stock_status_id = '" . (int)$stock_status_id . "'");

		return $query->row['total'];
	}
/*
				NOT IN USE
*/	
	public function getTotalProductsByWeightClassId($weight_class_id) {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "product WHERE weight_class_id = '" . (int)$weight_class_id . "'");

		return $query->row['total'];
	}
/*
				NOT IN USE
*/	
	public function getTotalProductsByLengthClassId($length_class_id) {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "product WHERE length_class_id = '" . (int)$length_class_id . "'");

		return $query->row['total'];
	}
/*
FUNCTION NAME 		-	getTotalProductsByDownloadId
DESCRIPTION 		-	Retrieves the rows containing the count of rows matching download_id
INPUT PARAMETER 	-	download_id
OUTPUT PARAMETER 	- 	Returns a column "total" containing the count of rows matched
*/
	public function getTotalProductsByDownloadId($download_id) {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "product_to_download WHERE download_id = '" . (int)$download_id . "'");
		
		return $query->row['total'];
	}
/*
FUNCTION NAME 		-	getTotalProductsByManufacturerId
DESCRIPTION 		-	Retrieves the rows containing the count of rows matching manufacturer_id
INPUT PARAMETER 	-	manufacturer_id
OUTPUT PARAMETER 	- 	Returns a column "total" containing the count of rows matched
*/	
	public function getTotalProductsByManufacturerId($manufacturer_id) {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "product WHERE broadcaster_id = '" . (int)$manufacturer_id . "'");

		return $query->row['total'];
	}
/*
FUNCTION NAME 		-	getTotalProductsByAttributeId
DESCRIPTION 		-	Retrieves the rows containing the count of rows matching attribute_id
INPUT PARAMETER 	-	attribute_id
OUTPUT PARAMETER 	- 	Returns a column "total" containing the count of rows matched
*/	
	public function getTotalProductsByAttributeId($attribute_id) {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "product_attribute WHERE attribute_id = '" . (int)$attribute_id . "'");

		return $query->row['total'];
	}	
/*
FUNCTION NAME 		-	getTotalProductsByOptionId
DESCRIPTION 		-	Retrieves the rows containing the count of rows matching option_id
INPUT PARAMETER 	-	option_id
OUTPUT PARAMETER 	- 	Returns a column "total" containing the count of rows matched
*/	
	public function getTotalProductsByOptionId($option_id) {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "product_option WHERE option_id = '" . (int)$option_id . "'");

		return $query->row['total'];
	}	
/*
FUNCTION NAME 		-	getTotalProductsByLayoutId
DESCRIPTION 		-	Retrieves the rows containing the count of rows matching layout_id
INPUT PARAMETER 	-	layout_id
OUTPUT PARAMETER 	- 	Returns a column "total" containing the count of rows matched
*/	
	public function getTotalProductsByLayoutId($layout_id) {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "product_to_layout WHERE layout_id = '" . (int)$layout_id . "'");
		return $query->row['total'];
	}

	public function getProductStatus($product_id)
	{
		$res=$this->db->query("SELECT status FROM " . DB_PREFIX . "product WHERE product_id = '" . (int)$product_id . "'");
		$rowdata=$res->row;
		return $rowdata['status'];
	}
	public function getProductResponseId($product_id)
	{
		$resp=$this->db->query("SELECT api_product_id from " . DB_PREFIX . "product_apiresponce WHERE product_id='" .(int)$product_id."'");
		return $api_prod_id=$resp->row;
	}
	public function getProductIdByName($name,$is_package=1)
	{
		$query = $this->db->query("SELECT p.product_id, p.channel_list,p.model
                                            FROM oc_product_description p_desc, oc_product p
                                            WHERE p_desc.name = '".$this->db->escape($name)."'
                                            AND p_desc.product_id = p.product_id
                                            AND p.is_package ='".$is_package."'");
     	return $query->rows;
     }
	public function getDetailsByID($pid,$is_package=1)
	{
		$query = $this->db->query("SELECT p.product_id, p.channel_list,p.model
                                            FROM oc_product_description p_desc, oc_product p
                                            WHERE p_desc.product_id = '".$pid."'
                                            AND p_desc.product_id = p.product_id
                                            AND p.is_package ='".$is_package."'");
     	return $query->rows;
     }
    public function getProductIdByNo($pkg_no,$is_package=1)	{
		$query = $this->db->query("SELECT p.product_id, p.channel_list,p.model FROM oc_product_description p_desc, oc_product p WHERE p.model = '".$pkg_no."'
            AND p_desc.product_id = p.product_id AND p.is_package ='".$is_package."'");
     	return $query->rows;
    }
    public function addApiResponceId($p_id,$product_id)
    {
        $this->db->query("INSERT INTO " . DB_PREFIX . "sms_kms_product SET product_id = '" . (int)$product_id . "', api_product_id = '" . (int)$p_id . "', is_package = 1");
    }

    public function getChanneIdlList($values) {
		$res=array();		
	   
        $query = $this->db->query("SELECT DISTINCT oc_api.api_product_id FROM oc_product_description oc_p,oc_sms_kms_product oc_api where oc_p.product_id in ({$values}) and oc_p.product_id=oc_api.product_id");
  
         return $query->rows;

	}
	public function addProdToPkgApiResponceId($product_id,$package_id,$prod_to_pkg_id)	{
		$this->db->query("INSERT INTO " . DB_PREFIX . "sms_kms_prod_pkg SET resp_id = '" . (int)$prod_to_pkg_id . "',product_id = '" . (int)$product_id . "',package_id = '" . (int)$package_id . "'");
	}
	public function deleteProductToPackage($product_id,$package_id)
	{
		$sql="DELETE FROM " . DB_PREFIX . "sms_kms_prod_pkg WHERE product_id = '" . (int)$product_id . "' and package_id = '" . (int)$package_id . "'";
		 	$this->db->query($sql);
	}
	public function getApiResponceId($package_id)
		{
	 	// $this->db->query("INSERT INTO " . DB_PREFIX . "user_api_response SET user_id = '" . (int)$user_id . "', api_user_id = '" . (int)$apiuser_id . "'");
	 	$query = $this->db->query("SELECT api_product_id FROM `" . DB_PREFIX . "sms_kms_product` WHERE product_id = '" . (int)$package_id . "'");
	
		return $query->row;
		}
	
		public function getApiproductId($package_id)
		{
	 	// $this->db->query("INSERT INTO " . DB_PREFIX . "user_api_response SET user_id = '" . (int)$user_id . "', api_user_id = '" . (int)$apiuser_id . "'");
	 	$query = $this->db->query("SELECT api_product_id FROM `" . DB_PREFIX . "sms_kms_product` WHERE product_id = '" . (int)$package_id . "'");
	
		return $query->row;
		}	




	public function getPreChannelList($package_id)
	{
        // $query = $this->db->query("SELECT channel_list FROM " . DB_PREFIX . "product where product_id ='".(int)$product_id."'");
        // return $query->row;
        $query = $this->db->query("SELECT pd.product_id FROM " . DB_PREFIX . "product_description pd INNER JOIN " . DB_PREFIX . "productToPackage pp ON pd.product_id = pp.product_id WHERE pp.package_id = '" . (int)$package_id . "'");
        return $query->rows;
	}
	public function getNewChannelList($list)
	{
		$productids = "";
			foreach($list as $value) {
			  $productids = $productids.','.$value;
			}
		$productids = substr($productids, 1);
        $query = $this->db->query("SELECT product_id FROM " . DB_PREFIX . "product_description WHERE product_id IN(".$productids.")");
        return $query->rows;
	}
	public function isPkgNameDuplication($prod_name)
	{
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_description WHERE  name = '" . $this->db->escape($prod_name) . "'");
		return $query->num_rows>0;
	}
	public function isPkgNameDuplicationFromId($pkg_name,$pkg_id)
	{
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_description WHERE  name = '" . $this->db->escape($pkg_name) . "' AND product_id !=".$pkg_id);
		return $query->num_rows>0;
	}
	public function addchannelToPackage($product_id,$pkg_id)
	{
		// $query = $this->db->query("UPDATE " . DB_PREFIX . "product set `channel_list` = if(`channel_list` is null, '$chname,', concat(`channel_list`, '$chname,')) WHERE product_id = '".$product_id."'");
		$query = $this->db->query("INSERT INTO " . DB_PREFIX . "productToPackage (product_id, package_id) VALUES (".$product_id.",".$pkg_id.")");
	}

	public function isduplicatepackageno($pkg_no,$pkg_name)
	{
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_description pd, " . DB_PREFIX . "product p WHERE  pd.name != '" . $this->db->escape($pkg_name) . "' AND p.model='".$pkg_no."' AND p.is_package=1");
		return $query->num_rows>0;
	}
	public function isduplicatepackagenoFromId($pkg_no,$pkg_id)
	{
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product WHERE  product_id != '" . $pkg_id . "' AND model='".$pkg_no."' AND is_package=1");
		return $query->num_rows>0;
	}
	public function getProductNos($values) {
		$res=array();	 
		$count = 0;
		$list = "";
		foreach ($values as $key => $value) {
			if ($count==0) {
				$list = $value["api_product_id"];
			}else{
				$list = $list.",".$value["api_product_id"];
			}
		 	$count++;		 	
		}
		// var_dump($list);exit();
        $query = $this->db->query("SELECT DISTINCT model AS model,pd.name AS name FROM oc_sms_kms_product skp left join oc_product p ON (skp.product_id = p.product_id) LEFT JOIN oc_product_description pd ON (p.product_id=pd.product_id) where skp.api_product_id in ($list) AND skp.is_package=0 AND skp.is_ppv=0");  

        return $query->rows;
	}
	public function getProductIDS($values) {
		$res=array();	 
		$count = 0;
		$list = "";
		foreach ($values as $key => $value) {
			if ($count==0) {
				$list = "'".$value."'";
			}else{
				$list = $list.","."'".$value."'";
			}
		 	$count++;		 	
		}
		// var_dump($list);exit();
        $query = $this->db->query("SELECT DISTINCT product_id FROM oc_product_description pd where pd.product_id in ($list)");  
        
        return $query->rows;
	}
	public function getProductNosduringUpdate($values) {
		$res=array();	 
		$count = 0;
		$list = "";
		foreach ($values as $key => $value) {
			if ($count==0) {
				$list = $value["product_id"];
			}else{
				$list = $list.",".$value["product_id"];
			}
		 	$count++;		 	
		}
		
        $query = $this->db->query("SELECT DISTINCT model AS model, pd.name AS name FROM oc_product p LEFT JOIN oc_product_description pd ON (p.product_id = pd.product_id) where p.product_id in ($list) AND p.is_package=0 AND p.is_ppv=0 AND p.is_nvod=0");  

        return $query->rows;
	}

	public function getSubscriptionDurationName($option_value_id)	{
		$query = $this->db->query("SELECT name FROM " . DB_PREFIX . "option_value_description WHERE  option_value_id = '" . $option_value_id . "'");		
		return $query->row['name'];
	}

	public function getRegions()	{
		$query = $this->db->query("SELECT region_name,region_id FROM " . DB_PREFIX . "region" );		
		return $query->rows;
	}

	public function addlogPackageModification($pkg_no,$pkg_name,$t_product_no){
		$t = time();
		$query = $this->db->query("INSERT INTO " . DB_PREFIX . "logPackageModification SET package_number = '" . $pkg_no . "',package_name = '" . $pkg_name . "',startdate = NOW(), batchno ='".$t."',status = 'NEW' ");
		foreach ($t_product_no as $key => $value) {
			$this->db->query("INSERT INTO oc_logPkgProductModification(batchno, product_number,product_name, status) VALUES (".$t.",".$value['model'].",'".$value['name']."','IN')");
		}
	}

	public function editlogPackageModification($pkg_no,$pkg_name,$t_product_no,$deleted_prd_no,$added_prd_no){
		
		$t = time();
		$t_product_no 	= trim($t_product_no,",");
		$deleted_prd_no = trim($deleted_prd_no,",");
		$added_prd_no 	= trim($added_prd_no,",");

		$t_product_no_arr 	= explode(",", $t_product_no);		
		if(strlen($deleted_prd_no))
			$deleted_prd_no_arr = explode(",", $deleted_prd_no);
		if(strlen($added_prd_no))
			$added_prd_no_arr	= explode(",", $added_prd_no);
		
		$query = $this->db->query("SELECT batchno FROM " . DB_PREFIX . "logPackageModification WHERE package_number = '".$pkg_no."' ORDER BY id DESC LIMIT 1" );
		
		$this->db->query("UPDATE " . DB_PREFIX . "logPackageModification SET enddate = NOW() WHERE batchno = '".$query->row['batchno']."'");
		$query = $this->db->query("INSERT INTO " . DB_PREFIX . "logPackageModification SET package_number = '" . $pkg_no . "',package_name = '" . $pkg_name . "',startdate = NOW(), batchno ='".$t."',status = 'MODIFY' ");
		
		if(isset($added_prd_no_arr))
			$no_change_arr = array_diff($t_product_no_arr, $added_prd_no_arr);
		
		if(isset($added_prd_no_arr)){
			foreach ($added_prd_no_arr as $key => $value) {				
				$query = $this->db->query("SELECT name FROM " . DB_PREFIX . "product_description pd inner join " . DB_PREFIX . "product p ON (p.product_id=pd.product_id) WHERE p.model = '".$value."'" );	
				$this->db->query("INSERT INTO oc_logPkgProductModification(batchno, product_number,product_name, status) VALUES (".$t.",".$value.",'".$query->row['name']."','IN')");
			}
		}
		if(isset($deleted_prd_no_arr)){
			foreach ($deleted_prd_no_arr as $key => $value) {
				$query = $this->db->query("SELECT name FROM " . DB_PREFIX . "product_description pd inner join " . DB_PREFIX . "product p ON (p.product_id=pd.product_id) WHERE p.model = '".$value."'" );	
				$this->db->query("INSERT INTO oc_logPkgProductModification(batchno, product_number,product_name, status) VALUES (".$t.",".$value.",'".$query->row['name']."','OUT')");
			}
		}
		if(isset($no_change_arr)){
			foreach ($no_change_arr as $key => $value) {
				$query = $this->db->query("SELECT name FROM " . DB_PREFIX . "product_description pd inner join " . DB_PREFIX . "product p ON (p.product_id=pd.product_id) WHERE p.model = '".$value."'" );	
				$this->db->query("INSERT INTO oc_logPkgProductModification(batchno, product_number,product_name, status) VALUES (".$t.",".$value.",'".$query->row['name']."','NC')");

			}
		}else{
			foreach ($t_product_no_arr as $key => $value) {
				$query = $this->db->query("SELECT name FROM " . DB_PREFIX . "product_description pd inner join " . DB_PREFIX . "product p ON (p.product_id=pd.product_id) WHERE p.model = '".$value."'" );	
				$this->db->query("INSERT INTO oc_logPkgProductModification(batchno, product_number,product_name, status) VALUES (".$t.",".$value.",'".$query->row['name']."','NC')");
			}
		}
	}
}
?>