<?php
/*
@File category.php(MODEL)
CATALOG:	 CATEGORY PAGE
    Manages the category list by retrieving it from database or adding it to the database.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ModelCatalogCategory extends Model {
/*
FUNCTION NAME 		-	addCategory
DESCRIPTION 		-	Adds new category detail to the database generating unique category_id.
INPUT PARAMETER 	-	category details as an array
OUTPUT PARAMETER 	- 	Adds detail to the database and returns to the category list page with a success notification
*/	
	public function addCategory($data) {
		$this->db->query("INSERT INTO " . DB_PREFIX . "category SET parent_id = '" . (int)$data['parent_id'] . "', `top` = '" . (isset($data['top']) ? (int)$data['top'] : 0) . "', `column` = '" . (int)$data['column'] . "', sort_order = '" . (int)$data['sort_order'] . "', status = '" . (int)$data['status'] . "', date_modified = NOW(), date_added = NOW()");

		$category_id = $this->db->getLastId();
				
		if (isset($data['image'])) {
			$this->db->query("UPDATE " . DB_PREFIX . "category SET image = '" . $this->db->escape(html_entity_decode($data['image'], ENT_QUOTES, 'UTF-8')) . "' WHERE category_id = '" . (int)$category_id . "'");
		}
		
		foreach ($data['category_description'] as $language_id => $value) {
			$this->db->query("INSERT INTO " . DB_PREFIX . "category_description SET category_id = '" . (int)$category_id . "', language_id = '" . (int)$language_id . "', name = '" . $this->db->escape($value['name']) . "', meta_keyword = '" . $this->db->escape($value['meta_keyword']) . "', meta_description = '" . $this->db->escape($value['meta_description']) . "', description = '" . $this->db->escape($value['description']) . "'");
		}

		// MySQL Hierarchical Data Closure Table Pattern
		$level = 0;
		
		$query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "category_path` WHERE category_id = '" . (int)$data['parent_id'] . "' ORDER BY `level` ASC");
		
		foreach ($query->rows as $result) {
			$this->db->query("INSERT INTO `" . DB_PREFIX . "category_path` SET `category_id` = '" . (int)$category_id . "', `path_id` = '" . (int)$result['path_id'] . "', `level` = '" . (int)$level . "'");
			
			$level++;
		}
		
		$this->db->query("INSERT INTO `" . DB_PREFIX . "category_path` SET `category_id` = '" . (int)$category_id . "', `path_id` = '" . (int)$category_id . "', `level` = '" . (int)$level . "'");

		if (isset($data['category_filter'])) {
			foreach ($data['category_filter'] as $filter_id) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "category_filter SET category_id = '" . (int)$category_id . "', filter_id = '" . (int)$filter_id . "'");
			}
		}
				
		if (isset($data['category_store'])) {
			foreach ($data['category_store'] as $store_id) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "category_to_store SET category_id = '" . (int)$category_id . "', store_id = '" . (int)$store_id . "'");
			}
		}
		
		// Set which layout to use with this category
		if (isset($data['category_layout'])) {
			foreach ($data['category_layout'] as $store_id => $layout) {
				if ($layout['layout_id']) {
					$this->db->query("INSERT INTO " . DB_PREFIX . "category_to_layout SET category_id = '" . (int)$category_id . "', store_id = '" . (int)$store_id . "', layout_id = '" . (int)$layout['layout_id'] . "'");
				}
			}
		}
						
		if ($data['keyword']) {
			$this->db->query("INSERT INTO " . DB_PREFIX . "url_alias SET query = 'category_id=" . (int)$category_id . "', keyword = '" . $this->db->escape($data['keyword']) . "'");
		}
		
		$this->cache->delete('category');
	}
/*
FUNCTION NAME 		-	editCategory
DESCRIPTION 		-	Updates category details for the selected category_id.
INPUT PARAMETER 	-	category_id, category details as an array
OUTPUT PARAMETER 	- 	Adds detail to the database and returns to the category list page with a success notification
*/	
	public function editCategory($category_id, $data) {
		$this->db->query("UPDATE " . DB_PREFIX . "category SET parent_id = '" . (int)$data['parent_id'] . "', `top` = '" . (isset($data['top']) ? (int)$data['top'] : 0) . "', `column` = '" . (int)$data['column'] . "', sort_order = '" . (int)$data['sort_order'] . "', status = '" . (int)$data['status'] . "', date_modified = NOW() WHERE category_id = '" . (int)$category_id . "'");

		if (isset($data['image'])) {
			$this->db->query("UPDATE " . DB_PREFIX . "category SET image = '" . $this->db->escape(html_entity_decode($data['image'], ENT_QUOTES, 'UTF-8')) . "' WHERE category_id = '" . (int)$category_id . "'");
		}

		$this->db->query("DELETE FROM " . DB_PREFIX . "category_description WHERE category_id = '" . (int)$category_id . "'");

		foreach ($data['category_description'] as $language_id => $value) {
			$this->db->query("INSERT INTO " . DB_PREFIX . "category_description SET category_id = '" . (int)$category_id . "', language_id = '" . (int)$language_id . "', name = '" . $this->db->escape($value['name']) . "', meta_keyword = '" . $this->db->escape($value['meta_keyword']) . "', meta_description = '" . $this->db->escape($value['meta_description']) . "', description = '" . $this->db->escape($value['description']) . "'");
		}
		
		// MySQL Hierarchical Data Closure Table Pattern
		$query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "category_path` WHERE path_id = '" . (int)$category_id . "' ORDER BY level ASC");
		
		if ($query->rows) {
			foreach ($query->rows as $category_path) {
				// Delete the path below the current one
				$this->db->query("DELETE FROM `" . DB_PREFIX . "category_path` WHERE category_id = '" . (int)$category_path['category_id'] . "' AND level < '" . (int)$category_path['level'] . "'");
				
				$path = array();
				
				// Get the nodes new parents
				$query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "category_path` WHERE category_id = '" . (int)$data['parent_id'] . "' ORDER BY level ASC");
				
				foreach ($query->rows as $result) {
					$path[] = $result['path_id'];
				}
				
				// Get whats left of the nodes current path
				$query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "category_path` WHERE category_id = '" . (int)$category_path['category_id'] . "' ORDER BY level ASC");
				
				foreach ($query->rows as $result) {
					$path[] = $result['path_id'];
				}
				
				// Combine the paths with a new level
				$level = 0;
				
				foreach ($path as $path_id) {
					$this->db->query("REPLACE INTO `" . DB_PREFIX . "category_path` SET category_id = '" . (int)$category_path['category_id'] . "', `path_id` = '" . (int)$path_id . "', level = '" . (int)$level . "'");
					
					$level++;
				}
			}
		} else {
			// Delete the path below the current one
			$this->db->query("DELETE FROM `" . DB_PREFIX . "category_path` WHERE category_id = '" . (int)$category_id . "'");
			
			// Fix for records with no paths
			$level = 0;
			
			$query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "category_path` WHERE category_id = '" . (int)$data['parent_id'] . "' ORDER BY level ASC");
			
			foreach ($query->rows as $result) {
				$this->db->query("INSERT INTO `" . DB_PREFIX . "category_path` SET category_id = '" . (int)$category_id . "', `path_id` = '" . (int)$result['path_id'] . "', level = '" . (int)$level . "'");
				
				$level++;
			}
			
			$this->db->query("REPLACE INTO `" . DB_PREFIX . "category_path` SET category_id = '" . (int)$category_id . "', `path_id` = '" . (int)$category_id . "', level = '" . (int)$level . "'");
		}

		$this->db->query("DELETE FROM " . DB_PREFIX . "category_filter WHERE category_id = '" . (int)$category_id . "'");
		
		if (isset($data['category_filter'])) {
			foreach ($data['category_filter'] as $filter_id) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "category_filter SET category_id = '" . (int)$category_id . "', filter_id = '" . (int)$filter_id . "'");
			}		
		}
				
		$this->db->query("DELETE FROM " . DB_PREFIX . "category_to_store WHERE category_id = '" . (int)$category_id . "'");
		
		if (isset($data['category_store'])) {		
			foreach ($data['category_store'] as $store_id) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "category_to_store SET category_id = '" . (int)$category_id . "', store_id = '" . (int)$store_id . "'");
			}
		}
		
		$this->db->query("DELETE FROM " . DB_PREFIX . "category_to_layout WHERE category_id = '" . (int)$category_id . "'");

		if (isset($data['category_layout'])) {
			foreach ($data['category_layout'] as $store_id => $layout) {
				if ($layout['layout_id']) {
					$this->db->query("INSERT INTO " . DB_PREFIX . "category_to_layout SET category_id = '" . (int)$category_id . "', store_id = '" . (int)$store_id . "', layout_id = '" . (int)$layout['layout_id'] . "'");
				}
			}
		}
						
		$this->db->query("DELETE FROM " . DB_PREFIX . "url_alias WHERE query = 'category_id=" . (int)$category_id. "'");
		
		if ($data['keyword']) {
			$this->db->query("INSERT INTO " . DB_PREFIX . "url_alias SET query = 'category_id=" . (int)$category_id . "', keyword = '" . $this->db->escape($data['keyword']) . "'");
		}
		
		$this->cache->delete('category');
	}
/*
FUNCTION NAME 		-	deleteCategory
DESCRIPTION 		-	Deletes category detail form the database for the selected category_id.
INPUT PARAMETER 	-	category_id
OUTPUT PARAMETER 	- 	Deletes detail from the database and returns to the category list page with a success notification
*/	
	public function deleteCategory($category_id) {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "category_path WHERE path_id IN ( " . $category_id . ")");
			
		foreach ($query->rows as $result) {	
			$this->db->query("DELETE FROM " . DB_PREFIX . "category WHERE category_id IN ( " . $category_id . ")");
			$this->db->query("DELETE FROM " . DB_PREFIX . "category_description WHERE category_id IN ( " . $category_id . ")");
			$this->db->query("DELETE FROM " . DB_PREFIX . "category_path WHERE category_id IN ( " . $category_id . ")");
			$this->db->query("DELETE FROM " . DB_PREFIX . "category_filter WHERE category_id IN ( " . $category_id . ")");
			$this->db->query("DELETE FROM " . DB_PREFIX . "category_to_store WHERE category_id IN ( " . $category_id . ")");
			$this->db->query("DELETE FROM " . DB_PREFIX . "category_to_layout WHERE category_id IN ( " . $category_id . ")");
			$this->db->query("DELETE FROM " . DB_PREFIX . "product_to_category WHERE category_id IN ( " . $category_id . ")");
			$this->db->query("DELETE FROM " . DB_PREFIX . "url_alias WHERE query = 'category_id =" . $category_id . "'");
		}
		
		$this->cache->delete('category');
	} 
/*
FUNCTION NAME 		-	repairCategories
DESCRIPTION 		-	Function to repair any erroneous categories that are not in the category path table.
INPUT PARAMETER 	-	parent_id, If parent id in not defined, this function takes 0 as default.
OUTPUT PARAMETER 	- 	Returns to the list after repair
*/	
	public function repairCategories($parent_id = 0) {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "category WHERE parent_id = '" . (int)$parent_id . "'");
		
		foreach ($query->rows as $category) {
			// Delete the path below the current one
			$this->db->query("DELETE FROM `" . DB_PREFIX . "category_path` WHERE category_id = '" . (int)$category['category_id'] . "'");
			
			// Fix for records with no paths
			$level = 0;
			
			$query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "category_path` WHERE category_id = '" . (int)$parent_id . "' ORDER BY level ASC");
			
			foreach ($query->rows as $result) {
				$this->db->query("INSERT INTO `" . DB_PREFIX . "category_path` SET category_id = '" . (int)$category['category_id'] . "', `path_id` = '" . (int)$result['path_id'] . "', level = '" . (int)$level . "'");
				
				$level++;
			}
			
			$this->db->query("REPLACE INTO `" . DB_PREFIX . "category_path` SET category_id = '" . (int)$category['category_id'] . "', `path_id` = '" . (int)$category['category_id'] . "', level = '" . (int)$level . "'");
						
			$this->repairCategories($category['category_id']);
		}
	}
/*
FUNCTION NAME 		-	getCategory
DESCRIPTION 		-	Retrieves category from the database based on the given category_id.
INPUT PARAMETER 	-	category_id
OUTPUT PARAMETER 	- 	Retruns a row queried containing details of the category.
*/			
	public function getCategory($category_id) {
		$query = $this->db->query("SELECT DISTINCT *, (SELECT GROUP_CONCAT(cd1.name ORDER BY level SEPARATOR ' &gt; ') FROM " . DB_PREFIX . "category_path cp LEFT JOIN " . DB_PREFIX . "category_description cd1 ON (cp.path_id = cd1.category_id AND cp.category_id != cp.path_id) WHERE cp.category_id = c.category_id AND cd1.language_id = '" . (int)$this->config->get('config_language_id') . "' GROUP BY cp.category_id) AS path, (SELECT keyword FROM " . DB_PREFIX . "url_alias WHERE query = 'category_id=" . (int)$category_id . "') AS keyword FROM " . DB_PREFIX . "category c LEFT JOIN " . DB_PREFIX . "category_description cd2 ON (c.category_id = cd2.category_id) WHERE c.category_id = '" . (int)$category_id . "' AND cd2.language_id = '" . (int)$this->config->get('config_language_id') . "'");
		
		return $query->row;
	} 
/*
FUNCTION NAME 		-	getCategories
DESCRIPTION 		-	Retrieves all the categories from the database. 
INPUT PARAMETER 	-	data array for filter options if any.
OUTPUT PARAMETER 	- 	Returns all the rows queried, containing category details.
*/	
	public function getCategories($data) {
		// $sql = "SELECT cp.category_id AS category_id, GROUP_CONCAT(cd1.name ORDER BY cp.level SEPARATOR ' &gt; ') AS name, c.parent_id, c.sort_order FROM " . DB_PREFIX . "category_path cp LEFT JOIN " . DB_PREFIX . "category c ON (cp.path_id = c.category_id) LEFT JOIN " . DB_PREFIX . "category_description cd1 ON (c.category_id = cd1.category_id) LEFT JOIN " . DB_PREFIX . "category_description cd2 ON (cp.category_id = cd2.category_id) WHERE cd1.language_id = '" . (int)$this->config->get('config_language_id') . "' AND cd2.language_id = '" . (int)$this->config->get('config_language_id') . "'";
		
		// if (!empty($data['filter_name'])) {
		// 	$sql .= " AND cd2.name LIKE '" . $this->db->escape($data['filter_name']) . "%'";
		// }

		// $sql .= " GROUP BY cp.category_id ORDER BY name";
		
		// if (isset($data['start']) || isset($data['limit'])) {
		// 	if ($data['start'] < 0) {
		// 		$data['start'] = 0;
		// 	}				

		// 	if ($data['limit'] < 1) {
		// 		$data['limit'] = 20;
		// 	}	
		 
		// 	$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		// }
						
		// $query = $this->db->query($sql);
		
		// return $query->rows;

		$sql = "SELECT cp.category_id AS category_id, GROUP_CONCAT(cd1.name ORDER BY cp.level SEPARATOR '&nbsp;&nbsp;&gt;&nbsp;&nbsp;') AS name, c1.parent_id, c1.sort_order FROM " . DB_PREFIX . "category_path cp LEFT JOIN " . DB_PREFIX . "category c1 ON (cp.category_id = c1.category_id) LEFT JOIN " . DB_PREFIX . "category c2 ON (cp.path_id = c2.category_id) LEFT JOIN " . DB_PREFIX . "category_description cd1 ON (cp.path_id = cd1.category_id) LEFT JOIN " . DB_PREFIX . "category_description cd2 ON (cp.category_id = cd2.category_id) WHERE cd1.language_id = '" . (int)$this->config->get('config_language_id') . "' AND cd2.language_id = '" . (int)$this->config->get('config_language_id') . "'";

		if (!empty($data['filter_name'])) {
			$sql .= " AND cd2.name LIKE '" . $this->db->escape($data['filter_name']) . "%'";
		}

		$sql .= " GROUP BY cp.category_id";

		$sort_data = array(
			'name',
			'sort_order'
		);

		if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
			$sql .= " ORDER BY " . $data['sort'];
		} else {
			$sql .= " ORDER BY sort_order";
		}

		if (isset($data['order']) && ($data['order'] == 'DESC')) {
			$sql .= " DESC";
		} else {
			$sql .= " ASC";
		}

		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

		$query = $this->db->query($sql);

		return $query->rows;

		
	}
				
	
/*
FUNCTION NAME 		-	getCategories
DESCRIPTION 		-	Retrieves all the categories from the database. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows queried containing category details.
*/
public function getAllCategories() {
		$categories = array();
		
		//$query = $this->db->query("SELECT DISTINCT(category_id) , name FROM " . DB_PREFIX . "category_description WHERE category_id  IN ( SELECT DISTINCT(category_id) from " . DB_PREFIX ."category WHERE parent_id=(select DISTINCT(category_id) from oc_category_description where name = 'channel packages')) GROUP BY category_id");
		$query = $this->db->query("SELECT DISTINCT(category_id) , name FROM " . DB_PREFIX . "category_description WHERE category_id  IN ( SELECT DISTINCT(category_id) from " . DB_PREFIX ."category) GROUP BY category_id");
		
		foreach ($query->rows as $result) {
			$categories[] = array(
				'category_id'      => $result['category_id'],
				'name'             => $result['name'],
			);
		}
		
		return $categories;
	}

/*
FUNCTION NAME 		-	getCategoryDescriptions
DESCRIPTION 		-	Retrieves the description for the given category_id
INPUT PARAMETER 	-	category_id
OUTPUT PARAMETER 	- 	Retruns an array conatining the category description
*/
	public function getCategoryDescriptions($category_id) {
		$category_description_data = array();
		
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "category_description WHERE category_id = '" . (int)$category_id . "'");
		
		foreach ($query->rows as $result) {
			$category_description_data[$result['language_id']] = array(
				'name'             => $result['name'],
				'meta_keyword'     => $result['meta_keyword'],
				'meta_description' => $result['meta_description'],
				'description'      => $result['description']
			);
		}
		
		return $category_description_data;
	}	
/*
FUNCTION NAME 		-	getCategoryFilters
DESCRIPTION 		-	Retrieves all the filters that can be applied on this given category_id
INPUT PARAMETER 	-	category_id
OUTPUT PARAMETER 	- 	Retruns an array containing the details of the filter group data.
*/	
	public function getCategoryFilters($category_id) {
		$category_filter_data = array();
		
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "category_filter WHERE category_id = '" . (int)$category_id . "'");
		
		foreach ($query->rows as $result) {
			$category_filter_data[] = $result['filter_id'];
		}

		return $category_filter_data;
	}

/*
FUNCTION NAME 		-	getCategoryStores
DESCRIPTION 		-	Retrieves the rows containing the details about the given category_id to extract the 
						store. 
INPUT PARAMETER 	-	category_id
OUTPUT PARAMETER 	- 	Returns the category_store_data containing the store_id for the selected category_id
*/	
	public function getCategoryStores($category_id) {
		$category_store_data = array();
		
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "category_to_store WHERE category_id = '" . (int)$category_id . "'");

		foreach ($query->rows as $result) {
			$category_store_data[] = $result['store_id'];
		}
		
		return $category_store_data;
	}
/*
FUNCTION NAME 		-	getCategoryLayouts
DESCRIPTION 		-	Retrieves the layout cateogry map details
INPUT PARAMETER 	-	category_id
OUTPUT PARAMETER 	- 	Returns the category_layout_data containing the layout id.
*/
	public function getCategoryLayouts($category_id) {
		$category_layout_data = array();
		
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "category_to_layout WHERE category_id = '" . (int)$category_id . "'");
		
		foreach ($query->rows as $result) {
			$category_layout_data[$result['store_id']] = $result['layout_id'];
		}
		
		return $category_layout_data;
	}
/*
FUNCTION NAME 		-	getTotalCategories
DESCRIPTION 		-	Retrieves the rows containing the count of rows in the category database.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns a column "total" containing the count of categories in the database.
*/		
	public function getTotalCategories() {
      	$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "category WHERE is_default=0");
		
		return $query->row['total'];
	}	
/*
FUNCTION NAME 		-	getTotalCategoriesByImageId
DESCRIPTION 		-	Retrieves the rows containing the count of rows in category table for the given image_id.
INPUT PARAMETER 	-	image_id
OUTPUT PARAMETER 	- 	Returns a column "total" containing the count of categories in the database.
*/		
	public function getTotalCategoriesByImageId($image_id) {
      	$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "category WHERE image_id = '" . (int)$image_id . "'");
		
		return $query->row['total'];
	}
/*
FUNCTION NAME 		-	getTotalCategoriesByLayoutId
DESCRIPTION 		-	Retrieves the row containing the count of rows in category_to_layout table for the given layout_id.
INPUT PARAMETER 	-	layout_id
OUTPUT PARAMETER 	- 	Returns a column "total" containing the count of categories in the database.
*/
	public function getTotalCategoriesByLayoutId($layout_id) {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "category_to_layout WHERE layout_id = '" . (int)$layout_id . "'");

		return $query->row['total'];
	}		

	public function CheckCategoryName($category_name){
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "category_description WHERE name = '" . $category_name . "'");

		return $query->row;
	}

	public function CheckParentId($parent_id){
		$query = $this->db->query("SELECT *  FROM " . DB_PREFIX . "category_description WHERE `category_id` = '" . (int)$parent_id . "'");
			return $query->row;
	}

	public function CheckCategoryNameByid($category_id){
		$query = $this->db->query("SELECT name FROM " . DB_PREFIX . "category_description WHERE `category_id` = '" . $category_id . "'");

		return $query->row;
	}

/*
FUNCTION NAME 		-	setDefaultCategories
DESCRIPTION 		-	update category as default based on the given category_id.
INPUT PARAMETER 	-	category_id
OUTPUT PARAMETER 	- 	Void
*/	
	public function	setDefaultCategories($category_id)
	{
		$this->db->query("UPDATE " . DB_PREFIX . "category SET is_default = 1 WHERE category_id = '" . (int)$category_id . "'");	
		$this->db->query("UPDATE " . DB_PREFIX . "category SET is_default = 0 WHERE category_id <> '" . (int)$category_id . "'");	
	}
/*
FUNCTION NAME 		-	checkCategoryIsDefault
DESCRIPTION 		-	check the category is default caterory
INPUT PARAMETER 	-	category_id
OUTPUT PARAMETER 	- 	is_default
*/	

	public function checkCategoryIsDefault($category_id){
		$query = $this->db->query("SELECT is_default FROM " . DB_PREFIX . "category WHERE `category_id` IN ( " . $category_id . ")");

		return $query->row['is_default'];
	}
/*FUNCTION NAME 		-	checkCategoryMapWithProduct
DESCRIPTION 		-	check the category is map with product 
INPUT PARAMETER 	-	category_id
OUTPUT PARAMETER 	- 	is_default
*/	

	public function checkCategoryMapWithProduct($category_id){
		$query = $this->db->query("SELECT category_id FROM " . DB_PREFIX . "product_to_category p  
				 WHERE p.category_id IN ( " . $category_id . ")");
		if($query->row!=NULL)
		return $query->row['category_id'];
	}

/*
FUNCTION NAME 		-	checkCategoryMapWithProductParentChild
DESCRIPTION 		-	check the category is map with parent or chlid
INPUT PARAMETER 	-	category_id
OUTPUT PARAMETER 	- 	is_default
*/	

	public function checkCategoryMapWithProductParentChild($category_id){
		$query = $this->db->query("SELECT c.category_id, d.name FROM " . DB_PREFIX . "category c 
				 INNER JOIN oc_category_description d ON d.category_id = c.category_id 
				 WHERE  c.parent_id ='".$category_id."'");
		if($query->row!=NULL)
		return $query->row;

	}
	
}
?>