<?php
/*
@File broadcaster.php(MODEL)
CATALOG:	 broadcaster PAGE
    Manages the broadcaster list by retrieving/adding/editing it from database.

@Author Mahesh Yallure
@date 16th dec. 2015
*/
class ModelCatalogBroadcastergroup extends Model {
/*
FUNCTION NAME 		-	addBroadcaster
DESCRIPTION 		-	Adds new broadcaster detail to the database.
INPUT PARAMETER 	-	broadcaster details as an array 
OUTPUT PARAMETER 	- 	Adds to the database and returns to the broadcaster list page with a success notification
*/		
	public function addBroadcaster($data) {
      	$this->db->query("INSERT INTO " . DB_PREFIX . "broadcaster SET name = '" . $this->db->escape(trim(preg_replace('!\s+!', ' ', $data['name']),' ')) . "', sort_order = '" . (int)$data['sort_order'] . "',broadcaster_email = '" .$data['email']. "',broadcaster_mobile = '".$data['telephone'] . "',broadcaster_city = '" .$data['city']. "',broadcaster_pin = '" .$data['postcode']. "',country_id = '" .$data["country_id"]. "',zone_id = '" .$data["zone_id"]. "'");
		
		$broadcaster_id = $this->db->getLastId();

		if (isset($data['image'])) {
			$this->db->query("UPDATE " . DB_PREFIX . "broadcaster SET image = '" . $this->db->escape(html_entity_decode($data['image'], ENT_QUOTES, 'UTF-8')) . "' WHERE broadcaster_id = '" . (int)$broadcaster_id . "'");
		}
		
		if (isset($data['broadcaster_store'])) {
			foreach ($data['broadcaster_store'] as $store_id) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "broadcaster_to_store SET broadcaster_id = '" . (int)$broadcaster_id . "', store_id = '" . (int)$store_id . "'");
			}
		}
			
		if (isset($data['product_detail'])) {
			foreach ($data['product_detail'] as $details) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "broadcaster_channel SET channel_name = '".trim(preg_replace('!\s+!', ' ', $details["name"]),' ')."',broadcaster_id = '" . (int)$broadcaster_id . "'");
			}
		}

		if ($data['keyword']) {
			$this->db->query("INSERT INTO " . DB_PREFIX . "url_alias SET query = 'broadcaster_id=" . (int)$broadcaster_id . "', keyword = '" . $this->db->escape($data['keyword']) . "'");
		}
		
		$this->cache->delete('manufacturer');
	}
/*
FUNCTION NAME 		-	editBroadcaster
DESCRIPTION 		-	Updates broadcaster details for the selected broadcaster_id.
INPUT PARAMETER 	-	broadcaster_id, broadcaster details as an array
OUTPUT PARAMETER 	- 	Adds detail to the database and returns to the broadcaster list page with a success notification
*/	
	public function editBroadcaster($broadcaster_id, $data) {
      	$this->db->query("UPDATE " . DB_PREFIX . "broadcaster SET name = '" . $this->db->escape(trim(preg_replace('!\s+!', ' ', $data['name']),' ')) . "', sort_order = '" . (int)$data['sort_order'] . "',broadcaster_email = '" .$data['email']. "',broadcaster_mobile = '".$data['telephone'] . "',broadcaster_city = '" .$data['city']. "',broadcaster_pin = '" .$data['postcode']. "',country_id = '" .$data["country_id"]. "',zone_id = '" .$data["zone_id"]. "' WHERE broadcaster_id = '" . (int)$broadcaster_id . "'");

		if (isset($data['image'])) {
			$this->db->query("UPDATE " . DB_PREFIX . "broadcaster SET image = '" . $this->db->escape(html_entity_decode($data['image'], ENT_QUOTES, 'UTF-8')) . "' WHERE broadcaster_id = '" . (int)$broadcaster_id . "'");
		}
		
		$this->db->query("DELETE FROM " . DB_PREFIX . "broadcaster_to_store WHERE broadcaster_id = '" . (int)$broadcaster_id . "'");

		if (isset($data['broadcaster_store'])) {
			foreach ($data['broadcaster_store'] as $store_id) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "broadcaster_to_store SET broadcaster_id = '" . (int)$broadcaster_id . "', store_id = '" . (int)$store_id . "'");
			}
		}
			
		$this->db->query("DELETE FROM " . DB_PREFIX . "broadcaster_channel WHERE broadcaster_id = '" . (int)$broadcaster_id . "'");
		if (isset($data['product_detail'])) {
			foreach ($data['product_detail'] as $details) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "broadcaster_channel SET channel_name = '".trim(preg_replace('!\s+!', ' ', $details["name"]),' ')."',broadcaster_id = '" . (int)$broadcaster_id . "'");
			}
		}


		$this->db->query("DELETE FROM " . DB_PREFIX . "url_alias WHERE query = 'broadcaster_id=" . (int)$broadcaster_id. "'");
		
		if ($data['keyword']) {
			$this->db->query("INSERT INTO " . DB_PREFIX . "url_alias SET query = 'broadcaster_id=" . (int)$broadcaster_id . "', keyword = '" . $this->db->escape($data['keyword']) . "'");
		}
		
		$this->cache->delete('broadcaster');
	}
/*
FUNCTION NAME 		-	deleteBroadcaster
DESCRIPTION 		-	Deletes broadcaster detail form the database for the selected broadcaster_id.
INPUT PARAMETER 	-	broadcaster_id
OUTPUT PARAMETER 	- 	Deletes detail from the database and returns to the broadcaster list page with a success notification
*/	
	public function deleteBroadcaster($broadcaster_id) {
		$this->db->query("DELETE FROM " . DB_PREFIX . "broadcaster WHERE broadcaster_id = '" . (int)$broadcaster_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "broadcaster_to_store WHERE broadcaster_id = '" . (int)$broadcaster_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "url_alias WHERE query = 'broadcaster_id=" . (int)$broadcaster_id . "'");
			
		$this->cache->delete('broadcaster');
	}	
/*
FUNCTION NAME 		-	getBroadcaster
DESCRIPTION 		-	Retrieves broadcaster from the database based on the given broadcaster_id.
INPUT PARAMETER 	-	broadcaster_id
OUTPUT PARAMETER 	- 	Retruns a row queried containing details of the broadcaster.
*/	
	public function getBroadcaster($broadcaster_id) {
		$query = $this->db->query("SELECT DISTINCT *, (SELECT keyword FROM " . DB_PREFIX . "url_alias WHERE query = 'broadcaster_id=" . (int)$broadcaster_id . "') AS keyword FROM " . DB_PREFIX . "broadcaster WHERE broadcaster_id = '" . (int)$broadcaster_id . "'");
		
		return $query->row;
	}
/*
FUNCTION NAME 		-	getBroadcasters
DESCRIPTION 		-	Retrieves all the broadcasters from the database. 
INPUT PARAMETER 	-	data array for filter options if any.
OUTPUT PARAMETER 	- 	Returns all the rows queried, containing broadcaster details.
*/		
	public function getBroadcasters($data = array()) {
		// $sql = "SELECT * FROM " . DB_PREFIX . "broadcaster WHERE broadcaster_id !=24";
		$sql = "SELECT * FROM " . DB_PREFIX . "broadcaster ";

		if (!empty($data['filter_name'])) {
			$sql .= " WHERE name LIKE '" . $this->db->escape($data['filter_name']) . "%'";
		}
		
		$sort_data = array(
			'name',
			'sort_order'
		);	
		
		if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
			$sql .= " ORDER BY " . $data['sort'];	
		} else {
			$sql .= " ORDER BY name";	
		}
		
		if (isset($data['order']) && ($data['order'] == 'DESC')) {
			$sql .= " DESC";
		} else {
			$sql .= " ASC";
		}
		
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}					

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
		
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}				
		
		$query = $this->db->query($sql);
	
		return $query->rows;
	}
/*
FUNCTION NAME 		-	getbroadcasterStores
DESCRIPTION 		-	Retrieves the rows containing the details about the given broadcastere_id to extract the 
						store mapped. 
INPUT PARAMETER 	-	broadcaster_id
OUTPUT PARAMETER 	- 	Returns the broadcaster_store_data containing the store_id for the selected broadcaster_id
*/	
	public function getBroadcasterStores($broadcaster_id) {
		$broadcaster_store_data = array();
		
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "broadcaster_to_store WHERE broadcaster_id = '" . (int)$broadcaster_id . "'");

		foreach ($query->rows as $result) {
			$broadcaster_store_data[] = $result['store_id'];
		}
		
		return $broadcaster_store_data;
	}
/*
FUNCTION NAME 		-	getTotalManufacturersByImageId
DESCRIPTION 		-	Retrieves the rows containing the count of rows in manufacturer table for the given image_id.
INPUT PARAMETER 	-	image_id
OUTPUT PARAMETER 	- 	Returns a column "total" containing the count of matching rows in the database.
*/		
	public function getTotalManufacturersByImageId($image_id) {
      	$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "broadcaster WHERE image_id = '" . (int)$image_id . "'");

		return $query->row['total'];
	}
/*
FUNCTION NAME 		-	getTotalBroadcasters
DESCRIPTION 		-	Retrieves the rows containing the count of rows in the broadcaster database.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns a column "total" containing the count of broadcaster in the database.
*/
	public function getTotalBroadcasters() {
      	$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "broadcaster WHERE broadcaster_id !=24");
		
		return $query->row['total'];
	}
/*
FUNCTION NAME 		-	getTotalBroadcasters
DESCRIPTION 		-	Retrieves the rows containing the count of rows in the broadcaster database.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns a column "total" containing the count of broadcaster in the database.
*/
	public function checkDuplicateBroadcaster($name,$broadcaster_id) {
      	$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "broadcaster  WHERE name = '" . $this->db->escape($name). "' AND broadcaster_id <> '".$broadcaster_id."'");
		
		return $query->row['total'];
	}

	/*
FUNCTION NAME 		-	getChannel
DESCRIPTION 		-	Retrieves the rows containing the count of rows in the broadcaster database.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns a column "total" containing the count of broadcaster in the database.
*/
	public function getChannel($broadcaster_id) {
     	$query = $this->db->query("SELECT channel_name as name FROM " . DB_PREFIX . "broadcaster_channel  WHERE  broadcaster_id = '".$broadcaster_id."'");

		
		return $query->rows;
	}

/*
FUNCTION NAME 		-	getChannelCount
DESCRIPTION 		-	Retrieves the rows containing the count of rows in the broadcaster database.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns a column "total" containing the count of broadcaster in the database.
*/
	public function getChannelCount($broadcaster_id) {
      	$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "broadcaster_channel WHERE broadcaster_id ='".$broadcaster_id."'");
		
		return $query->row['total'];
	}

	public function getBroadcasterInfo($broadcaster_id) {
		$query = $this->db->query("SELECT * FROM  ".DB_PREFIX."broadcaster_channel bc , ".DB_PREFIX."broadcaster bs WHERE bc.broadcaster_id =bs.broadcaster_id AND  bs.broadcaster_id = '" . (int)$broadcaster_id . "'");
		
		// $query = $this->db->query("SELECT * from " . DB_PREFIX . "broadcaster bs WHERE bs.broadcaster_id = '" . (int)$broadcaster_id . "'");
		

		return $query->row;
	}	

	    public function CheckProductDuplication($prod_name)
	{
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_description WHERE  name = '" . $this->db->escape($prod_name) . "'");
		return $query->num_rows>0;
	}
	public function CheckProductDuplicationFromBroadCaster($prod_name,$broadcaster_id)
	{
		$query = $this->db->query("SELECT channel_name FROM " . DB_PREFIX . "broadcaster_channel  WHERE  channel_name = '" . $this->db->escape($prod_name) . "' AND broadcaster_id !='".$broadcaster_id."' ");
		if($query->row!=NULL)
		return $query->row['channel_name'];
	}

			/*
		FUNCTION NAME 		-	getBroadcasterByEmail
		DESCRIPTION 		-	Retrieves the broadcaster details for the given email id
		INPUT PARAMETER 	-	email id
		OUTPUT PARAMETER 	- 	Returns the row retrieved.
		*/	
	public function getBroadcasterByEmail($email) {
		$query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "broadcaster WHERE LCASE(broadcaster_email) = '" . $this->db->escape(utf8_strtolower($email)) . "'");
	
		return $query->row;
	}

		/*
	FUNCTION NAME 		-	getCutomerByMobile
	DESCRIPTION 		-	Retrieves the customer details for the given mobile number
	INPUT PARAMETER 	-	mobile number
	OUTPUT PARAMETER 	- 	Returns the row retrieved.
	*/	
	public function getBroadcasterByMobile($mobile) {
		$query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "broadcaster WHERE broadcaster_mobile = '" . $this->db->escape($mobile) . "'");
	
		return $query->row;
	}
	/*
	FUNCTION NAME 		-	getTotalProductsByBroadcasterId
	DESCRIPTION 		-	Retrieves the rows containing the count of rows matching broadcaster_id
	INPUT PARAMETER 	-	broadcaster_id
	OUTPUT PARAMETER 	- 	Returns a column "total" containing the count of rows matched
	*/		
	public function getTotalProductsByBroadcasterId($broadcaster_id) {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "product WHERE broadcaster_id = '" . (int)$broadcaster_id . "'");

		return $query->row['total'];
	}
			/*
	FUNCTION NAME 		-	getCutomerByMobile
	DESCRIPTION 		-	Retrieves the customer details for the given mobile number
	INPUT PARAMETER 	-	mobile number
	OUTPUT PARAMETER 	- 	Returns the row retrieved.
	*/	
	public function getChaneelByBroadcaster($broadcaster_id) {
		$query = $this->db->query("SELECT channel_name FROM " . DB_PREFIX . "broadcaster_channel WHERE broadcaster_id = " . $broadcaster_id. "");
	
		return $query->rows;
	}
				/*
	FUNCTION NAME 		-	getCutomerByMobile
	DESCRIPTION 		-	Retrieves the customer details for the given mobile number
	INPUT PARAMETER 	-	mobile number
	OUTPUT PARAMETER 	- 	Returns the row retrieved.
	*/	
	public function getChanelFormProduct($name) {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_description pd inner join " . DB_PREFIX . "product p on pd.product_id=p.product_id WHERE pd.name = '".$name."' and p.broadcaster_id!='-1'");
	
		return $query->num_rows;
	}

	public function getZoneId($pin) {
		$query = $this->db->query("SELECT `zone_id` FROM " . DB_PREFIX . "broadcaster WHERE broadcaster_pin = '" . $this->db->escape($pin) . "'");
		if($query->num_rows>0){
			return $query->row['zone_id'];

		}else{
			return 0;
		}
		
	}



}
?>