<?php
/*
@File customer.php(MODEL)
REPORT:	 CUSTOMER PAGE
    This class queries the Total authorized subscribers as a  list from the database for the store
    to generate the report.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ModelBulkSubsListReport extends Model {
/*
FUNCTION NAME 		-	getCustomer
DESCRIPTION 		-	Queries the customer details based on the customer_id
INPUT PARAMETER 	-	customer_id
OUTPUT PARAMETER 	- 	Returns the asked customer details.
*/    
    public function getCustomer($customer_id) {
		// $query = $this->db->query("SELECT c.*, CONCAT(c.firstname, ' ', c.lastname) AS name,a.address_1 as address FROM " . DB_PREFIX . "customer c ," . DB_PREFIX . "address a WHERE c.customer_id='".$customer_id."' AND c.address_id=a.address_id");

		/*$query = $this->db->query("SELECT c.customer_id as customer_id, CONCAT(c.firstname, ' ', c.lastname) AS name, c.STBNO, c.telephone, c.date_added,s.is_active as status FROM " . DB_PREFIX . "customer c LEFT JOIN " . DB_PREFIX . "stb s ON (c.customer_id = s.customer_id) WHERE c.customer_id='".$customer_id."' ");*/
		$query = $this->db->query("SELECT user_group_id FROM " . DB_PREFIX . "user WHERE user_id like '" . $this->session->data['user_id'] . "'");
		if($query->row['user_group_id']==1){
					$query = $this->db->query("select Z.customer_id as customer_id,Z.customer_group_id, Z.custName AS name, Z.STBNO, Z.telephone, Z.date_added,Z.is_active as status, Z.name AS customer_group, Z.customer_unique_id as customerNo, C.plist as prod_pkg_no from
			(select c.customer_id,c.customer_unique_id,c.customer_group_id,concat(c.firstname,' ',c.lastname) as custName,c.email,c.telephone,
			s.is_active,cgd.name,c.date_added, c.STBNO
			FROM oc_customer c 
			inner join oc_customer_group_description cgd on c.customer_group_id=cgd.customer_group_id
			left join oc_stb s on s.customer_id = c.customer_id ) Z LEFT join
			(select A.user_id,group_concat(A.product_id) as plist from oc_cas_op_transactions A inner join 
					(select max(id) as id FROM 
						oc_cas_op_transactions where cmd_id in (10,11,6,7) group by user_id,product_id 
					) cas ON cas.id = A.id
					where A.cmd_id in (6,10)
					group by A.user_id) C
			on Z.customer_id = C.user_id WHERE Z.customer_id='".$customer_id."' ");
		}else{
			$query = $this->db->query("select Z.operator_id,Z.customer_id as customer_id,Z.customer_group_id, Z.custName AS name, Z.STBNO, Z.telephone, Z.date_added,Z.is_active as status, Z.name AS customer_group, Z.customer_unique_id as customerNo, C.plist as prod_pkg_no from
			(select c.customer_id,c.customer_unique_id,c.customer_group_id,concat(c.firstname,' ',c.lastname) as custName,c.email,c.telephone,
			s.is_active,cgd.name,c.date_added, c.STBNO, c.operator_id
			FROM oc_customer c 
			inner join oc_customer_group_description cgd on c.customer_group_id=cgd.customer_group_id
			left join oc_stb s on s.customer_id = c.customer_id ) Z LEFT join
			(select A.user_id,group_concat(A.product_id) as plist from oc_cas_op_transactions A inner join 
					(select max(id) as id FROM 
						oc_cas_op_transactions where cmd_id in (10,11,6,7) group by user_id,product_id 
					) cas ON cas.id = A.id
					where A.cmd_id in (6,10)
					group by A.user_id) C
			on Z.customer_id = C.user_id WHERE Z.customer_id='".$customer_id."' AND Z.operator_id=".$this->session->data['user_id']." ");
		}


		// var_dump("SELECT c.*, CONCAT(c.firstname, ' ', c.lastname) AS name,a.address_1 as address FROM " . DB_PREFIX . "customer c ," . DB_PREFIX . "address a WHERE c.status>0 and c.customer_id='".$customer_id."' AND c.address_id=a.address_id");
		return $query->rows;	
	}

	public function getCustomersForPrint($data) {
		// echo "<pre>"; print_r($data);die;
		$query = $this->db->query("SELECT user_group_id FROM " . DB_PREFIX . "user WHERE user_id like '" . $this->session->data['user_id'] . "'");
			if($query->row['user_group_id']==1){
				$sql ="select X.user_id as livestatus,Z.customer_id as customer_id,Z.customer_group_id, Z.custName AS name, Z.STBNO, Z.telephone, Z.date_added,Z.is_active as status,Z.active_date,Z.cust_id, Z.name AS customer_group, Z.customer_unique_id as customerNo, C.plist as prod_pkg_no, Z.operator, Z.operator_id,Z.addr from 
					(select c.customer_id,c.customer_unique_id,c.customer_group_id,concat(c.firstname,' ',c.lastname) as custName,c.email,c.telephone,
						s.is_active,s.active_date,s.customer_id as cust_id,cgd.name,c.date_added, c.STBNO, u.username as operator, c.operator_id, concat(ad.address_1,', ',ad.city,', ',ad.postcode) as addr
						FROM oc_customer c 
						inner join oc_address ad on ad.address_id = c.address_id
						inner join oc_customer_group_description cgd on c.customer_group_id=cgd.customer_group_id
						INNER JOIN oc_user u ON u.user_id=c.operator_id
						left join oc_stb s on s.customer_id = c.customer_id 
					) Z LEFT join
					(select A.user_id,group_concat(A.product_id) as plist from oc_subscriptionDesubscription A inner join 
						(select max(id) as id FROM 
							oc_subscriptionDesubscription where cmd_id in (10,11,6,7) group by user_id,product_id 
						) cas ON cas.id = A.id
						where A.cmd_id in (6,10) and A.exp_date > now() 
						group by A.user_id
					) C
					on Z.customer_id = C.user_id
					left join 
					(select aa.user_id from oc_activationDeactivation aa inner join 
						(select max(id) as id from oc_activationDeactivation ad group by user_id ) A
						on aa.id = A.id
						where cmd_id =0 
					) X on Z.customer_id = X.user_id";
			}else{
				$sql ="select X.user_id as livestatus,Z.customer_id as customer_id,Z.customer_group_id, Z.custName AS name, Z.STBNO, Z.telephone, Z.date_added,Z.is_active as status,Z.active_date,Z.cust_id, Z.name AS customer_group, Z.customer_unique_id as customerNo, C.plist as prod_pkg_no, Z.operator, Z.operator_id,Z.addr from 
					(select c.customer_id,c.customer_unique_id,c.customer_group_id,concat(c.firstname,' ',c.lastname) as custName,c.email,c.telephone,
						s.is_active,s.active_date,s.customer_id as cust_id,cgd.name,c.date_added, c.STBNO, u.username as operator, c.operator_id, concat(ad.address_1,', ',ad.city,', ',ad.postcode) as addr
						FROM oc_customer c 
						inner join oc_address ad on ad.address_id = c.address_id
						inner join oc_customer_group_description cgd on c.customer_group_id=cgd.customer_group_id
						INNER JOIN oc_user u ON u.user_id=c.operator_id
						left join oc_stb s on s.customer_id = c.customer_id 
					) Z LEFT join
					(select A.user_id,group_concat(A.product_id) as plist from oc_subscriptionDesubscription A inner join 
						(select max(id) as id FROM 
							oc_subscriptionDesubscription where cmd_id in (10,11,6,7) group by user_id,product_id 
						) cas ON cas.id = A.id
						where A.cmd_id in (6,10) and A.exp_date > now() 
						group by A.user_id
					) C
					on Z.customer_id = C.user_id
					left join 
					(select aa.user_id from oc_activationDeactivation aa inner join 
						(select max(id) as id from oc_activationDeactivation ad group by user_id ) A
						on aa.id = A.id
						where cmd_id =0 
					) X on Z.customer_id = X.user_id WHERE Z.operator_id=".$this->session->data['user_id']." ";
			}

		$implode=array();	

		if (!empty($data['filter_customer_unique_id'])) {
			$implode[] = "Z.customer_unique_id = '". $this->db->escape($data['filter_customer_unique_id']) . "'";
		}

		if (!empty($data['filter_name'])) {
			$implode[] = "Z.custName LIKE '%" . $this->db->escape($data['filter_name']) . "%'";
		}

		if (!empty($data['filter_stb'])) {
			if(strtoupper($data['filter_stb'])=='NULL'){
				$implode[] = "Z.STBNO = ''";
			}else{
				$implode[] = "Z.STBNO LIKE '%" . $this->db->escape($data['filter_stb']) . "%'";	
			}
		}
		
		if ($data['filter_customer_group_id']!='*') {
			$implode[] = "  Z.customer_group_id = '" . (int)$data['filter_customer_group_id'] . "'";
		}

		if (isset($data['filter_status']) && $data['filter_status']!='*') {
			if($data['filter_status']==2){
				$implode[]= " (Z.STBNO ='' || Z.STBNO='0')";
			}else if($data['filter_status']==0){
				// $implode[] = " Z.active_date IS NOT NULL AND Z.cust_id!=0 AND Z.is_active=0 AND Z.active_date NOT LIKE  $implode[] = " X.user_id is null and (Z.STBNO !='' && Z.STBNO!='0')";
				$implode[] = " X.user_id is null and (Z.STBNO !='' && Z.STBNO!='0')";
			}else{
				/*$implode[]= " Z.is_active = '" . (int)$data['filter_status'] . "'";*/
				$implode[] = " X.user_id is not null ";
			}
		}

		if (($this->session->data['user_group_id']==1)&&($data['filter_operator']!='*')) {
				$implode[] = "Z.operator_id='" .(int)$data['filter_operator'] . "'";
		}

		if($implode){
			if($this->session->data['user_group_id']!=1){
				$sql.=" AND ".implode( ' AND ', $implode);
			}else{
				$sql.=" WHERE ".implode( ' AND ', $implode);	
			}
			
		}	
		// echo $sql;
		$query = $this->db->query($sql);

		return $query->rows;	
	}

/*
FUNCTION NAME 		-	getCustomers
DESCRIPTION 		-	Queries all the approved customer detials from the database. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved
*/
	public function getCustomers($data) {
		$query = $this->db->query("SELECT user_group_id FROM " . DB_PREFIX . "user WHERE user_id like '" . $this->session->data['user_id'] . "'");
		if($query->row['user_group_id']==1){
				// $sql ="SELECT *, CONCAT(c.firstname, ' ', c.lastname) AS name FROM " . DB_PREFIX . "customer c LEFT JOIN " . DB_PREFIX . "address a ON (c.address_id = a.address_id) GROUP BY c.customer_id";

				/*$sql ="SELECT c.customer_id as customer_id, CONCAT(c.firstname, ' ', c.lastname) AS name, c.STBNO, c.telephone, c.date_added,s.is_active as status, cgd.name AS customer_group, group_concat(p.model) AS prod_pkg_no 
					FROM " . DB_PREFIX . "customer c 
					LEFT JOIN " . DB_PREFIX . "stb s ON (c.customer_id = s.customer_id) 
					LEFT JOIN " . DB_PREFIX . "customer_group_description cgd ON (c.customer_group_id = cgd.customer_group_id) 
					INNER JOIN oc_cas_op_transactions cas ON cas.user_id = c.customer_id
					INNER JOIN oc_product p ON p.product_id = cas.product_id";*/

				/*$sql = "select c.customer_id as customer_id, CONCAT(c.firstname, ' ', c.lastname) AS name, c.STBNO, c.telephone, c.date_added,s.is_active as status, cgd.name AS customer_group
FROM oc_customer c 
inner join oc_customer_group_description cgd on c.customer_group_id=cgd.customer_group_id
left join oc_stb s on s.customer_id = c.customer_id";
*/
//==================
				$sql ="select X.user_id as livestatus,Z.customer_id as customer_id,Z.customer_group_id, Z.custName AS name, Z.STBNO, Z.telephone, Z.date_added,Z.is_active as status,Z.active_date,Z.cust_id, Z.name AS customer_group, Z.customer_unique_id as customerNo, C.plist as prod_pkg_no, Z.operator, Z.operator_id,Z.addr from 
				(select c.customer_id,c.customer_unique_id,c.customer_group_id,concat(c.firstname,' ',c.lastname) as custName,c.email,c.telephone,
					s.is_active,s.active_date,s.customer_id as cust_id,cgd.name,c.date_added, c.STBNO, u.username as operator, c.operator_id, concat(ad.address_1,', ',ad.city,', ',ad.postcode) as addr
					FROM oc_customer c 
					inner join oc_address ad on ad.address_id = c.address_id
					inner join oc_customer_group_description cgd on c.customer_group_id=cgd.customer_group_id
					INNER JOIN oc_user u ON u.user_id=c.operator_id
					left join oc_stb s on s.customer_id = c.customer_id 
				) Z LEFT join
				(select A.user_id,group_concat(A.product_id) as plist from oc_subscriptionDesubscription A inner join 
					(select max(id) as id FROM 
						oc_subscriptionDesubscription where cmd_id in (10,11,6,7) group by user_id,product_id 
					) cas ON cas.id = A.id
					where A.cmd_id in (6,10) and A.exp_date > now() 
					group by A.user_id
				) C
				on Z.customer_id = C.user_id
				left join 
				(select aa.user_id from oc_activationDeactivation aa inner join 
					(select max(id) as id from oc_activationDeactivation ad group by user_id ) A
					on aa.id = A.id
					where cmd_id =0 
				) X on Z.customer_id = X.user_id";

//================== 

			}else{
				// $sql ="SELECT *, CONCAT(c.firstname, ' ', c.lastname) AS name FROM " . DB_PREFIX . "customer c LEFT JOIN " . DB_PREFIX . "address a ON (c.address_id = a.address_id) WHERE c.operator_id = ".$this->session->data['user_id']." GROUP BY c.customer_id";
				$sql ="select X.user_id as livestatus,Z.customer_id as customer_id,Z.customer_group_id, Z.custName AS name, Z.STBNO, Z.telephone, Z.date_added,Z.is_active as status,Z.active_date,Z.cust_id, Z.name AS customer_group, Z.customer_unique_id as customerNo, C.plist as prod_pkg_no, Z.operator, Z.operator_ida,Z.addr from 
					(select c.customer_id,c.customer_unique_id,c.customer_group_id,concat(c.firstname,' ',c.lastname) as custName,c.email,c.telephone,
						s.is_active,s.active_date,s.customer_id as cust_id,cgd.name,c.date_added, c.STBNO, u.username as operator, c.operator_id, c.operator_id, concat(ad.address_1,', ',ad.city,', ',ad.postcode) as addr
						FROM oc_customer c 
						inner join oc_address ad on ad.address_id = c.address_id
						inner join oc_customer_group_description cgd on c.customer_group_id=cgd.customer_group_id
						INNER JOIN oc_user u ON u.user_id=c.operator_id
						left join oc_stb s on s.customer_id = c.customer_id 
					) Z LEFT join
					(select A.user_id,group_concat(A.product_id) as plist from oc_subscriptionDesubscription A inner join 
						(select max(id) as id FROM 
							oc_subscriptionDesubscription where cmd_id in (10,11,6,7) group by user_id,product_id 
						) cas ON cas.id = A.id
						where A.cmd_id in (6,10) and A.exp_date > now() 
						group by A.user_id
					) C
					on Z.customer_id = C.user_id
					left join 
					(select aa.user_id from oc_activationDeactivation aa inner join 
						(select max(id) as id from oc_activationDeactivation ad group by user_id ) A
						on aa.id = A.id
						where cmd_id =0 
					) X on Z.customer_id = X.user_id WHERE Z.operator_id = ".$this->session->data['user_id']."";
			}	

		$implode=array();	

		if (!empty($data['filter_customer_unique_id'])) {
			$implode[] = "Z.customer_unique_id = '". $this->db->escape($data['filter_customer_unique_id']) . "'";
		}

		if (!empty($data['filter_name'])) {
			$implode[] = "Z.custName LIKE '%" . $this->db->escape($data['filter_name']) . "%'";
		}

		if (!empty($data['filter_stb'])) {
			if(strtoupper($data['filter_stb'])=='NULL'){
				$implode[] = "Z.STBNO = ''";
			}else{
				$implode[] = "Z.STBNO LIKE '%" . $this->db->escape($data['filter_stb']) . "%'";	
			}
		}
			
		if (!empty($data['filter_customer_group_id'])) {
			$implode[] = "  Z.customer_group_id = '" . (int)$data['filter_customer_group_id'] . "'";
		}

		if (isset($this->request->get['filter_status'])) {
			if($this->request->get['filter_status']==2){
				$implode[]= " (Z.STBNO ='' || Z.STBNO='0')";
			}else if($this->request->get['filter_status']==0){
				// $implode[] = " Z.active_date IS NOT NULL AND Z.cust_id!=0 AND Z.is_active=0 AND Z.active_date NOT LIKE  '0000-00-00 00:00:00'";
				$implode[] = " X.user_id is null and (Z.STBNO !='' && Z.STBNO!='0')";
			}else{
				/*$implode[]= " Z.is_active = '" . (int)$data['filter_status'] . "'";*/
				$implode[] = " X.user_id is not null ";
			}
		}

		if (($this->session->data['user_group_id']==1)&&(!empty($data['filter_operator']))) {
				$implode[] = "Z.operator_id='" .(int)$data['filter_operator'] . "'";
		}

		if ($this->session->data['user_group_id']==1) {
			if($implode){
				$sql.=" WHERE ".implode( ' AND ', $implode);
			}	
		}else{
			if($implode){
				$sql.=" AND ".implode( ' AND ', $implode);
			}	
		}
			// $sql.= " GROUP BY cas.user_id, cas.product_id";
		
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}				

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
		
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}	
		$query = $this->db->query($sql);
		return $query->rows;	
	}

/*
FUNCTION NAME 		-	getTotalStbAddress
DESCRIPTION 		-	Retrieves number of  stb number assign to customer and balance.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved by the query.
*/		
	public function getTotalAuthSubs($data) {
			// if($this->session->data['user_id']==1)
			// {
			// 	$query = "SELECT *, CONCAT(c.firstname, ' ', c.lastname) AS name FROM " . DB_PREFIX . "customer c LEFT JOIN " . DB_PREFIX . "address a ON (c.customer_id = a.customer_id) GROUP BY c.customer_id";
			// }else{
			// 	$query = "SELECT *, CONCAT(c.firstname, ' ', c.lastname) AS name FROM " . DB_PREFIX . "customer c LEFT JOIN " . DB_PREFIX . "address a ON (c.customer_id = a.customer_id) WHERE c.operator_id = ".$this->session->data['user_id']." GROUP BY c.customer_id";
			// } 
			// $query = $this->db->query($query);
			// return $query->num_rows;
			$query = $this->db->query("SELECT user_group_id FROM " . DB_PREFIX . "user WHERE user_id like '" . $this->session->data['user_id'] . "'");
			if($query->row['user_group_id']==1){
				/*$query = "SELECT count(*) AS total FROM " . DB_PREFIX . "customer c LEFT JOIN " . DB_PREFIX . "stb s ON (c.customer_id = s.customer_id) LEFT JOIN " . DB_PREFIX . "customer_group_description cgd ON (c.customer_group_id = cgd.customer_group_id) INNER JOIN oc_cas_op_transactions cas ON cas.user_id = c.customer_id
					INNER JOIN oc_product p ON p.product_id = cas.product_id";*/

				$query = "select count(*) as total from 
						(select c.customer_id,c.customer_unique_id,c.customer_group_id,concat(c.firstname,' ',c.lastname) as custName,c.email,c.telephone,
							s.is_active,s.active_date,s.customer_id as cust_id,cgd.name,c.date_added, c.STBNO, u.username as operator, c.operator_id
							FROM oc_customer c 
							inner join oc_address ad on ad.address_id = c.address_id							
							inner join oc_customer_group_description cgd on c.customer_group_id=cgd.customer_group_id
							INNER JOIN oc_user u ON u.user_id=c.operator_id
							left join oc_stb s on s.customer_id = c.customer_id 
						) Z LEFT join
						(select A.user_id,group_concat(A.product_id) as plist from oc_subscriptionDesubscription A inner join 
							(select max(id) as id FROM 
								oc_subscriptionDesubscription where cmd_id in (10,11,6,7) group by user_id,product_id 
							) cas ON cas.id = A.id
							where A.cmd_id in (6,10) and A.exp_date > now() 
							group by A.user_id
						) C
						on Z.customer_id = C.user_id
						left join 
						(select aa.user_id from oc_activationDeactivation aa inner join 
							(select max(id) as id from oc_activationDeactivation ad group by user_id ) A
							on aa.id = A.id
							where cmd_id =0 
						) X on Z.customer_id = X.user_id";

			}else{
				// $query = "SELECT count(*) AS total FROM " . DB_PREFIX . "customer c LEFT JOIN " . DB_PREFIX . "address a ON (c.address_id = a.address_id)  where c.operator_id = ".$this->session->data['user_id']." ";
				$query = "select count(*) as total from 
						(select c.customer_id,c.customer_unique_id,c.customer_group_id,concat(c.firstname,' ',c.lastname) as custName,c.email,c.telephone,
							s.is_active,s.active_date,s.customer_id as cust_id,cgd.name,c.date_added, c.STBNO, u.username as operator, c.operator_id
							FROM oc_customer c 
							inner join oc_address ad on ad.address_id = c.address_id
							inner join oc_customer_group_description cgd on c.customer_group_id=cgd.customer_group_id
							INNER JOIN oc_user u ON u.user_id=c.operator_id
							left join oc_stb s on s.customer_id = c.customer_id 
						) Z LEFT join
						(select A.user_id,group_concat(A.product_id) as plist from oc_subscriptionDesubscription A inner join 
							(select max(id) as id FROM 
								oc_subscriptionDesubscription where cmd_id in (10,11,6,7) group by user_id,product_id 
							) cas ON cas.id = A.id
							where A.cmd_id in (6,10) and A.exp_date > now() 
							group by A.user_id
						) C
						on Z.customer_id = C.user_id
						left join 
						(select aa.user_id from oc_activationDeactivation aa inner join 
							(select max(id) as id from oc_activationDeactivation ad group by user_id ) A
							on aa.id = A.id
							where cmd_id =0 
						) X on Z.customer_id = X.user_id WHERE Z.operator_id = ".$this->session->data['user_id']."";
			}

			$implode=array();

			if (!empty($data['filter_customer_unique_id'])) {
				$implode[] = "Z.customer_unique_id ='" . $this->db->escape($data['filter_customer_unique_id']) . "'";
			}
			if (!empty($data['filter_name'])) {
				$implode[] = "Z.custName LIKE '%" . $this->db->escape($data['filter_name']) . "%'";
			}

			if (!empty($data['filter_stb'])) {
				if(strtoupper($data['filter_stb'])=='NULL'){
					$implode[] = "Z.STBNO = ''";
				}else{
					$implode[] = "Z.STBNO LIKE '%" . $this->db->escape($data['filter_stb']) . "%'";	
				}
				// $implode[] = "STBNO LIKE '%" . $this->db->escape($data['filter_stb']) . "%'";
			}

			if (!empty($data['filter_customer_group_id'])) {
				$implode[] = " Z.customer_group_id = '" . (int)$data['filter_customer_group_id'] . "'";
			}

			if (isset($this->request->get['filter_status'])) {
				if($this->request->get['filter_status']==2){
					$implode[]= " (Z.STBNO ='' || Z.STBNO='0')";
				}else if($this->request->get['filter_status']==0){
					// $implode[] = " Z.active_date IS NOT NULL AND Z.cust_id!=0 AND Z.is_active=0 AND Z.active_date NOT LIKE  '0000-00-00 00:00:00'";
					$implode[] = " X.user_id is null and (Z.STBNO !='' && Z.STBNO!='0')";
				}else{
					// $implode[]= " Z.is_active = '" . (int)$data['filter_status'] . "'";
					$implode[] = " X.user_id is not null ";
				}
			}

			if (($this->session->data['user_group_id']==1)&&(!empty($data['filter_operator']))) {
					$implode[] = "Z.operator_id='" .(int)$data['filter_operator'] . "'";
			}

			if ($this->session->data['user_group_id']==1) {
				if($implode){
					$query.=" WHERE ".implode( ' AND ', $implode);
				}	
			}else{
				if($implode){
					$query.=" AND ".implode( ' AND ', $implode);
				}	
			}

			// $query.= " GROUP BY cas.user_id, cas.product_id";
			// echo $query;
		$countquery = $this->db->query($query);
			return $countquery->row['total'];
		}

  	public function getStbHw($stb_no) {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "stb   WHERE  stb_no='".$stb_no."'");

		return $query->rows;	
	}

	public function getOperators() {
		$query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "user");
	
		return $query->rows;
	}
}
?>