<?php

  /**
  * Author @Shiril Tripathi
  * Date-17-01-2019 
  */
  class ModelBulkStbBulkUnpair extends Model
  {
  	  

  	  public function getTotal($data)
  	  { 
        $implode = array();
        $sql = "SELECT count(*) as total FROM " . DB_PREFIX . "logUnpairStb";
        if (!empty($data['filter_date_added'])) {
          $implode[] = "DATE(date_added) = DATE( '" .$this->db->escape($data['filter_date_added']).  "')";
        }
        if ($implode) {
          $sql.= " WHERE ".implode( " AND ", $implode);
        }
        $sql.= " group by batchno "; 
        $query = $this->db->query($sql);
        return $query->num_rows;
  	  }

  	  public function getBulkUnpairStbLoglist($data)
  	  { 
        $implode = array();
        $sql = "SELECT * FROM " . DB_PREFIX . "logUnpairStb";
        if (!empty($data['filter_date_added'])) {
         $implode[] = "DATE(date_added) = DATE( '" .$this->db->escape($data['filter_date_added']).  "')";
        }
        if ($implode) {
         $sql.= " WHERE ".implode( " AND ", $implode);
        }
        $sql.= " group by batchno order by batchno DESC ";
        if (isset($data['start']) || isset($data['limit'])) {
        if ($data['start'] < 0) {
           $data['start'] = 0;
        }
        if ($data['limit'] < 1) {
           $data['limit'] = 20;
        }
        $sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
        } 
        $query = $this->db->query($sql);
        return $query->rows;

      }

  
    public function unpairstbProcedure($csv_xml_data,$kms_xml)
    {
       $sql = "call SmsstbUnpair('".str_replace("'","''",$csv_xml_data)."','".str_replace("'","''",$kms_xml)."')";
       $query = $this->db->query($sql);
    }


    public function getTotalBatchStblogList($data){
      
      $sql = "SELECT count(*) as total FROM " . DB_PREFIX . "logUnpairStb";
      if (!empty($data['batchno'])) {
        $sql.= " WHERE batchno='" . $this->db->escape($data['batchno']) ."' ";
      }

      if (!empty($data['filter_value'])) {
        $sql.= " AND stbno LIKE '" . $this->db->escape($data['filter_value']) . "%' ";
      }

      if (isset($data['filter_status']) && !is_null($data['filter_status'])) {
        $value = $data['filter_status'] == 0 ? "AND errorid=" : "AND errorid >=";
        $sql.= $value.$this->db->escape($data['filter_status']) ;
      }
   

      $query = $this->db->query($sql);
      return $query->row['total'];
    }

    public function getBulkUnpairStbNoLoglist($data)
    {
     
      $sql = "SELECT * FROM " . DB_PREFIX . "logUnpairStb";
     if (!empty($data['batchno'])) {
        $sql.= " WHERE batchno='" . $this->db->escape($data['batchno']) ."' ";
      }

      if (!empty($data['filter_value'])) {
        $sql.= " AND stbno LIKE '" . $this->db->escape($data['filter_value']) . "%' ";
      }

      if (isset($data['filter_status']) && !is_null($data['filter_status'])) {
        $value = $data['filter_status'] == 0 ? "AND errorid=" : "AND errorid >=";
        $sql.= $value.$this->db->escape($data['filter_status']) ;
      }

   
     if (isset($data['start']) || isset($data['limit'])) {
      if ($data['start'] < 0) {
        $data['start'] = 0;
      }
      if ($data['limit'] < 1) {
        $data['limit'] = 20;
      }
      $sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
    } 
    $query = $this->db->query($sql);
    return $query->rows;

    }
  }


?>