<?php

class ModelBulkPackageDeSubscriptionCount extends Model {

/*
FUNCTION NAME 		-	getTotalPackageCount
DESCRIPTION 		-	Retrieves the rows containing the count of rows in Product table.
INPUT PARAMETER 	-	-
OUTPUT PARAMETER 	- 	Returns a column "total" containing the count of categories in the database.
*/		
	public function getTotalPackageCount($data) {
		$datetime_obj = new DateTime($data['filter_month'], new DateTimeZone('Asia/Calcutta'));
		$filter_month = $datetime_obj->format('Y-m');
		$user_id = $this->session->data['user_id'];
      	$monthStartDate = date('Y-m-01', strtotime($filter_month)); 
		$monthEndDate   = date('Y-m-t', strtotime($filter_month));
		if($data['filter_date_end']!=''){
			$toMonth 	  = explode('-', $data['filter_date_end']); 
			$yearMonth    = $toMonth[0].'-'.$toMonth[1].'%'; 
		}

      	$query = "SELECT (pd.model) AS package_number, d.name, COUNT( cas.product_id ) AS total
				FROM  `oc_cas_op_transactions` cas 
				INNER JOIN oc_product_description d ON ( d.product_id = cas.product_id ) 
				LEFT JOIN oc_product pd ON ( d.product_id = pd.product_id )"; 
      	if($user_id==1){
	      	if ($data['filter_option']==1) {
	      			$filter_date_start=date_create($data['filter_date_start']);
				$filter_date_end=date_create($data['filter_date_end']);
				$diff=date_diff($filter_date_start,$filter_date_end);
				$days = $diff->format("%R%a");	

				$query .= " inner join (SELECT max(id) as id from oc_cas_op_transactions WHERE cmd_id=6  AND (
					((modify_date > '".$data['filter_date_start']."') AND (exp_date > '".$data['filter_date_end']."') AND (modify_date < '".$data['filter_date_end']."')) OR 
					((modify_date < '".$data['filter_date_start']."') AND (exp_date > '".$data['filter_date_end']."')) OR 
					((modify_date < '".$data['filter_date_start']."') AND (exp_date < '".$data['filter_date_end']."') AND (exp_date > '".$data['filter_date_start']."')) OR
					((modify_date < '".$data['filter_date_start']."') AND (exp_date < '".$data['filter_date_end']."') AND ((exp_date like '".$yearMonth."') AND ('".$days."' > 28))) OR 
					((modify_date < '".$data['filter_date_start']."') AND (exp_date > '".$data['filter_date_end']."') OR ((exp_date like '".$yearMonth."') AND ('".$days."' > 28))) OR 
					((modify_date > '".$data['filter_date_start']."') AND (exp_date < '".$data['filter_date_end']."') OR ((exp_date like '".$yearMonth."') AND ('".$days."' > 28))) OR ((exp_date like '".$yearMonth."') AND ('".$days."' > 28))) group by user_id, product_id) bm on cas.id = bm.id AND (is_package =1) GROUP BY cas.product_id";
			}elseif ($data['filter_option']==2) {
				$query .= " inner join (SELECT max(id) as id from oc_cas_op_transactions WHERE cmd_id=6   AND ((modify_date like '".$filter_month."%' ) OR (exp_date like '".$filter_month."%') OR (modify_date < '".$monthStartDate."' AND exp_date > '".$monthStartDate."')) group by user_id, product_id) bm on cas.id = bm.id AND (is_package =1) GROUP BY cas.product_id";
			}elseif ($data['filter_option']==3) {
				$query .= " inner join (SELECT max(id) as id from oc_cas_op_transactions WHERE cmd_id=6 AND ((modify_date LIKE  '".$data['filter_year']."%') OR (modify_date <  '".$data['filter_year']."%' AND exp_date >  '".$data['filter_year']."%')) group by user_id, product_id) bm on cas.id = bm.id AND (is_package =1) GROUP BY cas.product_id";
			}else{
				$query .= " inner join (SELECT max(id) as id from oc_cas_op_transactions WHERE cmd_id=6  group by user_id, product_id) bm on cas.id = bm.id AND (is_package =1) GROUP BY cas.product_id";
			}
		}else{
			if ($data['filter_option']==1) {
				$query .= " inner join (SELECT max(id) as id from oc_cas_op_transactions WHERE cmd_id=6  AND (
					((modify_date > '".$data['filter_date_start']."') AND (exp_date > '".$data['filter_date_end']."') AND (modify_date < '".$data['filter_date_end']."')) OR 
					((modify_date < '".$data['filter_date_start']."') AND (exp_date > '".$data['filter_date_end']."')) OR 
					((modify_date < '".$data['filter_date_start']."') AND (exp_date < '".$data['filter_date_end']."') AND (exp_date > '".$data['filter_date_start']."')) OR
					((modify_date < '".$data['filter_date_start']."') AND (exp_date < '".$data['filter_date_end']."') AND (exp_date like '".$yearMonth."')) OR 
					((modify_date < '".$data['filter_date_start']."') AND (exp_date > '".$data['filter_date_end']."') OR (exp_date like '".$yearMonth."')) OR 
					((modify_date > '".$data['filter_date_start']."') AND (exp_date < '".$data['filter_date_end']."') OR (exp_date like '".$yearMonth."')) OR (exp_date like '".$yearMonth."')) AND operator_id=".$user_id."  group by user_id, product_id) bm on cas.id = bm.id AND (is_package =1) GROUP BY cas.product_id";
			}elseif ($data['filter_option']==2) {
				$query .= " inner join (SELECT max(id) as id from oc_cas_op_transactions WHERE cmd_id=6   AND ((modify_date like '".$filter_month."%' ) OR (exp_date like '".$filter_month."%') OR (modify_date < '".$monthStartDate."' AND exp_date > '".$monthStartDate."')) AND operator_id=".$user_id."  group by user_id, product_id) bm on cas.id = bm.id AND (is_package =1) GROUP BY cas.product_id";
			}elseif ($data['filter_option']==3) {
				$query .= " inner join (SELECT max(id) as id from oc_cas_op_transactions WHERE cmd_id=6  AND ((modify_date LIKE  '".$data['filter_year']."%') OR (modify_date <  '".$data['filter_year']."%' AND exp_date >  '".$data['filter_year']."%')) AND operator_id=".$user_id." group by user_id, product_id) bm on cas.id = bm.id AND (is_package =1) GROUP BY cas.product_id";
			}else{
				$query .= "inner join (SELECT max(id) as id from oc_cas_op_transactions WHERE cmd_id=6  AND operator_id=".$user_id." group by user_id, product_id) bm on cas.id = bm.id AND (is_package =1) GROUP BY cas.product_id";
			}
		}

		$countquery = $this->db->query($query);
		return $countquery->num_rows;
	}

/*
FUNCTION NAME 		-	getPackageDetails
DESCRIPTION 		-	Get product details from product_description table with con.
INPUT PARAMETER 	-	-
OUTPUT PARAMETER 	- 	is_default
*/	

	public function getPackageDetails($data){
		$datetime_obj = new DateTime($data['filter_month'], new DateTimeZone('Asia/Calcutta'));
		$filter_month = $datetime_obj->format('Y-m');
		$monthStartDate = date('Y-m-01', strtotime($filter_month)); 
		$monthEndDate   = date('Y-m-t', strtotime($filter_month));
		if($data['filter_date_end']!=''){
			$toMonth 	  = explode('-', $data['filter_date_end']); 
			$yearMonth    = $toMonth[0].'-'.$toMonth[1].'%'; 
		}

		$sql = "SELECT MAX(cas.id) AS 'id', MAX( modify_date ) , MAX( exp_date ) , MAX( cmd_id ) AS 'cmd',pd.product_id as package_id, (pd.model) AS package_number, d.name,
				COUNT( cas.product_id ) AS count
				FROM  `oc_cas_op_transactions` cas 
				INNER JOIN oc_product_description d ON ( d.product_id = cas.product_id ) 
				LEFT JOIN oc_product pd ON ( d.product_id = pd.product_id ) ";
		$user_id = $this->session->data['user_id'];
		if($user_id==1){
			if ($data['filter_option']==1) {
				$filter_date_start=date_create($data['filter_date_start']);
				$filter_date_end=date_create($data['filter_date_end']);
				$diff=date_diff($filter_date_start,$filter_date_end);
				$days = $diff->format("%R%a");	

				$sql .= " inner join (SELECT max(id) as id from oc_cas_op_transactions WHERE cmd_id IN (6,7)  AND (
					((modify_date > '".$data['filter_date_start']."') AND (exp_date > '".$data['filter_date_end']."') AND (modify_date < '".$data['filter_date_end']."')) OR 
					((modify_date < '".$data['filter_date_start']."') AND (exp_date > '".$data['filter_date_end']."')) OR 
					((modify_date < '".$data['filter_date_start']."') AND (exp_date < '".$data['filter_date_end']."') AND (exp_date > '".$data['filter_date_start']."')) OR
					((modify_date < '".$data['filter_date_start']."') AND (exp_date < '".$data['filter_date_end']."') AND ((exp_date like '".$yearMonth."') AND ('".$days."' > 28))) OR 
					((modify_date < '".$data['filter_date_start']."') AND (exp_date > '".$data['filter_date_end']."') OR ((exp_date like '".$yearMonth."') AND ('".$days."' > 28))) OR 
					((modify_date > '".$data['filter_date_start']."') AND (exp_date < '".$data['filter_date_end']."') OR ((exp_date like '".$yearMonth."') AND ('".$days."' > 28))) OR ((exp_date like '".$yearMonth."') AND ('".$days."' > 28))) group by user_id, product_id) bm on cas.id = bm.id AND (is_package =1) GROUP BY cas.product_id";
			}elseif ($data['filter_option']==2) {
				$sql .= " inner join (SELECT max(id) as id from oc_cas_op_transactions WHERE cmd_id IN (6,7)   AND ((modify_date like '".$filter_month."%' ) OR (exp_date like '".$filter_month."%') OR (modify_date < '".$monthStartDate."' AND exp_date > '".$monthStartDate."')) group by user_id, product_id) bm on cas.id = bm.id AND (is_package =1) GROUP BY cas.product_id";
			}elseif ($data['filter_option']==3) {
				$sql .= " inner join (SELECT max(id) as id from oc_cas_op_transactions WHERE cmd_id IN (6,7)  AND ((modify_date LIKE  '".$data['filter_year']."%') OR (modify_date <  '".$data['filter_year']."%' AND exp_date >  '".$data['filter_year']."%')) group by user_id, product_id) bm on cas.id = bm.id AND (is_package =1) GROUP BY cas.product_id";
			}else{
				$sql .= " inner join (SELECT max(id) as id from oc_cas_op_transactions where cmd_id IN (6,7)  group by user_id, product_id) bm on cas.id = bm.id AND (is_package =1) GROUP BY cas.product_id";
			}
		}else{
			if ($data['filter_option']==1) {
				$sql .= " inner join (SELECT max(id) as id from oc_cas_op_transactions WHERE cmd_id IN (6,7)  AND (
					((modify_date > '".$data['filter_date_start']."') AND (exp_date > '".$data['filter_date_end']."') AND (modify_date < '".$data['filter_date_end']."')) OR 
					((modify_date < '".$data['filter_date_start']."') AND (exp_date > '".$data['filter_date_end']."')) OR 
					((modify_date < '".$data['filter_date_start']."') AND (exp_date < '".$data['filter_date_end']."') AND (exp_date > '".$data['filter_date_start']."')) OR
					((modify_date < '".$data['filter_date_start']."') AND (exp_date < '".$data['filter_date_end']."') AND (exp_date like '".$yearMonth."')) OR 
					((modify_date < '".$data['filter_date_start']."') AND (exp_date > '".$data['filter_date_end']."') OR (exp_date like '".$yearMonth."')) OR 
					((modify_date > '".$data['filter_date_start']."') AND (exp_date < '".$data['filter_date_end']."') OR (exp_date like '".$yearMonth."')) OR (exp_date like '".$yearMonth."')) AND operator_id=".$user_id."  group by user_id, product_id) bm on cas.id = bm.id AND (is_package =1) GROUP BY cas.product_id";
			}elseif ($data['filter_option']==2) {
				$sql .= " inner join (SELECT max(id) as id from oc_cas_op_transactions WHERE cmd_id IN (6,7)   AND ((modify_date like '".$filter_month."%' ) OR (exp_date like '".$filter_month."%') OR (modify_date < '".$monthStartDate."' AND exp_date > '".$monthStartDate."')) AND operator_id=".$user_id."  group by user_id, product_id) bm on cas.id = bm.id AND (is_package =1) GROUP BY cas.product_id";
			}elseif ($data['filter_option']==3) {
				$sql .= " inner join (SELECT max(id) as id from oc_cas_op_transactions WHERE cmd_id IN (6,7)  AND ((modify_date LIKE  '".$data['filter_year']."%') OR (modify_date <  '".$data['filter_year']."%' AND exp_date >  '".$data['filter_year']."%')) AND operator_id=".$user_id." group by user_id, product_id) bm on cas.id = bm.id AND (is_package =1) GROUP BY cas.product_id";
			}else{
				$sql .= " inner join (SELECT max(id) as id from oc_cas_op_transactions WHERE cmd_id IN (6,7)  AND operator_id=".$user_id." group by user_id, product_id) bm on cas.id = bm.id AND (is_package =1) GROUP BY cas.product_id";
			}
		}

		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}				
			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}			
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}	 
		// var_dump($sql);exit();
		$query = $this->db->query($sql);
		return $query->rows;

	}

/*
FUNCTION NAME 		-	getPackageDetailsForPDF
DESCRIPTION 		-	Get product details from product_description table with con.
INPUT PARAMETER 	-	-
OUTPUT PARAMETER 	- 	is_default
*/	
	public function getPackageDetailsForPDF($package_id,$data){
		// if($_REQUEST['option']!=1){
		if(isset($data['filter_month'])){
			$datetime_obj = new DateTime($data['filter_month'], new DateTimeZone('Asia/Calcutta'));
			$filter_month = $datetime_obj->format('Y-m');
			$monthStartDate = date('Y-m-01', strtotime($filter_month)); 
			$monthEndDate   = date('Y-m-t', strtotime($filter_month));
		}
		if(isset($data['filter_date_start']) && isset($data['filter_date_end'])){
			if($data['filter_date_end']!=''){
				$toMonth 	  = explode('-', $data['filter_date_end']); 
				$yearMonth    = $toMonth[0].'-'.$toMonth[1].'%'; 
			}
		}
		// }

		$pkgID = implode(',', $_REQUEST['selected']);
		$sql = "SELECT MAX(cas.id) AS 'id', MAX( modify_date ) , MAX( exp_date ) , MAX( cmd_id ) AS 'cmd',pd.product_id as package_id, (pd.model) AS package_number, d.name,
				COUNT( cas.product_id ) AS count
				FROM  `oc_cas_op_transactions` cas 
				INNER JOIN oc_product_description d ON ( d.product_id = cas.product_id ) 
				LEFT JOIN oc_product pd ON ( d.product_id = pd.product_id )"; 
				// LEFT JOIN oc_subscription s ON ( s.product_id = cas.product_id )";	

		$user_id = $this->session->data['user_id'];
		if($user_id==1){
			if ($data['filter_option']==1) {
				$sql .= " inner join (SELECT max(id) as id from oc_cas_op_transactions where cmd_id IN (6,7)  AND (
					((modify_date > '".$data['filter_date_start']."') AND (exp_date > '".$data['filter_date_end']."') AND (modify_date < '".$data['filter_date_end']."')) OR 
					((modify_date < '".$data['filter_date_start']."') AND (exp_date > '".$data['filter_date_end']."')) OR 
					((modify_date < '".$data['filter_date_start']."') AND (exp_date < '".$data['filter_date_end']."') AND (exp_date > '".$data['filter_date_start']."')) OR
					((modify_date < '".$data['filter_date_start']."') AND (exp_date < '".$data['filter_date_end']."') AND (exp_date like '".$yearMonth."')) OR 
					((modify_date < '".$data['filter_date_start']."') AND (exp_date > '".$data['filter_date_end']."') OR (exp_date like '".$yearMonth."')) OR 
					((modify_date > '".$data['filter_date_start']."') AND (exp_date < '".$data['filter_date_end']."') OR (exp_date like '".$yearMonth."')) OR (exp_date like '".$yearMonth."'))  group by user_id, product_id) bm on cas.id = bm.id AND (is_package =1 ) AND d.product_id IN (".$pkgID.") GROUP BY cas.product_id    ";
			}elseif ($data['filter_option']==2) {
				$sql .= " inner join (SELECT max(id) as id from oc_cas_op_transactions where cmd_id IN (6,7)  AND ((modify_date like '".$filter_month."%' ) OR (exp_date like '".$filter_month."%') OR (modify_date < '".$monthStartDate."' AND exp_date > '".$monthStartDate."')) group by user_id, product_id) bm on cas.id = bm.id AND (is_package =1 ) AND d.product_id IN (".$pkgID.") GROUP BY cas.product_id";
			}elseif ($data['filter_option']==3) {
				$sql .= " inner join (SELECT max(id) as id from oc_cas_op_transactions where cmd_id IN (6,7) AND ((modify_date LIKE  '".$data['filter_year']."%') OR (modify_date <  '".$data['filter_year']."%' AND exp_date >  '".$data['filter_year']."%')) group by user_id, product_id) bm on cas.id = bm.id AND (is_package =1 ) AND d.product_id IN (".$pkgID.") GROUP BY cas.product_id";
			}else{
				$sql .= " inner join (SELECT max(id) as id from oc_cas_op_transactions where cmd_id IN (6,7) group by user_id, product_id) bm on cas.id = bm.id AND (is_package =1 ) AND d.product_id IN (".$pkgID.") GROUP BY cas.product_id";
			}
		}else{
			if ($data['filter_option']==1) {
				$sql .= " inner join (SELECT max(id) as id from oc_cas_op_transactions where cmd_id IN (6,7)  AND (
					((modify_date > '".$data['filter_date_start']."') AND (exp_date > '".$data['filter_date_end']."') AND (modify_date < '".$data['filter_date_end']."')) OR 
					((modify_date < '".$data['filter_date_start']."') AND (exp_date > '".$data['filter_date_end']."')) OR 
					((modify_date < '".$data['filter_date_start']."') AND (exp_date < '".$data['filter_date_end']."') AND (exp_date > '".$data['filter_date_start']."')) OR
					((modify_date < '".$data['filter_date_start']."') AND (exp_date < '".$data['filter_date_end']."') AND (exp_date like '".$yearMonth."')) OR 
					((modify_date < '".$data['filter_date_start']."') AND (exp_date > '".$data['filter_date_end']."') OR (exp_date like '".$yearMonth."')) OR 
					((modify_date > '".$data['filter_date_start']."') AND (exp_date < '".$data['filter_date_end']."') OR (exp_date like '".$yearMonth."')) OR (exp_date like '".$yearMonth."')) AND operator_id=".$user_id."  group by user_id, product_id) bm on cas.id = bm.id AND (is_package =1 ) AND d.product_id IN (".$pkgID.") GROUP BY cas.product_id   ";
			}elseif ($data['filter_option']==2) {
				$sql .= " inner join (SELECT max(id) as id from oc_cas_op_transactions where cmd_id IN (6,7)  AND ((modify_date like '".$filter_month."%' ) OR (exp_date like '".$filter_month."%') OR (modify_date < '".$monthStartDate."' AND exp_date > '".$monthStartDate."')) AND operator_id=".$user_id."  group by user_id, product_id) bm on cas.id = bm.id AND (is_package =1 ) AND d.product_id IN (".$pkgID.") GROUP BY cas.product_id";
			}elseif ($data['filter_option']==3) {
				$sql .= " inner join (SELECT max(id) as id from oc_cas_op_transactions where cmd_id IN (6,7) AND ((modify_date LIKE  '".$data['filter_year']."%') OR (modify_date <  '".$data['filter_year']."%' AND exp_date >  '".$data['filter_year']."%')) AND operator_id=".$user_id." group by user_id, product_id) bm on cas.id = bm.id AND (is_package =1 ) AND d.product_id IN (".$pkgID.") GROUP BY cas.product_id";
			}else{
				$sql .= " inner join (SELECT max(id) as id from oc_cas_op_transactions where cmd_id IN (6,7) AND operator_id=".$user_id." group by user_id, product_id) bm on cas.id = bm.id AND (is_package =1 ) AND d.product_id IN (".$pkgID.") GROUP BY cas.product_id";
			}
		}
		$query = $this->db->query($sql);
		return $query->rows;
	}
}
?>
