<?php

class ModelBulkOperatorWiseReport extends Model {

/*
FUNCTION NAME 		-	getTotalPackageCount
DESCRIPTION 		-	Retrieves the rows containing the count of rows in Product table.
INPUT PARAMETER 	-	-
OUTPUT PARAMETER 	- 	Returns a column "total" containing the count of categories in the database.
*/		
	public function getOperatorSubscriptionReport($data,$isPrint){
		
		$datetime_obj = new DateTime($data['filter_date'], new DateTimeZone('Asia/Calcutta'));
		$filter_month = $datetime_obj->format('Y-m');
		/*$datetime_obj_start = new DateTime($data['filter_date'], new DateTimeZone('Asia/Calcutta'));
		$datetime_obj = new DateTime($data['filter_date'], new DateTimeZone('Asia/Calcutta'));
		$filterStartDate= $datetime_obj_start->format('Y-m-01').' 00:00:00';
		$filterDate= $datetime_obj->format('Y-m-t').' 23:59:59';*/
		$limit ='';
		if(!$isPrint){
			if (isset($data['start']) || isset($data['limit'])) {
				if ($data['start'] < 0) {
					$data['start'] = 0;
				}				
				if ($data['limit'] < 1) {
					$data['limit'] = 20;
				}			
				$limit = " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
			}
		}	
		
		$sql_query ='call bd_RprtsOperatorInvoice("'.$data['filter_operator'].'","'.$filter_month.'","'.$limit.'",'.$isPrint.')';
		
		$query = $this->db->MultiQuery($sql_query,0);
		return $query;
	}


	public function getOperatorList(){
		$sql = "SELECT * FROM `" . DB_PREFIX . "user` order by username asc";
		$query = $this->db->query($sql);
		return $query->rows;
	}
	public function getOperatorNameById($user_id){
		$sql = "SELECT * FROM oc_user WHERE user_id=".$user_id;
		$query = $this->db->query($sql);
		return $query->row;
	}

	public function getGSTTaxClassId(){
		$sql = "SELECT tax_class_id FROM oc_product WHERE tax_class_id!=0 limit 0,1";
		$query = $this->db->query($sql);
		return $query->row['tax_class_id'];
	}
	public function getTaxRate($value,$tax_class_id){
		$tax_rates = array();
		$customer_group_id=0;
		$tax_amount = 0;
		
			$tax_query = $this->db->query("SELECT tr2.tax_rate_id, tr2.name, tr2.rate, tr2.type FROM " . DB_PREFIX . "tax_rule tr1 LEFT JOIN " . DB_PREFIX . "tax_rate tr2 ON (tr1.tax_rate_id = tr2.tax_rate_id)  WHERE tr1.tax_class_id = '" . (int)$tax_class_id . "'  ORDER BY tr1.priority ASC");
			foreach ($tax_query->rows as $result) {
				$tax_rates[$result['tax_rate_id']] = array(
					'tax_rate_id' => $result['tax_rate_id'],
					'name'        => $result['name'],
					'rate'        => $result['rate'],
					'type'        => $result['type'],
				);
			}
		
		
		$tax_rate_data = array();
		
		foreach ($tax_rates as $tax_rate) {
			if (isset($tax_rate_data[$tax_rate['tax_rate_id']])) {
				$amount = $tax_rate_data[$tax_rate['tax_rate_id']]['amount'];
			} else {
				$amount = 0;
			}
			
			if ($tax_rate['type'] == 'F') {
				$amount += $tax_rate['rate'];
			} elseif ($tax_rate['type'] == 'P') {
				$amount += ($value / 100 * $tax_rate['rate']);
			}
		
			$tax_rate_data[$tax_rate['tax_rate_id']] = array(
				'tax_rate_id' => $tax_rate['tax_rate_id'],
				'name'        => $tax_rate['name'],
				'rate'        => $tax_rate['rate'],
				'type'        => $tax_rate['type'],
				'amount'      => $amount
			);
		}
		
		return $tax_rate_data;
	}
}
?>
