<?php

class ModelBulkPrdSubsListAsOnDate extends Model {

	public function getTotalProductCount($data) {
		$user_id = $this->session->data['user_id'];
		$datetime_obj = new DateTime($data['filter_month'], new DateTimeZone('Asia/Calcutta'));
		$filter_month = $datetime_obj->format('Y-m');
		$monthStartDate = date('Y-m-01', strtotime($filter_month)); 
		$monthEndDate   = date('Y-m-t', strtotime($filter_month));
		
		if($data['filter_date_end']!=''){
			$data['filter_date_end'] = $data['filter_date_end'].' 23:59:59';
			$toMonth 	  = explode('-', $data['filter_date_end']); 
			$yearMonth    = $toMonth[0].'-'.$toMonth[1].'%'; 
		}

      	$query = "SELECT COUNT(*) AS total FROM  `oc_cas_op_transactions` cas
				INNER JOIN oc_product_description d ON ( d.product_id = cas.product_id ) 
				LEFT JOIN oc_product pd ON ( d.product_id = pd.product_id ) LEFT JOIN oc_customer c ON (c.customer_id = cas.user_id) ";
		
			if ($data['filter_option']==1) {
				$filter_date_start=date_create($data['filter_date_start']);
				$filter_date_end=date_create($data['filter_date_end']);
				$diff=date_diff($filter_date_start,$filter_date_end);
				$days = $diff->format("%R%a");	
				
				$query .= " inner join (SELECT max(id) as id from oc_cas_op_transactions WHERE cmd_id=10  AND (
					((modify_date > '".$data['filter_date_start']."') AND (exp_date > '".$data['filter_date_end']."') AND (modify_date < '".$data['filter_date_end']."')) OR 
					((modify_date < '".$data['filter_date_start']."') AND (exp_date > '".$data['filter_date_end']."')) OR 
					((modify_date < '".$data['filter_date_start']."') AND (exp_date < '".$data['filter_date_end']."') AND (exp_date > '".$data['filter_date_start']."')) OR
					((modify_date < '".$data['filter_date_start']."') AND (exp_date < '".$data['filter_date_end']."') AND ((exp_date like '".$yearMonth."') AND ('".$days."' > 28))) OR 
					((modify_date < '".$data['filter_date_start']."') AND (exp_date > '".$data['filter_date_end']."') OR ((exp_date like '".$yearMonth."') AND ('".$days."' > 28))) OR 
					((modify_date > '".$data['filter_date_start']."') AND (exp_date < '".$data['filter_date_end']."') OR ((exp_date like '".$yearMonth."') AND ('".$days."' > 28))) OR ((exp_date like '".$yearMonth."') AND ('".$days."' > 28))) group by user_id, product_id) bm on cas.id = bm.id AND (is_package =0 AND is_ppv=0 AND is_nvod=0) ";
			}elseif ($data['filter_option']==2) {
				$query .= " inner join (SELECT max(id) as id from oc_cas_op_transactions WHERE cmd_id=10   AND ((modify_date like '".$filter_month."%' ) OR (exp_date like '".$filter_month."%') OR (modify_date < '".$monthStartDate."' AND exp_date > '".$monthStartDate."')) group by user_id, product_id) bm on cas.id = bm.id AND (is_package =0 AND is_ppv=0 AND is_nvod=0) ";
			}elseif ($data['filter_option']==3) {
				$query .= " inner join (SELECT max(id) as id from oc_cas_op_transactions WHERE cmd_id=10  AND ((modify_date LIKE  '".$data['filter_year']."%') OR (modify_date <  '".$data['filter_year']."%' AND exp_date >  '".$data['filter_year']."%')) group by user_id, product_id) bm on cas.id = bm.id AND (is_package =0 AND is_ppv=0 AND is_nvod=0) ";
			}else{
				$query .= " inner join (SELECT max(id) as id from oc_cas_op_transactions WHERE cmd_id=10  group by user_id, product_id) bm on cas.id = bm.id AND (is_package =0 AND is_ppv=0 AND is_nvod=0) ";
			}

		$countquery = $this->db->query($query);
		return $countquery->row['total'];
	}

/*
FUNCTION NAME 		-	getProductDetails
DESCRIPTION 		-	Get product details from product_description table with con.
INPUT PARAMETER 	-	-
OUTPUT PARAMETER 	- 	is_default
*/	

	public function getProductDetails($data){
		$datetime_obj = new DateTime($data['filter_month'], new DateTimeZone('Asia/Calcutta'));
		$filter_month = $datetime_obj->format('Y-m');
		$monthStartDate = date('Y-m-01', strtotime($filter_month)); 
		$monthEndDate   = date('Y-m-t', strtotime($filter_month));
		
		if($data['filter_date_end']!=''){
			$data['filter_date_end'] = $data['filter_date_end'].' 23:59:59';
			$toMonth 	  = explode('-', $data['filter_date_end']); 
			$yearMonth    = $toMonth[0].'-'.$toMonth[1].'%'; 
		}

		$sql = "SELECT (pd.model) AS pno, c.STBNO AS stbno, cas.modify_date, cas.exp_date
				FROM  `oc_cas_op_transactions` cas
				INNER JOIN oc_product_description d ON ( d.product_id = cas.product_id ) 
				LEFT JOIN oc_product pd ON ( d.product_id = pd.product_id ) LEFT JOIN oc_customer c ON (c.customer_id = cas.user_id) ";
		if ($data['filter_option']==1) {
			
				$filter_date_start=date_create($data['filter_date_start']);
				$filter_date_end=date_create($data['filter_date_end']);
				$diff=date_diff($filter_date_start,$filter_date_end);
				$days = $diff->format("%R%a");				
				
				$sql .= " inner join (SELECT max(id) as id from oc_cas_op_transactions WHERE cmd_id=10  AND (
					((modify_date > '".$data['filter_date_start']."') AND (exp_date > '".$data['filter_date_end']."') AND (modify_date < '".$data['filter_date_end']."')) OR 
					((modify_date < '".$data['filter_date_start']."') AND (exp_date > '".$data['filter_date_end']."')) OR 
					((modify_date < '".$data['filter_date_start']."') AND (exp_date < '".$data['filter_date_end']."') AND (exp_date > '".$data['filter_date_start']."')) OR
					((modify_date < '".$data['filter_date_start']."') AND (exp_date < '".$data['filter_date_end']."') AND ((exp_date like '".$yearMonth."') AND ('".$days."' > 28))) OR 
					((modify_date < '".$data['filter_date_start']."') AND (exp_date > '".$data['filter_date_end']."') OR ((exp_date like '".$yearMonth."') AND ('".$days."' > 28))) OR 
					((modify_date > '".$data['filter_date_start']."') AND (exp_date < '".$data['filter_date_end']."') OR ((exp_date like '".$yearMonth."') AND ('".$days."' > 28))) OR ((exp_date like '".$yearMonth."') AND ('".$days."' > 28))) group by user_id, product_id) bm on cas.id = bm.id AND (is_package =0 AND is_ppv=0 AND is_nvod=0) ";


			}elseif ($data['filter_option']==2) {
				$sql .= " inner join (SELECT max(id) as id from oc_cas_op_transactions WHERE cmd_id=10   AND ((modify_date like '".$filter_month."%' ) OR (exp_date like '".$filter_month."%') OR (modify_date < '".$monthStartDate."' AND exp_date > '".$monthStartDate."')) group by user_id, product_id) bm on cas.id = bm.id AND (is_package =0 AND is_ppv=0 AND is_nvod=0) ";
			}elseif ($data['filter_option']==3) {
				$sql .= " inner join (SELECT max(id) as id from oc_cas_op_transactions WHERE cmd_id=10  AND ((modify_date LIKE  '".$data['filter_year']."%') OR (modify_date <  '".$data['filter_year']."%' AND exp_date >  '".$data['filter_year']."%')) group by user_id, product_id) bm on cas.id = bm.id AND (is_package =0 AND is_ppv=0 AND is_nvod=0) ";
			}else{
				$sql .= " inner join (SELECT max(id) as id from oc_cas_op_transactions where cmd_id=10  group by user_id, product_id) bm on cas.id = bm.id AND (is_package =0 AND is_ppv=0 AND is_nvod=0) ";
			}


		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}				
			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}			
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}	
		// var_dump($sql);exit();
		$query = $this->db->query($sql);
		return $query->rows;

	}

	public function getProductDetailsForPDF($data){  
		// echo "<pre>"; print_r($_REQUEST);
		// if($_REQUEST['option']!=1){
		if(isset($data['filter_month'])){
			$datetime_obj = new DateTime($data['filter_month'], new DateTimeZone('Asia/Calcutta'));
			$filter_month = $datetime_obj->format('Y-m');
			$monthStartDate = date('Y-m-01', strtotime($filter_month)); 
			$monthEndDate   = date('Y-m-t', strtotime($filter_month));
		}
		
		if(isset($data['filter_date_start']) && isset($data['filter_date_end'])){
			if($data['filter_date_end']!=''){
				$data['filter_date_end'] = $data['filter_date_end'].' 23:59:59';
				$toMonth 	  = explode('-', $data['filter_date_end']); 
				$yearMonth    = $toMonth[0].'-'.$toMonth[1].'%'; 
			}
		}
		// }
		// $productID = implode(',', $_REQUEST['selected']);
		// var_dump($_REQUEST['selected']);exit();
		// $stbno = implode(',', $_REQUEST['selected']);
		// $id_list = "'";
		// foreach ($_REQUEST['selected'] as $key ) {
		// 	$id_list = $id_list."','".$key;
		// }
		// $id_list = trim($id_list,"',");

		$sql = "SELECT (pd.model) AS pno, c.STBNO AS stbno, cas.modify_date, cas.exp_date
				FROM  `oc_cas_op_transactions` cas
				INNER JOIN oc_product_description d ON ( d.product_id = cas.product_id ) 
				LEFT JOIN oc_product pd ON ( d.product_id = pd.product_id ) LEFT JOIN oc_customer c ON (c.customer_id = cas.user_id)";

			if ($data['filter_option']==1) {
				$filter_date_start=date_create($data['filter_date_start']);
				$filter_date_end=date_create($data['filter_date_end']);
				$diff=date_diff($filter_date_start,$filter_date_end);
				$days = $diff->format("%R%a");				
				
				$sql .= " inner join (SELECT max(id) as id from oc_cas_op_transactions WHERE cmd_id=10  AND (
					((modify_date > '".$data['filter_date_start']."') AND (exp_date > '".$data['filter_date_end']."') AND (modify_date < '".$data['filter_date_end']."')) OR 
					((modify_date < '".$data['filter_date_start']."') AND (exp_date > '".$data['filter_date_end']."')) OR 
					((modify_date < '".$data['filter_date_start']."') AND (exp_date < '".$data['filter_date_end']."') AND (exp_date > '".$data['filter_date_start']."')) OR
					((modify_date < '".$data['filter_date_start']."') AND (exp_date < '".$data['filter_date_end']."') AND ((exp_date like '".$yearMonth."') AND ('".$days."' > 28))) OR 
					((modify_date < '".$data['filter_date_start']."') AND (exp_date > '".$data['filter_date_end']."') OR ((exp_date like '".$yearMonth."') AND ('".$days."' > 28))) OR 
					((modify_date > '".$data['filter_date_start']."') AND (exp_date < '".$data['filter_date_end']."') OR ((exp_date like '".$yearMonth."') AND ('".$days."' > 28))) OR ((exp_date like '".$yearMonth."') AND ('".$days."' > 28))) group by user_id, product_id) bm on cas.id = bm.id AND (is_package =0 AND is_ppv=0 AND is_nvod=0)  ";
			}elseif ($data['filter_option']==2) {
				$sql .= " inner join (SELECT max(id) as id from oc_cas_op_transactions WHERE cmd_id=10   AND ((modify_date like '".$filter_month."%' ) OR (exp_date like '".$filter_month."%') OR (modify_date < '".$monthStartDate."' AND exp_date > '".$monthStartDate."')) group by user_id, product_id) bm on cas.id = bm.id AND (is_package =0 AND is_ppv=0 AND is_nvod=0)  ";
			}elseif ($data['filter_option']==3) {
				$sql .= " inner join (SELECT max(id) as id from oc_cas_op_transactions WHERE cmd_id=10  AND ((modify_date LIKE  '".$data['filter_year']."%') OR (modify_date <  '".$data['filter_year']."%' AND exp_date >  '".$data['filter_year']."%')) group by user_id, product_id) bm on cas.id = bm.id AND (is_package =0 AND is_ppv=0 AND is_nvod=0)  ";
			}else{
				$sql .= " inner join (SELECT max(id) as id from oc_cas_op_transactions where cmd_id=10  group by user_id, product_id) bm on cas.id = bm.id AND (is_package =0 AND is_ppv=0 AND is_nvod=0) ";
			}
		
		$query = $this->db->query($sql);
		return $query->rows;
	}	
}
?>
