<?php

class ModelBulkPpvSubscriptionCount extends Model {

/*
FUNCTION NAME 		-	getTotalPpvCount
DESCRIPTION 		-	Retrieves the rows containing the count of rows in Product table.
INPUT PARAMETER 	-	-
OUTPUT PARAMETER 	- 	Returns a column "total" containing the count of categories in the database.
*/		
	public function getTotalPpvCount($data) {
		$datetime_obj = new DateTime($data['filter_month'], new DateTimeZone('Asia/Calcutta'));
		$filter_month = $datetime_obj->format('Y-m');
		$user_id = $this->session->data['user_id'];

      	$query = "SELECT  d.name, COUNT( cas.product_id ) AS total FROM  `oc_cas_op_transactions` cas 
				INNER JOIN oc_product_description d ON ( d.product_id = cas.product_id ) 
				LEFT JOIN oc_product pd ON ( d.product_id = pd.product_id )"; 
		if($user_id==1){	
			if ($data['filter_option']==1) {
				$query .= " inner join (select max(id) as id from oc_cas_op_transactions where cmd_id=18 AND exp_date BETWEEN '".$data['filter_date_start']." 00:00:00' AND '".$data['filter_date_end']." 23:59:59' GROUP BY product_id, user_id) bm on cas.id = bm.id AND (is_ppv=1) GROUP BY cas.product_id";
			}elseif ($data['filter_option']==2) {
				$query .= " inner join (select max(id) as id from oc_cas_op_transactions where cmd_id=18 AND exp_date like '".$filter_month."%' GROUP BY product_id, user_id) bm on cas.id = bm.id AND (is_ppv=1) GROUP BY cas.product_id";
			}elseif ($data['filter_option']==3) {
				$query .= " inner join (select max(id) as id from oc_cas_op_transactions where cmd_id=18 AND exp_date like '".$data['filter_year']."%' GROUP BY product_id, user_id) bm on cas.id = bm.id AND (is_ppv=1) GROUP BY cas.product_id";
			}else{
				$query .= " inner join (select max(id) as id from oc_cas_op_transactions where cmd_id=18  group by user_id, product_id) bm on cas.id = bm.id AND (is_ppv=1) GROUP BY cas.product_id";
				
			}
		}else{
			if ($data['filter_option']==1) {
				$query .= " inner join (select max(id) as id from oc_cas_op_transactions where cmd_id=18 AND exp_date BETWEEN '".$data['filter_date_start']." 00:00:00' AND '".$data['filter_date_end']." 23:59:59' AND operator_id=".$user_id." GROUP BY product_id, user_id) bm on cas.id = bm.id AND (is_ppv=1) GROUP BY cas.product_id";
			}elseif ($data['filter_option']==2) {
				$query .= " inner join (select max(id) as id from oc_cas_op_transactions where cmd_id=18 AND cas.exp_date like '".$filter_month."%' AND operator_id=".$user_id." GROUP BY product_id, user_id) bm on cas.id = bm.id AND (is_ppv=1) GROUP BY cas.product_id";
			}elseif ($data['filter_option']==3) {
				$query .= " inner join (select max(id) as id from oc_cas_op_transactions where cmd_id=18 AND cas.exp_date like '".$data['filter_year']."%' AND operator_id=".$user_id." GROUP BY product_id, user_id) bm on cas.id = bm.id AND (is_ppv=1) GROUP BY cas.product_id";
			}else{
				$query .= " inner join (select max(id) as id from oc_cas_op_transactions where cmd_id=18 AND operator_id=".$user_id." GROUP BY product_id, user_id) bm on cas.id = bm.id AND (is_ppv=1) GROUP BY cas.product_id";
			}
		}

		$countquery = $this->db->query($query);
		return $countquery->num_rows;
	}

/*
FUNCTION NAME 		-	getPpvDetails
DESCRIPTION 		-	Get ppv details from product_description table with con.
INPUT PARAMETER 	-	-
OUTPUT PARAMETER 	- 	is_default
*/	
	public function getPpvDetails($data){
		$datetime_obj = new DateTime($data['filter_month'], new DateTimeZone('Asia/Calcutta'));
		$filter_month = $datetime_obj->format('Y-m');

		$sql = "SELECT d.product_id AS ppv_id, d.name, COUNT( cas.product_id ) AS count
				FROM  `oc_cas_op_transactions` cas 
				INNER JOIN oc_product_description d ON ( d.product_id = cas.product_id ) 
				LEFT JOIN oc_product pd ON ( d.product_id = pd.product_id )"; 
		$user_id = $this->session->data['user_id'];
		if($user_id==1){
			if ($data['filter_option']==1) {
				$sql .= " inner join (select max(id) as id from oc_cas_op_transactions where cmd_id=18 AND exp_date BETWEEN '".$data['filter_date_start']." 00:00:00' AND '".$data['filter_date_end']." 23:59:59' GROUP BY product_id, user_id)  bm on cas.id = bm.id AND (is_ppv=1) GROUP BY cas.product_id";
			}elseif ($data['filter_option']==2) {
				$sql .= " inner join (select max(id) as id from oc_cas_op_transactions where cmd_id=18 AND exp_date like '".$filter_month."%' GROUP BY product_id, user_id)  bm on cas.id = bm.id AND (is_ppv=1) GROUP BY cas.product_id";
			}elseif ($data['filter_option']==3) {
				$sql .= " inner join (select max(id) as id from oc_cas_op_transactions where cmd_id=18 AND exp_date like '".$data['filter_year']."%' GROUP BY product_id, user_id)  bm on cas.id = bm.id AND (is_ppv=1) GROUP BY cas.product_id";
			}else{
				$sql .= " inner join (select max(id) as id from oc_cas_op_transactions where cmd_id=18 GROUP BY product_id, user_id)  bm on cas.id = bm.id AND (is_ppv=1) GROUP BY cas.product_id";
			}
		}else{
			if ($data['filter_option']==1) {
				$sql .= " inner join (select max(id) as id from oc_cas_op_transactions where cmd_id=18 AND cas.exp_date BETWEEN '".$data['filter_date_start']." 00:00:00' AND '".$data['filter_date_end']." 23:59:59' AND operator_id=".$user_id." GROUP BY product_id, user_id) bm on cas.id = bm.id AND (is_ppv=1) GROUP BY cas.product_id";
			}elseif ($data['filter_option']==2) {
				$sql .= " inner join (select max(id) as id from oc_cas_op_transactions where cmd_id=18 AND cas.exp_date like '".$filter_month."%' AND operator_id=".$user_id." GROUP BY product_id, user_id) bm on cas.id = bm.id AND (is_ppv=1) GROUP BY cas.product_id";
			}elseif ($data['filter_option']==3) {
				$sql .= " inner join (select max(id) as id from oc_cas_op_transactions where cmd_id=18 AND cas.exp_date like '".$data['filter_year']."%' AND operator_id=".$user_id." GROUP BY product_id, user_id) bm on cas.id = bm.id AND (is_ppv=1) GROUP BY cas.product_id";
			}else{
				$sql .= " inner join (select max(id) as id from oc_cas_op_transactions where cmd_id=18 AND operator_id=".$user_id." GROUP BY product_id, user_id) bm on cas.id = bm.id AND (is_ppv=1) GROUP BY cas.product_id";
			}
		} 
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}				
			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}			
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}	
		$query = $this->db->query($sql);
		return $query->rows;

	}

/*
FUNCTION NAME 		-	getPpvDetailsForPDF
DESCRIPTION 		-	Get product details from product_description table with con.
INPUT PARAMETER 	-	-
OUTPUT PARAMETER 	- 	is_default
*/	
	public function getPpvDetailsForPDF($ppv_id,$data){
		$sql = "SELECT d.product_id AS ppv_id, d.name, COUNT( cas.product_id ) AS count
				FROM  `oc_cas_op_transactions` cas 
				INNER JOIN oc_product_description d ON ( d.product_id = cas.product_id ) 
				LEFT JOIN oc_product pd ON ( d.product_id = pd.product_id ) ";

		$sql .= " inner join (select max(id) as id from oc_cas_op_transactions where cmd_id=18 AND product_id =".(int)$ppv_id." GROUP BY product_id, user_id) bm on cas.id = bm.id AND (is_ppv=1) GROUP BY cas.product_id";

		$query = $this->db->query($sql);
		return $query->rows;
	}
}
?>
