<?php
/*
@File settopbox.php(MODEL)
LOCALISATION:	 SETTOPBOX PAGE
    This class queries the location of all the set top boxes ie (customer address) list for the store.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ModelBulkLocationwiseSettopbox extends Model {
	/*
FUNCTION NAME 		-	getCustomerAddress
DESCRIPTION 		-	Queries the address for the given customer_id
INPUT PARAMETER 	-	customer_id
OUTPUT PARAMETER 	- 	Returns the row queried containing the address
*/	
	public function getCustomerAddress($zone_id,$region_id) {
		$sql = "SELECT  r.region_name, (c.customer_id),CONCAT(c.firstname, ' ', c.lastname) AS name,(c.STBNO),CONCAT(a.address_1,' ',a.city) AS address,c.date_added,c.status FROM " . DB_PREFIX . "customer c INNER JOIN " . DB_PREFIX . "address a ON (c.address_id = a.address_id)  INNER JOIN oc_region r ON ( r.region_id = a.region_id ) ";

		if($zone_id!='' && $region_id!=''){
			$sql .="WHERE a.zone_id=".$zone_id." AND a.region_id=".$region_id;
			$sql .=" AND (c.STBNO NOT LIKE '' ) AND ( c.STBNO NOT LIKE '0') GROUP BY c.customer_id";
		}else{
			$sql .=" WHERE (c.STBNO NOT LIKE '' ) AND ( c.STBNO NOT LIKE '0') GROUP BY c.customer_id";
		}
		
		$query = $this->db->query($sql);
		return $query->rows;
	}
/*
FUNCTION NAME 		-	getAddress
DESCRIPTION 		-	Queries all the customers address.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the row queried containing address of each customers
*/	
	public function getAddress($data) {
		$sql="SELECT r.region_name, (c.customer_id),CONCAT(c.firstname, ' ', c.lastname) AS name,(c.STBNO),CONCAT(a.address_1,' ',a.city) AS address,c.date_added,c.status FROM " . DB_PREFIX . "customer c INNER JOIN " . DB_PREFIX . "address a ON (c.address_id = a.address_id)
			INNER JOIN oc_region r ON ( r.region_id = a.region_id ) ";

		if($data['zone_id']!='' && $data['region_id']!=''){
			$sql .="where (c.STBNO NOT LIKE '' ) AND ( c.STBNO NOT LIKE '0') AND a.zone_id=".$data['zone_id']." AND a.region_id=".$data['region_id'];
		}else{
			$sql .="where (c.STBNO NOT LIKE '' ) AND ( c.STBNO NOT LIKE '0') ";
		}
		if($this->session->data['user_id']!=1)
      	{
      		$sql.=" AND c.operator_id ='" . $this->session->data['user_id'] . "'";
      	}
		$sql .=" GROUP BY c.customer_id";
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}				
			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}	
		$query = $this->db->query($sql);
		return $query->rows;
	}
		/*
FUNCTION NAME 		-	getTotalStbAddress
DESCRIPTION 		-	Retrieves number of  stb number assign to customer and balance.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved by the query.
*/		
	public function getTotalStbAddress($data) {
		// $query = "SELECT (c.customer_id) FROM " . DB_PREFIX . "customer c INNER JOIN " . DB_PREFIX . "address a ON (c.address_id = a.address_id) ";

		$query="SELECT * FROM " . DB_PREFIX . "customer c INNER JOIN " . DB_PREFIX . "address a ON (c.address_id = a.address_id)
			INNER JOIN oc_region r ON ( r.region_id = a.region_id ) ";

		if($data['zone_id']!='' && $data['region_id']!=''){
			$query .="where (c.STBNO NOT LIKE '' ) AND ( c.STBNO NOT LIKE '0') AND a.zone_id=".$data['zone_id']." AND a.region_id=".$data['region_id'];
		}else{
			$query .="where (c.STBNO NOT LIKE '' ) AND ( c.STBNO NOT LIKE '0') ";
		}
		if($this->session->data['user_id']!=1)
      	{
      		$query.=" AND c.operator_id ='" . $this->session->data['user_id'] . "'";
      	}
		$query .=" GROUP BY c.customer_id";
		$countquery = $this->db->query($query);
		return $countquery->num_rows;
	}

	public function getZoneList($country_id){
		$sql = "SELECT zone_id, name from ".DB_PREFIX."zone WHERE country_id=".$country_id." ";
		$query = $this->db->query($sql);
		return $query->rows;
	}

	public function getRegionList($zone_id){
		$sql = "SELECT region_id, region_name from ".DB_PREFIX."region WHERE zone_id = ".$zone_id." ";
		$query = $this->db->query($sql);
		return $query->rows;
	}

	public function getLocationDetails($zone_id,$region_id){
		$sql = "SELECT name AS zone_name, r.region_name from ".DB_PREFIX."region r INNER JOIN " . DB_PREFIX . "zone z ON (r.zone_id = 
				z.zone_id) WHERE r.zone_id = ".$zone_id." AND r.region_id = ".$region_id." ";
		$query = $this->db->query($sql);
		return $query->row;
	}
}
?>