<?php
/*
@File deactvsubsageing.php(MODEL)
REPORT:	 AGING PAGE
    This class queries the ageing list for the subscribers from the database for the store
    to generate the report.

@Author Ravi Ranjan 
@date 5th Aug. 2014
*/
class ModelBulkDeactvsubsageing extends Model {
/*
FUNCTION NAME 		-	getAgeing
DESCRIPTION 		-	Queries the ageing of the subscriber on particular channels/packages
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns the asked queried rows
*/	
	public function getAgeing($data) {
		if($this->session->data['user_id']==1)
		{
			$sql= "SELECT c.customer_id,CONCAT(c.firstname,' ',c.lastname) AS name,c.STBNO,s.active_date,DATEDIFF(s.active_date,now()) AS duration FROM `oc_customer` c left join `oc_stb` s on(c.STBNO=s.stb_no) where s.active_date != 'NULL' AND is_active=0 AND s.active_date NOT LIKE  '0000-00-00 00:00:00'";
		}else {
			$sql= "SELECT c.customer_id,CONCAT(c.firstname,' ',c.lastname) AS name,c.STBNO,s.active_date,DATEDIFF(s.active_date,now()) AS duration FROM `oc_customer` c left join `oc_stb` s on(c.STBNO=s.stb_no) where s.active_date != 'NULL' AND is_active=0 AND s.operator_id='".$this->session->data['user_id']."'";	
		}

		if (!empty($data['filter_stbno'])) {
			$sql .= "  AND s.stb_no = '".$this->db->escape($data['filter_stbno'])."' ";
		}

		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}			

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
			
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}	
		
		$query = $this->db->query($sql);	
		return $query->rows;
	}
/*
FUNCTION NAME 		-	getAgeing
DESCRIPTION 		-	Queries the ageing of the subscriber on particular channels/packages
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns the asked queried rows
*/	
	public function getTotalageing($data) {
		if($this->session->data['user_id']==1)
			{
			$sql="SELECT count(*) AS 'total' FROM `oc_customer` c left join `oc_stb` s on(c.STBNO=s.stb_no) where s.active_date != 'NULL' AND is_active=0 AND s.active_date NOT LIKE  '0000-00-00 00:00:00'";
		}else {
			$sql="SELECT count(*) AS 'total' FROM `oc_customer` c left join `oc_stb` s on(c.STBNO=s.stb_no) where s.active_date != 'NULL' AND is_active=0 AND s.operator_id='".$this->session->data['user_id']."'";
		}

		if (!empty($data['filter_stbno'])) {
			$sql .= "  AND s.stb_no = '".$this->db->escape($data['filter_stbno'])."' ";
		}
			
		$query = $this->db->query($sql);		
		return $query->row['total'];

	}
	
/*
FUNCTION NAME 		-	getAgeingCustomer
DESCRIPTION 		-	Queries the ageing of the given product for the given customer_id
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns the queried rows
*/	

	public function getAgeingCustomer($customer_id) {
		$query = $this->db->query("SELECT c.customer_id,CONCAT(c.firstname,' ',c.lastname) AS name,c.STBNO,s.active_date,DATEDIFF(s.active_date,now()) AS duration FROM `oc_customer` c left join `oc_stb` s on(c.STBNO=s.stb_no) where is_active=0 AND c.customer_id=".$customer_id."");
		return $query->rows;	
	}
}
?>
