<?php
/*
@File customer.php(MODEL)
REPORT:	 CUSTOMER PAGE
    This class queries the Total authorized subscribers as a  list from the database for the store
    to generate the report.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/

class ModelBulkCustomerDueForReactivation extends Model {

	/*
FUNCTION NAME 		-	getCustomers
DESCRIPTION 		-	Queries all the approved customer detials from the database. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved
*/
	public function getCustomersFilter($data) {
		$expiry=date('Y-m-d', strtotime($data['filter_date'] ));
		$from=date('Y-m-d', strtotime($data['filter_from_date'] ));

		if($this->session->data['user_group_id']==1){
			$sql ="select b.customer_id,b.customer_unique_id,b.telephone,concat(b.firstname,' ',b.lastname) as name, b.STBNO,c.exp_date as expiry_date,
				region_name, username from oc_activationDeactivation c inner join (
					SELECT max(id) as maxId,user_id FROM `oc_activationDeactivation` cas where cmd_id IN (0,1) group by user_id
				) a on c.id = a.maxId 
				inner join oc_customer b on a.user_id = b.customer_id
				INNER JOIN oc_address A ON b.address_id = A.address_id
				INNER JOIN oc_region R ON A.region_id = R.region_id
				INNER JOIN oc_user u ON b.operator_id = u.user_id 
				where c.exp_date >= '".$from." 00:00:00' AND c.exp_date <= '".$expiry." 23:59:59' ";   
		} else {
			 $sql ="select b.customer_id,b.customer_unique_id,b.telephone,concat(b.firstname,' ',b.lastname) as name, b.STBNO,c.exp_date as expiry_date,
				region_name, username from oc_activationDeactivation c inner join (
					SELECT max(id) as maxId,user_id FROM `oc_activationDeactivation` cas where cmd_id IN (0,1) group by user_id
				) a on c.id = a.maxId 
				inner join oc_customer b on a.user_id = b.customer_id
				INNER JOIN oc_address A ON b.address_id = A.address_id
				INNER JOIN oc_region R ON A.region_id = R.region_id
				INNER JOIN oc_user u ON b.operator_id = u.user_id 
				where c.exp_date >= '".$from." 00:00:00' AND c.exp_date <= '".$expiry." 23:59:59' and  b.operator_id = ".$this->session->data['user_id'];      
		}

		

		if(isset($data['filter_region']) && $data['filter_region']!='-1'){
			$sql.=" AND A.region_id =".$data['filter_region'];
		}

		if(isset($data['filter_operator']) && $data['filter_operator']!='-1'){
			$sql.=" AND u.user_id =".$data['filter_operator'];
		}
		
		$sql .= "  ORDER BY c.exp_date DESC";	
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}				

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
		
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

		$query = $this->db->query($sql);
		return $query->rows;	
	}

	public function getTotalCustomersFilter($data) {
		$expiry=date('Y-m-d', strtotime($data['filter_date'] ));
		$from=date('Y-m-d', strtotime($data['filter_from_date'] ));

		if($this->session->data['user_group_id']==1){
			$sql ="select count(*) as total from oc_activationDeactivation c inner join (
					SELECT max(id) as maxId,user_id FROM `oc_activationDeactivation` cas where cmd_id IN (0,1) group by user_id
				) a on c.id = a.maxId 
				inner join oc_customer b on a.user_id = b.customer_id
				INNER JOIN oc_address A ON b.address_id = A.address_id
				INNER JOIN oc_region R ON A.region_id = R.region_id
				INNER JOIN oc_user u ON b.operator_id = u.user_id 
				where c.exp_date >= '".$from." 00:00:00' AND c.exp_date <= '".$expiry." 23:59:59' ";   
		} else {
			 $sql ="select count(*) as total from oc_activationDeactivation c inner join (
					SELECT max(id) as maxId,user_id FROM `oc_activationDeactivation` cas where cmd_id IN (0,1) group by user_id
				) a on c.id = a.maxId 
				inner join oc_customer b on a.user_id = b.customer_id
				INNER JOIN oc_address A ON b.address_id = A.address_id
				INNER JOIN oc_region R ON A.region_id = R.region_id
				INNER JOIN oc_user u ON b.operator_id = u.user_id 
				where c.exp_date >= '".$from." 00:00:00' AND c.exp_date <= '".$expiry." 23:59:59' and  b.operator_id = ".$this->session->data['user_id'];      
		}

		

		if(isset($data['filter_region']) && $data['filter_region']!='-1'){
			$sql.=" AND A.region_id =".$data['filter_region'];
		}

		if(isset($data['filter_operator']) && $data['filter_operator']!='-1'){
			$sql.=" AND u.user_id =".$data['filter_operator'];
		}
		
		

		$query = $this->db->query($sql);
		return $query->row['total'];	
	}
	 /*
FUNCTION NAME         -    getCustomerpdf
DESCRIPTION         -    Queries all the approved customer detials from the database. 
INPUT PARAMETER     -    void
OUTPUT PARAMETER     -     Returns all the rows retrieved
*/
    public function getCustomerpdf($data,$filter_region) {
        $expiry=date('Y-m-d', strtotime($data['filter_date'] ));
		$from=date('Y-m-d', strtotime($data['filter_from_date'] ));
		
		if($this->session->data['user_group_id']==1){
			$sql ="select b.customer_id,b.customer_unique_id,b.telephone,concat(b.firstname,' ',b.lastname) as name, b.STBNO,c.exp_date as expiry_date,
				region_name, username from oc_activationDeactivation c inner join (
					SELECT max(id) as maxId,user_id FROM `oc_activationDeactivation` cas where cmd_id IN (0,1) group by user_id
				) a on c.id = a.maxId 
				inner join oc_customer b on a.user_id = b.customer_id
				INNER JOIN oc_address A ON b.address_id = A.address_id
				INNER JOIN oc_region R ON A.region_id = R.region_id
				INNER JOIN oc_user u ON b.operator_id = u.user_id 
				where c.exp_date >= '".$from." 00:00:00' AND c.exp_date <= '".$expiry." 23:59:59' ";
		}else{
			$sql ="select b.customer_id,b.customer_unique_id,b.telephone,concat(b.firstname,' ',b.lastname) as name, b.STBNO,c.exp_date as expiry_date,
				region_name, username from oc_activationDeactivation c inner join (
					SELECT max(id) as maxId,user_id FROM `oc_activationDeactivation` cas where cmd_id IN (0,1) group by user_id
				) a on c.id = a.maxId 
				inner join oc_customer b on a.user_id = b.customer_id
				INNER JOIN oc_address A ON b.address_id = A.address_id
				INNER JOIN oc_region R ON A.region_id = R.region_id
				INNER JOIN oc_user u ON b.operator_id = u.user_id 
				where c.exp_date >= '".$from." 00:00:00' AND c.exp_date <= '".$expiry." 23:59:59' and  b.operator_id = ".$this->session->data['user_id'];		
		}

				

		if(isset($data['filter_region']) && $data['filter_region']!='-1'){
			$sql.=" AND A.region_id =".$data['filter_region'];
		}

		if(isset($data['filter_operator']) && $data['filter_operator']!='-1'){
			$sql.=" AND u.user_id =".$data['filter_operator'];
		}

		$sql .= "  ORDER BY c.exp_date DESC";	 
        $query = $this->db->query($sql);
        return $query->rows;    
    }
	
	public function getRegions(){
		$sql = "SELECT region_id, region_name FROM ".DB_PREFIX."region";
		$query = $this->db->query($sql);		
		return $query->rows;
	}

	public function getOperators(){
		if($this->session->data['user_group_id']==1){
			$sql = "SELECT user_id, username FROM ".DB_PREFIX."user";
		}else{
			$sql = "SELECT user_id, username FROM ".DB_PREFIX."user where user_id =".$this->session->data['user_id'];
		}
		$query = $this->db->query($sql);		
		return $query->rows;
	}
}
?>