<?php
/*
@File a_la_carte_price.php(MODEL)
LOCALISATION:	 A la carte price list PAGE
    This class queries all the  channels .

@Author Ravi Ranjan
@date 9th Aug. 2016
*/
class ModelBulkAlacarteprice extends Model {

	/*
FUNCTION NAME 		-	getChannelListDetails
DESCRIPTION 		-	Queries all the channel list details with their descriptions.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved.
*/	
	public function getChannelListDetails($data=array()) {
		$sql = "SELECT b.name as broadcasterName,p.product_id, p.service_id,p.access_criteria,p.lcn, pd.name, p.price,p.broadcaster_id,p.model,pd.product_type FROM oc_product p inner join oc_product_description pd on p.product_id = pd.product_id left join oc_broadcaster b on p.broadcaster_id=b.broadcaster_id WHERE p.is_package =0 AND p.is_ppv =0 AND p.is_nvod=0 ";

		if(isset($data['filter_value'])){
			$sql .= " AND  p.model ='".$data['filter_value']."'";
		}
		$sql.= " ORDER BY pd.name";	
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}				

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}
		// var_dump($sql);die;
		$query = $this->db->query($sql);
		return $query->rows;	
	 }

	 public function getChannelListDetailsPDF($product_id) {
		$sql = "SELECT b.name as broadcasterName,p.product_id, p.service_id,p.access_criteria,p.lcn, pd.name, p.price,p.broadcaster_id,p.model,pd.product_type FROM oc_product p inner join oc_product_description pd on p.product_id = pd.product_id left join oc_broadcaster b on p.broadcaster_id=b.broadcaster_id WHERE p.is_package =0 AND p.is_ppv =0 AND p.is_nvod=0 AND p.product_id=".$product_id;
		$query = $this->db->query($sql);
		return $query->rows;	
	 }
/*
FUNCTION NAME 		-	getChannelListDetails
DESCRIPTION 		-	Queries all the channel list details with their descriptions.
INPUT PARAMETER 	-	product_id
OUTPUT PARAMETER 	- 	Returns the detail row.
*/	
	public function getChannelDetail($product_id) {
		$sql = "SELECT p.model,p.product_id, p.service_id,p.access_criteria,p.lcn, pd.name, p.price,p.broadcaster_id FROM oc_product p, oc_product_description pd
				WHERE p.product_id = pd.product_id AND p.is_package =0 AND p.is_ppv =0 AND p.product_id = ".$product_id." 
				GROUP BY p.product_id ORDER BY pd.name";
		$query = $this->db->query($sql);
		return $query->row;	
	}
/*
FUNCTION NAME 		-	getCategories
DESCRIPTION 		-	
INPUT PARAMETER 	-	product_id
OUTPUT PARAMETER 	- 	Returns all the rows retrieved.
*/	
	public function getCategories($product_id) {
		$query = $this->db->query("SELECT cd.name as category
			FROM oc_product p, oc_product_description pd, oc_product_to_category cat, oc_category_description cd
			WHERE  p.product_id ='".$product_id."' AND p.product_id = pd.product_id AND p.product_id = cat.product_id AND cat.category_id = cd.category_id AND p.is_package=0 AND p.is_ppv=0");
			return $query->rows;
	}


		/*
FUNCTION NAME 		-	getUserDetails
DESCRIPTION 		-	Queries the selected User details with its description.
INPUT PARAMETER 	-	package_id
OUTPUT PARAMETER 	- 	Returns the row retrieved.
*/
	public function getUserDetails($user_id) {
		$query = $this->db->query("SELECT `firstname`,`lastname`,`email` FROM ".DB_PREFIX."user WHERE `user_id`='".$user_id."'");
		return $query->row;
	}

	/*
FUNCTION NAME 		-	getTotalChannels
DESCRIPTION 		-	Queries to get the total number of CHANNELS raised in the database.
INPUT PARAMETER 	-
OUTPUT PARAMETER 	- 	returns a row with column total containing count for the table.
*/	
	public function getTotalChannels($data = array()) {
		
		$sql="SELECT count(DISTINCT(p.product_id)) as total FROM ".DB_PREFIX."product p WHERE p.is_package =0 AND p.is_ppv =0 AND p.is_nvod=0 ";
			if(isset($data['filter_value'])){
				$sql .= " AND  p.model ='".$data['filter_value']."'";
			}
				/*if (isset($data['start']) || isset($data['limit'])) {
					if ($data['start'] < 0) {
						$data['start'] = 0;
					}				

					if ($data['limit'] < 1) {
						$data['limit'] = 20;
					}	
				
					$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
				}*/
		$query = $this->db->query($sql);
		if($query->row!='')
		return $query->row['total'];	
	}
/*
FUNCTION NAME 		-	getBroadcasterName
DESCRIPTION 		-	Queries to get the name of broadcaster channel belongs the database.
INPUT PARAMETER 	-	boadcaster_id
OUTPUT PARAMETER 	- 	returns a row with column name.
*/	
	public function getBroadcasterName($broadcaster_id)
	{
		$query = $this->db->query("SELECT name FROM ".DB_PREFIX."broadcaster WHERE broadcaster_id='".$broadcaster_id."'");
		return $query->row;
	}

}
?>
