<?php
	/*
	Author: Ravi Ranjan
	date:21 March 2018
	class for LCO MSO Payment Activity.
	*/
	class ModelBillOperatorPayment extends Model {
		/*
		FUNCTION NAME 		-	getOperators
		DESCRIPTION 		-	Retrieves the customer details for the given customer_id
		INPUT PARAMETER 	-	customer_id
		OUTPUT PARAMETER 	- 	Returns the row retrieved.
		*/	
		public function getOperators() {
			$query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "user WHERE user_id !=1");
			return $query->rows;
		}

		public function getOperator($user_id) {
			$query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "user WHERE user_id =".$user_id."");
		
			return $query->row;
		}

		public function addlcoCredite($data){
			
			$initiated_by = $this->initiater();
			if ($data["payment_method"] == "razorpay") {
				
				$this->db->query("UPDATE `oc_user` SET `credit`= credit + ".$data["payable_amount_online"]." WHERE `user_id` =".$data["merchant_order_id"]."");

				$this->db->query("INSERT INTO `oc_mso_lco_transaction`(`mso_id`, `lco_id`, `payment_type`, `amount`,`initiated_by`,`transaction_id`) VALUES (1,".$data["merchant_order_id"].",'Razorpay',".$data["payable_amount_online"].",'".$initiated_by['username']."','".$data['razorpay_payment_id']."')");				
			}elseif ($data["payment_method"] == "paypal") {
				
				$this->db->query("UPDATE `oc_user` SET `credit`= credit + ".$data["paypal_amount"]." WHERE `user_id` =".$data["operator_id"]."");

				$this->db->query("INSERT INTO `oc_mso_lco_transaction`(`mso_id`, `lco_id`, `payment_type`, `amount`,`initiated_by`,`transaction_id`) VALUES (1,".$data["operator_id"].",'".$data['payment_method']."',".$data["paypal_amount"].",'".$initiated_by['username']."','".$data['transaction_id']."')");	
			
			}else{
			
			$this->db->query("UPDATE `oc_user` SET `credit`= credit + ".$data["payable_amount"]." WHERE `user_id` =".$data["filter_operator_id"]."");

			$this->db->query("INSERT INTO `oc_mso_lco_transaction`(`mso_id`, `lco_id`, `payment_type`, `amount`,`initiated_by`) VALUES (1,".$data["filter_operator_id"].",'".$data["payment_method"]."',".$data["payable_amount"].",'".$initiated_by['username']."')");
		}

		}

		public function initiater(){

			$sql = "SELECT username FROM `oc_user` WHERE user_id = ".$this->session->data["user_id"]."";
			$query = $this->db->query($sql);
			return $query->row;
		}
	
		public function getUserPaymentList($data) {
			if ($this->session->data["user_id"] == 1) {
				$sql = "SELECT user_id,username,CONCAT(firstname,' ',lastname) as name,mobile_no,email,credit FROM `oc_user` WHERE user_id != 1";
				$sql.= $this->getFiltercondition($data);
				$query = $this->db->query($sql);
				return $query->rows;
			}else{
				$sql = "SELECT user_id,username,CONCAT(firstname,' ',lastname) as name,mobile_no,email,credit FROM `oc_user` WHERE user_id = ".$this->session->data["user_id"]."";
				$sql.= $this->getFiltercondition($data);
				$query = $this->db->query($sql);
				return $query->rows;
			}
		}
		public function getTotalpaid($data) {
			if ($this->session->data["user_id"] == 1) {
				$sql = "SELECT count(*) AS total FROM `oc_user` WHERE user_id != 1";
				$sql.= $this->getFiltercondition($data);
				$query = $this->db->query($sql);
				return $query->row['total'];
			}else{
				$sql = "SELECT count(*) AS total FROM `oc_user` WHERE user_id = ".$this->session->data["user_id"]."";
				$sql.= $this->getFiltercondition($data);
				$query = $this->db->query($sql);
				return $query->row['total'];
			}
		}
		public function getLCOPaymentPDFdata($id){
				$sql = "SELECT user_id,username,CONCAT(firstname,' ',lastname) as name,mobile_no,email,credit FROM `oc_user` WHERE user_id = ".$id."";
				$query = $this->db->query($sql);
				return $query->row;
		}

		public function getFiltercondition($data) {

			$final_bind='';
			$implode=array();

			if (!empty($data['filter_username'])) { 
				$implode[] = " username like '%".$this->db->escape($data['filter_username'])."%'";
			}

			if (!empty($data['filter_name'])) {
				$implode[] =  " CONCAT(firstname,' ',lastname) LIKE '%" . $this->db->escape($data['filter_name']) . "%'";
			}
			if (!empty($data['filter_email'])) { 
				$implode[]= "email like '%" .$this->db->escape($data['filter_email']) . "%'";
			}

			if (!empty($data['filter_mobile_no'])) {
				$implode[]= "mobile_no = '" . (int)$data['filter_mobile_no'] . "'";
			}

			if (!empty($data['filter_credit'])) {
				$implode[]= "credit = ".$this->db->escape($data['filter_credit']) ."";
			}

			if($implode){
				$final_bind =" AND ".implode( ' AND ', $implode);
			}	

			if (isset($data['start']) || isset($data['limit'])) {
				if ($data['start'] < 0) {
					$data['start'] = 0;
				}				

				if ($data['limit'] < 1) {
					$data['limit'] = 20;
				}	

				$final_bind .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
			}

			return $final_bind;
		}

		public function getLCODetails($data) {
				$sql = ("SELECT user_id,concat(firstname,' ',lastname) as user_name,`mobile_no`,email,credit FROM  `oc_user` WHERE  `user_id` = ".$data["filter_operator_id"]."");
				
				$query = $this->db->query($sql);
				return $query->row;	
		}

		public function getSubscribedDigit($option_name){
			$option_month=preg_replace("/\D/", ' ',$option_name);
			return int($option_month);
		}

		public function getCurrentDatetime()
		{
			$currDatetime = new DateTime("now",new DateTimeZone('Asia/Calcutta'));  
			$current_datetime = $currDatetime->format('Y-m-d H:i:s');
			return $current_datetime;
		}

		public function getCurrentDate()
		{
			$currDate = new DateTime("now",new DateTimeZone('Asia/Calcutta'));  
			$current_date = $currDate->format('Y-m-d H:i:s');
			return $current_date;
		}

		public function getPerdayPrice($option_value_digit,$price)
		{
			$perdayPrice=$price/($option_value_digit*30);
			return round($perdayPrice,3);
		}
		//=======================
		function getExtensions($type) {
			$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "extension WHERE `type` = '" . $this->db->escape($type) . "'");

			return $query->rows;
		}
		function getLcoList() {
			$query = $this->db->query("SELECT username FROM `oc_user` WHERE user_id != 1");
			return $query->rows;
		}

		function getKeyId() {
			$query = $this->db->query("SELECT `value` FROM `oc_setting` WHERE `group` = 'razorpay' AND `key` = 'razorpay_key_id'");
			return $query->row['value'];
		}
}
?>
