<?php
	/*
	Author: Ravi Ranjan
	date:17 March 2018
	class for History for LCO MSO Transaction Activity.
	*/
	class ModelBillBylcosubstrans extends Model {

		public function getTransactionList($data) {

			if ($this->session->data["user_group_id"] == 1) {

				$sql = " SELECT c.order_id, c.stbno, CONCAT( cc.firstname,  ' ', cc.lastname ) AS cname, u.username AS 		lco, ua.username AS initiator, c.amount, c.date_triggered FROM  `oc_lco_transactions` c
						INNER JOIN oc_customer cc ON c.customer_id = cc.customer_id INNER JOIN oc_user u ON c.lco_id = u.user_id INNER JOIN oc_user ua ON ua.user_id = c.initiated_by where 1";

				$sql.= $this->getFiltercondition($data);

				$sql .= " ORDER BY c.order_id DESC LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
				
				$query = $this->db->query($sql);
				
				return $query->rows;
			
			}else{
				$sql = "SELECT c.order_id, c.stbno, CONCAT( cc.firstname,  ' ', cc.lastname ) AS cname, u.username AS 		lco, ua.username AS initiator, c.amount, c.date_triggered
							FROM  `oc_lco_transactions` c
							INNER JOIN oc_customer cc ON c.customer_id = cc.customer_id
							INNER JOIN oc_user u ON c.lco_id = u.user_id
							INNER JOIN oc_user ua ON ua.user_id = c.initiated_by where u.user_id = ".$this->session->data["user_id"]."";
				
				$sql.= $this->getFiltercondition($data);
				
				$sql .= " ORDER BY c.order_id DESC LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];

				$query = $this->db->query($sql);
				return $query->rows;
			}	
		}

		public function getTotalTransaction($data) {
			if ($this->session->data["user_group_id"] == 1) {
				$sql = "SELECT count(*) as total FROM  `oc_lco_transactions` c
						INNER JOIN oc_customer cc ON c.customer_id = cc.customer_id INNER JOIN oc_user u ON c.lco_id = u.user_id INNER JOIN oc_user ua ON ua.user_id = c.initiated_by";
				$sql.= $this->getFiltercondition($data);
				$query = $this->db->query($sql);
				return $query->row['total'];
			}else{
				$sql = "SELECT count(*) as total FROM  `oc_lco_transactions` c
						INNER JOIN oc_customer cc ON c.customer_id = cc.customer_id INNER JOIN oc_user u ON c.lco_id = u.user_id INNER JOIN oc_user ua ON ua.user_id = c.initiated_by WHERE u.user_id = ".$this->session->data["user_id"]."";
				$sql.= $this->getFiltercondition($data);
				$query = $this->db->query($sql);
				return $query->row['total'];
			}
		}
	//======================
			public function getTransactionListPDF($id) {

				$sql = "SELECT c.order_id, c.stbno, CONCAT( cc.firstname,  ' ', cc.lastname ) AS cname, u.username AS 		lco, ua.username AS initiator, c.amount, c.date_triggered FROM  `oc_lco_transactions` c
						INNER JOIN oc_customer cc ON c.customer_id = cc.customer_id INNER JOIN oc_user u ON c.lco_id = u.user_id INNER JOIN oc_user ua ON ua.user_id = c.initiated_by where c.order_id = ".$id."";

				$query = $this->db->query($sql);
				return $query->row;
		}
	//======================		
		public function getPaymentPdfData($pay_id) {
			$sql = "SELECT cus.customer_id,CONCAT(cus.firstname,' ', cus.lastname) as customer_name
			,cus.customer_unique_id as customer_no,cus.STBNO,pt.advance_amt,pt.pending_amt,pt.amt_paid,pt.balance,pd.pay_month,pd.payment_date,pd.pay_id
			from " . DB_PREFIX . "payment_transaction as pt left join " . DB_PREFIX . "payment_detail as pd on(pt.pay_id = pd.pay_id) 
			inner join " . DB_PREFIX . "customer as cus on(pt.customer_id = cus.customer_id) where pd.pay_id = ".$pay_id."";
			$query = $this->db->query($sql);
			return $query->row;	
		}

		public function getFiltercondition($data) {

			$final_bind='';
			$implode=array();

			if (!empty($data['filter_order_id'])) { 
				$implode[] = " c.order_id like '%".$this->db->escape($data['filter_order_id'])."%'";
			}



			if (!empty($data['filter_stbno'])) { 
				$implode[]= "c.stbno = '".$this->db->escape($data['filter_stbno']) . "'";
			}

			if (!empty($data['filter_name'])) {
				
				$implode[] =  " CONCAT(cc.firstname,' ', cc.lastname) LIKE '%".$this->db->escape($data['filter_name'])."%'";
			}
			if (!empty($data['filter_lco_id'])) {
				
				$implode[]= "c.lco_id = '" . $data['filter_lco_id'] . "'";
			}

			if (!empty($data['filter_initiator_id'])) {
				$implode[]= "c.initiated_by = " .$data['filter_initiator_id']. "";
			}

			if (!empty($data['filter_amount'])) {
				$implode[]= "c.amount = '" .$this->db->escape($data['filter_amount']) . "'";
			}
			
			if (!empty($data['filter_transaction_date'])) {

				$implode[]= "c.`date_triggered` LIKE '%".$data['filter_transaction_date']."%'";
			}

			if($implode){
				$final_bind =" AND ".implode( ' AND ', $implode);
			}	

		/*	if (isset($data['start']) || isset($data['limit'])) {
				if ($data['start'] < 0) {
					$data['start'] = 0;
				}				

				if ($data['limit'] < 1) {
					$data['limit'] = 20;
				}	

				$final_bind .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
			}*/

			return $final_bind;
		}

		public function getLCOUserid($lconame){
			$sql = "SELECT user_id From oc_user where username like '%".$lconame."%'";
			$query = $this->db->query($sql);
			if ($query->num_rows) {
				return $query->row['user_id'];
			}else{
				return 0;
			}
		}

		public function getOperators() {
			if($this->session->data['user_group_id'] == 1){
				$query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "user ORDER BY user_id ASC");
			}else{
				$query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "user WHERE user_id= ".$this->session->data['user_id']." ORDER BY user_id ASC ");
			}
		 return $query->rows;
		}

		public function getInitiators() {
			if($this->session->data['user_group_id'] == 1){
				$query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "user ORDER BY user_id ASC");
			}else{
				$query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "user WHERE user_id= ".$this->session->data['user_id']." OR user_id = 1 ORDER BY user_id ASC ");
			}
		 return $query->rows;
		}
}
?>
