<?php 
/*
@File error_log.php(Controller)
ADMIN ERROR_LOG PAGE
    This class shows the error log for the admin side. All the errors are logged here 
    with the detail to resolve them.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ControllerToolErrorLog extends Controller { 
	private $error = array();
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads when admin clicks the "error log" option in the dopdown list.
						It get all the errors occured in the website and logs in here for 
						future reference.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the error log page showing all the errors occured in a list.
*/	
	public function index() {		
		$this->language->load('tool/error_log');

		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->data['heading_title'] = $this->language->get('heading_title');
		 
		$this->data['button_clear'] = $this->language->get('button_clear');

		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),       		
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('tool/error_log', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => ' :: '
   		);
		
		$this->data['clear'] = $this->url->link('tool/error_log/clear', 'token=' . $this->session->data['token'], 'SSL');
		
		$file = DIR_LOGS . $this->config->get('config_error_filename');
		
		if (file_exists($file)) {
			$this->data['log'] = file_get_contents($file, FILE_USE_INCLUDE_PATH, null);
		} else {
			$this->data['log'] = '';
		}

		$this->template = 'tool/error_log.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
	}
/*
FUNCTION NAME 		-	clear
DESCRIPTION 		-	Loads when admin clicks the clear button on the "error log" page. 
						It clears the log file by deleting all the errors that were logged
						in the error_log file.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the error_log page after clearing the log.
*/	
	public function clear() {
		$this->language->load('tool/error_log');
		
		$file = DIR_LOGS . $this->config->get('config_error_filename');
		
		$handle = fopen($file, 'w+'); 
				
		fclose($handle); 			
		
		$this->session->data['success'] = $this->language->get('text_success');
		
		$this->redirect($this->url->link('tool/error_log', 'token=' . $this->session->data['token'], 'SSL'));		
	}
}
?>