<?php 
 /*
@File stb.php(Controller)
ADMIN STB PAGE
    This class manages the all the stb numbers with the status i.e., allocated or not.
    

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ControllerSaleRegion extends Controller {
	private $error = array();
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads when admin clicks the stb detail option in the dopdown list.
						It get all the stb number list and displays it here.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the admin stb page showing all the stb number in a list.
*/
public function index() {
		$this->language->load('sale/region');
		 
		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('sale/region');
    	$this->getList();
  	}


/*
FUNCTION NAME 		-	getList
DESCRIPTION 		-	Gets all the stb number along with their availability and linked status. Calls a retrieval from the 
						database and make a list for it.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Renders the stb number list.
*/
public function getList() {	
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
						
		$url = '';
		//$this->data['regins'][]=array();
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('sale/region', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
		
   		$this->data['defaultRegion'] = $this->url->link('sale/region/defaultRegion', 'token=' . $this->session->data['token'] . $url, 'SSL');
   		$this->data['insert'] = $this->url->link('sale/region/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		$this->data['delete'] = $this->url->link('sale/region/delete', 'token=' . $this->session->data['token'] . $url, 'SSL');
		$this->data['button_insert'] = $this->language->get('button_insert');
    	$this->data['button_delete'] = $this->language->get('button_delete');


		$this->data['stbs'] = array();
			$data = array(
			'start'           => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'           => $this->config->get('config_admin_limit')
		);
		$total = $this->model_sale_region->getTotalRegion($data);
		$results = $this->model_sale_region->getDetail($data);
		foreach ($results as $result) {	
			$action = array();
		
			$action[] = array(
				'text' => $this->language->get('text_edit'),
				'href' => $this->url->link('sale/region/update', 'token=' . $this->session->data['token'] . '&region_id=' . $result['region_id'] . $url, 'SSL')
			);



			$this->data['regions'][] = array(
				'region_id'          => $result['region_id'],
				'region_name'        => $result['region_name'].(($result['is_default'] ==1) ? $this->language->get('text_default') : null),
				'pin'                => $result['pin'],
				'selected'           => isset($this->request->post['selected']) && in_array($result['region_id'], $this->request->post['selected']),
				'action'             => $action
			);	
		}	
		$this->data['heading_title'] = $this->language->get('heading_title');
		$this->data['column_country'] = $this->language->get('column_country');
		$this->data['column_state']   = $this->language->get('column_state');		
		$this->data['column_name'] = $this->language->get('column_name');
		$this->data['column_pin'] = $this->language->get('column_pin');		
		$this->data['column_action'] = $this->language->get('column_action');

		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['token'] = $this->session->data['token'];

		
		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}

		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		//----------------------
		$pagination = new Pagination();
		$pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('sale/region', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
			
		$this->data['pagination'] = $pagination->render();
		//---------------------------
		
		$url = '';

		
			if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
		
		$this->template = 'sale/region.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
  	}

  	// ============================================

  	/*
FUNCTION NAME 		-	insert
DESCRIPTION 		-	Loads the insert customer_ban_ip form page where the admin can give the
						details of the new review. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the admin customer_ban_ip form page.
*/  
  	public function insert() {
  		
			$obj = new restapi();

		$this->language->load('sale/region');

    	$this->document->setTitle($this->language->get('heading_title'));
					
		$this->load->model('sale/region');

  			 
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {    
      	  	$temp=$this->request->post;
// var_dump($temp);exit();
       	  	$data="region_name=".$temp['region']."&pin=".$temp['pin'];
	 		$method ="POST";
	 		$url=KMS_API."/enableRegion";
	 		$hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME.':'.API_AUTH);
        	
        	$apiresult = $obj->callAPI($method,$hdr,$url,$data);
        	$response=json_decode($apiresult);
    		$error=true;
    		// $respId="";
    		$errorMsg="";
    		$apimessage='';
    		foreach ($response as $key => $value) {
    			switch ($key) {
					case 'error':
						$error=	$value;
						break;
					case 'message':
						$apimessage=$value;				
						break;
					// case 'id':
					// 	$respId=$value;	
					// 	break;
					default:
						$errorMsg=$errorMsg." ".$key.":".$value;	
						break;
				}
    		}
    		if(!$error)
    		{
    			$sms_region_id=$this->model_sale_region->addRegion($this->request->post);
    			// $this->model_sale_region->addApiResponceId($respId,$sms_region_id);
        		$this->session->data['success'] = $this->language->get('text_insert_success');
        	
				$url = '';				
				if (isset($this->request->get['sort'])) {
					$url .= '&sort=' . $this->request->get['sort'];
				}

				if (isset($this->request->get['order'])) {
					$url .= '&order=' . $this->request->get['order'];
				}

				if (isset($this->request->get['page'])) {
					$url .= '&page=' . $this->request->get['page'];
				}
				// ----------------------------------------------------------------------------
				$this->WriteMessageLog("SUCCESS:","NA",$temp['region']."-".$temp['pin'],"addRegion");
				// ----------------------------------------------------------------------------	
				$this->redirect($this->url->link('sale/region', 'token=' . $this->session->data['token'] . $url, 'SSL'));
			}else{
				// ----------------------------------------------------------------------------
				$this->WriteMessageLog("ERROR:","NA",$temp['region']."-".$temp['pin'],"addRegion");
				// ----------------------------------------------------------------------------	
				$this->error['warning'] = $apimessage." ".$errorMsg;
        		$this->getForm();
        		return;
        	}
		}
    	
    	$this->getForm();
  	} 
/*
FUNCTION NAME 		-	update
DESCRIPTION 		-	Loads when the admin wants to edit the customer_ban_ip details that was 
						added/uploaded earlier. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the  form with the detials already saved earlier.
*/
   
  	public function update() {
  		$obj = new restapi();
		$this->language->load('sale/region');

    	$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('sale/region');
		
    	if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {

    		$temp=$this->request->post;
       	  	$data="region_name=".$temp['region']."&pin=".$temp['pin']."&update_id=1";
	 		$method ="POST";
	 		$url=KMS_API."/enableRegion";
	 		$hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
        	$apiresult = $obj->callAPI($method,$hdr,$url,$data);
// var_dump($data);exit();        	
        	$response=json_decode($apiresult);
    		$error=true;
    		// $respId="";
    		$errorMsg="";
    		$apimessage='';
    		foreach ($response as $key => $value) {
    			switch ($key) {
					case 'error':
						$error=	$value;
						break;
					case 'message':
						$apimessage=$value;				
						break;
					// case 'id':
					// 	$respId=$value;	
					// 	break;
					default:
						$errorMsg=$errorMsg." ".$key.":".$value;	
						break;
				}
    		}
    		if(!$error)
    		{
				$this->model_sale_region->editRegion($this->request->get['region_id'], $this->request->post);
		  		
				$this->session->data['success'] = $this->language->get('text_success');
		  
				$url = '';
							
				if (isset($this->request->get['sort'])) {
					$url .= '&sort=' . $this->request->get['sort'];
				}

				if (isset($this->request->get['order'])) {
					$url .= '&order=' . $this->request->get['order'];
				}

				if (isset($this->request->get['page'])) {
					$url .= '&page=' . $this->request->get['page'];
				}
				// ----------------------------------------------------------------------------
				$this->WriteMessageLog("SUCCESS:","NA",$temp['region']."-".$temp['pin'],"modifyRegion");
				// ----------------------------------------------------------------------------	
				$this->redirect($this->url->link('sale/region', 'token=' . $this->session->data['token'] . $url, 'SSL'));
			}else{
				// ----------------------------------------------------------------------------
				$this->WriteMessageLog("ERROR:","NA",$temp['region']."-".$temp['pin'],"modifyRegion");
				// ----------------------------------------------------------------------------	
				$this->error['warning']=$errorMsg.' '.$apimessage;
				$this->getForm();
			}
		}
    
    	$this->getForm();
  	}   
/*
FUNCTION NAME 		-	delete
DESCRIPTION 		-	Delete the selected customer_ban_ip listed on the page. Admin selects the 
						checkbox against the customer_ban_ip in the list to be deleted and it gets deleted 
						after clicking the delete button. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the customer_ban_ip list page after deleting the customer_ban_ip from the list.
*/
  	public function delete() {
  		$obj = new restapi();
		$this->language->load('sale/region');

    	$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('sale/region');
		$notDeleted="";
    	if ( $this->validateDelete() && $this->request->post) 
    	{
    		$error_encounter=0;
    		$flag=false;
    		$errorMsg='';
			foreach ($this->request->post['selected'] as $region_pin) 
			{
				// $deleted_flag=false;
				// $data = $this->model_sale_region->getApiResponceId($region_id);
				$respId="";		 
				// if(isset($data['kms_region_id']))
				// {
			 		$data="region_pin=".$region_pin;//$data['kms_region_id'];
		       	  	// $z ="78fef98a91761cf1b171451b49289000";
			 		$method ="POST";
			 		$url=KMS_API."/disableRegion";
			 		$hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
		        	$apiresult=$obj->callAPI($method,$hdr,$url,$data);
		        	$response=json_decode($apiresult);
		        	$error=true;
		        	
		        	foreach ($response as $key => $value) {
		        		switch ($key) {
							case 'error':
								$error=	$value;
								break;
							case 'message':
								$apimessage=$value;				
								break;
							default:
								$errorMsg=$errorMsg." ".$key.":".$value;	
								break;
						}
			   //      	if((strcmp($key,"error")==0) && $value==false){
						// 	$error=false;
						// }if($key=='message'){
						// 	$apimessage=$value;
						// }
						// if($key!='id' && $key!='error' && $key!='mq_response' && $key!='message'){
						// 	$errorMsg=$errorMsg." ".$key." :".$value;
						// }
					}
					if($error){
	    				$error_encounter=1;
	    				$errorMsg=$errorMsg." ".$key." :".$apimessage;
	    			}else{
	    				$flag=true;
	    				$this->model_sale_region->deleteRegion($region_pin);
	    			}
	        	// }else
	        	// {
	        	// 	$error_encounter=1;
	        	// 	$errorMsg=$errorMsg.'Error : Invalide Region !';
	        	// }
			}
			if($error_encounter)
	  		{		
				if($flag)
	  				$this->session->data['warning'] =$this->language->get('text_warning_partial_delete').' ('.$errorMsg.')';
		  		else
		  			$this->session->data['warning'] =$errorMsg;
			  	$this->redirect($this->url->link('sale/region', 'token=' . $this->session->data['token'], 'SSL'));
			}else{
				$this->session->data['success'] = $this->language->get('text_delete_success');//$this->language->get('text_success_delete');
				$this->redirect($this->url->link('sale/region', 'token=' . $this->session->data['token'], 'SSL'));
			}
			// if($deleted_flag){
				
			// }else{
			// 	$this->error['warning'] = $this->language->get('error_delete');
			// 	$this->getList();
			// 	return;
			// }			
			//$this->redirect($this->url->link('sale/region', 'token=' . $this->session->data['token'] . $url, 'SSL'));
    		
    	}
    	
    	
    	$this->getList();
  	}  
	//---------
 /*
FUNCTION NAME 		-	defaultGroup
DESCRIPTION 		-	Loads when the admin wants to change the  the customer_group added as default customer group. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the  form with the detials already saved earlier.
*/
   
  	public function defaultRegion() {
		$this->language->load('sale/region');
		$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('sale/region');
		// var_dump($this->request->post);exit();
		if(isset($this->request->post['selected'])){
			if (count($this->request->post['selected'])>1) {
				$this->error['warning'] = $this->language->get('text_mult_select');
					$this->getList();
					return;
			}
			if($this->validateDefault() && isset($this->request->post['selected'])) {
				$this->model_sale_region->defaultCustomerRegion($this->request->post['selected'][0]);
				$this->session->data['success'] = $this->language->get('text_default_set_succes');
				$url = '';
				$this->redirect($this->url->link('sale/region', 'token=' . $this->session->data['token'], 'SSL'));
			}
		}else{
			$this->error['warning']=$this->language->get('text_select_warning');
		}
		$this->getList();
	}


		/*
FUNCTION NAME 		-	validateForm
DESCRIPTION 		-	Validates the customer_group details given in the form for insertion/updation
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
*/

	protected function validateDefault() {
		if (!$this->user->hasPermission('modify', 'sale/region')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}
		
		if (!$this->error) {
			return true;
		} else {
			return false;
		}
	}

  	/*
FUNCTION NAME 		-	getForm
DESCRIPTION 		-	Builds the form for the insertion/updation of the customer_ban_ip details. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the customer_ban_ip form page.
*/  
  	protected function getForm() {
    	$this->data['heading_title'] = $this->language->get('heading_title');
 		
    	$this->data['entry_stb'] = $this->language->get('entry_stb');
    	$this->data['entry_sc'] = $this->language->get('entry_sc');
 
		$this->data['button_save'] = $this->language->get('button_save');
    	$this->data['button_cancel'] = $this->language->get('button_cancel');

 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}

		if (isset($this->error['country'])) {
			$this->data['error_country'] = $this->error['country'];
		} else {
			$this->data['error_country'] = '';
		}

		if (isset($this->error['zone_id'])) {
			$this->data['error_zone'] = $this->error['zone_id'];
		} else {
			$this->data['error_zone'] = '';
		}

		if (isset($this->error['country_id'])) {
			$this->data['error_country'] = $this->error['country_id'];
		} else {
			$this->data['error_country'] = '';
		}

 		if (isset($this->error['region'])) {
			$this->data['error_region'] = $this->error['region'];
		} else {
			$this->data['error_region'] = '';
		}

		if (isset($this->error['pin'])) {
			$this->data['error_pin'] = $this->error['pin'];
		} else {
			$this->data['error_pin'] = '';
		}
		
		$url = '';

		// if(isset($this->request->post['pin']))
		// {
		// 	$this->data['pin']=	'';//$this->request->post['pin'];
		// }else{
		// 	$this->data['pin']=	'';
		// }

		// if(isset($this->request->post['region']))
		// {
		// 	$this->data['region_name']=	$this->request->post['region'];
		// }else{
		// 	$this->data['region_name']=	'';
		// }

		$this->load->model('sale/region');
		$this->load->model('localisation/country');
		$this->load->model('sale/customer');
		$this->data['countries'] = $this->model_localisation_country->getCountries();

		if (isset($this->request->post['country_id'])) { 
			$this->data['country_id'] = $this->request->post['country_id'];
			$this->data['zones'] =$this->model_sale_customer->getZoneList($this->request->post['country_id']);
		}elseif (!empty($addr)) { 
			$this->data['country_id'] = $addr['country_id'];
			$this->data['zones'] =$this->model_sale_customer->getZoneList($addr['country_id']);
		} else {
			$this->data['zones'] =$this->model_sale_customer->getZoneList(99);
			$this->data['country_id'] = 99;
		}

		/*if (isset($this->request->post['zone_id'])) { 
			$this->data['zone_id'] = $this->request->post['zone_id'];
		}elseif (!empty($addr)) { 
			$this->data['zone_id'] = $addr['zone_id'];
		} else {
			$this->data['zone_id'] = '';
		} */	
		
		// if (isset($this->request->get['sort'])) {
		// 	$url .= '&sort=' . $this->request->get['sort'];
		// }

		// if (isset($this->request->get['order'])) {
		// 	$url .= '&order=' . $this->request->get['order'];
		// }
						
		// if (isset($this->request->get['page'])) {
		// 	$url .= '&page=' . $this->request->get['page'];
		// }
		
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('sale/region', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);

   		$this->data['token']= $this->session->data['token'];
		if (!isset($this->request->get['region_id'])) {
			$this->data['action'] = $this->url->link('sale/region/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		} else { 
			$this->data['action'] = $this->url->link('sale/region/update', 'token=' . $this->session->data['token'] . '&region_id=' . $this->request->get['region_id'] . $url, 'SSL');
		}
		  
    	$this->data['cancel'] = $this->url->link('sale/region', 'token=' . $this->session->data['token'] . $url, 'SSL');

    	if (isset($this->request->get['region_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
    	$region_info = $this->model_sale_region->getRegion($this->request->get['region_id']);
    	}

    	if (isset($this->request->post['region'])) {
      		$this->data['region'] = $this->request->post['region'];
		} elseif (!empty($region_info)) { 
			$this->data['region'] = $region_info['region_name'];
		} else {
      		$this->data['region'] = '';
    	}

    	if (isset($this->request->post['pin'])) {
      		$this->data['pin'] = '';//$this->request->post['pin'];
		} elseif (!empty($region_info)) { 
			$this->data['pin'] = $region_info['pin'];
		} else {
      		$this->data['pin'] = '';
    	}


    	if (isset($this->request->get['region_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
    	$zone_info =$this->model_sale_customer->getZoneList($region_info['zone_id']);
    	}

		if (isset($region_info['zone_id'])) {
      		$this->data['zone_id'] = $region_info['zone_id'];
		} elseif (!empty($region_info)) { 
			$this->data['zone_id'] = $region_info['zone_id'];
		} else {
      		$this->data['zone_id'] = '';
    	}
    	
    	// if (isset($this->request->get['stb_no']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
     //  		$stb_info = $this->model_sale_region->getSTB($this->request->get['stb_no']);
    	// }
			
  //   	if (isset($this->request->post['stb'])) {
  //     		$this->data['stb'] = $this->request->post['stb'];
		// } elseif (!empty($stb_info)) { 
		// 	$this->data['stb'] = $stb_info['stb_no'];
		// } else {
  //     		$this->data['stb'] = '';
  //   	}

  //   	if (isset($this->request->post['sc'])) {
  //     		$this->data['sc'] = $this->request->post['sc'];
		// }elseif (!empty($stb_info)) { 
		// 	$this->data['sc'] = $stb_info['is_smart_card'];
		// } else {
  //     		$this->data['sc'] = '';
  //   	}
    	$this->data['text_select'] 	  = $this->language->get('text_select');	
    	$this->data['column_country'] = $this->language->get('column_country');
		$this->data['column_state']   = $this->language->get('column_state');
    	$this->data['column_name']    = $this->language->get('column_name');
		$this->data['column_pin'] = $this->language->get('column_pin');	
		
		$this->template = 'sale/region_form.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
	}
/*
FUNCTION NAME 		-	validateForm
DESCRIPTION 		-	Validates the customer_ban_ip details given in the form for insertion/updation
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
*/
			 
  	protected function validateForm() {
  			
    	if (!$this->user->hasPermission('modify', 'sale/region')) {
      		$this->error['warning'] = $this->language->get('error_permission');
    	}
		if($this->request->post['zone_id']=='-1'){
			$this->error['zone_id'] = "Please select state..!";
		}

		if($this->request->post['country_id'] != 99){
			$this->error['country_id'] = "Please select country as India..!";
		}

    	if ((utf8_strlen($this->request->post['region']) <3) || (utf8_strlen($this->request->post['region']) > 24)) {
      		$this->error['region'] = "Region name is mandatory!, Length should be between 3-24!";
    	}elseif(preg_match('/[^a-f0-9 A-Z]/i', $this->request->post['region'])){
    		$this->error['region'] = "Accepts only 0-9 digits & alphabets A-Z";
    	}

    	if(!preg_match('/^[1-9][0-9]*$/', $this->request->post['pin'])){
    		$this->error['pin'] = "Region pin is mandatory!, Accepts only 0-9!";
    	}elseif ((utf8_strlen($this->request->post['pin']) !=6)) {
      		$this->error['pin'] = "Length should be between 6!";
    	}

    	$this->load->model('sale/region'); 
    	// $regionId = isset($this->request->get['region_id'])?$this->request->get['region_id']:-1; 
    	// $flag = $this->model_sale_region->isRegionExist($this->request->post['region'],$regionId);
    	// if($flag)
    	if(isset($this->request->get['region_id'])){
    		if($this->model_sale_region->isRegionExist($this->request->post['region'],$this->request->get['region_id']))
    			$this->error['region'] = "Region name already exist!";
    	}else{
    		if($this->model_sale_region->isRegionNameExist($this->request->post['region']))
    			$this->error['region'] = "Duplicate Region name!";
    		if($this->model_sale_region->isRegionPinExist($this->request->post['pin']))
    			$this->error['pin'] = "Duplicate Region Pin ".$this->request->post['pin'];

    	}
	
		if (!$this->error) {
	  		return true;
		} else {
	  		return false;
		}
		
  	}    
/*
FUNCTION NAME 		-	country
DESCRIPTION 		-	Loads the country information form the database to a json
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Renders the json values for the country retrieved.
*/		
	public function country() {
		 // $json = array('Test' =>'Hello');
		$json = array();
		$this->load->model('localisation/country');

    	$country_info = $this->model_localisation_country->getCountry($this->request->get['country_id']);
		//echo '<pre>'; print_r($country_info);
		if ($country_info) {
			$this->load->model('localisation/zone');

			$json = array(
				'country_id'        => $country_info['country_id'],
				'name'              => $country_info['name'],
				'iso_code_2'        => $country_info['iso_code_2'],
				'iso_code_3'        => $country_info['iso_code_3'],
				'address_format'    => $country_info['address_format'],
				'postcode_required' => $country_info['postcode_required'],
				'zone'              => $this->model_localisation_zone->getZonesByCountryId($this->request->get['country_id']),
				'status'            => $country_info['status']		
			);
		}
		
		$this->response->setOutput(json_encode($json));
	}   	
/*
FUNCTION NAME 		-	validateDelete
DESCRIPTION 		-	Validates the details of the customer_ban_ip content when deleted. 
						Checks if the deteled customer_ban_ip is already there in the database or not. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
*/
  	protected function validateDelete() {
    	if (!$this->user->hasPermission('modify', 'sale/region')) {
      		$this->error['warning'] = $this->language->get('error_permission');
    	}	

    	if(!isset($this->request->post['selected'])){
    		$this->error['warning'] = $this->language->get('error_checkbox');
    	}else{
    		for($i=0;$i<count($this->request->post['selected']);$i++){
    			
    			if($this->model_sale_region->isCustomerRegionDefault($this->request->post['selected'][$i])){
	    			$this->error['warning'] = "Default region cann't be deleted!";
	    			break;
    			}
    			if($this->model_sale_region->isRegionMapped($this->request->post['selected'][$i])){
	    			$this->error['warning'] = "Region are mapped to customer, please check!";
	    			break;
    			}
    		}
    	}	

		if (!$this->error) {
	  		return true;
		} else {
	  		return false;
		}  
  	}
  	private function getUserIdFromApiResponce($obj1)
	{
		$res=json_decode($obj1,true);

		foreach ($res as $value) 
			 {
			 if($value['error']==false)
			
				return $value;
			 }
			 return;
	}
	public function WriteMessageLog($status,$log_target_level,$log_target,$command){
		date_default_timezone_set('Asia/Kolkata');
   		$log_file = fopen(DIR_LOGS."command_log.txt", "a") or die("Unable to open file!");
 		$today  = date("Y-m-d H:i:s");
    	// fwrite($log_file, "\n".$status."\t\t".$today."\t\t".$log_target_level."\t\t\t\t".$log_target."\t\t\t\t\t".$command);
    	fwrite($log_file, "\n".str_pad($status,14," ").$today."\t".str_pad($log_target_level,18," ").str_pad($log_target,24," ").$command);
        fclose($log_file);
    } 
 }
?> 