<?php
/*
@File order.php(Controller)
ADMIN ORDER PAGE
    This class manages the customer's order by inserting/updating or by 
    printing the invoice for the selected order.
    

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ControllerSaleMobileRequest extends Controller {
	private $error = array();
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads when admin clicks the order option in the dopdown list.
						It get all the order list and displays it here.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the order page showing all the order in a list.
*/
  	public function index() {
		$this->language->load('sale/mobile_request');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('sale/mobile_request');
    	$this->getList();
  	}


/*
FUNCTION NAME 		-	getList
DESCRIPTION 		-	Gets all the orders added by the admin. Calls a retrieval from the 
						database and make a list for it.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Renders the order list.
*/
  	protected function getList() {
  
		if (isset($this->request->get['filter_mobile_no'])) {
			$filter_mobile_no = $this->request->get['filter_mobile_no'];
		} else {
			$filter_mobile_no = null;
		}
		if (isset($this->request->get['filter_recievedon'])) {
			$filter_recievedon = $this->request->get['filter_recievedon'];
		} else {
			$filter_recievedon = null;
		}
		if (isset($this->request->get['filter_message'])) {
			$filter_message = $this->request->get['filter_message'];
		} else {
			$filter_message = null;
		}
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
				
		$url = '';

		if (isset($this->request->get['filter_mobile_no'])) {
			$url .= '&filter_mobile_no=' . $this->request->get['filter_mobile_no'];
		}
		if (isset($this->request->get['filter_recievedon'])) {
			$url .= '&filter_recievedon=' . $this->request->get['filter_recievedon'];
		}
		if (isset($this->request->get['filter_message'])) {
			$url .= '&filter_message=' . $this->request->get['filter_message'];
		}
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   	
	   		$this->data['breadcrumbs'][] = array(
	       		'text'      => $this->language->get('heading_title'),
				'href'      => $this->url->link('sale/mobile_request', 'token=' . $this->session->data['token'] . $url, 'SSL'),
	      		'separator' => ' :: '
	   		);
   		
		$this->data['invoice'] = $this->url->link('sale/mobile_request/invoice', 'token=' . $this->session->data['token'], 'SSL');
		$this->data['insert'] = $this->url->link('sale/mobile_request/insert', 'token=' . $this->session->data['token'], 'SSL');
		$this->data['delete'] = $this->url->link('sale/mobile_request/delete', 'token=' . $this->session->data['token'] . $url, 'SSL');

		$this->data['orders'] = array();

		$data = array(
			'filter_mobile_no'       => $filter_mobile_no,
			'filter_recievedon'      => $filter_recievedon,
			'filter_message'		 => $filter_message,
			'start'                  => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'                  => $this->config->get('config_admin_limit')
		);

		$order_total =$this->model_sale_mobile_request->getTotalRequests($data);

		$results = $this->model_sale_mobile_request->getMobileRequests($data);
		
    	foreach ($results as $result) {
			$action = array();
						
			$action[] = array(
				'text' => $this->language->get('text_view'),
				'href' => $this->url->link('sale/mobile_request/info', 'token=' . $this->session->data['token'] . '&order_id=' . $result['id'] . $url, 'SSL')
			);
			
			$this->data['orders'][] = array(
				'id'      => $result['id'],
				'mobile_no'      => $result['mobile_no'],
				'date'        => $result['date'],
				'message'        => $result['message'],
				'selected'      => isset($this->request->post['selected']) && in_array($result['id'], $this->request->post['selected']),
				'action'        => $action
			);
		}

		$this->data['heading_title'] = $this->language->get('heading_title');

		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['text_missing'] = $this->language->get('text_missing');

		$this->data['column_mobile_number'] = $this->language->get('text_mobile_number');
		$this->data['column_recieved_on'] = $this->language->get('text_recieved_on');
		$this->data['column_msg'] = $this->language->get('text_msg');

		$this->data['column_action'] = $this->language->get('column_action');

		$this->data['button_invoice'] = $this->language->get('button_invoice');
		$this->data['button_insert'] = $this->language->get('button_insert');
		$this->data['button_delete'] = $this->language->get('button_delete');
		$this->data['button_filter'] = $this->language->get('button_filter');

		$this->data['token'] = $this->session->data['token'];
		
		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		}else if (isset($this->session->data['warning'])) {
			$this->data['error_warning'] = $this->session->data['warning'];

			unset($this->session->data['warning']);
		} else {
			$this->data['error_warning'] = '';
		}

		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];

			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}

		// $url = '';

		// if (isset($this->request->get['filter_mobile_no'])) {
		// 	$url .= '&filter_mobile_no=' . $this->request->get['filter_mobile_no'];
		// }
		// if (isset($this->request->get['filter_recievedon'])) {
		// 	$url .= '&filter_recievedon=' . $this->request->get['filter_recievedon'];
		// }

		// if (isset($this->request->get['page'])) {
		// 	$url .= '&page=' . $this->request->get['page'];
		// }

		$this->data['sort_order'] = $this->url->link('sale/mobile_request', 'token=' . $this->session->data['token'] . '&sort=o.order_id' . $url, 'SSL');
		$this->data['sort_customer'] = $this->url->link('sale/mobile_request', 'token=' . $this->session->data['token'] . '&sort=customer' . $url, 'SSL');
		$this->data['sort_status'] = $this->url->link('sale/mobile_request', 'token=' . $this->session->data['token'] . '&sort=status' . $url, 'SSL');
		$this->data['sort_total'] = $this->url->link('sale/mobile_request', 'token=' . $this->session->data['token'] . '&sort=o.total' . $url, 'SSL');
		$this->data['sort_date_added'] = $this->url->link('sale/mobile_request', 'token=' . $this->session->data['token'] . '&sort=o.date_added' . $url, 'SSL');
		$this->data['sort_date_modified'] = $this->url->link('sale/mobile_request', 'token=' . $this->session->data['token'] . '&sort=o.date_modified' . $url, 'SSL');

		// $url = '';

		// if (isset($this->request->get['filter_mobile_no'])) {
		// 	$url .= '&filter_mobile_no=' . $this->request->get['filter_mobile_no'];
		// }
		// if (isset($this->request->get['filter_recievedon'])) {
		// 	$url .= '&filter_recievedon=' . $this->request->get['filter_recievedon'];
		// }

		$pagination = new Pagination();
		$pagination->total = $order_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('sale/mobile_request', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');

		$this->data['pagination'] = $pagination->render();

		$this->data['filter_mobile_no'] = $filter_mobile_no;
		$this->data['filter_recievedon'] = $filter_recievedon;
		$this->data['filter_message'] = $filter_message;
		$this->load->model('localisation/order_status');

    	$this->data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

		$this->template = 'sale/mobile_request_list.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
		
		$this->response->setOutput($this->render());
  	}

/*
FUNCTION NAME 		-	validateForm
DESCRIPTION 		-	Validates the order details given in the form for insertion/updation
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
*/
	
  	protected function validateForm() {
    	if (!$this->user->hasPermission('modify', 'sale/mobile_request')) {
      		$this->error['warning'] = $this->language->get('error_permission');
    	}
    	$this->load->model('sale/mobile_request');
    	$customer_register = $this->model_sale_order->customerRegistered($this->request->post['firstname'],$this->request->post['lastname'],$this->request->post['email']);
    	if($customer_register==0){
    		$this->error['warning']=$this->language->get('error_warning_customer_reg');
    	}


    	if ((utf8_strlen($this->request->post['firstname']) < 1) || (utf8_strlen($this->request->post['firstname']) > 32)) {
      		$this->error['firstname'] = $this->language->get('error_firstname');
    	}

    	if ((utf8_strlen($this->request->post['lastname']) < 1) || (utf8_strlen($this->request->post['lastname']) > 32)) {
      		$this->error['lastname'] = $this->language->get('error_lastname');
    	}

    	if ((utf8_strlen($this->request->post['email']) > 96) || (!preg_match('/^[^\@]+@.*\.[a-z]{2,6}$/i', $this->request->post['email']))) {
      		$this->error['email'] = $this->language->get('error_email');
    	}
		
    	if ((utf8_strlen($this->request->post['telephone']) < 3) || (utf8_strlen($this->request->post['telephone']) > 32)) {
      		$this->error['telephone'] = $this->language->get('error_telephone');
    	}
		
    	if ((utf8_strlen($this->request->post['payment_firstname']) < 1) || (utf8_strlen($this->request->post['payment_firstname']) > 32)) {
      		$this->error['payment_firstname'] = $this->language->get('error_firstname');
    	}

    	if ((utf8_strlen($this->request->post['payment_lastname']) < 1) || (utf8_strlen($this->request->post['payment_lastname']) > 32)) {
      		$this->error['payment_lastname'] = $this->language->get('error_lastname');
    	}

    	if ((utf8_strlen($this->request->post['payment_address_1']) < 3) || (utf8_strlen($this->request->post['payment_address_1']) > 128)) {
      		$this->error['payment_address_1'] = $this->language->get('error_address_1');
    	}

    	if ((utf8_strlen($this->request->post['payment_city']) < 3) || (utf8_strlen($this->request->post['payment_city']) > 128)) {
      		$this->error['payment_city'] = $this->language->get('error_city');
    	}
		
		$this->load->model('localisation/country');
		
		$country_info = $this->model_localisation_country->getCountry($this->request->post['payment_country_id']);
		
		if ($country_info) {
			if ($country_info['postcode_required'] && (utf8_strlen($this->request->post['payment_postcode']) < 2) || (utf8_strlen($this->request->post['payment_postcode']) > 10)) {
				$this->error['payment_postcode'] = $this->language->get('error_postcode');
			}
			
			// VAT Validation
			$this->load->helper('vat');
			
			if ($this->config->get('config_vat') && $this->request->post['payment_tax_id'] && (vat_validation($country_info['iso_code_2'], $this->request->post['payment_tax_id']) == 'invalid')) {
				$this->error['payment_tax_id'] = $this->language->get('error_vat');
			}				
		}

    	if ($this->request->post['payment_country_id'] == '') {
      		$this->error['payment_country'] = $this->language->get('error_country');
    	}
		
    	if (!isset($this->request->post['payment_zone_id']) || $this->request->post['payment_zone_id'] == '') {
      		$this->error['payment_zone'] = $this->language->get('error_zone');
    	}	
		
    	if ($this->request->post['payment_method'] == '') {
      		// $this->error['payment_zone'] = $this->language->get('error_zone');
      		$this->error['payment_method'] = $this->language->get('error_payment');
    	}			
		
		if (!$this->request->post['payment_method']) {
			$this->error['payment_method'] = $this->language->get('error_payment');
		}	
					
		// Check if any products require shipping
		$shipping = false;
		
		if (isset($this->request->post['order_product'])) {
			$this->load->model('catalog/product');
			
			foreach ($this->request->post['order_product'] as $order_product) {
				$product_info = $this->model_catalog_product->getProduct($order_product['product_id']);
			
				if ($product_info && $product_info['shipping']) {
					$shipping = true;
				}
			}
		}
		
		// if ($shipping) {
		// 	if ((utf8_strlen($this->request->post['shipping_firstname']) < 1) || (utf8_strlen($this->request->post['shipping_firstname']) > 32)) {
		// 		$this->error['shipping_firstname'] = $this->language->get('error_firstname');
		// 	}
	
		// 	if ((utf8_strlen($this->request->post['shipping_lastname']) < 1) || (utf8_strlen($this->request->post['shipping_lastname']) > 32)) {
		// 		$this->error['shipping_lastname'] = $this->language->get('error_lastname');
		// 	}
			
		// 	if ((utf8_strlen($this->request->post['shipping_address_1']) < 3) || (utf8_strlen($this->request->post['shipping_address_1']) > 128)) {
		// 		$this->error['shipping_address_1'] = $this->language->get('error_address_1');
		// 	}
	
		// 	if ((utf8_strlen($this->request->post['shipping_city']) < 3) || (utf8_strlen($this->request->post['shipping_city']) > 128)) {
		// 		$this->error['shipping_city'] = $this->language->get('error_city');
		// 	}
	
		// 	$this->load->model('localisation/country');
			
		// 	$country_info = $this->model_localisation_country->getCountry($this->request->post['shipping_country_id']);
			
		// 	if ($country_info && $country_info['postcode_required'] && (utf8_strlen($this->request->post['shipping_postcode']) < 2) || (utf8_strlen($this->request->post['shipping_postcode']) > 10)) {
		// 		$this->error['shipping_postcode'] = $this->language->get('error_postcode');
		// 	}
	
		// 	if ($this->request->post['shipping_country_id'] == '') {
		// 		$this->error['shipping_country'] = $this->language->get('error_country');
		// 	}
			
		// 	if (!isset($this->request->post['shipping_zone_id']) || $this->request->post['shipping_zone_id'] == '') {
		// 		$this->error['shipping_zone'] = $this->language->get('error_zone');
		// 	}
			
		// 	if (!$this->request->post['shipping_method']) {
		// 		$this->error['shipping_method'] = $this->language->get('error_shipping');
		// 	}			
		// }
		
		if ($this->error && !isset($this->error['warning'])) {
			$this->error['warning'] = $this->language->get('error_warning');
		}
		
		if (!$this->error) {
	  		return true;
		} else {
	  		return false;
		}
  	} 

  	  	public function delete() {
		$this->language->load('sale/mobile_request');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('sale/mobile_request');

    	if (isset($this->request->post['selected']) && ($this->validateDelete())) {
			foreach ($this->request->post['selected'] as $order_id) {
				$this->model_sale_order->deleteOrder($order_id);
			}

			$this->session->data['success'] = $this->language->get('text_delete_success');

			$url = '';

			if (isset($this->request->get['filter_order_id'])) {
				$url .= '&filter_order_id=' . $this->request->get['filter_order_id'];
			}
			
			if (isset($this->request->get['filter_customer'])) {
				$url .= '&filter_customer=' . urlencode(html_entity_decode($this->request->get['filter_customer'], ENT_QUOTES, 'UTF-8'));
			}
												
			if (isset($this->request->get['filter_order_status_id'])) {
				$url .= '&filter_order_status_id=' . $this->request->get['filter_order_status_id'];
			}
			
			if (isset($this->request->get['filter_total'])) {
				$url .= '&filter_total=' . $this->request->get['filter_total'];
			}
						
			if (isset($this->request->get['filter_date_added'])) {
				$url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
			}
			
			if (isset($this->request->get['filter_date_modified'])) {
				$url .= '&filter_date_modified=' . $this->request->get['filter_date_modified'];
			}
													
			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$this->redirect($this->url->link('sale/mobile_request', 'token=' . $this->session->data['token'] . $url, 'SSL'));
    	}

    	$this->getList();
  	}   

}
?>