<?php 
 /*
@File settopbox.php(Controller)
ADMIN SETTOPBOX PAGE
    This class show the customers with the allocated set top boxes with basic details.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ControllerReportSubsNetworkReport extends Controller {
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads all the customer detials along with the assigned set top box and 
						displays it as a list.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the set top box page
*/
public function index() {
		$this->language->load('report/subsnetworkreport');
		 
		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('report/subsnetworkreport');
    	$this->getList();
  	}

/*
FUNCTION NAME 		-	printPdf
DESCRIPTION 		-	Loads the selected data for generating 
						a pdf.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Generates a pdf with the details given.
*/
public function printPdf(){

	    $this->pdf->AddPage();
	    $this->load->model('report/subsnetworkreport');
	   $this->pdf->Image(DIR_IMAGE.'/data/channels/logo.png',8,10,60);
	    
	    $this->pdf->SetFillColor(232,232,232);
	    $user = $this->model_report_subsnetworkreport->getUserDetails($this->session->data['user_id']);
		
		$this->pdf->SetFont('times','B',8);
		$this->pdf->SetY(8);
		$this->pdf->SetX(65);
		$this->pdf->Cell(190,6,$user['firstname'].' '.$user['lastname'],0,0,'C',0);
		$this->pdf->SetY(12);
		$this->pdf->SetX(65);
		$this->pdf->Cell(191,6,$user['email'],0,0,'C',0);

		$this->pdf->SetFont('times','B',8);
		$this->pdf->SetY(20);
		$this->pdf->Cell(184,6,'-: Location wise Set Top Box And CAS :-',1,0,'C',1);
		$this->pdf->SetY(30);
		$result = $this->model_report_subsnetworkreport->getSubscribers();
		$deactiveresult = $this->model_report_subsnetworkreport->getDeactiveSubscribers();
		$activeresult = $this->model_report_subsnetworkreport->getactiveSubscribers();
	  
	 	
		$this->pdf->Cell(110,6,'Total No Of Subscriber On The Network :-',1,0,'C',0);
	 	$this->pdf->SetFont('times','',8);
	 	$this->pdf->Cell(55,6,$result['count'],1,1,'L',0);

	 	$this->pdf->Cell(110,6,'Total No Of Active Subscriber On The Network :-',1,0,'C',0);
	 	$this->pdf->SetFont('times','',8);
	 	$this->pdf->Cell(55,6,$activeresult['count'],1,1,'L',0);

	 	$this->pdf->Cell(110,6,'Total No Of Deactive Subscriber On The Network :-',1,0,'C',0);
	 	$this->pdf->SetFont('times','',8);
	 	$this->pdf->Cell(55,6,$deactiveresult['count'],1,1,'L',0);

	 	
	                         
	    $this->pdf->Ln(8);   
	    $this->pdf->Cell(70,6,'Date',0,0,'C',0);
	    $this->pdf->Cell(70,6,'Signature',0,0,'C',0);
	    $this->pdf->Ln(8);
	    $this->pdf->Cell(70,6,Date("d-m-Y"),0,0,'C',0);
	    $this->pdf->Cell(70,6,'--------------------',0,0,'C',0);
	 
	    $this->pdf->Output();

	               
	    $this->pdf->Ln(8);   
	    $this->pdf->Cell(70,6,'Date',0,0,'C',0);
	    $this->pdf->Cell(70,6,'Signature',0,0,'C',0);
	    $this->pdf->Ln(8);
	    $this->pdf->Cell(70,6,Date("d-m-Y"),0,0,'C',0);
	    $this->pdf->Cell(70,6,'--------------------',0,0,'C',0);
	    $this->pdf->Output();
    }
/*
FUNCTION NAME 		-	getList
DESCRIPTION 		-	Gets all the customer details with their stb details.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Displays the customer details with their stb details as a list.
*/
public function getList() {	
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
						
		$url = '';

  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('report/subsnetworkreport', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);

   		//----------
		$data = array(
			'start'           => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'           => $this->config->get('config_admin_limit')
		);
		
		//-----------
		$this->data['printPdf'] = $this->url->link('report/subsnetworkreport/printPdf', 'token=' . $this->session->data['token'] . $url, 'SSL');
		$this->data['customers'] = array();

		$this->data['subscribers'] = array();

		
		$result = $this->model_report_subsnetworkreport->getSubscribers();
		$deactiveresult = $this->model_report_subsnetworkreport->getDeactiveSubscribers();
		$activeresult = $this->model_report_subsnetworkreport->getactiveSubscribers();
		$this->data['subscribers'][] = array(
			'count'       => $result['count'],
			'deactive'   =>$deactiveresult['count'],
			'active'  =>$activeresult['count']
			

		);	
		$this->data['heading_title'] = $this->language->get('heading_title');

		
		$this->data['column_active'] = $this->language->get('column_active');
		$this->data['column_deactive'] = $this->language->get('column_deactive');
		$this->data['column_subno'] = $this->language->get('column_subno');
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['button_invoice'] = $this->language->get('button_invoice');;
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['token'] = $this->session->data['token'];
		$this->data['button_invoice'] = $this->language->get('button_invoice');;

		
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		
		$pagination = new Pagination();
		// $pagination->total = $total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('report/subsnetworkreport', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
			
		$this->data['pagination'] = $pagination->render();
		
		$url = '';

		
			if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		$this->template = 'report/subsnetworkreport.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
  
  	}
 }
?> 